Option Explicit

 ' Description:
 '  This modules contains constants and type
 '  declarations needed by common dialog boxes.

 ' Constants:

  ' action properties
  Global Const DLG_FILE_OPEN = 1
  Global Const DLG_FILE_SAVE = 2
  Global Const DLG_COLOR = 3
  Global Const DLG_FONT = 4
  Global Const DLG_PRINT = 5
  Global Const DLG_HELP = 6
  
  ' file open/save dialog flags
  Global Const OFN_READONLY = &H1&
  Global Const OFN_OVERWRITEPROMPT = &H2&
  Global Const OFN_HIDEREADONLY = &H4&
  Global Const OFN_NOCHANGEDIR = &H8&
  Global Const OFN_SHOWHELP = &H10&
  Global Const OFN_NOVALIDATE = &H100&
  Global Const OFN_ALLOWMULTISELECT = &H200&
  Global Const OFN_EXTENTIONDIFFERENT = &H400&
  Global Const OFN_PATHMUSTEXIST = &H800&
  Global Const OFN_FILEMUSTEXIST = &H1000&
  Global Const OFN_CREATEPROMPT = &H2000&
  Global Const OFN_SHAREAWARE = &H4000&
  Global Const OFN_NOREADONLYRETURN = &H8000&
  
  ' color dialog flags
  Global Const CC_RGBINIT = &H1&
  Global Const CC_FULLOPEN = &H2&
  Global Const CC_PREVENTFULLOPEN = &H4&
  Global Const CC_SHOWHELP = &H8&
  
  ' printer dialog flags
  Global Const PD_ALLPAGES = &H0&
  Global Const PD_SELECTION = &H1&
  Global Const PD_PAGENUMS = &H2&
  Global Const PD_NOSELECTION = &H4&
  Global Const PD_NOPAGENUMS = &H8&
  Global Const PD_COLLATE = &H10&
  Global Const PD_PRINTTOFILE = &H20&
  Global Const PD_PRINTSETUP = &H40&
  Global Const PD_NOWARNING = &H80&
  Global Const PD_RETURNDC = &H100&
  Global Const PD_RETURNIC = &H200&
  Global Const PD_RETURNDEFAULT = &H400&
  Global Const PD_SHOWHELP = &H800&
  Global Const PD_USEDEVMODECOPIES = &H40000
  Global Const PD_DISABLEPRINTTOFILE = &H80000
  Global Const PD_HIDEPRINTTOFILE = &H100000
  
  ' font dialog flags
  Global Const CF_SCREENFONTS = &H1&
  Global Const CF_PRINTERFONTS = &H2&
  Global Const CF_BOTH = &H3&
  Global Const CF_SHOWHELP = &H4&
  Global Const CF_INITTOLOGFONTSTRUCT = &H40&
  Global Const CF_USESTYLE = &H80&
  Global Const CF_EFFECTS = &H100&
  Global Const CF_APPLY = &H200&
  Global Const CF_ANSIONLY = &H400&
  Global Const CF_NOVECTORFONTS = &H800&
  Global Const CF_NOSIMULATIONS = &H1000&
  Global Const CF_LIMITSIZE = &H2000&
  Global Const CF_FIXEDPITCHONLY = &H4000&
  Global Const CF_WYSIWYG = &H8000&
  Global Const CF_FORCEFONTEXIST = &H10000
  Global Const CF_SCALABLEONLY = &H20000
  Global Const CF_TTONLY = &H40000
  Global Const CF_NOFACESEL = &H80000
  Global Const CF_NOSTYLESEL = &H100000
  Global Const CF_NOSIZESEL = &H200000

  ' command parameter values for help:
  Global Const HELP_CONTEXT = &H1       ' display topic by context number
  Global Const HELP_QUIT = &H2          ' terminate help
  Global Const HELP_CONTENTS = &H3      ' display contents screen
  Global Const HELP_HELPONHELP = &H4    ' display help on using help
  Global Const HELP_SETINDEX = &H5      ' set the current index for multi index help
  Global Const HELP_SETCONTENTS = &H5   ' redefine Contents Screen
  Global Const HELP_CONTEXTPOPUP = &H8  ' display topic in popup window
  Global Const HELP_FORCEFILE = &H9     ' ensure help file is loaded
  Global Const HELP_KEY = &H101         ' search alternate keyword table
  Global Const HELP_COMMAND = &H102     ' execute a help macro
  Global Const HELP_PARTIALKEY = &H105  ' call winhelp search engine
  Global Const HELP_MULTIKEY = &H201    ' multiKey search
  Global Const HELP_SETWINPOS = &H203   ' set help window position
  
  ' cancel has been pressed
  Global Const CDERR_CANCEL = 32755

 ' Types:
  
  ' COMMON DIALOG FILE structure
  Type zzCD_FILE
    Title                        As String * 40     ' dialogue title
    Filename                     As String * 256    ' file name
    Filter(1 To 10)              As String * 128    ' filter
    FilterText(1 To 10)          As String * 128    ' filter text
    FilterCount                  As Integer         ' number of filters
    InitDir                      As String * 128    ' initial directory
  End Type
  
  ' COMMON DIALOG FONT structure
  Type zzCD_FONT
    Bold                         As Integer         ' bold on?
    Italic                       As Integer         ' italic on?
    Name                         As String * 128    ' name
    Size                         As Single          ' size
    StrikeThru                   As Integer         ' strike thru on?
    UnderLine                    As Integer         ' underline on?
    Color                        As Long            ' color selected
  End Type
  
  ' COMMON DIALOG PRINT structure
  Type zzCD_PRINT
    Copies                       As Integer         ' number of copies
    FromPage                     As Integer         ' from page
    ToPage                       As Integer         ' to page
    Min                          As Integer         ' minimum page number
    Max                          As Integer         ' maximum page number
    Selection                    As Integer         ' print selected section
    PageNums                     As Integer         ' print page range
    Collate                      As Integer         ' collate
    Filename                     As String * 256    ' file name
    PrintToFile                  As Integer         ' print to file
    Quality                      As Integer         ' print quality
  End Type

Function zzDialogColor (cdl As Control, lColor As Long) As Integer

 ' Description:
 '  Select a color from color common dialog.
 '  If a color is selected then TRUE is returned.

 ' Parameters:
 '  cdl                  reference to common dialog control
 '  lColorSelected       starting color

  ' turn on error handling
  cdl.CancelError = True
  On Error GoTo zzDialogColor_Error_Handler
  
  ' setup default color as one passed in
  cdl.Color = lColor

  ' setup flags
  cdl.Flags = CC_FULLOPEN Or CC_RGBINIT

  ' show dialog
  cdl.Action = DLG_COLOR

  ' return color selected
  lColor = cdl.Color
	     
  ' everything worked
  zzDialogColor = True
  Exit Function

' handle errors
zzDialogColor_Error_Handler:

  ' error processing
  zzDialogColor = False
  Exit Function

End Function

Function zzDialogFont (cdl As Control, tCD_FONT As zzCD_FONT) As Integer

 ' Description:
 '  Select a font
 '  If a selection is made then TRUE is returned.
 
 ' Parameters:
 '  cdl                     reference to common dialog control
 '  tCD_FONT                font structure

  ' turn on error handling
  cdl.CancelError = True
  On Error GoTo zzDialogFont_Error_Handler

  ' setup dialog defaults
  cdl.FontBold = tCD_FONT.Bold
  cdl.FontItalic = tCD_FONT.Italic
  cdl.FontName = tCD_FONT.Name
  cdl.FontSize = tCD_FONT.Size
  cdl.FontStrikeThru = tCD_FONT.StrikeThru
  cdl.FontUnderLine = tCD_FONT.UnderLine
  cdl.Color = tCD_FONT.Color

  ' setup flags
  cdl.Flags = CF_BOTH Or CF_EFFECTS

  ' show dialog box
  cdl.Action = DLG_FONT

  ' return changes to caller
  tCD_FONT.Bold = cdl.FontBold
  tCD_FONT.Italic = cdl.FontItalic
  tCD_FONT.Name = cdl.FontName
  tCD_FONT.Size = cdl.FontSize
  tCD_FONT.StrikeThru = cdl.FontStrikeThru
  tCD_FONT.UnderLine = cdl.FontUnderLine
  tCD_FONT.Color = cdl.Color
  
  ' no error occurred
  zzDialogFont = True
	     
  ' jump over error handler
  Exit Function

' handle errors
zzDialogFont_Error_Handler:

  ' return error value top caller
  zzDialogFont = False
  Exit Function

End Function

Sub zzDialogHelpContents (cdl As Control, ByVal sHelpFile$)

 ' Description:
 '  Invoke help file table of contents
 
 ' Parameters:
 '  cdl             reference to common dialog control
 '  sHelpFile       help file to view

  ' turn on error handling
  cdl.CancelError = True
  On Error Resume Next

  ' specify the help file to open
  cdl.HelpFile = sHelpFile
  
  ' go to contents
  cdl.HelpCommand = HELP_CONTENTS
  
  ' help dialog
  cdl.Action = DLG_HELP
  
End Sub

Sub zzDialogHelpContext (cdl As Control, ByVal sHelpFile$, ByVal nHelpContext%)

 ' Description:
 '  Invoke help file with contents reference
 
 ' Parameters:
 '  cdl       reference to common dialog control
 '  sHelpFile    help file to view
 '  nHelpContext help file context ID

  ' turn on error handling
  cdl.CancelError = True
  On Error Resume Next

  ' specify the help file to open
  cdl.HelpFile = sHelpFile
  
  ' go to context
  cdl.HelpCommand = HELP_CONTEXT

  ' setup reference id
  cdl.HelpContext = nHelpContext

  ' help dialog
  cdl.Action = DLG_HELP
  
End Sub

Sub zzDialogHelpSearch (cdl As Control, ByVal sHelpFile$)

 ' Description:
 '  Invoke help file search window
 
 ' Parameters:
 '  cdl             reference to common dialog control
 '  sHelpFile       help file to view

  ' turn on error handling
  cdl.CancelError = True
  On Error Resume Next

  ' specify the help file to open
  cdl.HelpFile = sHelpFile
  
  ' go to search window
  cdl.HelpCommand = HELP_PARTIALKEY
  
  ' help dialog
  cdl.Action = DLG_HELP
  
End Sub

Function zzDialogOpen (cdl As Control, tCD_File As zzCD_FILE) As Integer
 
 ' Description:
 '  Displays a File Open common dialog with a read
 '  only check box and returns the file name selected
 '  including path name as the function value.
 
 ' Parameters:
 '  cdl               reference to common dialog control

 ' Variables:
  Dim n1      As Integer  ' loop counter
  Dim s1      As String   ' work string
  Dim s2      As String   ' work string
  Dim sFilter As String   ' complete filter

  ' turn on error handling
  cdl.CancelError = True
  On Error GoTo zzDialogOpen_Error_Handler

  ' setup title
  cdl.DialogTitle = RTrim$(tCD_File.Title)
  
  ' setup up to ten filters
  For n1 = 1 To tCD_File.FilterCount
    s1 = tCD_File.FilterText(n1): s1 = RTrim$(s1)
    s2 = tCD_File.Filter(n1): s2 = RTrim$(s2)
    sFilter = sFilter & s1 & " (" & s2 & ")|"
    sFilter = sFilter & s2 & "|"
  Next n1

  ' setup default if none supplied
  If sFilter = gsEMPTY Then
    sFilter = "All Files|*.*"
  
  ' else remove trailing seperator
  Else
    sFilter = Left$(sFilter, Len(sFilter) - 1)
  End If

  ' assign filter
  cdl.Filter = sFilter

  ' initial directory
  If RTrim$(tCD_File.InitDir) <> gsEMPTY Then
    cdl.InitDir = RTrim$(tCD_File.InitDir)
  End If

  ' file name
  cdl.Filename = RTrim$(tCD_File.Filename)

  ' no read only check box
  cdl.Flags = OFN_HIDEREADONLY

  ' open dialog
  cdl.Action = DLG_FILE_OPEN

  ' file name
  tCD_File.Filename = cdl.Filename

  ' no error occurred
  zzDialogOpen = True
  Exit Function

' handle errors
zzDialogOpen_Error_Handler:

  ' return nothing to caller
  zzDialogOpen = False
  Exit Function

End Function

Function zzDialogPrint (cdl As Control, tCD_PRINT As zzCD_PRINT) As Integer
 
 ' Description:
 '  Select printer parameters
 '  If selection made then TRUE is returned.
 
 ' Parameters:
 '  cdl               reference to common dialog control

 ' Variables:
  Dim Flags As Integer
  
  ' turn on error handling
  cdl.CancelError = True
  On Error GoTo zzDialogPrint_Error_Handler

  ' set other attributes
  cdl.Copies = tCD_PRINT.Copies
  cdl.FromPage = tCD_PRINT.FromPage
  If cdl.FromPage < 1 Then cdl.FromPage = 1
  cdl.ToPage = tCD_PRINT.ToPage
  If cdl.ToPage < 1 Then cdl.ToPage = 999
  cdl.Min = tCD_PRINT.Min
  If cdl.Min < 1 Then cdl.Min = 1
  cdl.Max = tCD_PRINT.Max
  If cdl.Max < 1 Then cdl.Max = 999
  cdl.Filename = tCD_PRINT.Filename

  ' set flags
  If tCD_PRINT.Selection Then cdl.Flags = cdl.Flags Or PD_SELECTION
  If tCD_PRINT.PageNums Then cdl.Flags = cdl.Flags Or PD_PAGENUMS
  If tCD_PRINT.PrintToFile Then cdl.Flags = cdl.Flags Or PD_PRINTTOFILE
  If tCD_PRINT.Collate Then cdl.Flags = cdl.Flags Or PD_COLLATE

  ' print dialog
  cdl.Action = DLG_PRINT

  ' return attributes
  tCD_PRINT.Copies = cdl.Copies
  tCD_PRINT.FromPage = cdl.FromPage
  tCD_PRINT.ToPage = cdl.ToPage
  tCD_PRINT.Min = cdl.Min
  tCD_PRINT.Max = cdl.Max
  tCD_PRINT.Filename = cdl.Filename
  
  ' return flags
  tCD_PRINT.Selection = (cdl.Flags And PD_SELECTION) > 0
  tCD_PRINT.PageNums = (cdl.Flags And PD_PAGENUMS) > 0
  tCD_PRINT.PrintToFile = (cdl.Flags And PD_PRINTTOFILE) > 0
  tCD_PRINT.Collate = (cdl.Flags And PD_COLLATE) > 0

  ' no error occurred
  zzDialogPrint = True
		  
  ' jump over error handler
  Exit Function

' handle errors
zzDialogPrint_Error_Handler:

  ' return cancel taken
  zzDialogPrint = False
  Exit Function

End Function

Function zzDialogSave (cdl As Control, tCD_File As zzCD_FILE) As Integer

 ' Description:
 '  Select a File to Save

 ' Parameters:
 '  cdl               reference to common dialog control
 
 ' Variables:
  Dim n1      As Integer  ' loop counter
  Dim s1      As String   ' work string
  Dim s2      As String   ' work string
  Dim sFilter As String   ' complete filter
  
  ' turn on error handling
  cdl.CancelError = True
  On Error GoTo zzDialogSave_Error_Handler

  ' setup title
  cdl.DialogTitle = RTrim$(tCD_File.Title)
  
  ' setup up to ten filters
  For n1 = 1 To tCD_File.FilterCount
    s1 = tCD_File.FilterText(n1): s1 = RTrim$(s1)
    s2 = tCD_File.Filter(n1): s2 = RTrim$(s2)
    sFilter = sFilter & s1 & " (" & s2 & ")|"
    sFilter = sFilter & s2 & "|"
  Next n1

  ' setup default if none supplied
  If sFilter = gsEMPTY Then
    sFilter = "All Files (*.*)|*.*"
  
  ' else remove trailing seperator
  Else
    sFilter = Left$(sFilter, Len(sFilter) - 1)
  End If

  ' assign filter
  cdl.Filter = sFilter

  ' initial directory
  If RTrim$(tCD_File.InitDir) <> gsEMPTY Then
    cdl.InitDir = RTrim$(tCD_File.InitDir)
  End If

  ' file name
  cdl.Filename = RTrim$(tCD_File.Filename)

  ' no read only check box
  cdl.Flags = OFN_HIDEREADONLY

  ' save dialog
  cdl.Action = DLG_FILE_SAVE
  
  ' file name
  tCD_File.Filename = cdl.Filename

  ' no error occurred
  zzDialogSave = True
  Exit Function

' handle errors
zzDialogSave_Error_Handler:

  ' return error value top caller
  zzDialogSave = False
  Exit Function

End Function

Sub zzHelpContext (ByVal hWnd%, ByVal sHelpFile$, ByVal lContext&)
 
 ' Description:
 '  Show help based on context id passed in. If none
 '  is passed in then function uses currently active
 '  controls help ID. If not available then it uses
 '  the active forms help ID. IF not available then it
 '  shows help contents.

 ' Parameters:
 '  hWnd             windows handle
 '  sHelpFile        open help file
 '  lContext         context id

 ' Variables:
  Dim nCommand       As Integer    ' help command
  Dim nRC            As Integer    ' return code
  Dim ltmpContext    As Long       ' context id

  ' if help file specified
  If sHelpFile <> gsEMPTY Then

    ' if no context id passed in
    If lContext = 0 Then
    
      ' if active control is present
      If Not Screen.ActiveControl Is Nothing Then
      
	' use help id from active control
	nCommand = HELP_CONTEXT
	ltmpContext = Screen.ActiveControl.HelpContextID

      End If

      ' if active control has no help ID and form is currently active
      If (ltmpContext = 0) And Not (Screen.ActiveForm Is Nothing) Then
      
	' use help topic from current form
	nCommand = HELP_CONTEXT
	ltmpContext = Screen.ActiveForm.HelpContextID

      End If

      ' use help contents as a last resort
      If ltmpContext = 0 Then nCommand = HELP_CONTENTS

    ' help context passed in
    Else
      ltmpContext = lContext
      nCommand = HELP_CONTEXT
    End If
    
    ' call Windows help
    nRC = WinHelpLong(hWnd, sHelpFile, nCommand, ltmpContext)

  End If
					  
End Sub

Sub zzHelpEnd (ByVal hWnd%, ByVal sHelpFile$)

 ' Description:
 '  End windows help session on specific file.

 ' Parameters:
 '  hWnd             windows handle
 '  sHelpFile        open help file

 ' Variables:
  Dim nRC            As Integer    ' return code

  ' if help file specified
  If sHelpFile <> gsEMPTY Then
    nRC = WinHelpLong(hWnd, sHelpFile, HELP_QUIT, 0)
  End If

End Sub

