Option Explicit

 ' Description:
 '  This module contains constants that
 '  define the data base functions.
 
 ' Constants:
  
  ' create database and compact database language constants
  Global Const DB_LANG_GENERAL = ";LANGID=0x0809;CP=1252;COUNTRY=0"

  ' database field data types
  Global Const DB_BOOLEAN = 1
  Global Const DB_BYTE = 2
  Global Const DB_INTEGER = 3
  Global Const DB_LONG = 4
  Global Const DB_CURRENCY = 5
  Global Const DB_SINGLE = 6
  Global Const DB_DOUBLE = 7
  Global Const DB_DATE = 8
  Global Const DB_TEXT = 10
  Global Const DB_LONGBINARY = 11
  Global Const DB_MEMO = 12
  
  ' dynaset options
  Global Const DB_DEFAULTS = 0                ' default settings
  Global Const DB_DENYWRITE = 1               ' no others can change
  Global Const DB_READONLY = 4                ' read only
  Global Const DB_APPENDONLY = 8              ' add only
  Global Const DB_INCONSISTENT = 16           ' changes can effect all rows
  Global Const DB_CONSISTENT = 32             ' no changes that effect other rows
  Global Const DB_SQLPASSTHROUGH = 64         ' pass SQL to ODBC

  ' data actions
  Global Const DATA_ACTIONCANCEL = 0          ' Cancel operation
  Global Const DATA_ACTIONMOVEFIRST = 1       ' MoveFirst
  Global Const DATA_ACTIONMOVEPREVIOUS = 2    ' MovePrevious
  Global Const DATA_ACTIONMOVENEXT = 3        ' MoveNext
  Global Const DATA_ACTIONMOVELAST = 4        ' MoveLast
  Global Const DATA_ACTIONADDNEW = 5          ' AddNew
  Global Const DATA_ACTIONUPDATE = 6          ' Update
  Global Const DATA_ACTIONDELETE = 7          ' Delete
  Global Const DATA_ACTIONFIND = 8            ' Find method
  Global Const DATA_ACTIONBOOKMARK = 9        ' Bookmark has been set
  Global Const DATA_ACTIONCLOSE = 10          ' The Close method
  Global Const DATA_ACTIONUNLOAD = 11         ' The form is being unloaded

  ' data control error responses
  Global Const DATA_ERRCONTINUE = 0           ' continue
  Global Const DATA_ERRDISPLAY = 1            ' display message

  ' collating order (sort by...)
  Global Const DB_SORTUNDEFINED = 1           ' undefined
  Global Const DB_SORTGENERAL = 256           ' English, French, German, Portuguese, Italian
  Global Const DB_SORTSPANISH = 258           ' Spanish
  Global Const DB_SORTDUTCH = 259             ' Dutch
  Global Const DB_SORTSWEDFIN = 260           ' Swedish, Finnish
  Global Const DB_SORTNORDAN = 261            ' Norwegian, Danish
  Global Const DB_SORTICELANDIC = 262         ' Icelandic
  Global Const DB_SORTPDXINTL = 4096          ' Paradox International
  Global Const DB_SORTPDXSWE = 4097           ' Paradox Swedish, Finnish
  Global Const DB_SORTPDXNOR = 4098           ' Paradox Norwegian, Danish

  ' table attributes
  Global Const DB_ATTACHEXCLUSIVE = &H10000   ' Access table attached for exclusive use
  Global Const DB_ATTACHSAVEPWD = &H20000     ' User ID and password should be saved with the linking information
  Global Const DB_ATTACHEDODBC = &H20000000   ' Indicates the table is an attached table from an ODBC database, such as SQL Server or Oracle.
  Global Const DB_ATTACHEDTABLE = &H40000000  ' Indicates the table is an attached table from a non-ODBC database, such as Microsoft Access or Paradox.
  Global Const DB_SYSTEMOBJECT = &H80000002   ' Indicates the table is a system table

