Option Explicit
 
 ' Copyright:
 
 '  Copyright  1994, 1995, 1996
 '  Genesis Software, Inc. ALL RIGHTS RESERVED.
 
 '  The code found herein may not be reproduced, used, or distributed
 '  in any form without permission in writing from Genesis Software, Inc.
 '  except for noncommercial, private use and adaptation granted by
 '  U.S. copyright law. Redistribution of this code, or the
 '  distribution of derivative works, is expressly prohibited.

 '  This copyright applies to all code modules, forms and other
 '  libraries or functions supplied by Genesis Software, Inc.

 ' Description:

 '  This module contains the global constants and variables used
 '  to represent common values used within VB programs such as
 '  tab, carriage return, etc. The zzSetGlobalVariables routine
 '  should be called at the beginning of a program to make sure
 '  all variables have been setup.
 
 ' Constants:

  ' blank field
  Global Const gsEMPTY = ""
  
 ' Variables:

  ' control characters
  Global gsCHR_NUL               As String * 1      ' null
  Global gsCHR_TAB               As String * 1      ' tab
  Global gsCHR_LF                As String * 1      ' line feed
  Global gsCHR_CR                As String * 1      ' carriage return
  Global gsCHR_CRLF              As String * 2      ' carriage return/line feed

Sub zzSetGlobalVariables ()
 
 ' Description:
 '  Sets up the global character variables that must use Chr$(n..)
 '  as opposed to being able to use a string constant. Your program
 '  should call this routine at start up to insure that all global
 '  variables are setup before being used.

  gsCHR_NUL = Chr$(0)               ' null-terminator
  gsCHR_TAB = Chr$(9)               ' tab
  gsCHR_LF = Chr$(10)               ' line feed
  gsCHR_CR = Chr$(13)               ' carriage return
  gsCHR_CRLF = gsCHR_CR & gsCHR_LF  ' carriage return and line feed

End Sub

