VERSION 2.00
Begin Form frmServerObject 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Save/Restore Server Object"
   ClientHeight    =   5625
   ClientLeft      =   2895
   ClientTop       =   2730
   ClientWidth     =   8055
   Height          =   6030
   Icon            =   SROBJ.FRX:0000
   Left            =   2835
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   5625
   ScaleWidth      =   8055
   Top             =   2385
   Width           =   8175
   Begin Timer tmrDisplay 
      Enabled         =   0   'False
      Interval        =   1000
      Left            =   60
      Top             =   5820
   End
   Begin Frame zfraRestoreTo 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Restore To AS/400 Library"
      Height          =   915
      Left            =   60
      TabIndex        =   25
      Top             =   4650
      Width           =   4365
      Begin CommandButton cmdRestore 
         Caption         =   "&Restore"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   330
         Left            =   2400
         TabIndex        =   12
         Top             =   480
         Width           =   1785
      End
      Begin TextBox txtRestoreLibrary 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   285
         Left            =   120
         TabIndex        =   11
         Top             =   480
         Width           =   1935
      End
      Begin Label zlbl 
         BackStyle       =   0  'Transparent
         Caption         =   "Library"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   225
         Index           =   9
         Left            =   120
         TabIndex        =   26
         Top             =   240
         Width           =   1365
      End
   End
   Begin Frame zfraPCDataFile 
      BackColor       =   &H00C0C0C0&
      Caption         =   "PC Data File"
      Height          =   915
      Left            =   60
      TabIndex        =   27
      Top             =   3660
      Width           =   7905
      Begin TextBox txtPCFileName 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   285
         Left            =   120
         TabIndex        =   9
         Top             =   480
         Width           =   1695
      End
      Begin TextBox txtPCFileDirectory 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   285
         Left            =   1860
         TabIndex        =   10
         Top             =   480
         Width           =   5955
      End
      Begin Label zlbl 
         BackStyle       =   0  'Transparent
         Caption         =   "Name"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   225
         Index           =   7
         Left            =   120
         TabIndex        =   28
         Top             =   240
         Width           =   1485
      End
      Begin Label zlbl 
         BackStyle       =   0  'Transparent
         Caption         =   "Directory"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   225
         Index           =   8
         Left            =   1860
         TabIndex        =   32
         Top             =   240
         Width           =   1350
      End
   End
   Begin Frame zFra400DataFile 
      BackColor       =   &H00C0C0C0&
      Caption         =   "AS/400 Data File"
      Height          =   915
      Left            =   60
      TabIndex        =   35
      Top             =   1320
      Width           =   4395
      Begin TextBox txtDataFileName 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   285
         Left            =   120
         TabIndex        =   20
         Top             =   480
         Width           =   1935
      End
      Begin TextBox txtDataFileLibrary 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   285
         Left            =   2160
         TabIndex        =   21
         Top             =   480
         Width           =   1935
      End
      Begin Label zlbl 
         BackColor       =   &H00FFFFFF&
         BackStyle       =   0  'Transparent
         Caption         =   "Name"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   225
         Index           =   5
         Left            =   120
         TabIndex        =   36
         Top             =   240
         Width           =   1485
      End
      Begin Label zlbl 
         BackStyle       =   0  'Transparent
         Caption         =   "Library"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   225
         Index           =   6
         Left            =   2160
         TabIndex        =   37
         Top             =   240
         Width           =   1485
      End
   End
   Begin Frame zfra400SaveFile 
      BackColor       =   &H00C0C0C0&
      Caption         =   "AS/400 Save File"
      Height          =   915
      Left            =   60
      TabIndex        =   31
      Top             =   360
      Width           =   4395
      Begin TextBox txtSaveFileName 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   285
         Left            =   120
         TabIndex        =   14
         Top             =   480
         Width           =   1935
      End
      Begin TextBox txtSaveFileLibrary 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   285
         Left            =   2160
         TabIndex        =   15
         Top             =   480
         Width           =   1935
      End
      Begin Label zlbl 
         BackStyle       =   0  'Transparent
         Caption         =   "Name"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   225
         Index           =   3
         Left            =   120
         TabIndex        =   34
         Top             =   240
         Width           =   1485
      End
      Begin Label zlbl 
         BackStyle       =   0  'Transparent
         Caption         =   "Library"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   225
         Index           =   4
         Left            =   2160
         TabIndex        =   33
         Top             =   240
         Width           =   1485
      End
   End
   Begin Frame zfraSaveObject 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Save Object"
      Height          =   1335
      Left            =   60
      TabIndex        =   30
      Top             =   2280
      Width           =   7905
      Begin ComboBox cboObjectRelease 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   315
         Left            =   6390
         TabIndex        =   4
         Top             =   480
         Width           =   1215
      End
      Begin CommandButton cmdCreate 
         Caption         =   "&Create Save Set"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   330
         Left            =   2370
         TabIndex        =   6
         Top             =   870
         Width           =   1785
      End
      Begin CommandButton cmdSets 
         Caption         =   "Selec&t Save Set"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   330
         Left            =   120
         TabIndex        =   5
         Top             =   870
         Width           =   1785
      End
      Begin CommandButton cmdSave 
         Caption         =   "&Save"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   330
         Left            =   4590
         TabIndex        =   8
         Top             =   870
         Width           =   1785
      End
      Begin TextBox txtObjectName 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   285
         Left            =   120
         TabIndex        =   1
         Top             =   480
         Width           =   1935
      End
      Begin TextBox txtObjectLibrary 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   285
         Left            =   2160
         TabIndex        =   2
         Top             =   480
         Width           =   1935
      End
      Begin ComboBox cboObjectType 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   315
         Left            =   4560
         TabIndex        =   3
         Top             =   480
         Width           =   1215
      End
      Begin ComboBox cboSets 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   315
         Left            =   120
         Sorted          =   -1  'True
         Style           =   2  'Dropdown List
         TabIndex        =   0
         Top             =   480
         Visible         =   0   'False
         Width           =   7695
      End
      Begin CommandButton cmdDelete 
         Caption         =   "&Delete Save Set"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   330
         Left            =   2370
         TabIndex        =   7
         Top             =   870
         Visible         =   0   'False
         Width           =   1785
      End
      Begin Label zlbl 
         BackStyle       =   0  'Transparent
         Caption         =   "Release"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   225
         Index           =   14
         Left            =   6390
         TabIndex        =   45
         Top             =   240
         Width           =   855
      End
      Begin Label zlbl 
         BackStyle       =   0  'Transparent
         Caption         =   "Name"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   225
         Index           =   0
         Left            =   120
         TabIndex        =   22
         Top             =   240
         Width           =   1485
      End
      Begin Label zlbl 
         BackStyle       =   0  'Transparent
         Caption         =   "Library"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   225
         Index           =   1
         Left            =   2160
         TabIndex        =   23
         Top             =   240
         Width           =   1485
      End
      Begin Label zlbl 
         BackStyle       =   0  'Transparent
         Caption         =   "Type"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   225
         Index           =   2
         Left            =   4560
         TabIndex        =   24
         Top             =   240
         Width           =   1485
      End
   End
   Begin Frame zfraServerProgram 
      BackColor       =   &H00C0C0C0&
      Caption         =   "AS/400 Server Program"
      Height          =   1875
      Left            =   4530
      TabIndex        =   29
      Top             =   360
      Width           =   3435
      Begin ComboBox cboSystems 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   315
         Left            =   90
         Style           =   2  'Dropdown List
         TabIndex        =   44
         Top             =   450
         Width           =   1905
      End
      Begin ComboBox cboPriority 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   315
         Left            =   2340
         Style           =   2  'Dropdown List
         TabIndex        =   19
         Top             =   1440
         Width           =   795
      End
      Begin TextBox txtServerLibrary 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   285
         Left            =   90
         TabIndex        =   16
         Top             =   1440
         Width           =   1935
      End
      Begin OptionButton optServerMethod 
         BackColor       =   &H00C0C0C0&
         Caption         =   "REXX"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   225
         Index           =   1
         Left            =   2340
         TabIndex        =   18
         Top             =   720
         Width           =   855
      End
      Begin OptionButton optServerMethod 
         BackColor       =   &H00C0C0C0&
         Caption         =   "RPG"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   225
         Index           =   0
         Left            =   2340
         TabIndex        =   17
         Top             =   480
         Value           =   -1  'True
         Width           =   735
      End
      Begin Label zlbl 
         BackStyle       =   0  'Transparent
         Caption         =   "Type"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   225
         Index           =   13
         Left            =   2310
         TabIndex        =   43
         Top             =   240
         Width           =   615
      End
      Begin Label zlbl 
         BackStyle       =   0  'Transparent
         Caption         =   "System"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   225
         Index           =   12
         Left            =   90
         TabIndex        =   42
         Top             =   240
         Width           =   615
      End
      Begin Label zlbl 
         BackStyle       =   0  'Transparent
         Caption         =   "Priority"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   225
         Index           =   11
         Left            =   2340
         TabIndex        =   39
         Top             =   1170
         Width           =   615
      End
      Begin Label zlbl 
         BackStyle       =   0  'Transparent
         Caption         =   "Library"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   225
         Index           =   10
         Left            =   90
         TabIndex        =   38
         Top             =   1200
         Width           =   915
      End
   End
   Begin CommandButton cmdExit 
      Caption         =   "E&xit"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   330
      Left            =   6150
      TabIndex        =   13
      Top             =   5130
      Width           =   1785
   End
   Begin Label lblStatus 
      Alignment       =   2  'Center
      BackColor       =   &H00000000&
      ForeColor       =   &H0000FF00&
      Height          =   255
      Left            =   1320
      TabIndex        =   41
      Top             =   60
      Width           =   6645
   End
   Begin Label lblTime 
      Alignment       =   2  'Center
      BackColor       =   &H00000000&
      ForeColor       =   &H0000FF00&
      Height          =   255
      Left            =   60
      TabIndex        =   40
      Top             =   60
      Width           =   1275
   End
End
Option Explicit

 ' Constants:
  Const bGet = True                     ' get default info
  Const bSAVE = False                   ' save default info
  Const nSAVEFILE_RECORD_SIZE = 528     ' record size in save file
  Const sSERVER_RPG = "SROBJRPG"        ' RPG server
  Const sSERVER_REX = "SROBJREX"        ' REXX server
  Const sSOURCE_REX = "SRCREX"          ' REXX source file


 ' Variables:
  Dim bSaving        As Integer         ' running a save
  Dim nRC            As Integer         ' return code
  Dim sINIFile       As String          ' application INI file
  Dim sCmd           As String          ' remote command to execute
  Dim sMsgs          As String          ' remote command messages returned
  Dim sPartnerSYS    As String          ' Partner system

Sub AppDefaults (bGet As Integer)

 ' Description:
 '  Get or save defaults

 ' Parameters:
 '  bGet           get defaults from file

 ' Constants:
  Const sSECTION1 = "SERVER"
  Const sSECTION2 = "OBJECT"
  Const sSECTION3 = "SAVEFILE"
  Const sSECTION4 = "DATAFILE"
  Const sSECTION5 = "PCFILE"
  Const sSECTION6 = "RESTORE"
  Const sTOPIC1 = "Library"
  Const sTOPIC2 = "Type"
  Const sTOPIC3 = "Name"
  Const sTOPIC4 = "Priority"
  Const sTOPIC5 = "System"
  Const sTOPIC6 = "Release"
  Const sVALUE1 = "RPG"
  Const sVALUE2 = "REXX"

 ' Variables:
  Dim n1  As Integer
  Dim nRC As Integer
  Dim s1  As String

  MousePointer = HOURGLASS

  ' setup file reference
  nRC = zzINISetFile(sINIFile)

  ' if getting defaults
  If bGet Then

    ' setup first section
    nRC = zzINISetSection(sSECTION1)
    
    ' put list of systems into control
    Call zzCAPutSystemListIntoCtrl(Me.hWnd, cboSystems)
    
    ' get AS/400 server name
    nRC = zzINIGetString(sTOPIC5, sPartnerSYS)
    
    ' see if match found
    For n1 = 0 To cboSystems.ListCount - 1
      If cboSystems.List(n1) = sPartnerSYS Then
        cboSystems.ListIndex = n1
        Exit For
      End If
    Next
  
    ' get server library
    nRC = zzINIGetStringIntoTB(sTOPIC1, txtServerLibrary)
    
    ' get RPG/REXX option
    nRC = zzINIGetString(sTOPIC2, s1)
    optServerMethod(0).Value = (s1 = sVALUE1)
    optServerMethod(1).Value = (s1 = sVALUE2)

    ' get job priority option
    nRC = zzINIGetInteger(sTOPIC4, n1)
    cboPriority.ListIndex = n1

    ' get object information
    nRC = zzINISetSection(sSECTION2)
    nRC = zzINIGetStringIntoTB(sTOPIC3, txtObjectName)
    nRC = zzINIGetStringIntoTB(sTOPIC1, txtObjectLibrary)
    nRC = zzINIGetStringIntoTB(sTOPIC2, cboObjectType)
    nRC = zzINIGetStringIntoTB(sTOPIC6, cboObjectRelease)
    
    ' get save file information
    nRC = zzINISetSection(sSECTION3)
    nRC = zzINIGetStringIntoTB(sTOPIC3, txtSaveFileName)
    nRC = zzINIGetStringIntoTB(sTOPIC1, txtSaveFileLibrary)

    ' get data file information
    nRC = zzINISetSection(sSECTION4)
    nRC = zzINIGetStringIntoTB(sTOPIC3, txtDataFileName)
    nRC = zzINIGetStringIntoTB(sTOPIC1, txtDataFileLibrary)

    ' get PC file information
    nRC = zzINISetSection(sSECTION5)
    nRC = zzINIGetStringIntoTB(sTOPIC3, txtPCFileName)
    nRC = zzINIGetStringIntoTB(sTOPIC1, txtPCFileDirectory)

    ' get restore library information
    nRC = zzINISetSection(sSECTION6)
    nRC = zzINIGetStringIntoTB(sTOPIC1, txtRestoreLibrary)

    ' get save sets
    Call SaveSets(bGet)

  ' if saving defaults
  Else
  
    ' save AS/400 server library, type, priority
    nRC = zzINISetSection(sSECTION1)
    nRC = zzINIPutString(sTOPIC5, sPartnerSYS)
    nRC = zzINIPutString(sTOPIC1, txtServerLibrary.Text)
    If optServerMethod(0) Then
      nRC = zzINIPutString(sTOPIC2, sVALUE1)
    Else
      nRC = zzINIPutString(sTOPIC2, sVALUE2)
    End If
    nRC = zzINIPutInteger(sTOPIC4, cboPriority.ListIndex)

    ' save object information
    nRC = zzINISetSection(sSECTION2)
    nRC = zzINIPutString(sTOPIC3, txtObjectName.Text)
    nRC = zzINIPutString(sTOPIC1, txtObjectLibrary.Text)
    nRC = zzINIPutString(sTOPIC2, cboObjectType.Text)
    nRC = zzINIPutString(sTOPIC6, cboObjectRelease.Text)
  
    ' save save file information
    nRC = zzINISetSection(sSECTION3)
    nRC = zzINIPutString(sTOPIC3, txtSaveFileName.Text)
    nRC = zzINIPutString(sTOPIC1, txtSaveFileLibrary.Text)

    ' save data file information
    nRC = zzINISetSection(sSECTION4)
    nRC = zzINIPutString(sTOPIC3, txtDataFileName.Text)
    nRC = zzINIPutString(sTOPIC1, txtDataFileLibrary.Text)

    ' save PC file information
    nRC = zzINISetSection(sSECTION5)
    nRC = zzINIPutString(sTOPIC3, txtPCFileName.Text)
    nRC = zzINIPutString(sTOPIC1, txtPCFileDirectory.Text)

    ' save restore library information
    nRC = zzINISetSection(sSECTION6)
    nRC = zzINIPutString(sTOPIC1, txtRestoreLibrary.Text)

    ' save save sets
    Call SaveSets(bGet)

  End If
  
  MousePointer = DEFAULT

End Sub

Sub cboObjectRelease_KeyPress (KeyASCII As Integer)

  ' gobble enter key and convert entry to uppercase
  Call Gobble(cboObjectRelease, KeyASCII)

End Sub

Sub cboObjectType_KeyPress (KeyASCII As Integer)

  ' gobble enter key and convert entry to uppercase
  Call Gobble(cboObjectType, KeyASCII)

End Sub

Sub cboSets_Click ()

 ' Variables:
  Dim n2       As Integer
  Dim s1       As String
  Dim sDir     As String
  Dim sFile    As String
  Dim sLib     As String
  Dim sName    As String
  Dim sPath    As String
  Dim sRelease As String
  Dim sType    As String

  ' if form done loading
  If tmrDisplay.Enabled Then
    
    ' if item selected
    If cboSets.ListIndex >= 0 Then
  
      ' get currently selected item
      s1 = cboSets.List(cboSets.ListIndex)
  
      ' find library/name seperator
      n2 = InStr(s1, "/")
      If n2 > 0 Then
        
        ' get library
        sLib = Left$(s1, n2 - 1)
        s1 = Mid$(s1, n2 + 1)
      
        ' get object name
        n2 = InStr(s1, " ")
        If n2 > 0 Then
          sName = Left$(s1, n2 - 1)
          s1 = Mid$(s1, n2 + 1)
          
          ' get object type
          n2 = InStr(s1, " to ")
          If n2 > 0 Then
            sType = Left$(s1, n2 - 1)
            
            ' get directory and file
            s1 = Mid$(s1, n2 + 4)
            n2 = InStr(s1, " *")
            If n2 = 0 Then n2 = InStr(s1, " V")

            If n2 > 0 Then
              sPath = Left$(s1, n2 - 1)
              sRelease = Mid$(s1, n2 + 1)
            Else
              sPath = s1
              sRelease = "*CURRENT"
            End If
            
            ' parse path name
            Call zzFileParse(sPath, sDir, sFile)

          End If

        End If
      
      End If
      
    End If
  
    ' setup controls
    If sName <> gsEMPTY Then txtObjectName = sName
    If sLib <> gsEMPTY Then txtObjectLibrary = sLib
    If sType <> gsEMPTY Then cboObjectType = sType
    If sRelease <> gsEMPTY Then cboObjectRelease = sRelease
    If sFile <> gsEMPTY Then txtPCFileName = sFile
    If sDir <> gsEMPTY Then txtPCFileDirectory = sDir
  
  End If

End Sub

Sub cboSystems_Click ()

  ' place selected system in variable
  sPartnerSYS = cboSystems.Text

End Sub

Sub cmdCreate_Click ()

 ' Description:
 '  Creates a save set entry if one
 '  does not already exist
 
 ' Variables:
  Dim n1    As Integer
  Dim s1    As String

  ' if maximum has not been reached
  If cboSets.ListCount < 100 Then

    ' if valid values in controls
    If txtObjectName.Text <> gsEMPTY Then
      If txtObjectLibrary.Text <> gsEMPTY Then
        If cboObjectType.Text <> gsEMPTY Then
          If cboObjectRelease.Text <> gsEMPTY Then

            ' build string to add to combo box
            s1 = UCase$(Trim$(txtObjectLibrary.Text) & "/" & Trim$(txtObjectName.Text) & " " & Trim$(cboObjectType.Text))
            s1 = s1 & " to " & UCase$(zzPathFormat(Trim$(txtPCFileDirectory.Text)) & Trim$(txtPCFileName.Text))
            s1 = s1 & " " & UCase$(cboObjectRelease.Text)
            
            ' see if already in combo box
            ' if it is then no use to add it again
            For n1 = 0 To cboSets.ListCount - 1
              If s1 = cboSets.List(n1) Then
                If Not bSaving Then MsgBox "'" & s1 & "' already exists as save set.", MB_ICONSTOP
                Exit Sub
              End If
            Next n1
      
            ' add the new entry
            cboSets.AddItem s1

          End If
        End If
      End If
    End If
  
  End If

End Sub

Sub cmdDelete_Click ()

  ' remove current entry
  If cboSets.ListIndex >= 0 Then
    
    ' setup message box
    gsMBText = "Are you sure you wish to delete current entry '"
    gsMBText = gsMBText & cboSets.List(cboSets.ListIndex) & "'?"
    If MsgBox(gsMBText, MB_ICONQUESTION Or MB_YESNO) = IDYES Then
      
      ' remove entry
      cboSets.RemoveItem cboSets.ListIndex
      cboSets.Refresh
      If cboSets.ListCount > 0 Then
        cboSets.ListIndex = 0
      Else
        cboSets.ListIndex = -1
      End If
    
      cmdDelete.Enabled = cboSets.ListCount > 0
    
    End If

  End If

End Sub

Sub cmdExit_Click ()

  Unload Me

End Sub

Sub cmdRestore_Click ()

 ' Description:
 '  Restore object(s)
  
 ' Variables:
  Dim sLibrary          As String     ' original sav library
  Dim sObjectsRestored  As String     ' text showing number of objects restored

  ' please wait...
  Screen.MousePointer = HOURGLASS
  
  ' validate the data
  If DataValidation(False) <> True Then GoTo cmdRestoreExit

  ' get library name
  If GetSaveLibrary(sLibrary) <> True Then GoTo cmdRestoreExit
  
  ' set job priority, ignore messages that
  lblStatus = "Setting job priority"
  lblStatus.Refresh
  sCmd = "CHGJOB RUNPTY(" & cboPriority.Text & ")"
  If RunCmd(gsEMPTY, gsEMPTY) <> True Then GoTo cmdRestoreExit

  ' create the libary, ignore messages that
  ' library created (CPC2102) or library already exists (CPF2111)
  lblStatus = "Library " & txtRestoreLibrary & " being created"
  lblStatus.Refresh
  sCmd = "CRTLIB LIB(" & txtRestoreLibrary & ")"
  If RunCmd("CPC2102", "CPF2111") <> True Then GoTo cmdRestoreExit

  ' create the data file, ignore messages that
  ' file created (CPC7301) or already exists (CPF5813)
  lblStatus = "Data file " & txtDataFileLibrary & "/" & txtDataFileName & " being created"
  lblStatus.Refresh
  sCmd = "CRTPF FILE(" & txtDataFileLibrary & "/" & txtDataFileName & ") RCDLEN(528)"
  If RunCmd("CPC7301", "CPF5813") <> True Then GoTo cmdRestoreExit

  ' clear the data file, ignore messages that
  ' physical file cleared (CPC3101)
  lblStatus = "Data file " & txtDataFileLibrary & "/" & txtDataFileName & " being cleared"
  lblStatus.Refresh
  sCmd = "CLRPFM FILE(" & txtDataFileLibrary & "/" & txtDataFileName & ")"
  If RunCmd("CPC3101", gsEMPTY) <> True Then GoTo cmdRestoreExit

  ' transfer the file from the pc
  lblStatus = "PC file being copied to data file"
  lblStatus.Refresh
  If ObjectUpload() <> True Then GoTo cmdRestoreExit

  ' create save file, ignore messages that
  ' file created (CPC7301) or already exists (CPF5813)
  lblStatus = "Save file " & txtSaveFileLibrary & "/" & txtSaveFileName & " being created"
  lblStatus.Refresh
  sCmd = "CRTSAVF FILE(" & txtSaveFileLibrary & "/" & txtSaveFileName & ")"
  If RunCmd("CPC7301", "CPF5813") <> True Then GoTo cmdRestoreExit

  ' clear the savefile, ignore messages that file cleared
  lblStatus = "Save file " & txtSaveFileLibrary & "/" & txtSaveFileName & " being cleared"
  lblStatus.Refresh
  sCmd = "CLRSAVF FILE(" & txtSaveFileLibrary & "/" & txtSaveFileName & ")"
  If RunCmd("CPC3725", gsEMPTY) <> True Then GoTo cmdRestoreExit

  ' use RPG to copy data file to save file
  If optServerMethod(0) = True Then
    lblStatus = "Data file being copied to save file"
    lblStatus.Refresh
    sCmd = "CALL " & txtServerLibrary & "/" & sSERVER_RPG & " ('" & txtSaveFileName & "' '" & txtSaveFileLibrary & "' '" & txtDataFileName & "' '" & txtDataFileLibrary & "' 'TOSAVF')"
    If RunCmd(gsEMPTY, gsEMPTY) <> True Then GoTo cmdRestoreExit
  
  ' use REXX to copy data file to save file
  Else
    lblStatus = "Data file being copied to save file"
    lblStatus.Refresh
    sCmd = "STRREXPRC SRCMBR(" & sSERVER_REX & ") SRCFILE(" & txtServerLibrary & "/" & sSOURCE_REX & ") PARM('" & txtSaveFileLibrary & "/" & txtSaveFileName & " tosavf " & txtDataFileLibrary & "/" & txtDataFileName & "')"
    If RunCmd(gsEMPTY, gsEMPTY) <> True Then GoTo cmdRestoreExit
  End If

  ' restore the object, ignore messages that
  ' xxxx number of objects restored (CPC3703)
  lblStatus = "Object(s) being restored"
  lblStatus.Refresh
  sCmd = "RSTOBJ OBJ(" & txtObjectName & ") SAVLIB(" & sLibrary & ") DEV(*SAVF) OBJTYPE(" & cboObjectType.Text & ") SAVF(" & txtSaveFileLibrary & "/" & txtSaveFileName & ") RSTLIB(" & txtRestoreLibrary & ")"
  If RunCmd("CPC3703", gsEMPTY) <> True Then GoTo cmdRestoreExit
  
  ' see how many objects restored
  sObjectsRestored = Trim$(Mid$(sMsgs, InStr(sMsgs, ":") + 1))
  If Len(sObjectsRestored) > 3 Then sObjectsRestored = Left$(sObjectsRestored, Len(sObjectsRestored) - 3)
  lblStatus = sObjectsRestored
  lblStatus.Refresh
  
' end of save sequence
cmdRestoreExit:

  ' end "orphaned" remote command job
  nRC = zzSREndConversation(Me.hWnd, cboSystems.Text)
  Screen.MousePointer = DEFAULT

End Sub

Sub cmdSave_Click ()

 ' Description:
 '  Save object(s)
                 
 ' Variables:
  Dim sObjsSaved  As String     ' text showing number of objects saved

  lblStatus = gsEMPTY
  Screen.MousePointer = HOURGLASS

  ' set saving flag
  bSaving = True

  ' save current object(s)
  ' as save set entry
  cmdCreate = True
 
  ' validate the data
  If DataValidation(True) <> True Then GoTo cmdSaveExit

  ' set job priority, ignore messages that
  lblStatus = "Setting job priority"
  lblStatus.Refresh
  sCmd = "CHGJOB RUNPTY(" & cboPriority.Text & ")"
  If RunCmd(gsEMPTY, gsEMPTY) <> True Then GoTo cmdSaveExit

  ' create save file, ignore messages that
  ' file created (CPC7301) or already exists (CPF5813)
  lblStatus = "Save file " & txtSaveFileLibrary & "/" & txtSaveFileName & " being created"
  lblStatus.Refresh
  sCmd = "CRTSAVF FILE(" & txtSaveFileLibrary & "/" & txtSaveFileName & ")"
  If RunCmd("CPC7301", "CPF5813") <> True Then GoTo cmdSaveExit
  
  ' clear the save file, ignore messages that
  ' save file cleared (CPC3725)
  lblStatus = "Save file " & txtSaveFileLibrary & "/" & txtSaveFileName & " being cleared"
  lblStatus.Refresh
  sCmd = "CLRSAVF FILE(" & txtSaveFileLibrary & "/" & txtSaveFileName & ")"
  If RunCmd("CPC3725", gsEMPTY) <> True Then GoTo cmdSaveExit

  ' create the data file, ignore messages that
  ' file created (CPC7301) or already exists (CPF5813)
  lblStatus = "Data file " & txtDataFileLibrary & "/" & txtDataFileName & " being created"
  lblStatus.Refresh
  sCmd = "CRTPF FILE(" & txtDataFileLibrary & "/" & txtDataFileName & ") RCDLEN(528)"
  If RunCmd("CPC7301", "CPF5813") <> True Then GoTo cmdSaveExit

  ' clear the data file, ignore messages that
  ' physical file cleared (CPC3101)
  lblStatus = "Data file " & txtDataFileLibrary & "/" & txtDataFileName & " being cleared"
  lblStatus.Refresh
  sCmd = "CLRPFM FILE(" & txtDataFileLibrary & "/" & txtDataFileName & ")"
  If RunCmd("CPC3101", gsEMPTY) <> True Then GoTo cmdSaveExit

  ' save the object(s), ignore messages that
  ' xxxx number of objects saved
  lblStatus = "Object(s) being saved to save file"
  lblStatus.Refresh
  sCmd = "SAVOBJ OBJ(" & txtObjectName & ") LIB(" & txtObjectLibrary & ") DEV(*SAVF) OBJTYPE(" & cboObjectType.Text & ") SAVF(" & txtSaveFileLibrary & "/" & txtSaveFileName & ") TGTRLS(" & cboObjectRelease.Text & ")"
  If RunCmd("CPC3722", "CPC3723") <> True Then GoTo cmdSaveExit

  ' see how many objects saved
  sObjsSaved = Trim$(Mid$(sMsgs, InStr(sMsgs, ":") + 1))
  If Len(sObjsSaved) > 3 Then sObjsSaved = Left$(sObjsSaved, Len(sObjsSaved) - 3)
  
  ' convert using RPG program
  If optServerMethod(0) Then

    lblStatus = "Save file being copied to data file"
    lblStatus.Refresh
    sCmd = "CALL " & txtServerLibrary & "/" & sSERVER_RPG & " ('" & txtSaveFileName & "' '" & txtSaveFileLibrary & "' '" & txtDataFileName & "' '" & txtDataFileLibrary & "' 'FROMSAVF')"
    If RunCmd(gsEMPTY, gsEMPTY) <> True Then GoTo cmdSaveExit
  
  ' convert using REXX program
  Else
    lblStatus = "Save file being copied to data file"
    lblStatus.Refresh
    sCmd = "STRREXPRC SRCMBR(" & sSERVER_REX & ") SRCFILE(" & txtServerLibrary & "/" & sSOURCE_REX & ") PARM('" & txtSaveFileLibrary & "/" & txtSaveFileName & " fromsavf " & txtDataFileLibrary & "/" & txtDataFileName & "')"
    If RunCmd(gsEMPTY, gsEMPTY) <> True Then GoTo cmdSaveExit
  End If

  ' transfer the file to the pc
  lblStatus = "Data file being copied to PC file"
  lblStatus.Refresh
  If ObjectDownload() <> True Then GoTo cmdSaveExit

  ' show how many objects saved
  lblStatus = sObjsSaved
  lblStatus.Refresh
  
' end of save sequence
cmdSaveExit:

  ' end "orphaned" remote command job
  nRC = zzSREndConversation(Me.hWnd, cboSystems.Text)
  Screen.MousePointer = DEFAULT

  ' set saving flag off
  bSaving = False

End Sub

Sub cmdSets_Click ()

  ' if user wants to view save sets
  If cmdSets.Caption = "Selec&t Save Set" Then

    ' hide/show controls
    zlbl(1).Visible = False
    zlbl(2).Visible = False
    zlbl(14).Visible = False
    txtObjectName.Visible = False
    txtObjectLibrary.Visible = False
    cboObjectType.Visible = False
    cboObjectRelease.Visible = False
    cmdCreate.Visible = False
    cmdDelete.Visible = True
    cmdSave.Visible = False
    cboSets.Visible = True
    cmdDelete.Visible = True
    cmdDelete.Enabled = cboSets.ListCount > 0
    zfraPCDataFile.Visible = False

    ' set selection if none picked
    If cboSets.ListCount > 0 Then
      If cboSets.ListIndex = -1 Then
        cboSets.ListIndex = 0
      End If
    End If
    
    ' change captions
    zlbl(0).Caption = "Save Sets"
    cmdSets.Caption = "&Hide Save Sets"
    cboSets.SetFocus

  Else
    
    ' hide/show controls
    zlbl(0).Visible = True
    zlbl(1).Visible = True
    zlbl(2).Visible = True
    zlbl(14).Visible = True
    txtObjectName.Visible = True
    txtObjectLibrary.Visible = True
    cboObjectType.Visible = True
    cboObjectRelease.Visible = True
    cmdCreate.Visible = True
    cmdSave.Visible = True
    cboSets.Visible = False
    cmdDelete.Visible = False
    zfraPCDataFile.Visible = True

    ' change captions
    zlbl(0).Caption = "Name"
    cmdSets.Caption = "Selec&t Save Set"
    txtObjectName.SetFocus

  End If

End Sub

Function DataValidation (ByVal bSaving%) As Integer

 ' Description:
 '  Makes sure data is correct

 ' Parameters:
 '  bSaving              saving object flag

 ' Variables:
  Dim nFileNum           As Integer  ' file number
  Dim sMsg               As String   ' message text
  Dim sFile              As String   ' file name

  ' clear messages
  gsMBText = gsEMPTY

  ' test system selected
  If Len(cboSystems) = 0 Then
    gsMBText = gsMBText & gsCHR_CR & "Object system is blank. Please enter."
    cboSystems.SetFocus
  End If

  ' test object name
  If Len(Trim$(txtObjectName)) = 0 Then
    gsMBText = gsMBText & gsCHR_CR & "Object name is blank. Please enter."
    txtObjectName.SetFocus
  End If

  ' test object library
  If Len(Trim$(txtObjectLibrary)) = 0 Then
    gsMBText = gsMBText & gsCHR_CR & "Object library is blank. Please enter."
    txtObjectLibrary.SetFocus
  End If

  ' test object type
  If Len(Trim$(cboObjectType.Text)) = 0 Then
    gsMBText = gsMBText & gsCHR_CR & "Object type is blank. Please enter or select."
    cboObjectType.SetFocus
  End If

  ' test object release
  If Len(Trim$(cboObjectRelease.Text)) = 0 Then
    gsMBText = gsMBText & gsCHR_CR & "Object release level is blank. Please enter or select."
    cboObjectRelease.SetFocus
  End If

  ' test save file name
  If Len(Trim$(txtSaveFileName)) = 0 Then
    gsMBText = gsMBText & gsCHR_CR & "Save File name is blank. Please enter."
    txtSaveFileName.SetFocus
  End If

  ' test save File Library
  If Len(Trim$(txtSaveFileLibrary)) = 0 Then
    gsMBText = gsMBText & gsCHR_CR & "Save File library is blank. Please enter."
    txtSaveFileLibrary.SetFocus
  End If
  
  ' test data file name
  If Len(Trim$(txtDataFileName)) = 0 Then
    gsMBText = gsMBText & gsCHR_CR & "Data File name is blank. Please enter."
    txtDataFileName.SetFocus
  End If

  ' test data file Library
  If Len(Trim$(txtDataFileLibrary)) = 0 Then
    gsMBText = gsMBText & gsCHR_CR & "Data File library is blank. Please enter."
    txtDataFileLibrary.SetFocus
  End If

  ' test restore Library
  If Len(Trim$(txtRestoreLibrary)) = 0 Then
    gsMBText = gsMBText & gsCHR_CR & "Restore Library is blank. Please enter."
    txtRestoreLibrary.SetFocus
  End If

  ' test PC file name
  If Len(Trim$(txtPCFileName)) = 0 Then
    gsMBText = gsMBText & gsCHR_CR & "PC File name is blank. Please enter."
    txtPCFileName.SetFocus
  End If

  ' test PC Directory
  If Len(Trim$(txtPCFileDirectory)) = 0 Then
    gsMBText = gsMBText & gsCHR_CR & "PC File directory is blank. Please enter."
    txtPCFileDirectory.SetFocus
  End If

  ' if no error yet see if file name ok
  sFile = Trim$(txtPCFileDirectory)
  If Right$(sFile, 1) <> "\" Then sFile = sFile & "\"
  sFile = sFile & Trim$(txtPCFileName)

  ' if PC file exists then
  If bSaving Then
    If zzFileExists(sFile) Then
      sMsg = UCase$(sFile) & " already exists and will be overwritten."
      sMsg = sMsg & " Do you wish to continue?"
      If MsgBox(sMsg, MB_ICONQUESTION Or MB_YESNO Or MB_DEFBUTTON2) = IDNO Then
        gsMBText = gsMBText & gsCHR_CR & "PC File name or directory must be changed to prevent overwrite. Please enter new name and/or directory."
        txtPCFileName.SetFocus
      End If
    End If
  End If

  ' handle errors
  On Error Resume Next
  Err = 0
  
  ' open the file
  nFileNum = FreeFile
  Open sFile For Binary As #nFileNum
  
  ' if any error then show text on message box
  If Err <> 0 Then gsMBText = gsMBText & gsCHR_CR & "PC File error: " & Error$
  
  ' close file
  Close #nFileNum
  On Error GoTo 0

  ' errors encountered
  If gsMBText <> gsEMPTY Then
    MsgBox gsMBText, MB_ICONSTOP
    DataValidation = False
  
  ' errors not found
  Else
    DataValidation = True
  End If

End Function

Sub Form_Load ()

 ' Variables:
  Dim n1 As Integer

  ' setup global variables
  Call zzSetGlobalVariables

  ' setup title and INI file
  App.Title = "Save/Restore Server Object"
  sINIFile = App.Path & "\srobj.ini"
  
  ' center form
  Call zzFormCenter(Me)
  
  ' setup object types combo
  Call ObjectTypes

  ' setup job priorities
  cboPriority.AddItem "10"
  cboPriority.AddItem "20"
  cboPriority.AddItem "30"
  cboPriority.AddItem "40"
  cboPriority.AddItem "50"
  cboPriority.AddItem "60"

  ' setup job priorities
  cboObjectRelease.AddItem "*CURRENT"
  cboObjectRelease.AddItem "*PRV"
  cboObjectRelease.AddItem "V2R3M0"
  cboObjectRelease.AddItem "V3R0M5"
  cboObjectRelease.AddItem "V3R1M0"
  cboObjectRelease.AddItem "V3R1M1"
  
  ' get program defaults
  Call AppDefaults(bGet)
  
  ' turn on timer
  tmrDisplay.Enabled = True

End Sub

Sub Form_Unload (Cancel As Integer)

  ' save current settings as defaults
  Call AppDefaults(bSAVE)

  ' end program
  End

End Sub

Function GetSaveLibrary (sLibrary$) As Integer

 ' Description:
 '  Returns the library that the object(s)
 '  was originally saved from. This is
 '  necessary for the RSTOBJ command.

 ' Parameters:
 '  sLibrary             library name returned

 ' Variables:
  Dim nFileNum           As Integer  ' file number
  Dim sFile              As String   ' file name
    
  ' open PC file to be uploaded
  sFile = Trim$(txtPCFileDirectory.Text)
  If Right$(sFile, 1) <> "\" Then sFile = sFile & "\"
  sFile = sFile & Trim$(txtPCFileName.Text)
  nFileNum = FreeFile
  Open sFile For Binary As nFileNum

  ' fill with blanks
  sLibrary = Space$(12)

  ' get the string containing library name
  Get #nFileNum, 1315, sLibrary

  ' convert to ascii
  sLibrary = Trim$(zzCV_EBCDICToASCII(Me.hWnd, sLibrary))

  ' close the file
  Close nFileNum

  ' return true or false to caller
  GetSaveLibrary = sLibrary <> gsEMPTY

End Function

Sub Gobble (c As Control, KeyASCII As Integer)
  
  ' gobble up ENTER and make caps
  If KeyASCII = KEY_RETURN Then
    KeyASCII = 0
    SendKeys "{TAB}"
  Else
    KeyASCII = Asc(UCase$(Chr$(KeyASCII)))
  End If

End Sub

Function ObjectDownload () As Integer

 ' Description:
 '  Download data file which contains actual
 '  save file data to the local PC file

 ' Variables:
  Dim lConvID            As Long     ' conversation id
  Dim lProcCallBack      As Long     ' call back address
  Dim nAPIRC             As Integer  ' return code
  Dim nFileNum           As Integer  ' file number
  Dim nNumTemplates      As Integer  ' number of fields
  Dim sBuffer            As String   ' transfer buffer
  Dim sDataReturned      As String   ' data returned
  Dim sFile              As String   ' file name

  ' execute SELECT
  sBuffer = "SELECT * FROM " & Trim$(txtDataFileLibrary.Text) & "/" & Trim$(txtDataFileName.Text)
  nAPIRC = zzTFOpen(Me.hWnd, lProcCallBack, lConvID, sBuffer, cboSystems.Text, nNumTemplates)
  
  ' if select worked
  If nAPIRC = gnTF_OK Then

    ' setup the PC file name
    sFile = Trim$(txtPCFileDirectory)
    If Right$(sFile, 1) <> "\" Then sFile = sFile & "\"
    sFile = sFile & Trim$(txtPCFileName)

    ' delete and open PC file
    On Error Resume Next
    Kill sFile
    nFileNum = FreeFile
    Open sFile For Binary As #nFileNum

    ' retrieve records
    Do
      DoEvents
      nAPIRC = zzTFGetRecord(Me.hWnd, lProcCallBack, lConvID, cboSystems.Text, gnTF_NO_CONVERSION, sDataReturned)
      If nAPIRC <> gnTF_OK Then Exit Do
      Put #nFileNum, , sDataReturned
    Loop

    ' close file and conversation
    Close #nFileNum
    ObjectDownload = True
  
  Else
    MsgBox "File transfer download error 'x'" & Hex$(nAPIRC) & " encountered.", MB_ICONSTOP
    ObjectDownload = False
  End If

  ' close active transfer requests
  nAPIRC = zzTFEndConversation(Me.hWnd, lProcCallBack, lConvID, cboSystems.Text)

End Function

Sub ObjectTypes ()

 ' Description
 '  Loads the object type Combo with valid AS400 object types.

 ' Variables:
  Dim c As Control

  ' use a abbreviated name as a pointer to the cboObjectType Object
  Set c = cboObjectType

  ' clear the combo box contents
  c.Clear

  ' add the combo box items
  c.AddItem "*ALL"
  c.AddItem "*ALRTBL"
  c.AddItem "*AUTL"
  c.AddItem "*BNDDIR"
  c.AddItem "*CFGL"
  c.AddItem "*CHTFMT"
  c.AddItem "*CLD"
  c.AddItem "*CLS"
  c.AddItem "*CMD"
  c.AddItem "*CNNL"
  c.AddItem "*COSD"
  c.AddItem "*CSI"
  c.AddItem "*CSPMAP"
  c.AddItem "*CSPTBL"
  c.AddItem "*CTLD"
  c.AddItem "*DEVD"
  c.AddItem "*DOC"
  c.AddItem "*DTAARA"
  c.AddItem "*DTADCT"
  c.AddItem "*DTAQ"
  c.AddItem "*EDTD"
  c.AddItem "*FCT"
  c.AddItem "*FILE"
  c.AddItem "*FLR"
  c.AddItem "*FNTRSC"
  c.AddItem "*FORMDF"
  c.AddItem "*FTR"
  c.AddItem "*GSS"
  c.AddItem "*JOBD"
  c.AddItem "*JOBQ"
  c.AddItem "*JOBSCD"
  c.AddItem "*JRN"
  c.AddItem "*JRNRCV"
  c.AddItem "*LIB"
  c.AddItem "*LIND"
  c.AddItem "*MENU"
  c.AddItem "*MODD"
  c.AddItem "*MODULE"
  c.AddItem "*MSGF"
  c.AddItem "*MSGQ"
  c.AddItem "*NODL"
  c.AddItem "*NWID"
  c.AddItem "*OUTQ"
  c.AddItem "*OVL"
  c.AddItem "*PAGDFN"
  c.AddItem "*PAGSEG"
  c.AddItem "*PDG"
  c.AddItem "*PGM"
  c.AddItem "*PNLGRP"
  c.AddItem "*PRDVAL"
  c.AddItem "*PRDDFN"
  c.AddItem "*PRDLOD"
  c.AddItem "*QMFORM"
  c.AddItem "*QMQRY"
  c.AddItem "*QRYDFN"
  c.AddItem "*RCT"
  c.AddItem "*SBSD"
  c.AddItem "*SCHIDX"
  c.AddItem "*SPADCT"
  c.AddItem "*SQLPKG"
  c.AddItem "*SRVPGM"
  c.AddItem "*SSND"
  c.AddItem "*S36"
  c.AddItem "*TBL"
  c.AddItem "*USRIDX"
  c.AddItem "*USRPRF"
  c.AddItem "*USRQ"
  c.AddItem "*USRSPC"
  c.AddItem "*WSCCST"

End Sub

Function ObjectUpload () As Integer

 ' Description:
 '  Upload PC file which contains save file
 '  data to the AS/400 data file which will
 '  be copied to the save file.

 ' Variables:
  Dim lConvID            As Long     ' conversation id
  Dim lProcCallBack      As Long     ' call back address
  Dim lI                 As Long     ' working index
  Dim lLOF               As Long     ' length of file
  Dim lRecords           As Long     ' number of records to process
  Dim nAPIRC             As Integer  ' return code
  Dim nFileNum           As Integer  ' file number
  Dim nNumTemplates      As Integer  ' number of fields
  Dim sBuffer            As String   ' transfer buffer
  Dim sFile              As String   ' file name
  Dim sRecord            As String   ' data returned

  ' execute REPLACE
  sBuffer = "REPLACE * INTO " + Trim$(txtDataFileLibrary.Text) & "/" & Trim$(txtDataFileName.Text)
  nAPIRC = zzTFOpen(Me.hWnd, lProcCallBack, lConvID, sBuffer, cboSystems.Text, nNumTemplates)

  ' no transfer error
  If nAPIRC = gnTF_OK Then
    
    ' open PC file to be uploaded
    sFile = Trim$(txtPCFileDirectory.Text)
    If Right$(sFile, 1) <> "\" Then sFile = sFile & "\"
    sFile = sFile & Trim$(txtPCFileName.Text)
    nFileNum = FreeFile
    Open sFile For Binary As nFileNum
    
    ' get count of records
    lLOF = LOF(nFileNum)
    lRecords = lLOF / nSAVEFILE_RECORD_SIZE

    ' write each record to AS/400
    For lI = 1 To lRecords
      sRecord = Space$(nSAVEFILE_RECORD_SIZE)
      Get #nFileNum, , sRecord
      DoEvents
      nAPIRC = zzTFSendRecord(Me.hWnd, lProcCallBack, lConvID, cboSystems.Text, gnTF_NO_CONVERSION, sRecord, nSAVEFILE_RECORD_SIZE)
      If nAPIRC = gnTF_XFER_REQ_NOT_OPENED Then Exit For
      If nAPIRC = gnTF_EOF Then Exit For
    Next lI

    ' close the output file
    Close nFileNum
    ObjectUpload = True
  
  ' error
  Else
    MsgBox "File transfer upload error 'x'" & Hex$(nAPIRC) & " encountered.", MB_ICONSTOP
    ObjectUpload = False
  End If

  ' close file
  nAPIRC = zzTFClose(Me.hWnd, lProcCallBack, lConvID, cboSystems.Text)

  ' close active transfer requests
  nAPIRC = zzTFEndConversation(Me.hWnd, lProcCallBack, lConvID, cboSystems.Text)

End Function

Sub optServerMethod_KeyPress (Index As Integer, KeyASCII As Integer)
  
  ' gobble enter key and convert entry to uppercase
  Call Gobble(optServerMethod(Index), KeyASCII)

End Sub

Function RunCmd (ByVal sIgnoreMsg1$, ByVal sIgnoreMsg2$) As Integer

 ' Description:
 '  Execute command passed

 ' Parameters:
 '  sIgnoreMsg1         1st message to ignore
 '  sIgnoreMsg2         2nd message to ignore

 ' Variables:
  Dim lProcCallBack     As Long     ' call back address
  Dim nAPIRC            As Integer  ' API return code
  Dim nZ                As Integer  ' work index

  ' assume command worked
  RunCmd = True

  ' submit command
  nAPIRC = zzSRCmdAndFormatMsgsWithCB(Me.hWnd, cboSystems.Text, sCmd, sMsgs, lProcCallBack)
  
  ' if no severe error
  If nAPIRC <= gnSR_ERROR Then
  
    ' if messages returned
    If Len(sMsgs) > 0 Then

      ' don't ignore 1st message
      If sIgnoreMsg1 = gsEMPTY Then

        ' show messages
        MsgBox sMsgs, MB_ICONSTOP
        RunCmd = False

      ' ignore 1st message
      Else
        
        ' if 1st message not found
        nZ = InStr(1, sMsgs, sIgnoreMsg1)
        If nZ = 0 Then

          ' don't ignore 2nd message
          If sIgnoreMsg2 = gsEMPTY Then
            MsgBox sMsgs, MB_ICONSTOP
            RunCmd = False

          ' if 2nd message not found then
          ' show messages that were returned
          Else

            If InStr(1, sMsgs, sIgnoreMsg2) = 0 Then
              MsgBox sMsgs, MB_ICONSTOP
              RunCmd = False
            End If
          
          End If

        End If

      End If

    End If
  
  ' if severe error show it
  ' command did not work
  Else
    MsgBox "Remote command error 'x'" & Hex$(nAPIRC) & " encountered.", MB_ICONSTOP
    RunCmd = False
  End If

  ' give up timeslice
  DoEvents
  
End Function

Sub SaveSets (ByVal bGet%)


 ' Description:
 '  Get or save save sets

 ' Parameters:
 '  bGet           get defaults from file

 ' Constants:
  Const sSECTION6 = "SAVESETS"
  
 ' Variables:
  Dim n1  As Integer
  Dim s1  As String

  ' if getting defaults
  If bGet Then

    ' setup save sets section
    nRC = zzINISetSection(sSECTION6)
    
    ' clear any existing entries
    cboSets.Clear
    
    ' up to 100 entries possible
    For n1 = 0 To 99

      ' get next entry
      nRC = zzINIGetString(Right$("0" & Format$(n1), 2), s1)

      ' if something returned add to combo box
      If s1 <> gsEMPTY Then cboSets.AddItem s1
      
    Next n1

    ' move to first entry
    If cboSets.ListCount > 0 Then
      cboSets.ListIndex = 0
    End If

  ' if saving sets
  Else

    ' delete all entries in existing section
    nRC = zzINIDelSection(sSECTION6)
    
    ' setup save sets section
    nRC = zzINISetSection(sSECTION6)

    ' up to 99 entries possible
    For n1 = 0 To cboSets.ListCount - 1

      ' get entry from combo box
      s1 = cboSets.List(n1)

      ' put next entry into INI file
      nRC = zzINIPutString(Right$("0" & Format$(n1), 2), s1)

    Next n1
    
  End If

End Sub

Sub tmrDisplay_Timer ()

  ' show time
  lblTime = Format$(Time$, "h:mm:ss AM/PM")

End Sub

Sub txtDataFileLibrary_KeyPress (KeyASCII As Integer)

  ' gobble enter key and convert entry to uppercase
  Call Gobble(txtDataFileLibrary, KeyASCII)

End Sub

Sub txtDataFileName_KeyPress (KeyASCII As Integer)

  ' gobble enter key and convert entry to uppercase
  Call Gobble(txtDataFileName, KeyASCII)

End Sub

Sub txtObjectLibrary_KeyPress (KeyASCII As Integer)

  ' gobble enter key and convert entry to uppercase
  Call Gobble(txtObjectLibrary, KeyASCII)

End Sub

Sub txtObjectName_KeyPress (KeyASCII As Integer)

  ' gobble enter key and convert entry to uppercase
  Call Gobble(txtObjectName, KeyASCII)

End Sub

Sub txtPCFileDirectory_KeyPress (KeyASCII As Integer)

  ' gobble enter key and convert entry to uppercase
  Call Gobble(txtPCFileDirectory, KeyASCII)

End Sub

Sub txtPCFileName_KeyPress (KeyASCII As Integer)

  ' gobble enter key and convert entry to uppercase
  Call Gobble(txtPCFileName, KeyASCII)

End Sub

Sub txtRestoreLibrary_KeyPress (KeyASCII As Integer)

  ' gobble enter key and convert entry to uppercase
  Call Gobble(txtRestoreLibrary, KeyASCII)

End Sub

Sub txtSaveFileLibrary_KeyPress (KeyASCII As Integer)

  ' gobble enter key and convert entry to uppercase
  Call Gobble(txtSaveFileLibrary, KeyASCII)

End Sub

Sub txtSaveFileName_KeyPress (KeyASCII As Integer)

  ' gobble enter key and convert entry to uppercase
  Call Gobble(txtSaveFileName, KeyASCII)

End Sub

Sub txtServerLibrary_KeyPress (KeyASCII As Integer)
  
  ' gobble enter key and convert entry to uppercase
  Call Gobble(txtServerLibrary, KeyASCII)

End Sub

