VERSION 2.00
Begin Form frmMyRtrMon 
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Router Monitor"
   ClientHeight    =   3690
   ClientLeft      =   2055
   ClientTop       =   2070
   ClientWidth     =   6405
   Height          =   4095
   Icon            =   MYRTRMN2.FRX:0000
   Left            =   1995
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   184.5
   ScaleMode       =   2  'Point
   ScaleWidth      =   320.25
   Top             =   1725
   Width           =   6525
   Begin CommandButton cmdExitWindows 
      Caption         =   "E&xit Windows"
      Height          =   495
      Left            =   4860
      TabIndex        =   1
      Top             =   660
      Width           =   1455
   End
   Begin CheckBox chkDisplay 
      Caption         =   "Do Not Display This Screen"
      Height          =   255
      Left            =   120
      TabIndex        =   2
      Top             =   3180
      Width           =   3105
   End
   Begin CommandButton cmdClose 
      Caption         =   "&Close"
      Height          =   495
      Left            =   4860
      TabIndex        =   0
      Top             =   120
      Width           =   1455
   End
   Begin ComboBox cboSystems 
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00FF0000&
      Height          =   300
      Left            =   3600
      Style           =   2  'Dropdown List
      TabIndex        =   3
      Top             =   2640
      Width           =   1215
   End
   Begin Image imgRtrMon 
      Height          =   480
      Left            =   60
      Picture         =   MYRTRMN2.FRX:0302
      Top             =   120
      Width           =   480
   End
   Begin Image imgRtrOn 
      Height          =   480
      Left            =   60
      Picture         =   MYRTRMN2.FRX:0604
      Top             =   720
      Visible         =   0   'False
      Width           =   480
   End
   Begin Image imgRtrOff 
      Height          =   480
      Left            =   60
      Picture         =   MYRTRMN2.FRX:0906
      Top             =   1320
      Visible         =   0   'False
      Width           =   480
   End
   Begin Label lblMaxFrameSize 
      BackStyle       =   0  'Transparent
      Caption         =   "lblMaxFrameSize"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00FF0000&
      Height          =   255
      Left            =   3600
      TabIndex        =   4
      Top             =   480
      Width           =   1215
   End
   Begin Label zLBL 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Router Loaded and DLLs Available?:"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Index           =   0
      Left            =   540
      TabIndex        =   5
      Top             =   120
      Width           =   3015
   End
   Begin Label zLBL 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Maximum Frame Size:"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Index           =   1
      Left            =   540
      TabIndex        =   18
      Top             =   480
      Width           =   3015
   End
   Begin Label lblLoaded 
      BackStyle       =   0  'Transparent
      Caption         =   "lblLoaded"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00FF0000&
      Height          =   255
      Left            =   3600
      TabIndex        =   17
      Top             =   120
      Width           =   1215
   End
   Begin Label zLBL 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Query Of Conversation State Supported?:"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Index           =   2
      Left            =   540
      TabIndex        =   16
      Top             =   840
      Width           =   3015
   End
   Begin Label zLBL 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Extended Allocate Supported?:"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Index           =   3
      Left            =   540
      TabIndex        =   15
      Top             =   1200
      Width           =   3015
   End
   Begin Label lblState 
      BackStyle       =   0  'Transparent
      Caption         =   "lblState"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00FF0000&
      Height          =   255
      Left            =   3600
      TabIndex        =   14
      Top             =   840
      Width           =   1215
   End
   Begin Label lblExtended 
      BackStyle       =   0  'Transparent
      Caption         =   "lblExtended"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00FF0000&
      Height          =   255
      Left            =   3600
      TabIndex        =   13
      Top             =   1200
      Width           =   1215
   End
   Begin Label zLBL 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Default System's User ID:"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Index           =   5
      Left            =   540
      TabIndex        =   12
      Top             =   1920
      Width           =   3015
   End
   Begin Label zLBL 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Default System:"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Index           =   4
      Left            =   540
      TabIndex        =   11
      Top             =   1560
      Width           =   3015
   End
   Begin Label lblSystem 
      BackStyle       =   0  'Transparent
      Caption         =   "lblSystem"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00FF0000&
      Height          =   255
      Left            =   3600
      TabIndex        =   10
      Top             =   1560
      Width           =   1215
   End
   Begin Label lblUserID 
      BackStyle       =   0  'Transparent
      Caption         =   "lblUserID"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00FF0000&
      Height          =   255
      Left            =   3600
      TabIndex        =   9
      Top             =   1920
      Width           =   1215
   End
   Begin Label zLBL 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Available Systems:"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Index           =   7
      Left            =   540
      TabIndex        =   8
      Top             =   2640
      Width           =   3015
   End
   Begin Label zLBL 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Number Of Available Systems:"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Index           =   6
      Left            =   540
      TabIndex        =   7
      Top             =   2280
      Width           =   3015
   End
   Begin Label lblSystemCount 
      BackStyle       =   0  'Transparent
      Caption         =   "lblSystemCount"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00FF0000&
      Height          =   255
      Left            =   3600
      TabIndex        =   6
      Top             =   2280
      Width           =   1215
   End
End
Option Explicit

 ' Constants:
  Const sNO = "No"
  Const sQUESTION = "?"
  Const sYES = "Yes"

 ' Variables:
  Dim nRC      As Integer         ' return code

Sub cmdClose_Click ()

  Unload Me

End Sub

Sub cmdExitWindows_Click ()

 ' Description:
 '  End windows because router not loaded

  ' build message to ask user if they want to end windows
  gsMBText = "Are you sure you wish to end Windows?"
  gnMBType = MB_ICONQUESTION Or MB_YESNO Or MB_DEFBUTTON2
    
  ' if user wants to end
  If MsgBox(gsMBText, gnMBType) = IDYES Then
    nRC = ExitWindows(0, 0)
  End If
  
End Sub

Sub Form_Load ()

 ' Variables:
  Dim nMaxFrameSize               As Integer
  Dim bQueryConversationSupported As Integer
  Dim bExtendedAllocateSupported  As Integer

  ' title should match caption
  App.Title = Caption

  ' center the form
  Top = (Screen.Height - Height) \ 2
  Left = (Screen.Width - Width) \ 2

  ' tell user to wait
  Screen.MousePointer = HOURGLASS

  ' if router loaded
  If gbRouterLoaded Then

    ' set image on
    imgRtrMon = imgRtrOn

    ' hide exit button
    cmdExitWindows.Visible = False

    ' set label caption
    lblLoaded.Caption = sYES
    
    ' get router capabilities
    Call zzCAGetCapabilities(Me.hWnd, nMaxFrameSize, bQueryConversationSupported, bExtendedAllocateSupported)

    ' put maximum frame size in label
    lblMaxFrameSize.Caption = Format$(nMaxFrameSize)

    ' is query of conversation state supported
    If bQueryConversationSupported Then
      lblState = sYES
    Else
      lblState = sNO
    End If
  
    ' is extended allocate supported
    If bExtendedAllocateSupported Then
      lblExtended = sYES
    Else
      lblExtended = sNO
    End If

    ' get system name
    lblSystem = zzCAGetDefaultSystem(Me.hWnd)
    
    ' get user name
    lblUserID = zzCAGetUserID(Me.hWnd, lblSystem)
    
    ' get system count
    lblSystemCount = Format$(zzCAGetSystemCount(Me.hWnd))
    
    ' get system list
    Call zzCAPutSystemListIntoCtrl(Me.hWnd, cboSystems)
    
  ' if router not loaded
  Else
    
    ' set image off
    imgRtrMon = imgRtrOff

    ' show exit button
    cmdExitWindows.Visible = True
    
    ' set captions
    lblLoaded = sNO
    lblMaxFrameSize = sQUESTION
    lblState = sQUESTION
    lblExtended = sQUESTION
    lblSystem = sQUESTION
    lblUserID = sQUESTION
    lblSystemCount = sQUESTION
    
    ' hide list of systems
    cboSystems.Visible = False

  End If

  ' set form's icon to match image
  Icon = imgRtrMon

  ' no more waiting
  Screen.MousePointer = DEFAULT

End Sub

Sub Form_Unload (Cancel As Integer)

  ' write ini file entry
  nRC = zzINIPutInteger("Omit Check", chkDisplay.Value)
  
  ' end program
  End

End Sub

