VERSION 2.00
Begin Form frmRmtCmd 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Remote Command API Demonstration"
   ClientHeight    =   4785
   ClientLeft      =   750
   ClientTop       =   1380
   ClientWidth     =   7545
   Height          =   5190
   Icon            =   RMTCMD.FRX:0000
   Left            =   690
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   4785
   ScaleWidth      =   7545
   Top             =   1035
   Width           =   7665
   Begin TextBox txtMsgs 
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   1815
      Left            =   660
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   4
      TabStop         =   0   'False
      Top             =   2400
      Width           =   6795
   End
   Begin CommandButton cmdExit 
      Caption         =   "E&xit"
      Height          =   375
      Left            =   5400
      TabIndex        =   3
      Top             =   4320
      Width           =   2055
   End
   Begin TextBox txtCommands 
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   1815
      Left            =   660
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   0
      Top             =   300
      Width           =   6795
   End
   Begin CommandButton cmdExecute 
      Caption         =   "Execute Command"
      Height          =   375
      Left            =   60
      TabIndex        =   1
      Top             =   4320
      Width           =   2055
   End
   Begin CommandButton cmdStop 
      Caption         =   "Stop Conversation"
      Height          =   375
      Left            =   2160
      TabIndex        =   2
      Top             =   4320
      Width           =   2055
   End
   Begin Image imgRmtCmd 
      Height          =   480
      Index           =   0
      Left            =   60
      Picture         =   RMTCMD.FRX:0302
      Top             =   60
      Width           =   480
   End
   Begin Image imgRmtCmd 
      Height          =   480
      Index           =   1
      Left            =   60
      Picture         =   RMTCMD.FRX:0604
      Top             =   660
      Visible         =   0   'False
      Width           =   480
   End
   Begin Image imgRmtCmd 
      Height          =   480
      Index           =   3
      Left            =   60
      Picture         =   RMTCMD.FRX:0906
      Top             =   1860
      Visible         =   0   'False
      Width           =   480
   End
   Begin Image imgRmtCmd 
      Height          =   480
      Index           =   2
      Left            =   60
      Picture         =   RMTCMD.FRX:0C08
      Top             =   1260
      Visible         =   0   'False
      Width           =   480
   End
   Begin Label lblReturnCode 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00000000&
      Height          =   255
      Left            =   6600
      TabIndex        =   7
      Top             =   2160
      Width           =   855
   End
   Begin Label zLBL 
      Alignment       =   2  'Center
      BackColor       =   &H00800000&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "AS/400 Messages and API Return Code"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00FFFFFF&
      Height          =   255
      Index           =   1
      Left            =   660
      TabIndex        =   6
      Top             =   2160
      Width           =   5955
   End
   Begin Label zLBL 
      Alignment       =   2  'Center
      BackColor       =   &H00800000&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Enter AS/400 Command Below"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00FFFFFF&
      Height          =   255
      Index           =   0
      Left            =   660
      TabIndex        =   5
      Top             =   60
      Width           =   6795
   End
End
Option Explicit

 ' Variables:
  Dim nRC                    As Integer    ' wrapper return code
  Dim sMessages              As String     ' error message returned
  Dim sRemoteCommand         As String     ' command to execute
  Dim sSystem                As String     ' default system

Sub cmdExecute_Click ()

 ' Description:
 '  Execute command

 ' Variables:
  Dim nPos13 As Integer     ' position of end of line

  ' take command from text box
  sRemoteCommand = txtCommands.Text

  ' find end of first command
  nPos13 = InStr(sRemoteCommand, gsCHR_CR)
  If nPos13 = 0 Then nPos13 = Len(sRemoteCommand) + 1
  sRemoteCommand = Left$(sRemoteCommand, nPos13 - 1)

  ' tell user to wait
  Screen.MousePointer = HOURGLASS
  
  ' call command
  nRC = zzSRCmdAndFormatMsgs(Me.hWnd, sSystem, sRemoteCommand, sMessages)

  ' if no error
  If nRC = gnSR_OK Then
    
    ' change image to show conversation
    imgRmtCmd(0) = imgRmtCmd(3)

    ' show no error code
    lblReturnCode.Caption = gsEMPTY
    lblReturnCode.BackColor = WHITE
  
  ' if error
  Else

    ' show error code
    lblReturnCode.Caption = Hex$(nRC)
    lblReturnCode.BackColor = RED

    ' if router not loaded then change image and buttons
    If nRC = gnSR_ROUTER_NOT_LOADED Then
      imgRmtCmd(0) = imgRmtCmd(1)
      cmdExecute.Enabled = False
      cmdStop.Enabled = False
    Else
      ' change image to show conversation
      imgRmtCmd(0) = imgRmtCmd(3)
    End If
    
  End If

  ' add any messages to text box
  txtMsgs.Text = sMessages & txtMsgs.Text

  ' no more waiting
  Screen.MousePointer = DEFAULT

End Sub

Sub cmdExit_Click ()
  
  ' end program
  Unload Me

End Sub

Sub cmdStop_Click ()
  
  ' if conversation active
  If imgRmtCmd(0) = imgRmtCmd(3) Then
    
    ' end conversation
    nRC = zzSREndConversation(Me.hWnd, sSystem)

    ' if no error
    If nRC = gnSR_OK Then
    
      ' show no error code
      lblReturnCode.Caption = gsEMPTY
      lblReturnCode.BackColor = WHITE
  
      ' no conversation now active
      imgRmtCmd(0) = imgRmtCmd(2)
  
    ' if error
    Else

      ' show error code
      lblReturnCode.Caption = Hex$(nRC)
      lblReturnCode.BackColor = RED

    End If

  End If
  
End Sub

Sub Form_Load ()

  ' set global variables
  Call zzSetGlobalVariables

  ' center form
  zzFormCenter Me

  ' is router loaded
  If zzCARouterLoaded(Me.hWnd) Then

    ' router active, no conversation yet
    imgRmtCmd(0) = imgRmtCmd(2)

    ' get default system
    sSystem = zzCAGetDefaultSystem(Me.hWnd)

  Else

    ' router inactive, no conversation possible
    imgRmtCmd(0) = imgRmtCmd(1)
    
    ' disable buttons
    cmdExecute.Enabled = False
    cmdStop.Enabled = False

  End If

End Sub

Sub Form_Unload (Cancel As Integer)
  
  ' if conversation active then end it
  cmdStop_Click

  ' end program
  End

End Sub

Sub txtMsgs_GotFocus ()
  
  ' messages cannot be editted
  txtCommands.SetFocus

End Sub

