VERSION 2.00
Begin Form frmFolders 
   Caption         =   "Shared Folder Connections"
   ClientHeight    =   4410
   ClientLeft      =   1260
   ClientTop       =   1500
   ClientWidth     =   6195
   Height          =   4815
   Icon            =   FOLDERS.FRX:0000
   Left            =   1200
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   4410
   ScaleWidth      =   6195
   Top             =   1155
   Width           =   6315
   Begin CommandButton cmdReleaseAll 
      Caption         =   "R&elease All"
      Height          =   315
      Left            =   4860
      TabIndex        =   5
      Top             =   2370
      Width           =   1215
   End
   Begin Frame fraStatus 
      Caption         =   "Drive Status"
      Height          =   1455
      Left            =   120
      TabIndex        =   16
      Top             =   2880
      Width           =   5955
      Begin CommandButton cmdUpdate 
         Caption         =   "&Update"
         Height          =   315
         Left            =   4440
         TabIndex        =   17
         Top             =   300
         Width           =   1215
      End
      Begin Label lblDrives 
         Alignment       =   2  'Center
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "A"
         Height          =   255
         Index           =   1
         Left            =   240
         TabIndex        =   21
         Top             =   720
         Width           =   375
      End
      Begin Label lblDrives 
         Alignment       =   2  'Center
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "B"
         Height          =   255
         Index           =   2
         Left            =   660
         TabIndex        =   22
         Top             =   720
         Width           =   375
      End
      Begin Label lblDrives 
         Alignment       =   2  'Center
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "C"
         Height          =   255
         Index           =   3
         Left            =   1080
         TabIndex        =   23
         Top             =   720
         Width           =   375
      End
      Begin Label lblDrives 
         Alignment       =   2  'Center
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "D"
         Height          =   255
         Index           =   4
         Left            =   1500
         TabIndex        =   24
         Top             =   720
         Width           =   375
      End
      Begin Label lblDrives 
         Alignment       =   2  'Center
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "E"
         Height          =   255
         Index           =   5
         Left            =   1920
         TabIndex        =   25
         Top             =   720
         Width           =   375
      End
      Begin Label lblDrives 
         Alignment       =   2  'Center
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "F"
         Height          =   255
         Index           =   6
         Left            =   2340
         TabIndex        =   26
         Top             =   720
         Width           =   375
      End
      Begin Label lblDrives 
         Alignment       =   2  'Center
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "G"
         Height          =   255
         Index           =   7
         Left            =   2760
         TabIndex        =   27
         Top             =   720
         Width           =   375
      End
      Begin Label lblDrives 
         Alignment       =   2  'Center
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "H"
         Height          =   255
         Index           =   8
         Left            =   3180
         TabIndex        =   28
         Top             =   720
         Width           =   375
      End
      Begin Label lblDrives 
         Alignment       =   2  'Center
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "I"
         Height          =   255
         Index           =   9
         Left            =   3600
         TabIndex        =   29
         Top             =   720
         Width           =   375
      End
      Begin Label lblDrives 
         Alignment       =   2  'Center
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "J"
         Height          =   255
         Index           =   10
         Left            =   4020
         TabIndex        =   30
         Top             =   720
         Width           =   375
      End
      Begin Label lblDrives 
         Alignment       =   2  'Center
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "K"
         Height          =   255
         Index           =   11
         Left            =   4440
         TabIndex        =   31
         Top             =   720
         Width           =   375
      End
      Begin Label lblDrives 
         Alignment       =   2  'Center
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "L"
         Height          =   255
         Index           =   12
         Left            =   4860
         TabIndex        =   32
         Top             =   720
         Width           =   375
      End
      Begin Label lblDrives 
         Alignment       =   2  'Center
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "M"
         Height          =   255
         Index           =   13
         Left            =   5280
         TabIndex        =   33
         Top             =   720
         Width           =   375
      End
      Begin Label lblDrives 
         Alignment       =   2  'Center
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "N"
         Height          =   255
         Index           =   14
         Left            =   240
         TabIndex        =   34
         Top             =   1080
         Width           =   375
      End
      Begin Label lblDrives 
         Alignment       =   2  'Center
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "O"
         Height          =   255
         Index           =   15
         Left            =   660
         TabIndex        =   35
         Top             =   1080
         Width           =   375
      End
      Begin Label lblDrives 
         Alignment       =   2  'Center
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "P"
         Height          =   255
         Index           =   16
         Left            =   1080
         TabIndex        =   36
         Top             =   1080
         Width           =   375
      End
      Begin Label lblDrives 
         Alignment       =   2  'Center
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Q"
         Height          =   255
         Index           =   17
         Left            =   1500
         TabIndex        =   37
         Top             =   1080
         Width           =   375
      End
      Begin Label lblDrives 
         Alignment       =   2  'Center
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "R"
         Height          =   255
         Index           =   18
         Left            =   1920
         TabIndex        =   38
         Top             =   1080
         Width           =   375
      End
      Begin Label lblDrives 
         Alignment       =   2  'Center
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "S"
         Height          =   255
         Index           =   19
         Left            =   2340
         TabIndex        =   39
         Top             =   1080
         Width           =   375
      End
      Begin Label lblDrives 
         Alignment       =   2  'Center
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "T"
         Height          =   255
         Index           =   20
         Left            =   2760
         TabIndex        =   40
         Top             =   1080
         Width           =   375
      End
      Begin Label lblDrives 
         Alignment       =   2  'Center
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "U"
         Height          =   255
         Index           =   21
         Left            =   3180
         TabIndex        =   41
         Top             =   1080
         Width           =   375
      End
      Begin Label lblDrives 
         Alignment       =   2  'Center
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "V"
         Height          =   255
         Index           =   22
         Left            =   3600
         TabIndex        =   42
         Top             =   1080
         Width           =   375
      End
      Begin Label lblDrives 
         Alignment       =   2  'Center
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "W"
         Height          =   255
         Index           =   23
         Left            =   4020
         TabIndex        =   43
         Top             =   1080
         Width           =   375
      End
      Begin Label lblDrives 
         Alignment       =   2  'Center
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "X"
         Height          =   255
         Index           =   24
         Left            =   4440
         TabIndex        =   44
         Top             =   1080
         Width           =   375
      End
      Begin Label lblDrives 
         Alignment       =   2  'Center
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Y"
         Height          =   255
         Index           =   25
         Left            =   4860
         TabIndex        =   45
         Top             =   1080
         Width           =   375
      End
      Begin Label lblDrives 
         Alignment       =   2  'Center
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Z"
         Height          =   255
         Index           =   26
         Left            =   5280
         TabIndex        =   46
         Top             =   1080
         Width           =   375
      End
      Begin Label lblStatus 
         Alignment       =   2  'Center
         BackColor       =   &H000000FF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Unavailable"
         Height          =   255
         Index           =   1
         Left            =   240
         TabIndex        =   18
         Top             =   360
         Width           =   1215
      End
      Begin Label lblStatus 
         Alignment       =   2  'Center
         BackColor       =   &H0000FF00&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Available"
         Height          =   255
         Index           =   0
         Left            =   1560
         TabIndex        =   19
         Top             =   360
         Width           =   1215
      End
      Begin Label lblStatus 
         Alignment       =   2  'Center
         BackColor       =   &H0000FFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Shared"
         Height          =   255
         Index           =   2
         Left            =   2880
         TabIndex        =   20
         Top             =   360
         Width           =   1215
      End
   End
   Begin CommandButton cmdStatus 
      Caption         =   "&Status"
      Height          =   315
      Left            =   4860
      TabIndex        =   3
      Top             =   1530
      Width           =   1215
   End
   Begin CommandButton cmdCapability 
      Caption         =   "Ca&pability"
      Height          =   315
      Left            =   4860
      TabIndex        =   1
      Top             =   750
      Width           =   1215
   End
   Begin CommandButton cmdRelease 
      Caption         =   "&Release"
      Height          =   315
      Left            =   4860
      TabIndex        =   4
      Top             =   1950
      Width           =   1215
   End
   Begin CommandButton cmdAssign 
      Caption         =   "&Assign"
      Height          =   315
      Left            =   4860
      TabIndex        =   2
      Top             =   1170
      Width           =   1215
   End
   Begin CommandButton cmdClose 
      Caption         =   "C&lose"
      Height          =   315
      Left            =   4860
      TabIndex        =   0
      Top             =   180
      Width           =   1215
   End
   Begin ListBox lstConnections 
      Height          =   810
      Left            =   120
      TabIndex        =   15
      Top             =   1980
      Width           =   4455
   End
   Begin Frame fraNew 
      Caption         =   "New Connection"
      Height          =   1545
      Left            =   120
      TabIndex        =   6
      Top             =   90
      Width           =   4455
      Begin ComboBox cboSystems 
         Height          =   300
         Left            =   1650
         Style           =   2  'Dropdown List
         TabIndex        =   8
         Top             =   300
         Width           =   1575
      End
      Begin CommandButton cmdFirst 
         Caption         =   "F&irst Available"
         Height          =   315
         Left            =   2850
         TabIndex        =   13
         Top             =   1110
         Width           =   1395
      End
      Begin ComboBox cboDrive 
         Height          =   300
         Left            =   1650
         Style           =   2  'Dropdown List
         TabIndex        =   12
         Top             =   1110
         Width           =   1035
      End
      Begin TextBox txtFolder 
         Height          =   315
         Left            =   1650
         TabIndex        =   10
         Top             =   690
         Width           =   2595
      End
      Begin Label zlblSystems 
         Caption         =   "&System:"
         Height          =   255
         Left            =   150
         TabIndex        =   7
         Top             =   330
         Width           =   1335
      End
      Begin Label zlblDrive 
         Caption         =   "&Drive:"
         Height          =   255
         Left            =   150
         TabIndex        =   11
         Top             =   1110
         Width           =   1335
      End
      Begin Label zlblFolder 
         Caption         =   "Shared &Folder:"
         Height          =   255
         Left            =   150
         TabIndex        =   9
         Top             =   750
         Width           =   1335
      End
   End
   Begin Label zlblConnections 
      Caption         =   "Current Dri&ve Connections:"
      Height          =   255
      Left            =   120
      TabIndex        =   14
      Top             =   1740
      Width           =   2415
   End
End
Option Explicit

 ' Variables
  Dim nRC           As Integer    ' return code

  Dim nHeight       As Integer
  Dim nWidth        As Integer

Sub cboDrive_Click ()

  ' update form
  Call UpdateForm

End Sub

Sub cmdAssign_Click ()
  
 ' Description:
 '  Assign currently selected drive to folder
  
  ' call assignment wrapper
  MousePointer = HOURGLASS
  nRC = zzSFAssign(Me.hWnd, cboDrive.List(cboDrive.ListIndex), cboSystems.Text, txtFolder)
  MousePointer = DEFAULT

  ' if error occurred show error message
  If nRC <> gnSF_SUCCESS Then
    Call ShowErrorMessage
  
  ' if no error then update display elements
  Else
    Call UpdateDrives
    Call UpdateForm
  End If

End Sub

Sub cmdCapability_Click ()
  
 ' Description:
 '  Display shared folder capability level
  
  ' setup start of message
  gsMBText = "Shared folders, version 2.2 or higher, is "

  ' running or not
  If zzSFGetCapability(Me.hWnd) = 0 Then
    gsMBText = gsMBText & "not running."
  Else
    gsMBText = gsMBText & "running."
  End If

  ' capability level
  gsMBText = gsMBText & " Current capability level is" & Str$(zzSFGetCapability(Me.hWnd)) & "."

  ' show message
  MsgBox gsMBText

End Sub

Sub cmdClose_Click ()
  
  Unload Me

End Sub

Sub cmdFirst_Click ()
  
 ' Description:
 '  Get first available drive

 ' Variables:
  Dim sDrive        As String     ' drive to use

  ' get first available drive
  sDrive = zzSFGetAvailableDrive(Me.hWnd)

  ' if no drive selected then
  ' tell user that none are available
  If sDrive = gsEMPTY Then
    gsMBText = "No drive is available"
    MsgBox gsMBText & " for shared folder use."
  
  ' if drive selected then set
  ' combo box to that drive
  Else
    cboDrive.ListIndex = Asc(sDrive) - 65
  End If

End Sub

Sub cmdRelease_Click ()

 ' Description:
 '  Release currently selected drive/folder
  
  ' call the wrapper
  MousePointer = HOURGLASS
  nRC = zzSFRelease(Me.hWnd, lstConnections.List(lstConnections.ListIndex))
  MousePointer = DEFAULT
  
  ' if error occurred show error message
  If nRC <> gnSF_SUCCESS Then
    Call ShowErrorMessage
  
  ' if no error then update display elements
  Else
    Call UpdateDrives
    Call UpdateForm
  End If

End Sub

Sub cmdReleaseAll_Click ()

 ' Description:
 '  Release all shared folders
  
 ' Variables:
  Dim i            As Integer   ' loop counter

  MousePointer = HOURGLASS

  ' loop through each assigned drive
  For i = 0 To lstConnections.ListCount - 1
    nRC = zzSFRelease(Me.hWnd, Left$(lstConnections.List(i), 1))
  Next i

  ' update drives and forms
  Call UpdateDrives
  Call UpdateForm
  
  ' set to first available drive
  cmdFirst = True
  
  MousePointer = DEFAULT

End Sub

Sub cmdStatus_Click ()

 ' Description:
 '  Show status ofcurrently selected drive/folder
  
 ' Variables:
  Dim sAS400Name  As String
  Dim sFolderName As String

  MousePointer = HOURGLASS
  nRC = zzSFGetAssignedDriveStatus(Me.hWnd, lstConnections.List(lstConnections.ListIndex), sAS400Name, sFolderName)
  MousePointer = DEFAULT

  ' if no error
  If nRC = 0 Then
    
    ' tell user the system and folder name
    gsMBText = "Drive: " & Left$(lstConnections.List(lstConnections.ListIndex), 1) & gsCHR_CRLF
    gsMBText = gsMBText & "System Name: " & sAS400Name & gsCHR_CRLF
    gsMBText = gsMBText & "Folder: " & sFolderName
    MsgBox gsMBText

  ' error
  Else
    Call ShowErrorMessage
  End If

End Sub

Sub cmdUpdate_Click ()

  ' update drive status
  Call UpdateDrives
  Call UpdateForm

End Sub

Sub DemoCode ()
 
 ' Description:
 '  Sample code to open a shared folder and write
 '  data out to it. Although found within this form
 '  this code is for demonstration purposes only and
 '  is not used within this program.

 ' Variables:
  Dim n1        As Integer      ' API return code
  Dim nFileNum  As Integer      ' file number
  Dim sAS400    As String       ' AS/400 selected
  Dim sDrive    As String       ' drive selected
  Dim sFile     As String       ' file used
  Dim sFolder   As String       ' folder used

  ' use default system and QIWSFL2\MRI2924 folder
  sAS400 = gsEMPTY
  sFolder = "QIWSFL2\MRI2924"
  
  ' get available drive
  sDrive = zzSFGetAvailableDrive(Me.hWnd)
  If sDrive <> gsEMPTY Then
  
    ' assign it
    n1 = zzSFAssign(Me.hWnd, sDrive, sAS400, sFolder)
  
    ' if no error
    If n1 = gnSF_SUCCESS Then
  
      ' setup file name
      sFile = "DATETIME.@@@"
      nFileNum = FreeFile
  
      ' open file
      Open sDrive & ":\" & sFile For Output As nFileNum
      
      ' output data
      Print #nFileNum, Date$
      Print #nFileNum, Time$
      
      ' close file
      Close nFileNum
    
      ' release folder
      n1 = zzSFRelease(Me.hWnd, sDrive)
  
    End If
  
  End If

End Sub

Sub Form_Load ()

  ' setup global variables
  Call zzSetGlobalVariables

  ' center form
  zzFormCenter Me

  ' save width and height
  nHeight = Height
  nWidth = Width
  
  ' title same as caption
  App.Title = Caption

  ' populate combo box
  cboDrive.AddItem "A"
  cboDrive.AddItem "B"
  cboDrive.AddItem "C"
  cboDrive.AddItem "D"
  cboDrive.AddItem "E"
  cboDrive.AddItem "F"
  cboDrive.AddItem "G"
  cboDrive.AddItem "H"
  cboDrive.AddItem "I"
  cboDrive.AddItem "J"
  cboDrive.AddItem "K"
  cboDrive.AddItem "L"
  cboDrive.AddItem "M"
  cboDrive.AddItem "N"
  cboDrive.AddItem "O"
  cboDrive.AddItem "P"
  cboDrive.AddItem "Q"
  cboDrive.AddItem "R"
  cboDrive.AddItem "S"
  cboDrive.AddItem "T"
  cboDrive.AddItem "U"
  cboDrive.AddItem "V"
  cboDrive.AddItem "W"
  cboDrive.AddItem "X"
  cboDrive.AddItem "Y"
  cboDrive.AddItem "Z"
  
  ' show current status
  Call UpdateDrives
  
  ' populate list of systems
  Call zzCAPutSystemListIntoCtrl(Me.hWnd, cboSystems)

  ' set to first available drive
  cmdFirst = True
  
End Sub

Sub Form_Resize ()

  ' set width and height
  On Error Resume Next
  If nHeight <> Height Then Height = nHeight
  If nWidth <> Width Then Width = nWidth

End Sub

Sub Form_Unload (Cancel As Integer)

  ' end program
  End

End Sub

Sub lblDrives_Click (Index As Integer)
  
  ' out into current drive
  cboDrive.ListIndex = Index - 1

End Sub

Sub lstConnections_Click ()

  ' update form
  Call UpdateForm

  ' update combo box
  cboDrive.ListIndex = Asc(Left$(lstConnections.List(lstConnections.ListIndex), 1)) - 65

End Sub

Sub ShowErrorMessage ()

 ' Description:
 '  Show error message

 ' Variables
  Dim sError           As String    ' error message
  
  ' message based on error code
  Select Case nRC

    Case gnSF_PATH_NOT_FOUND
      sError = "path not found"
    
    Case gnSF_ACCESS_DENIED
      sError = "access denied"
    
    Case gnSF_INVALID_DRIVE
      sError = "invalid drive"
    
    Case gnSF_NO_MORE_FILES
      sError = "no more files"
    
    Case gnSF_GENERAL_FAILURE
      sError = "general failure"
    
    Case gnSF_NET_NOT_SUPPORTED
      sError = "network request not supported"
    
    Case gnSF_NO_ROUTER
      sError = "router not found"
    
    Case gnSF_SYSTEM_NAME_NOT_FOUND
      sError = "system name not found"
    
    Case gnSF_UNEXPECT_NET_ERROR
      sError = "unexpected network error"
    
    Case gnSF_NET_ACCESS_DENIED
      sError = "network access denied"
    
    Case gnSF_FOLDER_NAME_NOT_FOUND
      sError = "folder name not found"
    
    Case gnSF_NET_NAME_LIMIT
      sError = "name too long"
    
    Case gnSF_TOO_MANY_ASSIGNED
      sError = "maximum number of drives already assigned"
    
    Case gnSF_ALREADY_ASSIGNED
      sError = "drive already assigned"

    Case Else

  End Select

  If sError <> gsEMPTY Then
    sError = ", " & sError & ","
  End If

  ' display error
  gsMBText = "Shared folders API error number " & Hex$(nRC)
  gsMBText = gsMBText & sError & " occurred."
  MsgBox gsMBText, MB_ICONEXCLAMATION

End Sub

Sub UpdateDrives ()

 ' Description:
 '  Update drive information that is shown
 '  at the bottom of the screen.
  
 ' Variables:
  Dim i            As Integer   ' loop counter
  Dim sAS400Name   As String    ' as400 name
  Dim sDriveStatus As String    ' status flags
  Dim sFolderName  As String    ' folder name

  MousePointer = HOURGLASS

  ' clear list box
  lstConnections.Clear

  ' a,b,c never available
  lblDrives(1).BackColor = RED
  lblDrives(2).BackColor = RED
  lblDrives(3).BackColor = RED
  
  ' get status flag for all drives
  sDriveStatus = zzSFGetStatusOfDrives(Me.hWnd)

  ' loop through each drive
  For i = 4 To 26
    
    Select Case Mid$(sDriveStatus, i, 1)
      
      ' unavailable
      Case "0"
        lblDrives(i).BackColor = RED

      ' available
      Case "1"
        lblDrives(i).BackColor = GREEN

      ' shared
      Case "2"
        lblDrives(i).BackColor = YELLOW
        nRC = zzSFGetAssignedDriveStatus(Me.hWnd, Chr$(64 + i), sAS400Name, sFolderName)
        lstConnections.AddItem Chr$(64 + i) & ": \\" & sAS400Name & "\" & sFolderName
        
      ' unknown
      Case Else
        lblDrives(i).BackColor = RED

    End Select
  
  Next i
  
  MousePointer = DEFAULT

End Sub

Sub UpdateForm ()
 
 ' Description:
 '  Update form when drive selected
  
 ' Variables:
  Dim sAS400Name  As String
  Dim sFolderName As String

  ' set folder name
  nRC = zzSFGetAssignedDriveStatus(Me.hWnd, cboDrive.List(cboDrive.ListIndex), sAS400Name, sFolderName)
  txtFolder = UCase$(RTrim$(sFolderName))

  ' handle errors
  On Error Resume Next
  
  ' set command buttons based on current selection
  cmdAssign.Enabled = (lblDrives(cboDrive.ListIndex + 1).BackColor = GREEN)
  cmdStatus.Enabled = (lstConnections.ListIndex >= 0)
  cmdRelease.Enabled = (lstConnections.ListIndex >= 0)

End Sub

