VERSION 2.00
Begin Form frmColumns 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Retrieve Field Descriptions"
   ClientHeight    =   3090
   ClientLeft      =   555
   ClientTop       =   1695
   ClientWidth     =   7365
   Height          =   3495
   Icon            =   COLUMNS.FRX:0000
   Left            =   495
   LinkTopic       =   "Form1"
   ScaleHeight     =   3090
   ScaleWidth      =   7365
   Top             =   1350
   Width           =   7485
   Begin OptionButton optMethod 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Extract Columns"
      Height          =   315
      Index           =   1
      Left            =   2640
      TabIndex        =   3
      Top             =   420
      Width           =   1695
   End
   Begin OptionButton optMethod 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Get Templates"
      Height          =   315
      Index           =   0
      Left            =   2640
      TabIndex        =   2
      Top             =   120
      Width           =   1695
   End
   Begin CommandButton cmdExit 
      Caption         =   "E&xit"
      Height          =   555
      Left            =   5640
      TabIndex        =   5
      Top             =   120
      Width           =   1095
   End
   Begin CommandButton cmdGet 
      Caption         =   "Retrieve"
      Height          =   555
      Left            =   4440
      TabIndex        =   4
      Top             =   120
      Width           =   1095
   End
   Begin TextBox txtFile 
      Height          =   315
      Left            =   1320
      TabIndex        =   1
      Top             =   360
      Width           =   1215
   End
   Begin TextBox txtLibrary 
      Height          =   315
      Left            =   60
      TabIndex        =   0
      Top             =   360
      Width           =   1215
   End
   Begin Grid grdFields 
      Cols            =   10
      FixedCols       =   0
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   2235
      Left            =   60
      TabIndex        =   6
      Top             =   780
      Width           =   7215
   End
   Begin Label zlbl 
      Alignment       =   2  'Center
      BackColor       =   &H00800000&
      Caption         =   "File"
      ForeColor       =   &H00FFFFFF&
      Height          =   255
      Index           =   1
      Left            =   1320
      TabIndex        =   8
      Top             =   120
      Width           =   1215
   End
   Begin Label zlbl 
      Alignment       =   2  'Center
      BackColor       =   &H00800000&
      Caption         =   "Library"
      ForeColor       =   &H00FFFFFF&
      Height          =   255
      Index           =   0
      Left            =   60
      TabIndex        =   7
      Top             =   120
      Width           =   1215
   End
End
Option Explicit

  ' Variables:
  Dim asFieldType(0 To 15) As String     ' field type descriptions

Sub cmdExit_Click ()

  ' end program
  Unload Me

End Sub

Sub cmdGet_Click ()

 ' Description:
 '  Reset grid, retrieve templates, and place field
 '  information into grid.

 ' Variables:
  Dim bNum        As Integer       ' field type numeric flag
  Dim iCnt        As Integer       ' loop counter
  Dim nFields     As Integer       ' number of fields found
  Dim sTmp        As String        ' work field

  ' AS/400 file column information
  ReDim atCols(1 To 500) As TFColType

  ' hourglass
  MousePointer = HOURGLASS
  
  ' reset grid
  grdFields.Rows = 2
  grdFields.FixedRows = 1

  ' if using get template method then
  If optMethod(0) Then

    ' get field templates
    nFields = zzTFGetTemplatesAll(Me.hWnd, zzCAGetDefaultSystem(Me.hWnd), txtLibrary, txtFile, atCols())

  ' if using extract columns method
  Else
  
    ' get column information
    nFields = zzTFGetColumnsAll(Me.hWnd, zzCAGetDefaultSystem(Me.hWnd), txtLibrary, txtFile, atCols())
  
  End If
  
  ' if no templates found
  If nFields = 0 Then
    
    ' tell user of error
    MsgBox "No field descriptions found for " & UCase$(txtLibrary) & "/" & UCase$(txtFile) & "."

  Else
    
    ' add templates to grid
    For iCnt = 1 To nFields

      ' start with field name
      sTmp = atCols(iCnt).sName & gsCHR_TAB
      
      ' add text description of type of field
      sTmp = sTmp & asFieldType(atCols(iCnt).nType) & gsCHR_TAB
      
      ' add buffer length of field
      sTmp = sTmp & Str$(atCols(iCnt).nLen) & gsCHR_TAB

      ' add number of digits
      If atCols(iCnt).nDigits <> 0 Then
        
        sTmp = sTmp & Str$(atCols(iCnt).nDigits) & gsCHR_TAB

        ' if binary, zoned, or packed then
        bNum = (atCols(iCnt).nType = gnTF_BINARY_FIELD)
        bNum = bNum Or (atCols(iCnt).nType = gnTF_ZONED_FIELD)
        bNum = bNum Or (atCols(iCnt).nType = gnTF_PACKED_FIELD)
        If bNum Then
        
          ' add in number of decimals
          sTmp = sTmp & Str$(atCols(iCnt).nDecPos) & gsCHR_TAB
  
        ' else add nothing
        Else
          sTmp = sTmp & gsCHR_TAB
        End If

      Else
        sTmp = sTmp & gsCHR_TAB & gsCHR_TAB
      End If
      
      ' is field null capable
      If atCols(iCnt).bNullCap Then
        sTmp = sTmp & "Yes" & gsCHR_TAB
      Else
        sTmp = sTmp & gsCHR_TAB
      End If

      ' is field variable length
      If atCols(iCnt).bVarLen Then
        sTmp = sTmp & "Yes" & gsCHR_TAB
      Else
        sTmp = sTmp & gsCHR_TAB
      End If

      ' add description
      sTmp = sTmp & atCols(iCnt).sText

      ' add to grid
      grdFields.AddItem sTmp, grdFields.Rows - 1

    Next iCnt
    
    ' remove last record which is empty
    On Error Resume Next
    grdFields.RemoveItem grdFields.Rows - 1
    
  End If
           
  ' no more hourglass
  MousePointer = DEFAULT
  grdFields.SetFocus

End Sub

Sub Form_Load ()

  ' set global character constants
  Call zzSetGlobalVariables

  ' set application title
  App.Title = Caption

  ' setup text descriptions for field types
  asFieldType(0) = "Hexadecimal"
  asFieldType(1) = "Binary"
  asFieldType(2) = "Character"
  asFieldType(3) = "Zoned"
  asFieldType(4) = "Packed"
  asFieldType(5) = "Reserved"
  asFieldType(6) = "IGC Open"
  asFieldType(7) = "IGC Only"
  asFieldType(8) = "IGC Either"
  asFieldType(9) = "Undefined"
  asFieldType(10) = "Undefined"
  asFieldType(11) = "Time"
  asFieldType(12) = "Date"
  asFieldType(13) = "Timestamp"
  asFieldType(14) = "Undefined"
  asFieldType(15) = "Graphic"

  ' setup option default to templates
  optMethod(0).Value = True

  ' format grid
  grdFields.Rows = 2
  grdFields.FixedRows = 1
  grdFields.Cols = 8

  ' build headings
  grdFields.Row = 0
  grdFields.Col = 0
  grdFields.Text = "Name"
  grdFields.ColWidth(0) = 1035

  grdFields.Col = 1
  grdFields.Text = "Type"
  grdFields.ColWidth(1) = 1035

  grdFields.Col = 2
  grdFields.Text = "Size"
  grdFields.ColWidth(2) = 390

  grdFields.Col = 3
  grdFields.Text = "Digits"
  grdFields.ColWidth(3) = 450
  
  grdFields.Col = 4
  grdFields.Text = "Decimals"
  grdFields.ColWidth(4) = 720

  grdFields.Col = 5
  grdFields.Text = "Null Capable?"
  grdFields.ColWidth(5) = 1065

  grdFields.Col = 6
  grdFields.Text = "Variable Length?"
  grdFields.ColWidth(6) = 1275

  grdFields.Col = 7
  grdFields.Text = "Description"
  grdFields.ColWidth(7) = 5000

End Sub

Sub Form_Resize ()

  ' handle resize of grid width and height
  On Error Resume Next
  grdFields.Width = ScaleWidth - (grdFields.Left * 2)
  grdFields.Height = ScaleHeight - grdFields.Top - 60

End Sub

Sub Form_Unload (Cancel As Integer)

  ' end program
  End

End Sub

