Option Explicit
Dim msReturn As String
Dim mlResult As Long

Dim miVideoWidth As Integer
Dim miVideoHeight As Integer
Dim miHwndVideo As Integer

Declare Sub GetWindowRect Lib "USER" (ByVal hWnd As Integer, lpRect As RECT)
Declare Sub MoveWindow Lib "User" (ByVal hWnd As Integer, ByVal x As Integer, ByVal y As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal bRepaint As Integer)
Declare Sub ScreenToClient Lib "User" (ByVal hWnd As Integer, lpPoint As POINTAPI)
Declare Function GetParent Lib "User" (ByVal hWnd As Integer) As Integer

Function HIBYTE (lParam As Long) As Integer
      HIBYTE = lParam \ &H100 And &HFF&
End Function

Function HIWORD (lParam As Long) As Long
Dim dVolume As Double
    If lParam < 0 Then
	dVolume = 2# * 2147483648# + CDbl(lParam)
    Else
	dVolume = CDbl(lParam)
    End If
    HIWORD = CLng(dVolume / CDbl(&H10000) And &HFFFF&)
End Function

Function LOBYTE (wParam As Integer) As Integer
      LOBYTE = wParam And &HFF&
End Function

Function LOWORD (lParam As Long) As Long
      LOWORD = CLng(lParam And &HFFFF&)
End Function

Function MAKELONG (ByVal lLoWord As Long, ByVal lHiWord As Long) As Long
Dim dVolume As Double
    dVolume = (CDbl(lHiWord) * &H10000) + CDbl(lLoWord)
    If dVolume > 2147483647 Then
	MAKELONG = CLng(dVolume - 2# * 2147483648#)
    Else
	MAKELONG = CLng(dVolume)
    End If
End Function

Function mmCenterVideo (ByVal sAlias As String, ByVal iHwnd As Integer) As Long
Dim lRes As Long
Dim lpRect As RECT
Dim iLeft As Integer, iTop As Integer
    
    If miHwndVideo <> 0 Then
	' get the window rectangle of our window
	GetWindowRect iHwnd, lpRect
	iLeft = (lpRect.right - lpRect.left) \ 2 - miVideoWidth \ 2
	iTop = (lpRect.bottom - lpRect.top) \ 2 - miVideoHeight \ 2

	' Move and size the video window
	MoveWindow miHwndVideo, iLeft, iTop, miVideoWidth, miVideoHeight, True
    
	mmCenterVideo = mmSend("put " + sAlias + " destination at 0 0 " + Format$(miVideoWidth) + " " + Format$(miVideoHeight))
    Else
	' Return the error
	mmCenterVideo = -1
    End If
End Function

Function mmClose (ByVal sAlias As String) As Long
    mmClose = mmSend("close " + sAlias + " wait")
End Function

Function mmDefaultVideo (ByVal sAlias As String) As Long
Dim lRes As Long
Dim lpRect As RECT

    If miHwndVideo <> 0 Then
	' Move and size the video window
	MoveWindow miHwndVideo, 0, 0, miVideoWidth, miVideoHeight, True

	' Return the video to it's default size
	mmDefaultVideo = mmSend("put " + sAlias + " destination at 0 0 " + Format$(miVideoWidth) + " " + Format$(miVideoHeight))
    Else
	mmDefaultVideo = -1
    End If

End Function

Function mmDelete (ByVal sAlias As String, ByVal lFrom As Long, ByVal lTo As Long) As Long
    mmDelete = mmSend("delete " + sAlias + " from " + Format$(lFrom) + " to " + Format$(lTo))
End Function

Function mmGetErrorString () As String
Dim sError As String
Dim iLen As Integer, iRes As Integer
    iLen = 255
    sError = Space$(iLen)
    iRes = mciGetErrorString(mlResult, sError, iLen)
    sError = Trim$(sError)
    mmGetErrorString = Left$(sError, Len(sError) - 1)
End Function

Function mmGetLong (ByVal sAlias As String, ByVal sDesc As String) As Long
    If mmSend("status " + sAlias + " " + sDesc + " wait") = 0 Then
	mmGetLong = Val(msReturn)
    Else
	mmGetLong = 0
    End If
End Function

Function mmGetVolume (ByVal sAlias As String, lVolumeLeft As Long, lVolumeRight As Long) As Integer
Dim iDeviceID As Integer
Dim lVolume As Long
    ' Get the device id for our opened audiofile
    iDeviceID = mciGetDeviceID(sAlias) - 1
    If waveOutGetVolume(iDeviceID, lVolume) = 0 Then
	lVolumeLeft = lVolume And &HFFFF&
	lVolumeRight = ((lVolume And &HFFFF0000) / &H10000) And &HFFFF&
	mmGetVolume = True
    Else
	mmGetVolume = False
    End If
End Function

Function mmIsOpen (ByVal sAlias As String) As Integer
Dim lRes As Long
    lRes = mmSend("status " + sAlias + " ready")
    If lRes = 0 Then
	mmIsOpen = msReturn = "true"
    Else
	mmIsOpen = False
    End If
End Function

Function mmLength (ByVal sAlias As String) As Long
    
    If mmSend("status " + sAlias + " length wait") = 0 Then
	mmLength = Val(msReturn)
    Else
	mmLength = 0
    End If
End Function

Function mmNewAudio (ByVal sAlias As String, ByVal iChannels As Integer, ByVal lSamples As Long, ByVal iBitsPerSample As Integer) As Long
Dim lRes As Long
    lRes = mmSend("open new type waveaudio alias " + sAlias + " buffer 5")
    If lRes = 0 Then
	lRes = mmSend("set " + sAlias + " channels" + Format$(iChannels))
    Else
	mmNewAudio = lRes
    End If
    If lRes = 0 Then
	lRes = mmSend("set " + sAlias + " samplespersec" + Format$(lSamples))
    Else
	mmNewAudio = lRes
    End If
    If lRes = 0 Then
	lRes = mmSend("set " + sAlias + " bitspersample" + Format$(iBitsPerSample))
    Else
	mmNewAudio = lRes
    End If
    If lRes = 0 Then
	mmNewAudio = mmSend("cue " + sAlias + " input")
    Else
	mmNewAudio = lRes
    End If
End Function

Function mmOpen (ByVal sFileName As String, ByVal sAlias As String, ByVal bInWindow As Integer, ByVal iHwnd As Integer) As Long
Dim sCommand As String
Dim lRes As Long
Dim lpRectVideo As RECT
    
    sCommand = "open " + sFileName + " alias " + sAlias + " wait"
    If bInWindow Then
	sCommand = sCommand + " parent " + Format$(iHwnd) + " style child"
    End If
    lRes = mmSend(sCommand)
    If bInWindow Then
	lRes = mmSend("status " + sAlias + " window handle")
	If lRes = 0 Then
	    miHwndVideo = Val(msReturn)
	    ' get the window rectangle of the video (= videosize)
	    GetWindowRect miHwndVideo, lpRectVideo
	    miVideoWidth = lpRectVideo.right - lpRectVideo.left
	    miVideoHeight = lpRectVideo.bottom - lpRectVideo.top
	Else
	    miHwndVideo = 0
	    miVideoWidth = 0
	    miVideoHeight = 0
	End If
    End If
    mmOpen = lRes

End Function

Function mmPause (ByVal sAlias As String) As Long
    mmPause = mmSend("pause " + sAlias + " wait")
End Function

Function mmPlay (ByVal sAlias As String, ByVal lFrom As Long, ByVal lTo As Long, ByVal bWait As Integer) As Long
Dim sCommand As String
    sCommand = "play " + sAlias + " from " + Format$(lFrom) + " to " + Format$(lTo)
    If bWait Then
	sCommand = sCommand + " wait"
    End If
    mmPlay = mmSend(sCommand)
End Function

Function mmPosition (ByVal sAlias As String) As Long
    If mmSend("status " + sAlias + " position wait") = 0 Then
	mmPosition = Val(msReturn)
    Else
	mmPosition = 0
    End If
End Function

Function mmRecord (ByVal sAlias As String, ByVal bInsert As Integer) As Long
Dim sCommand As String
    sCommand = "record " + sAlias
    If bInsert Then sCommand = sCommand + " insert"
    mmRecord = mmSend(sCommand)
End Function

Function mmResume (ByVal sAlias As String, ByVal bWait As Integer) As Long
Dim sCommand As String
    sCommand = "resume " + sAlias
    If bWait Then
	sCommand = sCommand + " wait"
    End If
    mmResume = mmSend(sCommand)
End Function

Function mmSave (ByVal sAlias As String, ByVal sFileName As String) As Long
    mmSave = mmSend("save " + sAlias + " " + sFileName)
End Function

Function mmSeek (ByVal sAlias As String, ByVal lPosition As Long) As Long
Dim lRes As Long
    
    lRes = mmSend("set " + sAlias + " seek exactly on")
    If lRes = 0 Then
	mmSeek = mmSend("seek " + sAlias + " to " + Format$(lPosition) + " wait")
    Else
	mmSeek = lRes
    End If
End Function

Function mmSend (ByVal sCommand As String) As Long
Dim iLen As Integer
Dim sReturnTrans As String
Dim sTransFile As String
Dim iRes As Integer
    msReturn = Space$(255)
    iLen = Len(msReturn)
    mlResult = mciSendString(sCommand, msReturn, iLen, 0)
    If mlResult = 0 Then
	msReturn = Trim$(msReturn)
	msReturn = Left$(msReturn, Len(msReturn) - 1)
	If Len(msReturn) Then
	    ' Path to the translation file
	    sTransFile = App.Path
	    If Right$(sTransFile, 1) <> "\" Then sTransFile = sTransFile + "\"
	    sTransFile = sTransFile + gsMMTRANSTABLE
	    ' Translate the string using the translation table

	    sReturnTrans = Space$(255)
	    iRes = GetPrivateProfileString(gsMMTRANSSECTION, msReturn, msReturn, sReturnTrans, 255, sTransFile)
	    msReturn = Trim$(sReturnTrans)
	    msReturn = Left$(msReturn, Len(msReturn) - 1)
	End If
    Else
	msReturn = ""
    End If
    mmSend = mlResult
End Function

Function mmSetDoor (ByVal sAlias, ByVal bDoorOpen As Integer) As Long
Dim sCommand As String
    sCommand = "set " + sAlias + " door "
    If bDoorOpen Then
	sCommand = sCommand + "open"
    Else
	sCommand = sCommand + "closed"
    End If
    mmSetDoor = mmSend(sCommand)
End Function

Function mmSetSilent (ByVal sAlias, ByVal bSilent As Integer) As Long
Dim sCommand As String
    sCommand = "set " + sAlias + " audio all "
    If bSilent Then
	sCommand = sCommand + "off"
    Else
	sCommand = sCommand + "on"
    End If
    mmSetSilent = mmSend(sCommand)
End Function

Function mmSetTimeFormat (ByVal sAlias, ByVal iTimeFormat As Integer) As Long
Dim sCommand As String
Dim sFormat As String
    Select Case iTimeFormat
	Case MCI_FORMAT_MILLISECONDS:
			' Audio/CD-Audio/MIDI/Video Overlay/VideoDisc format
			sFormat = "milliseconds"
	Case MCI_FORMAT_HMS:
			' VideoDisc format
			sFormat = "hms"
	Case MCI_FORMAT_MSF:
			' CD-Audio format
			sFormat = "msf"
	Case MCI_FORMAT_FRAMES:
			' Animation/VideoDisc format
			sFormat = "frames"
	Case MCI_FORMAT_SMPTE_24:
			' MIDI format
			sFormat = "SMPTE 24"
	Case MCI_FORMAT_SMPTE_25:
			' MIDI format
			sFormat = "SMPTE 25"
	Case MCI_FORMAT_SMPTE_30:
			' MIDI format
			sFormat = "SMPTE 30"
	Case MCI_FORMAT_SMPTE_30DROP:
			' MIDI format
			sFormat = "SMPTE 30 drop"
	Case MCI_FORMAT_BYTES:
			' Audio format
			sFormat = "bytes"
	Case MCI_FORMAT_SAMPLES:
			' Audio format
			sFormat = "samples"
	Case MCI_FORMAT_TMSF:
			' CD-Audio format
			sFormat = "tmsf"
	Case Else:
			'Unknown time format
			mmSetTimeFormat = MCIERR_BAD_TIME_FORMAT
			Exit Function
    End Select
    sCommand = "set " + sAlias + " time format " + sFormat
    mmSetTimeFormat = mmSend(sCommand)
End Function

Function mmSetVolume (ByVal sAlias As String, ByVal lVolumeLeft As Long, lVolumeRight As Long) As Integer
Dim iDeviceID As Integer
    ' Get the device id for our opened audiofile
    iDeviceID = mciGetDeviceID(sAlias) - 1
    
    ' Create a double word with the volume for left
    ' and right channel set to equal value and pass it to
    ' waveOutSetVolume
    mmSetVolume = (waveOutSetVolume(iDeviceID, Val("&H" + Hex$(lVolumeRight)), Val("&H" & Hex$(lVolumeLeft))) = 0)
End Function

Function mmSizeVideo (ByVal sAlias As String, ByVal iHwnd As Integer) As Long
Dim lRes As Long

Dim lpRect As RECT
Dim ptPoint As POINTAPI

Dim iLeft As Integer, iTop As Integer
    
    If miHwndVideo <> 0 Then

	' get the window rectangle of our window
	GetWindowRect iHwnd, lpRect
	ptPoint.x = lpRect.left
	ptPoint.y = lpRect.top

	' map the screen coordinates to left and top positions
	ScreenToClient GetParent(iHwnd), ptPoint
	
	' Move and size our own window
	MoveWindow iHwnd, ptPoint.x, ptPoint.y, miVideoWidth, miVideoHeight, True

	' Move and size the video window
	MoveWindow miHwndVideo, 0, 0, miVideoWidth, miVideoHeight, True
	
	' Return the video to it's normal size
	mmSizeVideo = mmSend("put " + sAlias + " destination at 0 0 " + Format$(miVideoWidth) + " " + Format$(miVideoHeight))
    Else
	mmSizeVideo = -1
    End If
End Function

Function mmStatus (ByVal sAlias As String) As String
    
    If mmSend("status " + sAlias + " mode") = 0 Then
	mmStatus = msReturn
    Else
	mmStatus = "error"
    End If
End Function

Function mmStop (ByVal sAlias As String) As Long
    mmStop = mmSend("stop " + sAlias + " wait")
End Function

Function mmStretchVideo (ByVal sAlias As String, ByVal iHwnd As Integer) As Long
Dim lRes As Long
Dim lpRect As RECT

    ' Check if the device is capable of stretching
    lRes = mmSend("capability " + sAlias + " can stretch")
    If Mid$(msReturn, 1, 4) = "true" Or Mid$(msReturn, 1, 4) = "waar" Then ' device can stretch
	' Obtain the window handle of the video window
	If miHwndVideo <> 0 Then
	
	    ' Enable stretching for those devices that need it
	    lRes = mmSend("window " + sAlias + " stretch")
	
	    ' Get the dimensions of our window
	    GetWindowRect iHwnd, lpRect

	    ' Move and size the video window
	    MoveWindow miHwndVideo, 0, 0, lpRect.right - lpRect.left, lpRect.bottom - lpRect.top, True

	    ' Stretch the video to the size of our window
	    mmStretchVideo = mmSend("put " + sAlias + " destination at 0 0 " + Format$(lpRect.right - lpRect.left) + " " + Format$(lpRect.bottom - lpRect.top))
	Else
	    mmStretchVideo = -1
	End If
    Else
	mmStretchVideo = lRes
    End If
End Function

Function mmVideoHeight (ByVal sAlias As String) As Long
    mmVideoHeight = miVideoHeight
End Function

Function mmVideoWidth (ByVal sAlias As String) As Long
    mmVideoWidth = miVideoWidth
End Function

