Type RECT   ' Same as Windows API
    left As Integer
    top As Integer
    right As Integer
    bottom As Integer
End Type

Type POINTAPI   ' Same as Windows API
    x As Integer
    y As Integer
End Type

' API Call for international support
Declare Function GetPrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer, ByVal lpFileName As String) As Integer

' Translation table in INI file
Global Const gsMMTRANSTABLE = "MMRETURN.INI"
Global Const gsMMTRANSSECTION = "mmtranslate"

' ***************************************************************************
'                             Sound support
' ****************************************************************************/
Declare Function sndPlaySound Lib "MMSYSTEM" (ByVal lpszSoundName As String, ByVal uFlags As Integer) As Integer

'  flag values for wFlags parameter
Global Const SND_SYNC = &H0                 '  play synchronously (default)
Global Const SND_ASYNC = &H1                '  play asynchronously
Global Const SND_NODEFAULT = &H2            '  don't use default sound
Global Const SND_MEMORY = &H4               '  lpszSoundName points to a memory file
Global Const SND_LOOP = &H8                 '  loop the sound until next sndPlaySound
Global Const SND_NOSTOP = &H10              '  don't stop any currently playing sound

Declare Function waveOutGetVolume Lib "MMSYSTEM" (ByVal udeviceid As Integer, lpdwvolume As Long) As Integer
Declare Function waveOutSetVolume Lib "MMSYSTEM" (ByVal udeviceid As Integer, ByVal wVolumeRight As Integer, ByVal wVolumeLeft As Integer) As Integer
Declare Function waveOutGetErrorText Lib "MMSYSTEM" (ByVal uError As Integer, ByVal lpText As String, ByVal uSize As Integer) As Integer
' ***************************************************************************
'                             MCI support
' ****************************************************************************/

'  MCI function prototypes
Declare Function mciSendCommand Lib "mmsystem" (ByVal udeviceid As Integer, ByVal uMessage As Integer, ByVal dwParam1 As Long, ByVal dwParam2 As Long) As Long
Declare Function mciSendString Lib "mmsystem" (ByVal lpstrCommand As String, ByVal lpstrReturnString As String, ByVal uReturnLength As Integer, ByVal hWndCallback As Integer) As Long
Declare Function mciGetDeviceID Lib "mmsystem" (ByVal lpstrName As String) As Integer
Declare Function mciGetDeviceIDFromElementID Lib "mmsystem" (ByVal dwElementID As Long, ByVal lpstrType As String) As Integer
Declare Function mciGetErrorString Lib "mmsystem" (ByVal wError As Long, ByVal lpstrBuffer As String, ByVal uLength As Integer) As Integer
Declare Function mciGetCreatorTask Lib "mmsystem" (ByVal udeviceid As Integer) As Integer
Declare Function mciExecute Lib "mmsystem" (ByVal lpstrCommand As String) As Integer

'  MCI error return values
Global Const MCIERR_BASE = 256

Global Const MCI_STRING_OFFSET = 512
Global Const MCI_VD_OFFSET = 1024
Global Const MCI_CD_OFFSET = 1088
Global Const MCI_WAVE_OFFSET = 1152
Global Const MCI_SEQ_OFFSET = 1216

Global Const MCIERR_INVALID_DEVICE_ID = (MCIERR_BASE + 1)
Global Const MCIERR_UNRECOGNIZED_KEYWORD = (MCIERR_BASE + 3)
Global Const MCIERR_UNRECOGNIZED_COMMAND = (MCIERR_BASE + 5)
Global Const MCIERR_HARDWARE = (MCIERR_BASE + 6)
Global Const MCIERR_INVALID_DEVICE_NAME = (MCIERR_BASE + 7)
Global Const MCIERR_OUT_OF_MEMORY = (MCIERR_BASE + 8)
Global Const MCIERR_DEVICE_OPEN = (MCIERR_BASE + 9)
Global Const MCIERR_CANNOT_LOAD_DRIVER = (MCIERR_BASE + 10)
Global Const MCIERR_MISSING_COMMAND_STRING = (MCIERR_BASE + 11)
Global Const MCIERR_PARAM_OVERFLOW = (MCIERR_BASE + 12)
Global Const MCIERR_MISSING_STRING_ARGUMENT = (MCIERR_BASE + 13)
Global Const MCIERR_BAD_INTEGER = (MCIERR_BASE + 14)
Global Const MCIERR_PARSER_INTERNAL = (MCIERR_BASE + 15)
Global Const MCIERR_DRIVER_INTERNAL = (MCIERR_BASE + 16)
Global Const MCIERR_MISSING_PARAMETER = (MCIERR_BASE + 17)
Global Const MCIERR_UNSUPPORTED_FUNCTION = (MCIERR_BASE + 18)
Global Const MCIERR_FILE_NOT_FOUND = (MCIERR_BASE + 19)
Global Const MCIERR_DEVICE_NOT_READY = (MCIERR_BASE + 20)
Global Const MCIERR_INTERNAL = (MCIERR_BASE + 21)
Global Const MCIERR_DRIVER = (MCIERR_BASE + 22)
Global Const MCIERR_CANNOT_USE_ALL = (MCIERR_BASE + 23)
Global Const MCIERR_MULTIPLE = (MCIERR_BASE + 24)
Global Const MCIERR_EXTENSION_NOT_FOUND = (MCIERR_BASE + 25)
Global Const MCIERR_OUTOFRANGE = (MCIERR_BASE + 26)
Global Const MCIERR_FLAGS_NOT_COMPATIBLE = (MCIERR_BASE + 28)
Global Const MCIERR_FILE_NOT_SAVED = (MCIERR_BASE + 30)
Global Const MCIERR_DEVICE_TYPE_REQUIRED = (MCIERR_BASE + 31)
Global Const MCIERR_DEVICE_LOCKED = (MCIERR_BASE + 32)
Global Const MCIERR_DUPLICATE_ALIAS = (MCIERR_BASE + 33)
Global Const MCIERR_BAD_CONSTANT = (MCIERR_BASE + 34)
Global Const MCIERR_MUST_USE_SHAREABLE = (MCIERR_BASE + 35)
Global Const MCIERR_MISSING_DEVICE_NAME = (MCIERR_BASE + 36)
Global Const MCIERR_BAD_TIME_FORMAT = (MCIERR_BASE + 37)
Global Const MCIERR_NO_CLOSING_QUOTE = (MCIERR_BASE + 38)
Global Const MCIERR_DUPLICATE_FLAGS = (MCIERR_BASE + 39)
Global Const MCIERR_INVALID_FILE = (MCIERR_BASE + 40)
Global Const MCIERR_NULL_PARAMETER_BLOCK = (MCIERR_BASE + 41)
Global Const MCIERR_UNNAMED_RESOURCE = (MCIERR_BASE + 42)
Global Const MCIERR_NEW_REQUIRES_ALIAS = (MCIERR_BASE + 43)
Global Const MCIERR_NOTIFY_ON_AUTO_OPEN = (MCIERR_BASE + 44)
Global Const MCIERR_NO_ELEMENT_ALLOWED = (MCIERR_BASE + 45)
Global Const MCIERR_NONAPPLICABLE_FUNCTION = (MCIERR_BASE + 46)
Global Const MCIERR_ILLEGAL_FOR_AUTO_OPEN = (MCIERR_BASE + 47)
Global Const MCIERR_FILENAME_REQUIRED = (MCIERR_BASE + 48)
Global Const MCIERR_EXTRA_CHARACTERS = (MCIERR_BASE + 49)
Global Const MCIERR_DEVICE_NOT_INSTALLED = (MCIERR_BASE + 50)
Global Const MCIERR_GET_CD = (MCIERR_BASE + 51)
Global Const MCIERR_SET_CD = (MCIERR_BASE + 52)
Global Const MCIERR_SET_DRIVE = (MCIERR_BASE + 53)
Global Const MCIERR_DEVICE_LENGTH = (MCIERR_BASE + 54)
Global Const MCIERR_DEVICE_ORD_LENGTH = (MCIERR_BASE + 55)
Global Const MCIERR_NO_INTEGER = (MCIERR_BASE + 56)
Global Const MCIERR_WAVE_OUTPUTSINUSE = (MCIERR_BASE + 64)
Global Const MCIERR_WAVE_SETOUTPUTINUSE = (MCIERR_BASE + 65)
Global Const MCIERR_WAVE_INPUTSINUSE = (MCIERR_BASE + 66)
Global Const MCIERR_WAVE_SETINPUTINUSE = (MCIERR_BASE + 67)
Global Const MCIERR_WAVE_OUTPUTUNSPECIFIED = (MCIERR_BASE + 68)
Global Const MCIERR_WAVE_INPUTUNSPECIFIED = (MCIERR_BASE + 69)
Global Const MCIERR_WAVE_OUTPUTSUNSUITABLE = (MCIERR_BASE + 70)
Global Const MCIERR_WAVE_SETOUTPUTUNSUITABLE = (MCIERR_BASE + 71)
Global Const MCIERR_WAVE_INPUTSUNSUITABLE = (MCIERR_BASE + 72)
Global Const MCIERR_WAVE_SETINPUTUNSUITABLE = (MCIERR_BASE + 73)
Global Const MCIERR_SEQ_DIV_INCOMPATIBLE = (MCIERR_BASE + 80)
Global Const MCIERR_SEQ_PORT_INUSE = (MCIERR_BASE + 81)
Global Const MCIERR_SEQ_PORT_NONEXISTENT = (MCIERR_BASE + 82)
Global Const MCIERR_SEQ_PORT_MAPNODEVICE = (MCIERR_BASE + 83)
Global Const MCIERR_SEQ_PORT_MISCERROR = (MCIERR_BASE + 84)
Global Const MCIERR_SEQ_TIMER = (MCIERR_BASE + 85)
Global Const MCIERR_SEQ_PORTUNSPECIFIED = (MCIERR_BASE + 86)
Global Const MCIERR_SEQ_NOMIDIPRESENT = (MCIERR_BASE + 87)
Global Const MCIERR_NO_WINDOW = (MCIERR_BASE + 90)
Global Const MCIERR_CREATEWINDOW = (MCIERR_BASE + 91)
Global Const MCIERR_FILE_READ = (MCIERR_BASE + 92)
Global Const MCIERR_FILE_WRITE = (MCIERR_BASE + 93)

'  all custom device driver errors must be >= than this value
Global Const MCIERR_CUSTOM_DRIVER_BASE = (MCIERR_BASE + 256)

'  MCI command message identifiers
Global Const MCI_OPEN = &H803
Global Const MCI_CLOSE = &H804
Global Const MCI_ESCAPE = &H805
Global Const MCI_PLAY = &H806
Global Const MCI_SEEK = &H807
Global Const MCI_STOP = &H808
Global Const MCI_PAUSE = &H809
Global Const MCI_INFO = &H80A
Global Const MCI_GETDEVCAPS = &H80B
Global Const MCI_SPIN = &H80C
Global Const MCI_SET = &H80D
Global Const MCI_STEP = &H80E
Global Const MCI_RECORD = &H80F
Global Const MCI_SYSINFO = &H810
Global Const MCI_BREAK = &H811
Global Const MCI_SOUND = &H812
Global Const MCI_SAVE = &H813
Global Const MCI_STATUS = &H814
Global Const MCI_CUE = &H830
Global Const MCI_REALIZE = &H840
Global Const MCI_WINDOW = &H841
Global Const MCI_PUT = &H842
Global Const MCI_WHERE = &H843
Global Const MCI_FREEZE = &H844
Global Const MCI_UNFREEZE = &H845
Global Const MCI_LOAD = &H850
Global Const MCI_CUT = &H851
Global Const MCI_COPY = &H852
Global Const MCI_PASTE = &H853
Global Const MCI_UPDATE = &H854
Global Const MCI_RESUME = &H855
Global Const MCI_DELETE = &H856

'  device ID for "all devices"
Global Const MCI_ALL_DEVICE_ID = &HFFFF

'  constants for predefined MCI device types
Global Const MCI_DEVTYPE_VCR = (MCI_STRING_OFFSET + 1)
Global Const MCI_DEVTYPE_VIDEODISC = (MCI_STRING_OFFSET + 2)
Global Const MCI_DEVTYPE_OVERLAY = (MCI_STRING_OFFSET + 3)
Global Const MCI_DEVTYPE_CD_AUDIO = (MCI_STRING_OFFSET + 4)
Global Const MCI_DEVTYPE_DAT = (MCI_STRING_OFFSET + 5)
Global Const MCI_DEVTYPE_SCANNER = (MCI_STRING_OFFSET + 6)
Global Const MCI_DEVTYPE_ANIMATION = (MCI_STRING_OFFSET + 7)
Global Const MCI_DEVTYPE_DIGITAL_VIDEO = (MCI_STRING_OFFSET + 8)
Global Const MCI_DEVTYPE_OTHER = (MCI_STRING_OFFSET + 9)
Global Const MCI_DEVTYPE_WAVEFORM_AUDIO = (MCI_STRING_OFFSET + 10)
Global Const MCI_DEVTYPE_SEQUENCER = (MCI_STRING_OFFSET + 11)

Global Const MCI_DEVTYPE_FIRST = MCI_DEVTYPE_VCR
Global Const MCI_DEVTYPE_LAST = MCI_DEVTYPE_SEQUENCER

'  return values for 'status mode' command
Global Const MCI_MODE_NOT_READY = (MCI_STRING_OFFSET + 12)
Global Const MCI_MODE_STOP = (MCI_STRING_OFFSET + 13)
Global Const MCI_MODE_PLAY = (MCI_STRING_OFFSET + 14)
Global Const MCI_MODE_RECORD = (MCI_STRING_OFFSET + 15)
Global Const MCI_MODE_SEEK = (MCI_STRING_OFFSET + 16)
Global Const MCI_MODE_PAUSE = (MCI_STRING_OFFSET + 17)
Global Const MCI_MODE_OPEN = (MCI_STRING_OFFSET + 18)

'  constants used in 'set time format' and 'status time format' commands
Global Const MCI_FORMAT_MILLISECONDS = 0
Global Const MCI_FORMAT_HMS = 1
Global Const MCI_FORMAT_MSF = 2
Global Const MCI_FORMAT_FRAMES = 3
Global Const MCI_FORMAT_SMPTE_24 = 4
Global Const MCI_FORMAT_SMPTE_25 = 5
Global Const MCI_FORMAT_SMPTE_30 = 6
Global Const MCI_FORMAT_SMPTE_30DROP = 7
Global Const MCI_FORMAT_BYTES = 8
Global Const MCI_FORMAT_SAMPLES = 9
Global Const MCI_FORMAT_TMSF = 10

'  MCI time format conversion macros

'  flags for wParam of MM_MCINOTIFY message
Global Const MCI_NOTIFY_SUCCESSFUL = &H1
Global Const MCI_NOTIFY_SUPERSEDED = &H2
Global Const MCI_NOTIFY_ABORTED = &H4
Global Const MCI_NOTIFY_FAILURE = &H8

'  common flags for dwFlags parameter of MCI command messages
Global Const MCI_NOTIFY = &H1&
Global Const MCI_WAIT = &H2&
Global Const MCI_FROM = &H4&
Global Const MCI_TO = &H8&
Global Const MCI_TRACK = &H10&

'  flags for dwFlags parameter of MCI_OPEN command message
Global Const MCI_OPEN_SHAREABLE = &H100&
Global Const MCI_OPEN_ELEMENT = &H200&
Global Const MCI_OPEN_ALIAS = &H400&
Global Const MCI_OPEN_ELEMENT_ID = &H800&
Global Const MCI_OPEN_TYPE_ID = &H1000&
Global Const MCI_OPEN_TYPE = &H2000&

'  flags for dwFlags parameter of MCI_SEEK command message
Global Const MCI_SEEK_TO_START = &H100&
Global Const MCI_SEEK_TO_END = &H200&

'  flags for dwFlags parameter of MCI_STATUS command message
Global Const MCI_STATUS_ITEM = &H100&
Global Const MCI_STATUS_START = &H200&

'  flags for dwItem field of the MCI_STATUS_PARMS parameter block
Global Const MCI_STATUS_LENGTH = &H1&
Global Const MCI_STATUS_POSITION = &H2&
Global Const MCI_STATUS_NUMBER_OF_TRACKS = &H3&
Global Const MCI_STATUS_MODE = &H4&
Global Const MCI_STATUS_MEDIA_PRESENT = &H5&
Global Const MCI_STATUS_TIME_FORMAT = &H6&
Global Const MCI_STATUS_READY = &H7&
Global Const MCI_STATUS_CURRENT_TRACK = &H8&

'  flags for dwFlags parameter of MCI_INFO command message
Global Const MCI_INFO_PRODUCT = &H100&
Global Const MCI_INFO_FILE = &H200&

'  flags for dwFlags parameter of MCI_GETDEVCAPS command message
Global Const MCI_GETDEVCAPS_ITEM = &H100&

'  flags for dwItem field of the MCI_GETDEVCAPS_PARMS parameter block
Global Const MCI_GETDEVCAPS_CAN_RECORD = &H1&
Global Const MCI_GETDEVCAPS_HAS_AUDIO = &H2&
Global Const MCI_GETDEVCAPS_HAS_VIDEO = &H3&
Global Const MCI_GETDEVCAPS_DEVICE_TYPE = &H4&
Global Const MCI_GETDEVCAPS_USES_FILES = &H5&
Global Const MCI_GETDEVCAPS_COMPOUND_DEVICE = &H6&
Global Const MCI_GETDEVCAPS_CAN_EJECT = &H7&
Global Const MCI_GETDEVCAPS_CAN_PLAY = &H8&
Global Const MCI_GETDEVCAPS_CAN_SAVE = &H9&

'  flags for dwFlags parameter of MCI_SYSINFO command message
Global Const MCI_SYSINFO_QUANTITY = &H100&
Global Const MCI_SYSINFO_OPEN = &H200&
Global Const MCI_SYSINFO_NAME = &H400&
Global Const MCI_SYSINFO_INSTALLNAME = &H800&

'  flags for dwFlags parameter of MCI_SET command message
Global Const MCI_SET_DOOR_OPEN = &H100&
Global Const MCI_SET_DOOR_CLOSED = &H200&
Global Const MCI_SET_TIME_FORMAT = &H400&
Global Const MCI_SET_AUDIO = &H800&
Global Const MCI_SET_VIDEO = &H1000&
Global Const MCI_SET_ON = &H2000&
Global Const MCI_SET_OFF = &H4000&

'  flags for dwAudio field of MCI_SET_PARMS or MCI_SEQ_SET_PARMS
Global Const MCI_SET_AUDIO_ALL = &H0&
Global Const MCI_SET_AUDIO_LEFT = &H1&
Global Const MCI_SET_AUDIO_RIGHT = &H2&

'  flags for dwFlags parameter of MCI_BREAK command message
Global Const MCI_BREAK_KEY = &H100&
Global Const MCI_BREAK_HWND = &H200&
Global Const MCI_BREAK_OFF = &H400&

'  flags for dwFlags parameter of MCI_RECORD command message
Global Const MCI_RECORD_INSERT = &H100&
Global Const MCI_RECORD_OVERWRITE = &H200&

'  flags for dwFlags parameter of MCI_SOUND command message
Global Const MCI_SOUND_NAME = &H100&

'  flags for dwFlags parameter of MCI_SAVE command message
Global Const MCI_SAVE_FILE = &H100&

'  flags for dwFlags parameter of MCI_LOAD command message
Global Const MCI_LOAD_FILE = &H100&

'  generic parameter block for MCI command messages with no special parameters
Type MCI_GENERIC_PARMS
	dwCallback As Long
End Type
' typedef MCI_GENERIC_PARMS FAR *LPMCI_GENERIC_PARMS;

'  parameter block for MCI_OPEN command message
Type MCI_OPEN_PARMS
    dwCallback As Long
    wDeviceID As Integer
    wReserved0 As Integer
    lpstrDeviceType As String
    lpstrElementName As String
    lpstrAlias As String
End Type

'  parameter block for MCI_PLAY command message
Type MCI_PLAY_PARMS
    dwCallback As Long
    dwFrom As Long
    dwTo As Long
End Type

'  parameter block for MCI_SEEK command message
Type MCI_SEEK_PARMS
    dwCallback As Long
    dwTo As Long
End Type

'  parameter block for MCI_STATUS command message
Type MCI_STATUS_PARMS
    dwCallback As Long
    dwReturn As Long
    dwItem As Long
    dwTrack As Long
End Type

'  parameter block for MCI_INFO command message
Type MCI_INFO_PARMS
    dwCallback As Long
    lpstrReturn As Long
    dwRetSize As Long
End Type

'  parameter block for MCI_GETDEVCAPS command message
Type MCI_GETDEVCAPS_PARMS
    dwCallback As Long
    dwReturn As Long
    dwItem As Long
End Type

'  parameter block for MCI_SYSINFO command message
Type MCI_SYSINFO_PARMS
    dwCallback As Long
    lpstrReturn As Long
    dwRetSize As Long
    dwNumber As Long
    wDeviceType As Integer
    wReserved0 As Integer
End Type

'  parameter block for MCI_SET command message
Type MCI_SET_PARMS
    dwCallback As Long
    dwTimeFormat As Long
    dwAudio As Long
End Type

'  parameter block for MCI_BREAK command message
Type MCI_BREAK_PARMS
    dwCallback As Long
    nVirtKey As Integer
    wReserved0 As Integer
    hwndBreak As Integer
    wReserved1 As Integer
End Type

'  parameter block for MCI_SOUND command message
Type MCI_SOUND_PARMS
    dwCallback As Long
    lpstrSoundName As String
End Type

'  parameter block for MCI_SAVE command message
Type MCI_SAVE_PARMS
    dwCallback As Long
    lpFileName As String
End Type

'  parameter block for MCI_LOAD command message
Type MCI_LOAD_PARMS
    dwCallback As Long
    lpFileName As String
End Type

'  parameter block for MCI_RECORD command message
Type MCI_RECORD_PARMS
    dwCallback As Long
    dwFrom As Long
    dwTo As Long
End Type


'  MCI extensions for videodisc devices

'  flag for dwReturn field of MCI_STATUS_PARMS
Global Const MCI_VD_MODE_PARK = (MCI_VD_OFFSET + 1)

'  flag for dwReturn field of MCI_STATUS_PARMS
Global Const MCI_VD_MEDIA_CLV = (MCI_VD_OFFSET + 2)
Global Const MCI_VD_MEDIA_CAV = (MCI_VD_OFFSET + 3)
Global Const MCI_VD_MEDIA_OTHER = (MCI_VD_OFFSET + 4)
Global Const MCI_VD_FORMAT_TRACK = &H4001

'  flags for dwFlags parameter of MCI_PLAY command message
Global Const MCI_VD_PLAY_REVERSE = &H10000
Global Const MCI_VD_PLAY_FAST = &H20000
Global Const MCI_VD_PLAY_SPEED = &H40000
Global Const MCI_VD_PLAY_SCAN = &H80000
Global Const MCI_VD_PLAY_SLOW = &H100000

'  flag for dwFlags parameter of MCI_SEEK command message
Global Const MCI_VD_SEEK_REVERSE = &H10000

'  flags for dwItem field of MCI_STATUS_PARMS parameter block
Global Const MCI_VD_STATUS_SPEED = &H4002&
Global Const MCI_VD_STATUS_FORWARD = &H4003&
Global Const MCI_VD_STATUS_MEDIA_TYPE = &H4004&
Global Const MCI_VD_STATUS_SIDE = &H4005&
Global Const MCI_VD_STATUS_DISC_SIZE = &H4006&

'  flags for dwFlags parameter of MCI_GETDEVCAPS command message
Global Const MCI_VD_GETDEVCAPS_CLV = &H10000
Global Const MCI_VD_GETDEVCAPS_CAV = &H20000

Global Const MCI_VD_SPIN_UP = &H10000
Global Const MCI_VD_SPIN_DOWN = &H20000

'  flags for dwItem field of MCI_GETDEVCAPS_PARMS parameter block
Global Const MCI_VD_GETDEVCAPS_CAN_REVERSE = &H4002&
Global Const MCI_VD_GETDEVCAPS_FAST_RATE = &H4003&
Global Const MCI_VD_GETDEVCAPS_SLOW_RATE = &H4004&
Global Const MCI_VD_GETDEVCAPS_NORMAL_RATE = &H4005&

'  flags for the dwFlags parameter of MCI_STEP command message
Global Const MCI_VD_STEP_FRAMES = &H10000
Global Const MCI_VD_STEP_REVERSE = &H20000

'  flag for the MCI_ESCAPE command message
Global Const MCI_VD_ESCAPE_STRING = &H100&

'  parameter block for MCI_PLAY command message
Type MCI_VD_PLAY_PARMS
    dwCallback As Long
    dwFrom As Long
    dwTo As Long
    dwSpeed As Long
End Type

'  parameter block for MCI_STEP command message
Type MCI_VD_STEP_PARMS
    dwCallback As Long
    dwFrames As Long
End Type

'  parameter block for MCI_ESCAPE command message
Type MCI_VD_ESCAPE_PARMS
    dwCallback As Long
    lpstrCommand As String
End Type


'  MCI extensions for waveform audio devices

'  flags for the dwFlags parameter of MCI_OPEN command message
Global Const MCI_WAVE_OPEN_BUFFER = &H10000

'  flags for the dwFlags parameter of MCI_SET command message
Global Const MCI_WAVE_SET_FORMATTAG = &H10000
Global Const MCI_WAVE_SET_CHANNELS = &H20000
Global Const MCI_WAVE_SET_SAMPLESPERSEC = &H40000
Global Const MCI_WAVE_SET_AVGBYTESPERSEC = &H80000
Global Const MCI_WAVE_SET_BLOCKALIGN = &H100000
Global Const MCI_WAVE_SET_BITSPERSAMPLE = &H200000

'  flags for the dwFlags parameter of MCI_STATUS, MCI_SET command messages
Global Const MCI_WAVE_INPUT = &H400000
Global Const MCI_WAVE_OUTPUT = &H800000

'  flags for the dwItem field of MCI_STATUS_PARMS parameter block
Global Const MCI_WAVE_STATUS_FORMATTAG = &H4001&
Global Const MCI_WAVE_STATUS_CHANNELS = &H4002&
Global Const MCI_WAVE_STATUS_SAMPLESPERSEC = &H4003&
Global Const MCI_WAVE_STATUS_AVGBYTESPERSEC = &H4004&
Global Const MCI_WAVE_STATUS_BLOCKALIGN = &H4005&
Global Const MCI_WAVE_STATUS_BITSPERSAMPLE = &H4006&
Global Const MCI_WAVE_STATUS_LEVEL = &H4007&

'  flags for the dwFlags parameter of MCI_SET command message
Global Const MCI_WAVE_SET_ANYINPUT = &H4000000
Global Const MCI_WAVE_SET_ANYOUTPUT = &H8000000

'  flags for the dwFlags parameter of MCI_GETDEVCAPS command message
Global Const MCI_WAVE_GETDEVCAPS_INPUTS = &H4001&
Global Const MCI_WAVE_GETDEVCAPS_OUTPUTS = &H4002&

'  parameter block for MCI_OPEN command message
Type MCI_WAVE_OPEN_PARMS
    dwCallback As Long
    wDeviceID As Integer
    wReserved0 As Integer
    lpstrDeviceType As String
    lpstrElementName As String
    lpstrAlias As String
    dwBufferSeconds As Long
End Type

'  parameter block for MCI_DELETE command message
Type MCI_WAVE_DELETE_PARMS
    dwCallback As Long
    dwFrom As Long
    dwTo As Long
End Type
' typedef MCI_WAVE_DELETE_PARMS FAR *LPMCI_WAVE_DELETE_PARMS;

'  parameter block for MCI_SET command message
Type MCI_WAVE_SET_PARMS
    dwCallback As Long
    dwTimeFormat As Long
    dwAudio As Long
    wInput As Integer
    wReserved0 As Integer
    wOutput As Integer
    wReserved1 As Integer
    wFormatTag As Integer
    wReserved2 As Integer
    nChannels As Integer
    wReserved3 As Integer
    nSamplesPerSec As Long
    nAvgBytesPerSec As Long
    nBlockAlign As Integer
    wReserved4 As Integer
    wBitsPerSample As Integer
    wReserved5 As Integer
End Type


'  MCI extensions for MIDI sequencer devices

'  flags for the dwReturn field of MCI_STATUS_PARMS parameter block
Global Const MCI_SEQ_DIV_PPQN = (0 + MCI_SEQ_OFFSET)
Global Const MCI_SEQ_DIV_SMPTE_24 = (1 + MCI_SEQ_OFFSET)
Global Const MCI_SEQ_DIV_SMPTE_25 = (2 + MCI_SEQ_OFFSET)
Global Const MCI_SEQ_DIV_SMPTE_30DROP = (3 + MCI_SEQ_OFFSET)
Global Const MCI_SEQ_DIV_SMPTE_30 = (4 + MCI_SEQ_OFFSET)

'  flags for the dwMaster field of MCI_SEQ_SET_PARMS parameter block
Global Const MCI_SEQ_FORMAT_SONGPTR = &H4001
Global Const MCI_SEQ_FILE = &H4002
Global Const MCI_SEQ_MIDI = &H4003
Global Const MCI_SEQ_SMPTE = &H4004
Global Const MCI_SEQ_NONE = 65533

'  flags for the dwItem field of MCI_STATUS_PARMS parameter block
Global Const MCI_SEQ_STATUS_TEMPO = &H4002&
Global Const MCI_SEQ_STATUS_PORT = &H4003&
Global Const MCI_SEQ_STATUS_SLAVE = &H4007&
Global Const MCI_SEQ_STATUS_MASTER = &H4008&
Global Const MCI_SEQ_STATUS_OFFSET = &H4009&
Global Const MCI_SEQ_STATUS_DIVTYPE = &H400A&

'  flags for the dwFlags parameter of MCI_SET command message
Global Const MCI_SEQ_SET_TEMPO = &H10000
Global Const MCI_SEQ_SET_PORT = &H20000
Global Const MCI_SEQ_SET_SLAVE = &H40000
Global Const MCI_SEQ_SET_MASTER = &H80000
Global Const MCI_SEQ_SET_OFFSET = &H1000000

'  parameter block for MCI_SET command message
Type MCI_SEQ_SET_PARMS
    dwCallback As Long
    dwTimeFormat As Long
    dwAudio As Long
    dwTempo As Long
    dwPort As Long
    dwSlave As Long
    dwMaster As Long
    dwOffset As Long
End Type


'  MCI extensions for animation devices

'  flags for dwFlags parameter of MCI_OPEN command message
Global Const MCI_ANIM_OPEN_WS = &H10000
Global Const MCI_ANIM_OPEN_PARENT = &H20000
Global Const MCI_ANIM_OPEN_NOSTATIC = &H40000

'  flags for dwFlags parameter of MCI_PLAY command message
Global Const MCI_ANIM_PLAY_SPEED = &H10000
Global Const MCI_ANIM_PLAY_REVERSE = &H20000
Global Const MCI_ANIM_PLAY_FAST = &H40000
Global Const MCI_ANIM_PLAY_SLOW = &H80000
Global Const MCI_ANIM_PLAY_SCAN = &H100000

'  flags for dwFlags parameter of MCI_STEP command message
Global Const MCI_ANIM_STEP_REVERSE = &H10000
Global Const MCI_ANIM_STEP_FRAMES = &H20000

'  flags for dwItem field of MCI_STATUS_PARMS parameter block
Global Const MCI_ANIM_STATUS_SPEED = &H4001&
Global Const MCI_ANIM_STATUS_FORWARD = &H4002&
Global Const MCI_ANIM_STATUS_HWND = &H4003&
Global Const MCI_ANIM_STATUS_HPAL = &H4004&
Global Const MCI_ANIM_STATUS_STRETCH = &H4005&

'  flags for the dwFlags parameter of MCI_INFO command message
Global Const MCI_ANIM_INFO_TEXT = &H10000

'  flags for dwItem field of MCI_GETDEVCAPS_PARMS parameter block
Global Const MCI_ANIM_GETDEVCAPS_CAN_REVERSE = &H4001&
Global Const MCI_ANIM_GETDEVCAPS_FAST_RATE = &H4002&
Global Const MCI_ANIM_GETDEVCAPS_SLOW_RATE = &H4003&
Global Const MCI_ANIM_GETDEVCAPS_NORMAL_RATE = &H4004&
Global Const MCI_ANIM_GETDEVCAPS_PALETTES = &H4006&
Global Const MCI_ANIM_GETDEVCAPS_CAN_STRETCH = &H4007&
Global Const MCI_ANIM_GETDEVCAPS_MAX_WINDOWS = &H4008&

'  flags for the MCI_REALIZE command message
Global Const MCI_ANIM_REALIZE_NORM = &H10000
Global Const MCI_ANIM_REALIZE_BKGD = &H20000

'  flags for dwFlags parameter of MCI_WINDOW command message
Global Const MCI_ANIM_WINDOW_HWND = &H10000
Global Const MCI_ANIM_WINDOW_STATE = &H40000
Global Const MCI_ANIM_WINDOW_TEXT = &H80000
Global Const MCI_ANIM_WINDOW_ENABLE_STRETCH = &H100000
Global Const MCI_ANIM_WINDOW_DISABLE_STRETCH = &H200000

'  flags for hWnd field of MCI_ANIM_WINDOW_PARMS parameter block
Global Const MCI_ANIM_WINDOW_DEFAULT = &H0&

'  flags for dwFlags parameter of MCI_PUT command message
Global Const MCI_ANIM_RECT = &H10000
Global Const MCI_ANIM_PUT_SOURCE = &H20000
Global Const MCI_ANIM_PUT_DESTINATION = &H40000

'  flags for dwFlags parameter of MCI_WHERE command message
Global Const MCI_ANIM_WHERE_SOURCE = &H20000
Global Const MCI_ANIM_WHERE_DESTINATION = &H40000

'  flags for dwFlags parameter of MCI_UPDATE command message
Global Const MCI_ANIM_UPDATE_HDC = &H20000

'  parameter block for MCI_OPEN command message
Type MCI_ANIM_OPEN_PARMS
    dwCallback As Long
    wDeviceID As Integer
    wReserved0 As Integer
    lpstrDeviceType As String
    lpstrElementName As String
    lpstrAlias As String
    dwStyle As Long
    hWndParent As Integer
    wReserved1 As Integer
End Type

'  parameter block for MCI_PLAY command message
Type MCI_ANIM_PLAY_PARMS
    dwCallback As Long
    dwFrom As Long
    dwTo As Long
    dwSpeed As Long
End Type

'  parameter block for MCI_STEP command message
Type MCI_ANIM_STEP_PARMS
    dwCallback As Long
    dwFrames As Long
End Type

'  parameter block for MCI_WINDOW command message
Type MCI_ANIM_WINDOW_PARMS
    dwCallback As Long
    hWnd As Integer
    wReserved1 As Integer
    nCmdShow As Integer
    wReserved2 As Integer
    lpstrText As String
End Type

'  parameter block for MCI_PUT, MCI_UPDATE, MCI_WHERE command messages
Type MCI_ANIM_RECT_PARMS
    dwCallback As Long
    rc As RECT
End Type

'  parameter block for MCI_UPDATE PARMS
Type MCI_ANIM_UPDATE_PARMS
    dwCallback As Long
    rc As RECT
    hDC As Integer
End Type


'  MCI extensions for video overlay devices

'  flags for dwFlags parameter of MCI_OPEN command message
Global Const MCI_OVLY_OPEN_WS = &H10000
Global Const MCI_OVLY_OPEN_PARENT = &H20000

'  flags for dwFlags parameter of MCI_STATUS command message
Global Const MCI_OVLY_STATUS_HWND = &H4001&
Global Const MCI_OVLY_STATUS_STRETCH = &H4002&

'  flags for dwFlags parameter of MCI_INFO command message
Global Const MCI_OVLY_INFO_TEXT = &H10000

'  flags for dwItem field of MCI_GETDEVCAPS_PARMS parameter block
Global Const MCI_OVLY_GETDEVCAPS_CAN_STRETCH = &H4001&
Global Const MCI_OVLY_GETDEVCAPS_CAN_FREEZE = &H4002&
Global Const MCI_OVLY_GETDEVCAPS_MAX_WINDOWS = &H4003&

'  flags for dwFlags parameter of MCI_WINDOW command message
Global Const MCI_OVLY_WINDOW_HWND = &H10000
Global Const MCI_OVLY_WINDOW_STATE = &H40000
Global Const MCI_OVLY_WINDOW_TEXT = &H80000
Global Const MCI_OVLY_WINDOW_ENABLE_STRETCH = &H100000
Global Const MCI_OVLY_WINDOW_DISABLE_STRETCH = &H200000

'  flags for hWnd parameter of MCI_OVLY_WINDOW_PARMS parameter block
Global Const MCI_OVLY_WINDOW_DEFAULT = &H0&

'  flags for dwFlags parameter of MCI_PUT command message
Global Const MCI_OVLY_RECT = &H10000
Global Const MCI_OVLY_PUT_SOURCE = &H20000
Global Const MCI_OVLY_PUT_DESTINATION = &H40000
Global Const MCI_OVLY_PUT_FRAME = &H80000
Global Const MCI_OVLY_PUT_VIDEO = &H100000

'  flags for dwFlags parameter of MCI_WHERE command message
Global Const MCI_OVLY_WHERE_SOURCE = &H20000
Global Const MCI_OVLY_WHERE_DESTINATION = &H40000
Global Const MCI_OVLY_WHERE_FRAME = &H80000
Global Const MCI_OVLY_WHERE_VIDEO = &H100000

'  parameter block for MCI_OPEN command message
Type MCI_OVLY_OPEN_PARMS
    dwCallback As Long
    wDeviceID As Integer
    wReserved0 As Integer
    lpstrDeviceType As String
    lpstrElementName As String
    lpstrAlias As String
    dwStyle As Long
    hWndParent As Integer
    wReserved1 As Integer
End Type

'  parameter block for MCI_WINDOW command message
Type MCI_OVLY_WINDOW_PARMS
    dwCallback As Long
    hWnd As Integer
    wReserved1 As Integer
    nCmdShow As Integer
    wReserved2 As Integer
    lpstrText As String
End Type

'  parameter block for MCI_PUT, MCI_UPDATE, and MCI_WHERE command messages
Type MCI_OVLY_RECT_PARMS
    dwCallback As Long
    rc As RECT
End Type

'  parameter block for MCI_SAVE command message
Type MCI_OVLY_SAVE_PARMS
    dwCallback As Long
    lpFileName As String
    rc As RECT
End Type

'  parameter block for MCI_LOAD command message
Type MCI_OVLY_LOAD_PARMS
    dwCallback As Long
    lpFileName As String
    rc As RECT
End Type

