					
*******************************************************
*******************************************************
* This function registers all of the CodeLock API's
*
FUNCTION RegCLFunc
	* define globals to hold codelock registered function
	* handles.
	PUBLIC RemLckDBF 	&& RemoveLockDatabase
	PUBLIC RemLckSgF 	&& RemoveCodeLockSigniture
	PUBLIC GVerF 		&& GetVersionString
	PUBLIC RIDToProF	&& RegIDToProtCode
	PUBLIC ChProgLF		&& CheckProgramLock
	PUBLIC InProgLF		&& InstallProgramLock
	PUBLIC ReProgLF		&& RemoveProgramLock
	PUBLIC ChTimeLF		&& CheckTimeLock
	PUBLIC InTimeLF		&& InstallTimeLock
	PUBLIC ReTimeLF		&& RemoveTimeLock
	PUBLIC ChCountLF	&& CheckCounterLock
	PUBLIC InCountLF	&& InstallCounterLock
	PUBLIC ReCountLF	&& RemoveCounterLock
	PUBLIC GInstLTypF	&& GetInstalledLockTypes 
	PUBLIC GenRegIDF	&& GenerateRegistrationID
	PUBLIC GProdRegF 	&& GetProductRegistration
	PUBLIC WProdRegF	&& WriteProductRegistration
	PUBLIC IsCLInstF	&& IsCodeLockInstalled
	PUBLIC IsCLWorkF	&& IsCodeLockWorking
	PUBLIC GenRetCF		&& GenerateReturnCode
	PUBLIC UseRetCF		&& UseReturnCode
	PUBLIC GetTimeLF	&& GetTimeLeft
	PUBLIC GetCountLF	&& GetCountLeft

	* the first call to regfn always fails??? use
	* a dummy call as a work around.
	Dummy = REGFN(1,"C","I","CLDEMO3.DLL")
	GProdRegF = REGFN(12,"C@C@C@C@C@C@C@C","I","CLDEMO3.DLL")
	RemLckDBF = REGFN(13,"C","I","CLDEMO3.DLL")
	RemLckSgF = REGFN(14,"C","I","CLDEMO3.DLL")
	GVerF = REGFN(15,"@CI","I","CLDEMO3.DLL")
	RIDToProF = REGFN(16,"CC","I","CLDEMO3.DLL")
	ChProgLF = REGFN(17,"CC","I","CLDEMO3.DLL")
	InProgLF = REGFN(18,"CC","I","CLDEMO3.DLL")
	ReProgLF = REGFN(19,"C","I","CLDEMO3.DLL")
	ChTimeLF = REGFN(20,"C","I","CLDEMO3.DLL")
	InTimeLF = REGFN(21,"CI","I","CLDEMO3.DLL")
	ReTimeLF = REGFN(22,"C","I","CLDEMO3.DLL")
	ChCountLF = REGFN(23,"C","I","CLDEMO3.DLL")
	InCountLF = REGFN(24,"CII","I","CLDEMO3.DLL")
	ReCountLF = REGFN(25,"C","I","CLDEMO3.DLL")
	IsCLInstF = REGFN(27,"C","I","CLDEMO3.DLL")
	GInstLTypF = REGFN(28,"C","I","CLDEMO3.DLL")
	GenRegIDF = REGFN(29,"@CII","I","CLDEMO3.DLL")
	WProdRegF = REGFN(30,"CCCCCCCC","I","CLDEMO3.DLL")
	GenRetCF = REGFN(31,"C","I","CLDEMO3.DLL")
	IsCLWorkF = REGFN(32,"","I","CLDEMO3.DLL")
	UseRetCF = REGFN(33,"I","I","CLDEMO3.DLL")
	GetTimeLF = REGFN(34,"C","I","CLDEMO3.DLL")
	GetCountLF = REGFN(35,"C","I","CLDEMO3.DLL")
RETURN 1

*******************************************************
*******************************************************
* This function fixes the return values from CodeLock
* since FoxPro does not support unsigned integers. 
* Without this fixup, return values > 32767 would apear
* to be negative values.
*
FUNCTION FixRetCode
PARAMETERS Ret
	* fix the integer returned if it was negative
	IF Ret < 0
		Ret = (Ret + 32768) + 32768
	ENDIF
RETURN Ret

