/******************************************************************************
*
* DESCRIPTION: 
*
* AUTHOR: Mike Jones
*
* CREATED: 04/05/95
*
* HISTORY: 
*
******************************************************************************/

// include files
#include <windows.h>
#include <stdlib.h>
#include "resource.h"
#include "codelock.h"

BOOL InitApplication(HANDLE hInstance);
BOOL InitInstance(HANDLE hInstance, WORD nCmdShow);
LONG FAR PASCAL MainWndProc(HWND hWnd, unsigned msg, WORD wParam,
	LONG lParam);

HANDLE hInst;
char gszProductID[] = "YOURPROGRAM";
char gszCypher[] = "SECRET";
PROTCODE gRetCode = 48628;

BOOL CALLBACK RegDlgProc(HWND hWndDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
	char szReg[10];
	char szBuf[100];
	static PROTCODE nAuth, nValidAuth;

	switch (msg)
	{
		case WM_INITDIALOG:
			// Get registration number from storage.
			GetProductRegistration(gszProductID, szReg, NULL, NULL, NULL, NULL, NULL, NULL);

			// Check to see if there is a valid registration number.
			if (strlen(szReg) == 0)
			{
				// Generate a registration number.
				GenerateRegistrationID(szReg, 6, 6);
		
				// Write registration number to storage.
				WriteProductRegistration(gszProductID, szReg, NULL, NULL, NULL, NULL, NULL, NULL);
			}

			// Fill in registration number
			SetWindowText(GetDlgItem(hWndDlg, IDC_REGNUM), szReg);

			// Generate a valid unlock code to compare with user entry.
			nValidAuth = RegIDToProtCode(gszCypher, szReg);
			
			// Store valid auth code for demo.
			ltoa(nValidAuth, szBuf, 10);
			SetWindowText(GetDlgItem(hWndDlg, IDC_UNLOCK), szBuf);
			
			break;

		case WM_COMMAND:
			if (wParam == IDOK)
			{
				// Get user entry.
				GetWindowText(GetDlgItem(hWndDlg, IDC_UNLOCK), szBuf, 100);

				// convert to number.
				nAuth = atoi(szBuf);

				// Is it a valid unlock code?
				if (nAuth == nValidAuth)
				{
					// yes, shutdown dialog.
					EndDialog(hWndDlg, CODELOCK_SUCCESS);
				}
				else
					MessageBox(hWndDlg, "Invalid unlock code.", "CodeLock Sample", MB_ICONASTERISK|MB_OK);
			}
			else if (wParam == IDCANCEL)
			{
				EndDialog(hWndDlg, CODELOCK_FAILURE);
			}
			else
				return(0);
			break;

		default:
			return(0);
	}
	return(1);
}


int CheckCodeLock(HINSTANCE hInst)
{
	char szReg[10];
	char szBuf[200];
	int nTime;

	// turn on secure return codes
	UseReturnCode(1);

	// Check for an existing installation of this program.
	if (IsCodeLockInstalled(gszProductID) == gRetCode)
	{
		// It's been installed before.

		// Check program lock.
		if (CheckProgramLock(gszProductID, "Key") == gRetCode)
		{
			// Valid program lock, return success.
			return(CODELOCK_SUCCESS);
		}

REGISTER:
		// Get remaining time on lock.
		nTime = GetTimeLeft(gszProductID);

		wsprintf(szBuf, "This program has not been registered and you have %d days left"
			" in your trial period.  Would you like to register it now?", nTime);
		// Since there was no program lock, prompt user to register.
		if (MessageBox(GetFocus(), szBuf, "CodeLock Sample", MB_ICONQUESTION|MB_YESNO)
			== IDYES)
		{
			// Display a dialog prompting the user for an unlock code.
			if (DialogBox(hInst, MAKEINTRESOURCE(IDD_REGISTER), GetFocus(), &RegDlgProc) == CODELOCK_SUCCESS)
			{
				// successful registration, install a program lock and remove timelock.
				InstallProgramLock(gszProductID, "Key");
				RemoveTimeLock(gszProductID);
				return(CODELOCK_SUCCESS);
			}
		}

		// Check for time remaining on time lock.
		if (CheckTimeLock(gszProductID) == gRetCode)
		{
			// Time remains, return sucess.
			return(CODELOCK_SUCCESS);
		}

		// Looks like time has expired or locks have been
		// tampered with. Inform user and exit.
		MessageBox(GetFocus(), "Your trial period for this program has expired. "
			"If you find this software usefull, please register it.", "CodeLock Sample", 
			MB_ICONSTOP|MB_OK);

		return(CODELOCK_FAILURE);
	}
	else
	{
		// First time installation.

		// Install a time lock.
		InstallTimeLock(gszProductID, 30);

		// Generate a registration number.
		GenerateRegistrationID(szReg, 6, 6);

		// Write registration number to storage.
		WriteProductRegistration(gszProductID, szReg, NULL, NULL, NULL, NULL, NULL, NULL);

		// Go to registration prompt
		goto REGISTER;
	}
}

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmdLine,
	int nCmdShow)
{
	MSG msg;

	if (CheckCodeLock(hInstance) != CODELOCK_SUCCESS)
		return 1;

	hInst = hInstance;
	if (!hPrevInstance)
		if (!InitApplication(hInstance))
			return FALSE;
	if (!InitInstance(hInstance, nCmdShow))
		return FALSE;

	while (GetMessage(&msg, NULL, NULL, NULL)) {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return msg.wParam;
}

/*
 * InitApplication
 *
 * Description:
 *	Registers the window class.
 *
 * Inputs:	hInstance
 * Outputs:	TRUE or FALSE
 */

BOOL InitApplication(HANDLE hInstance)
{
	WNDCLASS wc;

	wc.style = 0;
	wc.lpfnWndProc = MainWndProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = hInstance;
	wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = GetStockObject(WHITE_BRUSH);
	wc.lpszMenuName = NULL;
	wc.lpszClassName = "TestClass";
	if (RegisterClass(&wc) == FALSE)
		return FALSE;
	return TRUE;
}

/*
 * InitInstance
 *
 * Description:
 *	Creates the program's window.
 *
 * Inputs:	hInstance, nCmdShow
 * Outputs:	TRUE or FALSE
 */

BOOL InitInstance(HANDLE hInstance, WORD nCmdShow)
{
	HWND hWnd;

	hWnd = CreateWindow("TestClass", "Program Lock Sample", WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, NULL,
		LoadMenu(hInstance, MAKEINTRESOURCE(IDR_MENU1)), hInstance, NULL);

	if (!hWnd)
		return FALSE;

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);
	return TRUE;
}

/*
 * MainWndProc
 *
 * Description:
 *	Main window Proc.
 *
 * Input:	Standard Window Proc.
 * Outputs:	None.
 */

LONG FAR PASCAL MainWndProc(HWND hWnd, unsigned msg, WORD wParam,
	LONG lParam)
{
	switch (msg) {
	case WM_DESTROY:
		PostQuitMessage(0);
		break;

	case WM_CLOSE:
		PostQuitMessage(0);
		return FALSE;

	case WM_COMMAND:
		if (wParam == IDM_RESET)
		{
			if (MessageBox(hWnd, "Would you like to remove all locks and signitures? "
				"It will be as if you never ran this sample.", "CodeLock Sample", 
				MB_ICONQUESTION|MB_YESNO)==IDYES)
			{
				// Reset codelock.
				RemoveCodeLockSigniture(gszProductID);
				RemoveLockDatabase(gszProductID);
			}
		}
		break;
	default:
		return DefWindowProc(hWnd, msg, wParam, lParam);
	}
	return FALSE;
}

