/*
 *	CODELOCK include file
 *	Software Copy Protection Library
 *	Copyright (c) 1993-1995 by Robust Software
 *
 */

// Function return codes
#define CODELOCK_SUCCESS			1
#define CODELOCK_FAILURE			0

// Lock types (for GetInstalledLockTypes()).
#define PROGRAM_LOCK				8
#define TIME_LOCK					16
#define COUNTER_LOCK				32

// nOperation values passed to InstallCounterLock()
#define SET_COUNTER					1
#define ADD_COUNTER					2

typedef UINT PROTCODE;

// Lock functions
PROTCODE FAR PASCAL InstallProgramLock(LPSTR lpszProductID, LPSTR lpszKey);
PROTCODE FAR PASCAL CheckProgramLock(LPSTR lpszProductID, LPSTR lpszKey);
PROTCODE FAR PASCAL RemoveProgramLock(LPSTR lpszProductID);
PROTCODE FAR PASCAL InstallTimeLock(LPSTR lpszProductID, int nDaysTillExpire);
PROTCODE FAR PASCAL CheckTimeLock(LPSTR lpszProductID);
PROTCODE FAR PASCAL RemoveTimeLock(LPSTR lpszProductID);
PROTCODE FAR PASCAL InstallCounterLock(LPSTR lpszProductID, int nOperation,
	int nCounts);
PROTCODE FAR PASCAL CheckCounterLock(LPSTR lpszProductID);
PROTCODE FAR PASCAL RemoveCounterLock(LPSTR lpszProductID);
int FAR PASCAL GetInstalledLockTypes(LPSTR lpszProductID);
PROTCODE FAR PASCAL RemoveLockDatabase(LPSTR lpszProductID);
int FAR PASCAL GetTimeLeft(LPSTR lpszProductID);
int FAR PASCAL GetCountLeft(LPSTR lpszProductID);

// Product registration functions
int FAR PASCAL GenerateRegistrationID(LPSTR lpsz, int nCnt, int nMaxIDLen);
PROTCODE FAR PASCAL RegIDToProtCode(LPSTR lpszCypherID, LPSTR lpszRegID);
PROTCODE FAR PASCAL WriteProductRegistration(LPSTR lpszProductID, LPSTR lpszSerialNum,
	LPSTR lpszRegID, LPSTR lpszCompanyName, LPSTR lpszUserName, LPSTR lpszUserDef1,
	LPSTR lpszUserDef2, LPSTR lpszUserDef3);
PROTCODE FAR PASCAL GetProductRegistration(LPSTR lpszProductID, LPSTR lpszSerialNum,
	LPSTR lpszRegID, LPSTR lpszCompanyName, LPSTR lpszUserName, LPSTR lpszUserDef1,
	LPSTR lpszUserDef2, LPSTR lpszUserDef3);

// Miscellaneous functions
PROTCODE FAR PASCAL IsCodeLockInstalled(LPSTR lpszProductID);
int FAR PASCAL GetVersionString(LPSTR lpszVersion, int nSize);
int FAR PASCAL EncryptString(LPSTR lpszSrc, LPSTR lpszDest, int nSrcLen, WORD wKey);
PROTCODE FAR PASCAL RemoveCodeLockSigniture(LPSTR lpszProductID);
PROTCODE FAR PASCAL GenerateReturnCode(LPSTR lpszProductID);
int FAR PASCAL IsCodeLockWorking();
int FAR PASCAL UseReturnCode(int bTrue);

