
'---------------------------------------------------------
' Handles alligning forms.  Forms all have a Gadet picturebox,
' around which a gap is left to draw a border to simulate
' a 3D control.  Each form is started in the top left corner,
' from which it can be moved by dragging.
'---------------------------------------------------------
'
Sub AllignForm (Frm As Form)
    Frm.Width = Frm.Gadget.Width + (2 * Outline)
    Frm.Height = Frm.Gadget.Height + (2 * Outline)
    Frm.Gadget.Move Outline, Outline
End Sub

'---------------------------------------------------------
' This routine simulates the dragging behavior found in ProgMan.
' The built-in VB DragDrop routine does not handle clipping
' properly and yields poor visual results.
'
' The routine:
'   - Gets a handle to the screen (a DC of Null)
'   - Creates a rectangular region based on the X,Y of the LCD
'   - Sets the Clipping Region to that rectangle
'   - Paints a box on the screen based on the mouse X,Y
'     combined with the applets height and width.
'   - Releases the Windows resources.
'---------------------------------------------------------
'
Sub GhostForm (X As Integer, Y As Integer, H As Integer, W As Integer)
    hScreen = GetDC(0)
    hRegion = CreateRectRgn(RgnX1, RgnY1, RgnX2, RgnY2)
    zot = SelectClipRgn(hScreen, hRegion)
    hBrush = GetStockObject(NULL_BRUSH)
    hObjOld = SelectObject(hScreen, hBrush)
    zot = SetROP2(hScreen, R2_NOTXORPEN)
    zot = Rectangle(hScreen, X, Y, H, W)
    zot = DeleteObject(hRegion)
    zot = UnrealizeObject(hScreen)
    hScreen = ReleaseDC(0, hScreen)
End Sub

Sub Main ()
    Screen.MousePointer = 11
    
    TPRatio = Screen.TwipsPerPixelX
    Bevel = 2 * TPRatio
    Outline = Bevel + TPRatio

    Load Calculator

    ' Determine the screen bounding region
    RgnX1 = Int(0) / TPRatio
    RgnY1 = Int(0) / TPRatio
    RgnX2 = Int(Screen.Width / TPRatio)
    RgnY2 = Int(Screen.Height / TPRatio)
    
    q% = DoEvents()
    Screen.MousePointer = 0

    Calculator.Show

End Sub

'---------------------------------------------------------
' This routine simulates a 3D form by drawing lines around
' a control where that control is positioned with a surrounding
' gap on the form itself.  The degree of the bevel can be
' changed in the WH_MAIN FormLoad routine, and is based on
' a pixel measurement.
'---------------------------------------------------------
'
Sub Make3DForm (TheForm As Form, Ctrl As Control)
    
    L% = Ctrl.Left
    R% = Ctrl.Left + Ctrl.Width
    T% = Ctrl.Top
    B% = Ctrl.Top + Ctrl.Height
    
    TheForm.Line (L% - Bevel, T% - Bevel)-(R% + Bevel, T%), QBColor(15), BF
    TheForm.Line (L% - Bevel, T%)-(L%, B%), QBColor(15), BF
    TheForm.Line (L% - Bevel, B%)-(R% + Bevel, B% + Bevel), QBColor(8), BF
    TheForm.Line (R%, B%)-(R% + Bevel, T%), QBColor(8), BF
    TheForm.Line (L% - Outline, T% - Outline)-(R% + Outline - TPRatio, B% + Outline - TPRatio), QBColor(0), B
    
End Sub

Sub ShadeControl (TheControl As Control, ThePic As Control)
    ThePic.ScaleMode = 3    ' Pixel
    ThePic.ScaleHeight = 8
    ThePic.ScaleWidth = 8
    hBrush = CreatePatternBrush(ThePic.Picture)
    TheControl.ScaleMode = 3    'Pixel
    Dim FillArea As RECT
    FillArea.Left = 0
    FillArea.Top = 0
    FillArea.right = TheControl.ScaleWidth
    FillArea.bottom = TheControl.ScaleHeight
    Success% = FillRect(TheControl.hDC, FillArea, hBrush)
    Success% = DeleteObject(hBrush)
    TheControl.ScaleMode = 1
End Sub

