/****************************************************************************

    PROGRAM: Generic.c

    PURPOSE: Generic template for Windows applications

    FUNCTIONS:

    WinMain() - calls initialization function, processes message loop
    InitApplication() - initializes window data and registers window
    InitInstance() - saves instance handle and creates main window
    MainWndProc() - processes messages
    About() - processes messages for "About" dialog box

    COMMENTS:

	Windows can have several copies of your application running at the
	same time.  The variable hInst keeps track of which instance this
	application is so that processing will be to the correct window.

****************************************************************************/
#include "windows.h"            /* required for all Windows applications */
#include "dwdtest.h"            /* specific to this program          */
#include "string.h"


HANDLE hInst;               /* current instance              */
#define MAIN
char szbuf[15][62];
/****************************************************************************

    FUNCTION: WinMain(HANDLE, HANDLE, LPSTR, int)

    PURPOSE: calls initialization function, processes message loop

    COMMENTS:

	Windows recognizes this function by name as the initial entry point
	for the program.  This function calls the application initialization
	routine, if no other instance of the program is running, and always
	calls the instance initialization routine.  It then executes a message
	retrieval and dispatch loop that is the top-level control structure
	for the remainder of execution.  The loop is terminated when a WM_QUIT
	message is received, at which time this function exits the application
	instance by returning the value passed by PostQuitMessage().

	If this function must abort before entering the message loop, it
	returns the conventional value NULL.

****************************************************************************/

int PASCAL WinMain(HANDLE  hInstance, HANDLE  hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
    MSG msg;                     /* message              */

    if (!hPrevInstance)          /* Other instances of app running? */
    if (!InitApplication(hInstance)) /* Initialize shared things */
	return (FALSE);      /* Exits if unable to initialize     */

	     
    /* Perform initializations that apply to a specific instance */

    if (!InitInstance(hInstance, nCmdShow))
	return (FALSE);

    /* Acquire and dispatch messages until a WM_QUIT message is received. */

    while (GetMessage(&msg,    /* message structure              */
	NULL,          /* handle of window receiving the message */
	NULL,          /* lowest message to examine          */
	NULL))         /* highest message to examine         */
    {
    TranslateMessage(&msg);    /* Translates virtual key codes       */
    DispatchMessage(&msg);     /* Dispatches message to window       */
    }

    return (msg.wParam);       /* Returns the value from PostQuitMessage */
}


/****************************************************************************

    FUNCTION: InitApplication(HANDLE)

    PURPOSE: Initializes window data and registers window class

    COMMENTS:

	This function is called at initialization time only if no other
	instances of the application are running.  This function performs
	initialization tasks that can be done once for any number of running
	instances.

	In this case, we initialize a window class by filling out a data
	structure of type WNDCLASS and calling the Windows RegisterClass()
	function.  Since all instances of this application use the same window
	class, we only need to do this when the first instance is initialized.


****************************************************************************/

BOOL InitApplication(hInstance)
HANDLE hInstance;                  /* current instance       */
{
    WNDCLASS  wc;

    /* Fill in window class structure with parameters that describe the       */
    /* main window.                                                           */

    wc.style = NULL;                    /* Class style(s).                    */
    wc.lpfnWndProc = MainWndProc;       /* Function to retrieve messages for  */
					/* windows of this class.             */
    wc.cbClsExtra = 0;                  /* No per-class extra data.           */
    wc.cbWndExtra = 0;                  /* No per-window extra data.          */
    wc.hInstance = hInstance;           /* Application that owns the class.   */
    wc.hIcon = LoadIcon(hInstance, "IDI_ICON_APP");
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName =  "DWDMenu";   /* Name of menu resource in .RC file. */
    wc.lpszClassName = "DWDTestClass"; /* Name used in call to CreateWindow. */

    /* Register the window class and return success/failure code. */

    return (RegisterClass(&wc));

}


/****************************************************************************

    FUNCTION:  InitInstance(HANDLE, int)

    PURPOSE:  Saves instance handle and creates main window

    COMMENTS:

	This function is called at initialization time for every instance of
	this application.  This function performs initialization tasks that
	cannot be shared by multiple instances.

	In this case, we save the instance handle in a static variable and
	create and display the main program window.

****************************************************************************/

BOOL InitInstance(hInstance, nCmdShow)
    HANDLE          hInstance;          /* Current instance identifier.       */
    int             nCmdShow;           /* Param for first ShowWindow() call. */
{
    HWND            hWnd;               /* Main window handle.                */

    /* Save the instance handle in static variable, which will be used in  */
    /* many subsequence calls from this application to Windows.            */

    hInst = hInstance;

    /* Create a main window for this application instance.  */

    hWnd = CreateWindow(
	"DWDTestClass",                /* See RegisterClass() call.          */
	"DWD DLL Testing Application",   /* Text for window title bar.         */
	WS_OVERLAPPEDWINDOW,            /* Window style.                      */
	CW_USEDEFAULT,                  /* Default horizontal position.       */
	CW_USEDEFAULT,                  /* Default vertical position.         */
	CW_USEDEFAULT,                  /* Default width.                     */
	CW_USEDEFAULT,                  /* Default height.                    */
	NULL,                           /* Overlapped windows have no parent. */
	NULL,                           /* Use the window class menu.         */
	hInstance,                      /* This instance owns this window.    */
	NULL                            /* Pointer not needed.                */
    );

    /* If window could not be created, return "failure" */

    if (!hWnd)
	return (FALSE);

    /* Make the window visible; update its client area; and return "success" */

    ShowWindow(hWnd, nCmdShow);  /* Show the window                        */
    UpdateWindow(hWnd);          /* Sends WM_PAINT message                 */
    return (TRUE);               /* Returns the value from PostQuitMessage */

}

/****************************************************************************

    FUNCTION: MainWndProc(HWND, UINT, WPARAM, LPARAM)

    PURPOSE:  Processes messages

    MESSAGES:

    WM_COMMAND    - application menu (About dialog box)
    WM_DESTROY    - destroy window

    COMMENTS:

    To process the IDM_ABOUT message, call MakeProcInstance() to get the
    current instance address of the About() function.  Then call Dialog
    box which will create the box according to the information in your
    generic.rc file and turn control over to the About() function.  When
    it returns, free the intance address.

****************************************************************************/

long FAR PASCAL MainWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
PAINTSTRUCT lps;
HDC hdc;
int i;
    switch (message)
    {
	case WM_COMMAND:       /* message: command from application menu */
	    switch (wParam)
	    {
	    
	    case IDM_DATE:
	     
	     
	     if(DisplayDates(hWnd, IDW_DEFAULT))
	     {
	     char buf[40];
	     lstrcpy(szbuf[0],"GetDates(IDX_DATELONG)\t" );
	     if(GetDates(IDX_DATELONG, buf, sizeof(buf)))
	     lstrcat(szbuf[0],buf);
	     
	     lstrcpy(szbuf[1],"GetDates(IDX_DATESHORT)\t" );
	     if(GetDates(IDX_DATESHORT, buf, sizeof(buf)))
	     lstrcat(szbuf[1],buf);
	     
	     lstrcpy(szbuf[2],"GetDates(IDX_DAYLONG)\t" );
	     if(GetDates(IDX_DAYLONG, buf, sizeof(buf)))
	     lstrcat(szbuf[2],buf);
	     
	     
	     lstrcpy(szbuf[3],"GetDates(IDX_DAYSHORT)\t" );
	     if(GetDates(IDX_DAYSHORT, buf, sizeof(buf)))
	     lstrcat(szbuf[3],buf);
	     
	     lstrcpy(szbuf[4],"GetDates(IDX_DAYNUM)\t" );
	     if(GetDates(IDX_DAYNUM, buf, sizeof(buf)))
	     lstrcat(szbuf[4],buf);
	     
	     
	     lstrcpy(szbuf[5],"GetDates(IDX_MONTHLONG)\t" );
	     if(GetDates(IDX_MONTHLONG, buf, sizeof(buf)))
	     lstrcat(szbuf[5],buf);
	     
	     
	     lstrcpy(szbuf[6],"GetDates(IDX_MONTHSHORT)\t" );
	     if(GetDates(IDX_MONTHSHORT, buf, sizeof(buf)))
	     lstrcat(szbuf[6],buf);
	     
	     
	     lstrcpy(szbuf[7],"GetDates(IDX_MONTHDAY)\t" );
	     if(GetDates(IDX_MONTHDAY, buf, sizeof(buf)))
	     lstrcat(szbuf[7],buf);
	     
	     	     
	     lstrcpy(szbuf[8],"GetDates(IDX_YEARLONG)\t" );
	     if(GetDates(IDX_YEARLONG, buf, sizeof(buf)))
	     lstrcat(szbuf[8],buf);
	     
	     
	     lstrcpy(szbuf[9],"GetDates(IDX_YEARSHORT)\t" );
	     if(GetDates(IDX_YEARSHORT, buf, sizeof(buf)))
	     lstrcat(szbuf[9],buf);
	     
	     
	     lstrcpy(szbuf[10],"GetDates(IDX_ASCTIME)\t" );
	     if(GetDates(IDX_ASCTIME, buf, sizeof(buf)))
	     lstrcat(szbuf[10],buf);
	     
	     
	     lstrcpy(szbuf[11],"GetDates(IDX_STDDATE)\t" );
	     if(GetDates(IDX_STDDATE, buf, sizeof(buf)))
	     lstrcat(szbuf[11],buf);
	     
	     
	     lstrcpy(szbuf[12],"GetDates(IDX_STDDATESHORT)\t" );
	     if(GetDates(IDX_STDDATESHORT, buf, sizeof(buf)))
	     lstrcat(szbuf[12],buf);
	     
	     
	     lstrcpy(szbuf[13],"GetDates(IDX_DBFDATE)\t" );
	     if(GetDates(IDX_DBFDATE, buf, sizeof(buf)))
	     lstrcat(szbuf[13],buf);
	     
	     
	     lstrcpy(szbuf[14],"GetDates(IDX_STDTIME)\t" );
	     if(GetDates(IDX_STDTIME, buf, sizeof(buf)))
	     lstrcat(szbuf[14],buf);
	     
	                     
	     InvalidateRect(hWnd, NULL ,TRUE);
	     }
	     
	     
	     break;


        case IDM_DATE_CENTER:


	     if(DisplayDates(hWnd, IDW_CENTER))
	     {
	     char buf[40];
	     lstrcpy(szbuf[0],"GetDates(IDX_DATELONG)\t" );
	     if(GetDates(IDX_DATELONG, buf, sizeof(buf)))
	     lstrcat(szbuf[0],buf);
	     
	     lstrcpy(szbuf[1],"GetDates(IDX_DATESHORT)\t" );
	     if(GetDates(IDX_DATESHORT, buf, sizeof(buf)))
	     lstrcat(szbuf[1],buf);
	     
	     lstrcpy(szbuf[2],"GetDates(IDX_DAYLONG)\t" );
	     if(GetDates(IDX_DAYLONG, buf, sizeof(buf)))
	     lstrcat(szbuf[2],buf);
	     
	     
	     lstrcpy(szbuf[3],"GetDates(IDX_DAYSHORT)\t" );
	     if(GetDates(IDX_DAYSHORT, buf, sizeof(buf)))
	     lstrcat(szbuf[3],buf);
	     
	     lstrcpy(szbuf[4],"GetDates(IDX_DAYNUM)\t" );
	     if(GetDates(IDX_DAYNUM, buf, sizeof(buf)))
	     lstrcat(szbuf[4],buf);
	     
	     
	     lstrcpy(szbuf[5],"GetDates(IDX_MONTHLONG)\t" );
	     if(GetDates(IDX_MONTHLONG, buf, sizeof(buf)))
	     lstrcat(szbuf[5],buf);
	     
	     
	     lstrcpy(szbuf[6],"GetDates(IDX_MONTHSHORT)\t" );
	     if(GetDates(IDX_MONTHSHORT, buf, sizeof(buf)))
	     lstrcat(szbuf[6],buf);
	     
	     
	     lstrcpy(szbuf[7],"GetDates(IDX_MONTHDAY)\t" );
	     if(GetDates(IDX_MONTHDAY, buf, sizeof(buf)))
	     lstrcat(szbuf[7],buf);
	     
	     	     
	     lstrcpy(szbuf[8],"GetDates(IDX_YEARLONG)\t" );
	     if(GetDates(IDX_YEARLONG, buf, sizeof(buf)))
	     lstrcat(szbuf[8],buf);
	     
	     
	     lstrcpy(szbuf[9],"GetDates(IDX_YEARSHORT)\t" );
	     if(GetDates(IDX_YEARSHORT, buf, sizeof(buf)))
	     lstrcat(szbuf[9],buf);
	     
	     
	     lstrcpy(szbuf[10],"GetDates(IDX_ASCTIME)\t" );
	     if(GetDates(IDX_ASCTIME, buf, sizeof(buf)))
	     lstrcat(szbuf[10],buf);
	     
	     
	     lstrcpy(szbuf[11],"GetDates(IDX_STDDATE)\t" );
	     if(GetDates(IDX_STDDATE, buf, sizeof(buf)))
	     lstrcat(szbuf[11],buf);
	     
	     
	     lstrcpy(szbuf[12],"GetDates(IDX_STDDATESHORT)\t" );
	     if(GetDates(IDX_STDDATESHORT, buf, sizeof(buf)))
	     lstrcat(szbuf[12],buf);
	     
	     
	     lstrcpy(szbuf[13],"GetDates(IDX_DBFDATE)\t" );
	     if(GetDates(IDX_DBFDATE, buf, sizeof(buf)))
	     lstrcat(szbuf[13],buf);
	     
	     
	     lstrcpy(szbuf[14],"GetDates(IDX_STDTIME)\t" );
	     if(GetDates(IDX_STDTIME, buf, sizeof(buf)))
	     lstrcat(szbuf[14],buf);
	                     
	     InvalidateRect(hWnd, NULL ,TRUE);
	     }
	    break;

	    case ID_FILE_EXIT:
	    PostMessage(hWnd, WM_SYSCOMMAND,SC_CLOSE,0L);
	    break;

	    case IDM_ABOUT:
		DialogBox(hInst, "AboutBox", hWnd, About); 
	    break;

	    }
	   
	     
	 break;


	case WM_PAINT:

	     {
	     int nTabs[2];
	     HFONT hFont, hOldFont;
	     hdc = BeginPaint(hWnd,&lps);
	     nTabs[0] = lstrlen(szbuf[0])*3;
	     nTabs[1] = lstrlen(szbuf[0])*4;
	     hFont = CreateFont(-14,0,0,0,FW_NORMAL,0,0,0,ANSI_CHARSET,OUT_DEFAULT_PRECIS,
                               CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,FF_DONTCARE,(LPSTR)"Ariel");

           	hOldFont = SelectObject(hdc, hFont);
    	 if(szbuf[0][0] != '\0')	
	     for(i = 0; i < 15; i++)
	     	TabbedTextOut(hdc, 10,20*i,szbuf[i],lstrlen(szbuf[i]), sizeof(nTabs) / sizeof(int), nTabs, nTabs[0]);
         
         hFont = SelectObject(hdc, hOldFont);
      	 DeleteObject(hFont);

	     
	     EndPaint(hWnd,&lps);
	     }
	     break;
	case WM_DESTROY:          /* message: window being destroyed */
	    PostQuitMessage(0);
	    break;

	default:                  /* Passes it on if unproccessed    */
	    return (DefWindowProc(hWnd, message, wParam, lParam));
    }
    return (NULL);
}


/****************************************************************************

    FUNCTION: About(HWND, unsigned, WORD, LONG)

    PURPOSE:  Processes messages for "About" dialog box

    MESSAGES:

    WM_INITDIALOG - initialize dialog box
    WM_COMMAND    - Input received

    COMMENTS:

    No initialization is needed for this particular dialog box, but TRUE
    must be returned to Windows.

    Wait for user to click on "Ok" button, then close the dialog box.

****************************************************************************/

BOOL FAR PASCAL CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message)
    {
	case WM_INITDIALOG:            /* message: initialize dialog box */
	    return (TRUE);

	case WM_COMMAND:               /* message: received a command */
	    if (wParam == IDOK         /* "OK" box selected?          */
		|| wParam == IDCANCEL) /* System menu close command?  */
	    {
		EndDialog(hDlg, TRUE); /* Exits the dialog box        */
		return (TRUE);
	    }
	    break;
    }
    return (FALSE);               /* Didn't process a message    */
}
