//TextFx DLL Version 1.0


//header files
#include 	<windows.h>
#include 	<string.h>


//function prototypes
#ifdef __cplusplus
	extern "C" {
	#endif
int far pascal _export GetTextFxVersion ();
void far pascal _export TextRotate (HDC dc,int Xstart,int Ystart,LPSTR TheString,LPSTR TheFontName,LPSTR TheStyleWord,LPSTR AlignmentWord,int PointSize,COLORREF TheColor,int TheRotation);
#ifdef __cplusplus
	}
	#endif


#pragma argsused
int far pascal LibMain(HINSTANCE hInstance, WORD wDataSeg, WORD cbHeapSize, LPSTR lpstrCmdLine)
   {
   if (cbHeapSize) UnlockData(0);
   return TRUE;
   }


//-----------------------------------------------------------------------
//  Name:	GetTextFxVersion
//-----------------------------------------------------------------------
int far pascal _export GetTextFxVersion ()
{
   int RetValue=100;
   return ((int) RetValue);
   }



//-----------------------------------------------------------------------
//   Name:	TextRotate
//-----------------------------------------------------------------------
void far pascal _export TextRotate (HDC dc,int Xstart,int Ystart,LPSTR TheString,LPSTR TheFontName,LPSTR TheStyleWord,LPSTR AlignmentWord,int PointSize,COLORREF TheColor,int TheRotation)
{
    //declare local variables
	int			i;
	int			ThisWeight;
    int			ThisItalic;
	int			nHeight;
	HFONT		ThisFont;
	HFONT		NewFont;
	int			PrevMode;
	COLORREF	OldTextColor;
	int			PrevAlign;
	int			TheStyle;
	char *		parseAlign2 [4] = {
				       "bold",
 				       "italic",
					   "bolditalic",
                       "plain"
					   };
	int			TheAlignment;
	char *		parseAlign3 [3] = {
				       "left",
 				       "center",
					   "right"
					   };

    //translate function parameters
	TheStyle=3;
	for (i = 0; i < 4; i++)
	if (lstrcmpi (parseAlign2 [i],TheStyleWord) == 0) TheStyle=i;

	TheAlignment=0;
	for (i = 0; i < 3; i++)
	if (lstrcmpi (parseAlign3 [i],AlignmentWord) == 0) TheAlignment=i;

	if (TheRotation<0) TheRotation=0;
	if (TheRotation>359) TheRotation=359;
    TheRotation=TheRotation*10;

				switch (TheStyle)
				{
					case 0:
						ThisWeight=FW_BOLD;
						ThisItalic=FALSE;
						break;
					case 1:
						ThisWeight=FW_NORMAL;
						ThisItalic=TRUE;
        		        break;
		            case 2:
						ThisWeight=FW_BOLD;
						ThisItalic=TRUE;
						break;
					case 3:
						ThisWeight=FW_NORMAL;
						ThisItalic=FALSE;
						break;
				}
    		nHeight = (GetDeviceCaps (dc, LOGPIXELSY) * PointSize) / -72;
			ThisFont = CreateFont (nHeight, 0, TheRotation, 0, ThisWeight,ThisItalic, 0, 0,
			          DEFAULT_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
		       	      PROOF_QUALITY, FF_DONTCARE | DEFAULT_PITCH, TheFontName);

			switch (TheAlignment)
			{
				case 0:
					PrevAlign=SetTextAlign(dc,TA_LEFT);
	                break;
				case 1:
					PrevAlign=SetTextAlign(dc,TA_CENTER);
        	        break;
				case 2:
					PrevAlign=SetTextAlign(dc,TA_RIGHT);
					break;
            }


            //display the text
			NewFont=SelectObject (dc,ThisFont);
			OldTextColor=GetTextColor(dc);
			PrevMode=SetBkMode(dc,TRANSPARENT);
            SetTextColor(dc,TheColor);
			TextOut(dc,Xstart,Ystart,TheString,lstrlen(TheString));

            //restore original device context values
			SetTextColor(dc,OldTextColor);
			SetBkMode(dc,PrevMode);
            SetTextAlign(dc,PrevAlign);
			SelectObject(dc,NewFont);
			DeleteObject(ThisFont);
}


//-----------------------------------------------------------------------
//  Name:	Windows Exit Procedure
//-----------------------------------------------------------------------
#pragma argsused
int far pascal WEP(int nParam)
{
	return TRUE;
}
