Type PointAPI
    x As Integer
    y As Integer
End Type

Type Size
    cx As Integer
    cy As Integer
End Type

Type Rect
    xTopLeft As Integer
    yTopLeft As Integer
    xBottomRight As Integer
    yBottomRight As Integer
End Type

Global Const SRCCOPY = &HCC0020
Global WindRect As Rect
Global WindowPos As PointAPI
Global HintFlag As Integer, WindowHandle As Integer
Global HintHandle As Integer, HintBitMap As Integer
Global RecArea As Rect, RecWidth As Integer, RecHeight As Integer

Declare Function CreateDC Lib "GDI" (ByVal lpDriverName As String, ByVal lpDeviceName As Any, ByVal lpOutput As Any, ByVal lpInitData As Any) As Integer
Declare Sub GetCursorPos Lib "User" (lpPoint As PointAPI)
Declare Function GetTextExtentPoint Lib "GDI" (ByVal hDC As Integer, ByVal lpszString As String, ByVal cbString As Integer, lpSize As Size) As Integer
Declare Function CreateCompatibleDC Lib "GDI" (ByVal hDC As Integer) As Integer
Declare Function Rectangle Lib "GDI" (ByVal hDC As Integer, ByVal X1 As Integer, ByVal Y1 As Integer, ByVal X2 As Integer, ByVal Y2 As Integer) As Integer
Declare Function RoundRect Lib "GDI" (ByVal hDC As Integer, ByVal X1 As Integer, ByVal Y1 As Integer, ByVal X2 As Integer, ByVal Y2 As Integer, ByVal X3 As Integer, ByVal Y3 As Integer) As Integer
Declare Function TextOut Lib "GDI" (ByVal hDC As Integer, ByVal x As Integer, ByVal y As Integer, ByVal lpString As String, ByVal nCount As Integer) As Integer
Declare Function CreateCompatibleBitmap Lib "GDI" (ByVal hDC As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer) As Integer
Declare Function SelectObject Lib "GDI" (ByVal hDC As Integer, ByVal hObject As Integer) As Integer
Declare Function BitBlt Lib "GDI" (ByVal hDestDC As Integer, ByVal x As Integer, ByVal y As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal hSrcDC As Integer, ByVal XSrc As Integer, ByVal YSrc As Integer, ByVal dwRop As Long) As Integer
Declare Function DeleteDC Lib "GDI" (ByVal hDC As Integer) As Integer
Declare Function DeleteObject Lib "GDI" (ByVal hObject As Integer) As Integer
Declare Sub GetWindowRect Lib "User" (ByVal hWnd As Integer, lpRect As Rect)
Declare Function CreateSolidBrush Lib "GDI" (ByVal crColor As Long) As Integer
Declare Sub SetSysColors Lib "User" (ByVal nChanges As Integer, lpSysColor As Integer, lpColorValues As Long)
Declare Function SetBkColor Lib "GDI" (ByVal hDC As Integer, ByVal crColor As Long) As Long
Declare Function CreateFont Lib "GDI" (ByVal H%, ByVal W%, ByVal E%, ByVal O%, ByVal W%, ByVal I%, ByVal U%, ByVal S%, ByVal C%, ByVal OP%, ByVal CP%, ByVal Q%, ByVal PAF%, ByVal F$) As Integer
Declare Function SetMapMode Lib "GDI" (ByVal hDC As Integer, ByVal nMapMode As Integer) As Integer

Sub CheckBalloon (TheForm As Form)

    Dim MousePointer As PointAPI
    Dim WindRectTemp As Rect

    Call GetWindowRect(TheForm.hWnd, WindRectTemp)
    Call GetCursorPos(MousePointer)

    If MousePointer.x < WindRectTemp.xTopLeft Or MousePointer.y < WindRectTemp.yTopLeft Or MousePointer.y > WindRectTemp.yBottomRight Then
        Call RemBalloon(TheForm)
    End If
    
End Sub

Sub PutBalloon (MyString As String, TheForm As Form)
    
    Dim MousePointer As PointAPI
    Dim MyStringSize As Size
    Dim RecRegion As Integer
    Dim BrushHandle As Integer
    ReDim BottomPoints(2) As PointAPI
    Dim FontName As String
    Dim FontSize As Integer
    Dim FontHandle As Integer
    Dim FontWeight As Integer
    
    If HintFlag = 0 Then
        
        HintFlag = 1
        
        Call GetWindowRect(TheForm.hWnd, WindRect)

        WindowHandle = CreateDC("Display", ByVal 0&, ByVal 0&, ByVal 0&)
        HintHandle = CreateCompatibleDC(WindowHandle)
        
        FontName = "Courier New"
        FontSize = 16
        FontWeight = 800
        FontHandle = CreateFont(FontSize, 0, 0, 0, FontWeight, 0, 0, 0, 0, 0, 0, 0, 0, FontName)
        Dummy% = SelectObject(WindowHandle, FontHandle)

        Dummy% = GetTextExtentPoint(WindowHandle, MyString, Len(MyString), MyStringSize)
        
        Call GetCursorPos(MousePointer)
        
        RecArea.xTopLeft = MousePointer.x + 10
        RecArea.yTopLeft = MousePointer.y + 10
        RecArea.xBottomRight = MousePointer.x + MyStringSize.cx + 18
        RecArea.yBottomRight = MousePointer.y + MyStringSize.cy + 18
        RecWidth = RecArea.xBottomRight - RecArea.xTopLeft
        RecHeight = RecArea.yBottomRight - RecArea.yTopLeft
        
        Do Until RecArea.xBottomRight < WindRect.xBottomRight Or RecArea.xBottomRight < 0
            RecArea.xBottomRight = RecArea.xBottomRight - 5
            RecArea.xTopLeft = RecArea.xTopLeft - 5
        Loop

        If RecArea.xBottomRight > WindRect.xBottomRight Or RecArea.xTopLeft < WindRect.xTopLeft Or RecArea.xBottomRight < 0 Then
            Exit Sub
        End If

        HintBitMap = CreateCompatibleBitmap(WindowHandle, RecWidth, RecHeight)
        Dummy% = SelectObject(HintHandle, HintBitMap)
        Dummy% = BitBlt(HintHandle, 0, 0, RecWidth, RecHeight, WindowHandle, RecArea.xTopLeft, RecArea.yTopLeft, SRCCOPY)
                  
        BottomPoints(1).x = RecArea.xBottomRight
        BottomPoints(1).y = RecArea.yBottomRight
        BottomPoints(2).x = RecArea.xTopLeft
        BottomPoints(2).y = RecArea.yBottomRight
        
        Color& = RGB(255, 255, 0)
        BrushHandle = CreateSolidBrush(Color&)
        Dummy% = SelectObject(WindowHandle, BrushHandle)

        Dummy% = RoundRect(WindowHandle, RecArea.xTopLeft, RecArea.yTopLeft, RecArea.xBottomRight, RecArea.yBottomRight, 20, 20)
        WinBackColor = SetBkColor(WindowHandle, Color&)
        Dummy% = SelectObject(WindowHandle, FontHandle)
        Dummy% = TextOut(WindowHandle, RecArea.xTopLeft + 4, RecArea.yTopLeft + 4, MyString, Len(MyString))
                           
        

    End If

End Sub

Sub RemBalloon (TheForm As Form)

    Dim WindRectNew As Rect
    
    If HintFlag = 1 Then
        
        Call GetWindowRect(TheForm.hWnd, WindRectNew)
    
        RecArea.xTopLeft = RecArea.xTopLeft + (WindRectNew.xTopLeft - WindRect.xTopLeft)
        RecArea.yTopLeft = RecArea.yTopLeft + (WindRectNew.yTopLeft - WindRect.yTopLeft)
    
        HintFlag = 0
        Dummy% = BitBlt(WindowHandle, RecArea.xTopLeft, RecArea.yTopLeft, RecWidth, RecHeight, HintHandle, 0, 0, SRCCOPY)
        Dummy2& = SetBkColor(WindowHandle, WinBackColor)
        Dummy% = DeleteDC(WindowHandle)
        Dummy% = DeleteDC(HintHandle)
        Dummy% = DeleteObject(HintBitMap)
        Dummy% = DeleteObject(BrushHandle)
        BalloonHint = ""

    End If

End Sub

