'****************************************************************************
'*                                                                          *
'*      Module Name: BackGround                                             *
'*                                                                          *
'*             Created:              By:Michael McCarthy                    *
'*            Modified:              By:                                    *
'*                                                                          *
'*            Comments:                                                     *
'*  This module contains 4 functions that draw and create gradiant bitmaps  *
'****************************************************************************
'
Option Explicit


'These variables are used by the two forms to save the current custom colors
    Global glngFrom&
    Global glngTo&

'This is the structure of a BitMap File Header
    Type BITMAPmudtFileHeader
	bfType As Integer
	bfSize As Long
	bfReserved1 As Integer
	bfReserved2 As Integer
	bfOffBits As Long
    End Type

'This is the structure of a bitmap header
    Type BITMAPINFOHEADER '40 bytes
	biSize As Long
	biWidth As Long
	biHeight As Long
	biPlanes As Integer
	biBitCount As Integer
	biCompression As Long
	biSizeImage As Long
	bixPelsPerMeter As Long
	biyPelsPerMeter As Long
	biClrUsed As Long
	biclrImportant As Long
    End Type

'Scratch variable
    Dim mintReply%

'This is the where the File Header and Bitmap header
'get compiled to be written out to the file
    Dim mstrFileInfo As String * 54

'These are the two header variables variables
    Dim mudtFileHeader As BITMAPmudtFileHeader
    Dim mudtBInfo As BITMAPINFOHEADER

'********************************************************************************
'*                                                                              *
'*      Function Name: CheckQB                                                  *
'*                                                                              *
'*             Created:              By:Michael McCarthy                        *
'*            Modified:              By:                                        *
'*                                                                              *
'*          Parameters:                                                         *
'*                                                                              *
'*             Returns:                                                         *
'*                      True        -   If color is a QBColor                   *
'*                      False       -   If color is NOT a QBColor               *
'*                                                                              *
'*            Comments:                                                         *
'*  When selecting gradiants that are close to one of the 20 system colors      *
'*  (QBColor's) the RGB function will return a best match of the System color   *
'*  instead of one of the mapped colors.  For this reason this function will    *
'*  Let the DrawBackGround function know if a QBColor has been choosen.  This   *
'*  allows the DrawBackGround function to minimize banding.                     *
'********************************************************************************
'
Function CheckQB (ByVal lngColor&) As Integer

On Error GoTo CheckQBError

Dim mblnReturn%

mblnReturn = False

Select Case lngColor
    Case QBColor(1): mblnReturn = True
    Case QBColor(2): mblnReturn = True
    Case QBColor(3): mblnReturn = True
    Case QBColor(4): mblnReturn = True
    Case QBColor(5): mblnReturn = True
    Case QBColor(6): mblnReturn = True
    Case QBColor(7): mblnReturn = True
    Case QBColor(8): mblnReturn = True
    Case QBColor(9): mblnReturn = True
    Case QBColor(10): mblnReturn = True
    Case QBColor(11): mblnReturn = True
    Case QBColor(13): mblnReturn = True
    Case QBColor(14): mblnReturn = True
    Case QBColor(15): mblnReturn = True
End Select

CheckQB = mblnReturn

Exit Function
CheckQBError:
    CheckQB = True
    Exit Function
End Function

'****************************************************************************
'*                                                                          *
'*      Procedure Name: CreateBitMap                                        *
'*                                                                          *
'*             Created:              By:Michael McCarthy                    *
'*            Modified:              By:                                    *
'*                                                                          *
'*          Parameters:                                                     *
'*                  vintNumColors   -   Number of Colors to create          *
'*                  vlngFrom        -   The starting color                  *
'*                  vlngTo          -   The ending color                    *
'*                                                                          *
'*             Returns:                                                     *
'*                      True        -   If successful                       *
'*                      False       -   If unsuccessful                     *
'*                                                                          *
'*            Comments:                                                     *
'*  This function will create a 1 pixel bitmap with a color palette defined *
'* by the passed parameters.                                                *
'****************************************************************************
'
Function CreateBitmap (ByVal vintNumColors%, ByVal vlngFrom&, ByVal vlngTo&) As Integer

On Error GoTo SaveError

Dim i%
Dim dblStepRed#, dblStepBlue#, dblStepGreen#
Dim dblRed#, dblBlue#, dblGreen#
Dim strColor$

'Find the individual Red, Green and Blue values for the starting color
    dblRed = (vlngFrom And 255)
    dblGreen = (Int(vlngFrom / 256) And 255)
    dblBlue = (Int(vlngFrom / 65536) And 255)

'Find the step values for each color for the number of colors passed
    dblStepRed = ((vlngTo And 255) - dblRed) / vintNumColors
    dblStepGreen = ((Int(vlngTo / 256) And 255) - dblGreen) / vintNumColors
    dblStepBlue = ((Int(vlngTo / 65536) And 255) - dblBlue) / vintNumColors

i = 0
Do
'Create color, Colors are stored Blue, Green, Red
    strColor = strColor & Chr(dblBlue And 255) & Chr(dblGreen And 255) & Chr(dblRed And 255) & Chr(0) 'Red
    
'Add the step value to each color segment
    dblBlue = dblBlue + dblStepBlue
    dblGreen = dblGreen + dblStepGreen
    dblRed = dblRed + dblStepRed
    i = i + 1
Loop Until i >= vintNumColors

'Fill the Bitmap header with the appropriate values
    mudtBInfo.biSize = 40               ' Size of Header in Bytes
    mudtBInfo.biWidth = 1               ' Width of Bitmap in Pixels
    mudtBInfo.biHeight = 1              ' Height of Bitmap in Pixels
    mudtBInfo.biPlanes = 1              ' Number of Planes
    mudtBInfo.biBitCount = 8            ' Number of Color Bits per Pixel
    mudtBInfo.biCompression = 0         ' Compression Style
    mudtBInfo.biSizeImage = (mudtBInfo.biWidth * mudtBInfo.biHeight) * 4    ' Size of Bitmap in bytes (4 bytes per pixel)
    mudtBInfo.bixPelsPerMeter = 0       ' Pixels Per Meter x
    mudtBInfo.biyPelsPerMeter = 0       ' Pixelx Per Meter y
    mudtBInfo.biClrUsed = vintNumColors ' Number of colors in Bitmap
    mudtBInfo.biclrImportant = 0        ' Number of Important Colors (0 means all important)

'Fill the File header with the appropriate information
    mudtFileHeader.bfType = 19778       '   File Type   'BM' - Bitmap
'Number of bytes in the file
    mudtFileHeader.bfSize = Len(mudtFileHeader) + Len(mudtBInfo) + Len(strColor) + mudtBInfo.biSizeImage  ' frmPalette.txtFile(2)
    mudtFileHeader.bfReserved1 = 0
    mudtFileHeader.bfReserved2 = 0
'Number of Bytes where bitmap actually starts in the file
    mudtFileHeader.bfOffBits = Len(strColor) + Len(mudtFileHeader) + Len(mudtBInfo)

'Now fill the string with all the bitmap information
    Mid(mstrFileInfo, 15, 4) = GetAscii(mudtBInfo.biSize, 4)
    Mid(mstrFileInfo, 19, 4) = GetAscii(mudtBInfo.biWidth, 4)
    Mid(mstrFileInfo, 23, 4) = GetAscii(mudtBInfo.biHeight, 4)
    Mid(mstrFileInfo, 27, 2) = GetAscii(mudtBInfo.biPlanes, 2)
    Mid(mstrFileInfo, 29, 2) = GetAscii(mudtBInfo.biBitCount, 2)
    Mid(mstrFileInfo, 31, 4) = GetAscii(mudtBInfo.biCompression, 4)
    Mid(mstrFileInfo, 35, 4) = GetAscii(mudtBInfo.biSizeImage, 4)
    Mid(mstrFileInfo, 39, 4) = GetAscii(mudtBInfo.bixPelsPerMeter, 4)
    Mid(mstrFileInfo, 43, 4) = GetAscii(mudtBInfo.biyPelsPerMeter, 4)
    Mid(mstrFileInfo, 47, 4) = GetAscii(mudtBInfo.biClrUsed, 4)
    Mid(mstrFileInfo, 51, 4) = GetAscii(mudtBInfo.biclrImportant, 4)
			    
    Mid(mstrFileInfo, 1, 2) = GetAscii(mudtFileHeader.bfType, 2)
    Mid(mstrFileInfo, 3, 4) = GetAscii(mudtFileHeader.bfSize, 4)
    Mid(mstrFileInfo, 7, 2) = GetAscii(mudtFileHeader.bfReserved1, 2)
    Mid(mstrFileInfo, 9, 2) = GetAscii(mudtFileHeader.bfReserved2, 2)
    Mid(mstrFileInfo, 11, 4) = GetAscii(mudtFileHeader.bfOffBits, 4)
    
'At this point I choose to save the bitmap in the current directory
'Hopefully for immediate use, but the file can be saved anywhere
    Open "custom.bmp" For Output As 1
	Print #1, mstrFileInfo & strColor & Chr(0) & Chr(0) & Chr(0) & Chr(0)
    Close

    CreateBitmap = True
Exit Function
SaveError:
    Close
    CreateBitmap = False
    Exit Function
End Function

'********************************************************************************
'*                                                                              *
'*      Procedure Name: DrawBackGround                                          *
'*                                                                              *
'*             Created:              By:Michael McCarthy                        *
'*            Modified:              By:                                        *
'*                                                                              *
'*          Parameters:                                                         *
'*                      rfrmForm    -   The form to paint                       *
'*                      rstrText    -   Any text to print on the form           *
'*                      vlngFrom    -   The starting color of the fill          *
'*                      vlngTo      -   The ending color of the fill            *
'*                      vintStyle   -   The style of the background             *
'*                      vintStep    -   Number of Gradiant Steps in fill        *
'*                                                                              *
'*            Comments:                                                         *
'*  This procedure performs a gradient fill on the background of a form shading *
'*  it from the color in vlngFrom to the color in vlngTo.                       *
'*  For the best effect the form should contain a picture with a pallette of    *
'*  all the gradient values.  (See CreateBitmap)                                *
'********************************************************************************
'
Sub DrawBackGround (rfrmForm As Form, rstrText$, ByVal vlngFrom&, ByVal vlngTo&, ByVal vintStyle%, ByVal vintStep%)

Dim i%

Dim lngGradColor&, lngLastColor&
Dim dblWidth#, dblHeight#, dblStepHeight#, dblStepWidth#
Dim dblRed#, dblBlue#, dblGreen#
Dim dblStepRed#, dblStepBlue#, dblStepGreen#

On Error Resume Next

'Find the Gradiant Starting and Step Values
    dblRed = (vlngFrom And 255)
    dblGreen = (Int(vlngFrom / 256) And 255)
    dblBlue = (Int(vlngFrom / 65536) And 255)

    dblStepRed = ((vlngTo And 255) - dblRed) / vintStep
    dblStepGreen = ((Int(vlngTo / 256) And 255) - dblGreen) / vintStep
    dblStepBlue = ((Int(vlngTo / 65536) And 255) - dblBlue) / vintStep
    
    rfrmForm.ScaleMode = 3              'Scalemode set to pixels
    rfrmForm.DrawStyle = 6              'DrawStyle set to Inside Solid
    rfrmForm.AutoRedraw = True          'Make form redraw itself

'Find the Number of Pixels for the number of steps
    dblWidth = rfrmForm.ScaleWidth / vintStep
    dblHeight = rfrmForm.ScaleHeight / vintStep

'Set DrawWidth to to the maximum Pixel Size
    If dblHeight > dblWidth Then
	rfrmForm.DrawWidth = dblHeight + 1
    Else
	rfrmForm.DrawWidth = dblWidth + 1
    End If

'If this is the circle method add 2 to cover defects
    If vintStyle = 4 Then rfrmForm.DrawWidth = rfrmForm.DrawWidth + 2
    
'Set BackGround to the major color
    rfrmForm.BackColor = vlngFrom
    lngGradColor = vlngFrom

'Cycle through all the steps and draw the appropriate pattern
    For i = 1 To vintStep + 1
	lngLastColor = lngGradColor
	lngGradColor = (dblBlue And 255) * 65536 + Int(dblGreen And 255) * 256 + Int(dblRed And 255)
	
	If CheckQB(lngGradColor) Then
	    lngGradColor = lngLastColor
	    lngLastColor = (dblBlue And 255) * 65536 + Int(dblGreen And 255) * 256 + Int(dblRed And 255)
	End If

	dblRed = dblRed + dblStepRed
	dblBlue = dblBlue + dblStepBlue
	dblGreen = dblGreen + dblStepGreen

    'Compute the current Step
	dblStepHeight = (i - 1) * dblHeight
	dblStepWidth = (i - 1) * dblWidth
	Select Case Int(vintStyle):
	    Case 0: 'Top to Bottom
		rfrmForm.Line (0, dblStepHeight)-(rfrmForm.ScaleWidth, dblStepHeight), lngGradColor
	    Case 1: 'Top Left corner to Bottom Right Corner
		rfrmForm.Line (0, dblStepHeight)-(dblStepWidth, 0), lngGradColor
		rfrmForm.Line (rfrmForm.ScaleWidth, rfrmForm.ScaleHeight - dblStepHeight)-(rfrmForm.ScaleWidth - dblStepWidth, rfrmForm.ScaleHeight), lngGradColor
	    Case 2: 'Top Right corner to Bottom Left Corner
		rfrmForm.Line (rfrmForm.ScaleWidth - dblStepWidth, 0)-(rfrmForm.ScaleWidth, dblStepHeight), lngGradColor
		rfrmForm.Line (0, rfrmForm.ScaleHeight - dblStepHeight)-(dblStepWidth, rfrmForm.ScaleHeight), lngGradColor
	    Case 3: 'Edge to Center Square
		rfrmForm.Line (dblStepWidth / 2, dblStepHeight / 2)-(rfrmForm.ScaleWidth - dblStepWidth / 2, dblStepHeight / 2), lngGradColor
		rfrmForm.Line (dblStepWidth / 2, dblStepHeight / 2)-(dblStepWidth / 2, rfrmForm.ScaleHeight - dblStepHeight / 2), lngGradColor
		rfrmForm.Line (dblStepWidth / 2, rfrmForm.ScaleHeight - dblStepHeight / 2)-(rfrmForm.ScaleWidth - dblStepWidth / 2, rfrmForm.ScaleHeight - dblStepHeight / 2), lngGradColor
		rfrmForm.Line (rfrmForm.ScaleWidth - dblStepWidth / 2, dblStepHeight / 2)-(rfrmForm.ScaleWidth - dblStepWidth / 2, rfrmForm.ScaleHeight - dblStepHeight / 2), lngGradColor
	    Case 4: 'Edge to Center Circle
		rfrmForm.Circle (rfrmForm.ScaleWidth / 2, rfrmForm.ScaleHeight / 2), dblStepHeight, lngGradColor
	End Select
    Next
    
'Background is drawn now put text on form
    rfrmForm.ScaleMode = 2          'Scalemode set to Point
    rfrmForm.FontSize = rfrmForm.ScaleWidth / 18
    rfrmForm.FontBold = True
    rfrmForm.FontItalic = False
    rfrmForm.FontName = "Times New Roman"

'Print the passed text
    rfrmForm.CurrentY = 10
    rfrmForm.CurrentX = 10
    rfrmForm.ForeColor = QBColor(0)
    rfrmForm.Print " " + rstrText + Str(vintStyle)

'Offset the text for a shadowed effect
    rfrmForm.CurrentY = 8
    rfrmForm.CurrentX = 8
    rfrmForm.ForeColor = QBColor(15)
    rfrmForm.Print " " + rstrText + Str(vintStyle)

End Sub

'****************************************************************************
'*                                                                          *
'*      Function Name: GetAscii                                             *
'*                                                                          *
'*             Created:              By:Michael McCarthy                    *
'*            Modified:              By:                                    *
'*                                                                          *
'*          Parameters:                                                     *
'*                      rvntNum     -   Number to Convert                   *
'*                      rintBytes   -   Number of bytes to convert to       *
'*                                                                          *
'*             Returns:                                                     *
'*                      -   The converted string or null if unsuccessful    *
'*                                                                          *
'*            Comments:                                                     *
'*  This funciton accepts a number and converts it to a string that can be  *
'*  saved out to a file.  It converts the number using Hi/Lo format.        *
'****************************************************************************
'
Function GetAscii (rvntNum As Variant, rintBytes%) As String

On Error GoTo GetAsciiError

Dim i%
Dim lngNum As Long
Dim strTemp As String * 4

i = 1
lngNum = rvntNum

Do
    Mid(strTemp, i, 1) = Chr(lngNum And 255)
    lngNum = lngNum \ 256
    i = i + 1
Loop Until i > rintBytes

GetAscii = Left(strTemp, rintBytes)

Exit Function
GetAsciiError:
    GetAscii = ""
    Exit Function
End Function

