//********************************************************
// ARRAY.C - Visual Basic Array Manipulation DLL Source
// Author: Chuck Benedict, CIS 73672,1662
// Date: 3/9/1994
// Usage Information:
//		You have my permission to use this code in whatever
//		way you see fit on the condition that you agree not
//		to hold me responsible for anything either positive
//		or negative that results due to its usage.  If you
//		find the DLL or the source code useful, I will
//		gladly accept donations ($10 would be nice)!
//		My address: 1503 Clear Valley
//						Houston, TX  77014
// Revisions:
//    V0.1 - DeleteArrayIndex function created
//********************************************************
#include "windows.h"
#include "vbapi.h"
#include <string.h>

int FAR PASCAL LibMain (
	HANDLE hInstance,			// DLLs Module Handle
	USHORT uDataSeg,			// data segment selector
	USHORT cbHeapSize,		// initial heap size
	LPSTR  lpszCmdLine)		// command line arguments?
	{

	// Unlock the data segment that LibEntry locked for us
	UnlockData (0);
	return TRUE;						// true to succeed
	}

void FAR MyMemmove(
   char __huge  *hpSource,        // Source buffer pointer
   char __huge  *hpDest,          // Destination buffer pointer
   unsigned long  lCount)         // Count of bytes to move
{

   UINT         ucount;           // Temporary short int
   BOOL         bReverse = FALSE; // Bottom up?

// If we are moving less than 64K, we can do it all in one call.
   if (HIWORD(lCount) == 0) {
      _fmemmove(hpDest, hpSource, LOWORD(lCount));

      return;
   }

// We are now dealing with >64K of data. If the destination 
// is lower in memory than the source, we can repetitively 
// copy 64K blocks from the top of each block. If the destination
// is higher in memory than the source, we must repetitively move 
// 64K blocks from the bottom of the source and destination to
// prevent overwriting the source. We start by adjusting the source
// and destination pointers to point at the last 64K chunk in the

// block and set a flag (bReverse). After each block move, we move
// the source and destination pointers up or down appropriately.

   if (hpDest > hpSource) {
      hpSource += (lCount - 65535);  
      hpDest += (lCount - 65535);
      bReverse = TRUE;
   }
   while (TRUE) {
      if (HIWORD(lCount))
         ucount = 65535;       // >64K left; set ucount to 64K
      else
         ucount = LOWORD(lCount);
      _fmemmove(hpDest, hpSource, ucount);

      lCount -= ucount;        // Reduce the amount left to move
      if (lCount == 0)
         return;               // All done; return
      if (bReverse) {          // Update source/destination pointers
         if (HIWORD(lCount)) {
            hpDest -= ucount;
            hpSource -= ucount;
         } else {
            hpDest -= LOWORD(lCount);
            hpSource -= LOWORD(lCount);
         }
      } else {
         hpDest += ucount;

         hpSource += ucount;
      }
   }
   return;
}

int FAR PASCAL _export DeleteArrayIndex(
	HAD hAD,
	SHORT Index)
{
	ULONG lBounds;					// define working variables
	SHORT arIndex[1];
	char __huge *source;
	char __huge *dest;
	ULONG lCount;

// we can only do one-dimentional arrays for now
	if (VBArrayIndexCount(hAD) != 1)
		return 0;

// check to make sure index is within range of array boundries
	lBounds = VBArrayBounds(hAD, 1);
	if (Index < LOBOUND(lBounds) || Index > HIBOUND(lBounds))
		return 0;

// check if the Index passed = upper bound
	if (Index == HIBOUND(lBounds))
		return -1;

// now, get source and dest address: source will be Index + 1,
// dest will be Index
	arIndex[0] = Index + 1;
	source = (char __huge *) VBArrayElement(hAD, 1, arIndex);
   arIndex[0] = Index;
	dest = (char __huge *) VBArrayElement(hAD, 1, arIndex);
	lCount = (HIBOUND(lBounds) - Index) * VBArrayElemSize(hAD);

// move the memory
	MyMemmove(source, dest, lCount);
	return -1;
}