Unit D_DstPay;

INTERFACE
Uses
   Wintypes, Winprocs;

function D_DstPayInit(Window : hWnd; Message,wParam : Word;lParam : LongInt):Integer;

IMPLEMENTATION
Uses r_incl,s_incl,MBMDEFS,TuADS,Strings,Win31;

Function CountDistAffair(hCursor : word; DistCode : Pointer;
                                            Var Total : Double;
                                            Var Payed : Double;
                                            Var Credit : double;
                                               CMPAYED : Pointer;
                                               Update  : Boolean
                                            ): Integer;
Var
   RecNb        : Integer;
   TableAffair  : pTable;
   Done         : Boolean;
   NextDist     : Pointer;
   AffairBuff   : pAFFAIRS;
begin
   TableAffair   := GetTableInfo(hCursor,'AFFAIRS');
   If (TableAffair <> NIL) then
   begin
       Done     := False;
       Total    := 0;
       Payed    := 0;
       Credit   := 0;
       RecNb := TbSearchRef(TableAffair,1,DISTCODE);
       If (StrComp('ALL',DISTCODE) = 0) then RecNb := 1;
       If (RecNb > 0 )then
       begin
          While Not Done do
          begin
             AffairBuff := TbGetRecordAddress(TableAffair,RecNb);
             Total := Total + AffairBuff^._TOCOMMISSION;
             If (StrLen(AffairBuff^._CMPAYED) = 0 ) then
                Credit := Credit + AffairBuff^._TOCOMMISSION
             else
                Payed := Payed + AffairBuff^._TOCOMMISSION ;
              if Update then
                 TbSetField(TableAffair,RecNb,8,CMPAYED,SizeOf(CSTRING15));
             Inc(RecNb);
             if RecNb >TableAffair^.NbRecs then Done := True else
             begin
                NextDist  := TbGetFieldAddress(TableAffair,RecNb,1);
                If (StrComp('ALL',DISTCODE) <> 0 ) then
                    If (StrComp(NextDist,DISTCODE) <> 0 ) then Done := True;
             end;
          end;
       end;
   end;
end;


Function GOClip(hWindow : hWnd; hCursor: Word): integer;
Var
   pClip         : Pointer;
   Index         : integer;
   TableCUSTOMER : pTable;
   TmpBuffer     : pointer;
   RecBuffer     : pointer;
   DISTCODE      : Pointer;
   Total,Payed,
   Credit        : double;
   I,J           : Word;
   Tmp2Buffer    : array[0..50] of char;
   StrBuffer     : String;
   Sel           : Integer;
   Update        : Boolean;
   CmdPay        : array[0..50] of char;
begin
{   If hClip = 0 then}
       Update := FALSE;
       if IsDlgButtonChecked(hWindow,ID_UPDCHK)> 0 then
          Update := TRUE;
       If Update then
          GetDlgItemText(hWindow,ID_UPDDATE,CmdPay,15);
       Index :=  SendDlgItemMessage(hWindow,ID_DISTLIST,LB_GetCount, 0,0);
       TableCUSTOMER := GetTableInfo(hInstance,'CUSTOMER');

       if Index < 1 then Index := 1;
       hClip := GlobalAlloc(GHND,TableCustomer^.RecSize * Index);
       pClip := GlobalLock(hClip);

       TmpBuffer := GlobalAllocPtr(GHND,TableCUSTOMER^.RecSize);
       DISTCODE  := GlobalAllocPtr(GHND,TableCUSTOMER^.RecSize);
       StrCopy(pClip,'Distributors commision '+#13+#10);
       StrCat(pClip,'DCODE'+#9);
       StrCat(pClip,'NAME'+#9);
       StrCat(pClip,'PNAME'+#9);
       StrCat(pClip,'COMPANY'+#9);
       StrCat(pClip,'ADDRESS'+#9);
       StrCat(pClip,'ZIP'+#9);
       StrCat(pClip,'CITY'+#9);
       StrCat(pClip,'COUNTRY'+#9);
       StrCat(pClip,'CARDTYPE'+#9);
       StrCat(pClip,'CARDNUMBER'+#9);
       StrCat(pClip,'AMOUNT');
       StrCat(pClip,#13+#10);
       If Index > 0 then
       For J := 0 to Index-1 do
       begin
          Sel :=  SendDlgItemMessage(hWindow,ID_DISTLIST,LB_GetSel, J,0);
          if (Sel > 0)then
          begin
             SendDlgItemMessage(hWindow,ID_DISTLIST,LB_GetText, J,LongInt(TmpBuffer));
             StrlCopy(DISTCODE,TmpBuffer,30);
             I := TbSearchRef(TableCUSTOMER,1,DISTCODE);
             if I > 0 then
             begin
                RecBuffer := TbGetFieldAddress(TableCUSTOMER,I,1);
                CountDistAffair(hInstance,RecBuffer,Total,Payed,Credit,@CMDPAY,Update);
                if Credit > 0 then
                begin
                   StrCopy(TmpBuffer,RecBuffer);
                   StrCat(TmpBuffer,#9);
                   RecBuffer := TbGetFieldAddress(TableCUSTOMER,I,2);
                   StrCat(TmpBuffer,RecBuffer);
                   StrCat(TmpBuffer,#9);
                   RecBuffer := TbGetFieldAddress(TableCUSTOMER,I,3);
                   StrCat(TmpBuffer,RecBuffer);
                   StrCat(TmpBuffer,#9);
                   RecBuffer := TbGetFieldAddress(TableCUSTOMER,I,4);
                   StrCat(TmpBuffer,RecBuffer);
                   StrCat(TmpBuffer,#9);
                   RecBuffer := TbGetFieldAddress(TableCUSTOMER,I,6);
                   StrCat(TmpBuffer,RecBuffer);
                   StrCat(TmpBuffer,#9);
                   RecBuffer := TbGetFieldAddress(TableCUSTOMER,I,8);
                   StrCat(TmpBuffer,RecBuffer);
                   StrCat(TmpBuffer,#9);
                   RecBuffer := TbGetFieldAddress(TableCUSTOMER,I,7);
                   StrCat(TmpBuffer,RecBuffer);
                   StrCat(TmpBuffer,#9);
                   RecBuffer := TbGetFieldAddress(TableCUSTOMER,I,9);
                   StrCat(TmpBuffer,RecBuffer);
                   StrCat(TmpBuffer,#9);
                   RecBuffer := TbGetFieldAddress(TableCUSTOMER,I,13);
                   StrCat(TmpBuffer,RecBuffer);
                   StrCat(TmpBuffer,#9);
                   RecBuffer := TbGetFieldAddress(TableCUSTOMER,I,14);
                   StrCat(TmpBuffer,RecBuffer);
                   StrCat(TmpBuffer,#9);

                   Str(Credit:6:1,StrBuffer);
                   StrPCopy(Tmp2Buffer,StrBuffer);
                   StrCat(TmpBuffer,Tmp2Buffer);
                   StrCat(TmpBuffer,#13+#10);

                   StrCat(pClip,TmpBuffer);
               end;
             end;
          end;
       end;
       MessageBox(hWindow,'Payment List available in the Clibboard','Message',0);
       GlobalFreePtr(TmpBuffer);
       GlobalFreePtr(DISTCODE);
       OpenClipBoard(hWindow);
       EmptyClipboard;
       SetClipboardData(cf_Text,hClip);
       CloseClipBoard;
       GlobalUnlock(hClip);
end;

{-----------------------------------------------------------------------}
{ Function : D_Account                                                  }
{-----------------------------------------------------------------------}
{ Purpose :                                                             }
{    Callback function for the D_Account Dialog Box                     }
{-----------------------------------------------------------------------}
{  Parameters : Standart window  parameters                             }
{-----------------------------------------------------------------------}

function D_DstPayWndProc(Dialog: HWnd; Message, WParam: Word;
               LParam: Longint): LongInt; export;
var
   Return         : LongInt;
   TableCustomer  : pTable;
   I              : Integer;
   TmpBuffer      : Pointer;
   Tmp2Buffer     : array[0..50] of char;
   StrBuffer      : String;
   RecBuffer      : Pointer;
   TAB            : Integer;
   Index          : Integer;
   Total,Payed,Credit :Double;
   CMDPAY             : array[0..16] of char;
   Sel                : Integer;
begin
   Return := 0;
   case Message of
      WM_INITDIALOG:
      begin
         TAB := 70;
         SendDlgItemMessage(Dialog,ID_DISTLIST,LB_SETTABSTOPS, 1, LongInt(@TAB));
         TAB := 50;
         SendDlgItemMessage(Dialog,ID_DISTLIST,LB_SETTABSTOPS, 1, LongInt(@TAB));
         TableCUSTOMER := GetTableInfo(hInstance,'CUSTOMER');
         TmpBuffer := GlobalAllocPtr(GHND,TableCUSTOMER^.RecSize);
         For I := 1 to TableCUSTOMER^.NbRecs do
         begin
            RecBuffer := TbGetFieldAddress(TableCUSTOMER,I,1);
            CountDistAffair(hInstance,RecBuffer,Total,Payed,Credit,@CMDPAY,FALSE);
            if Credit > 0 then
            begin
               StrCopy(TmpBuffer,RecBuffer);
               StrCat(TmpBuffer,#9);
               RecBuffer := TbGetFieldAddress(TableCUSTOMER,I,2);
               StrCat(TmpBuffer,RecBuffer);
               StrCat(TmpBuffer,#9);
               RecBuffer := TbGetFieldAddress(TableCUSTOMER,I,4);
               StrCat(TmpBuffer,RecBuffer);
               StrCat(TmpBuffer,#9);

               Str(Credit:6:1,StrBuffer);
               StrPCopy(Tmp2Buffer,StrBuffer);
               StrCat(TmpBuffer,Tmp2Buffer);

               SendDlgItemMessage(Dialog,ID_DISTLIST,LB_ADDSTRING, 0, LongInt(TmpBuffer));
           end;
         end;
         GlobalFreePtr(TmpBuffer);
      end;

      WM_COMMAND:
              Case WParam Of

               ID_EXIT :begin
                            EndDialog(Dialog, 1);
                            Exit;
                        end;
               ID_OK :begin
                            EndDialog(Dialog, 1);
                            Exit;
                         end;

               ID_UNSEL : Begin
                             Sel :=  SendDlgItemMessage(Dialog,ID_DISTLIST,LB_GetSelCount, 0,0);
                             if (Sel > 0)then
                                SendDlgItemMessage(Dialog,ID_DISTLIST, LB_SETSEL, 0, MakeLong($FFFF,0));
                          end;
               ID_SALL  : Begin
                             Sel :=  SendDlgItemMessage(Dialog,ID_DISTLIST,LB_GetCount, 0,0);
                             if (Sel > 0)then
                                SendDlgItemMessage(Dialog,ID_DISTLIST, LB_SETSEL, 1, MakeLong($FFFF,0));
                          end;
               ID_GO  : Begin
                             GOClip(Dialog,hInstance);
                          end;

               ID_DISTLIST : begin
                                 If HiWORD(LParam)= LBN_SELCHANGE then
                                 begin
                                 end;
                             end;
               end;
      end;
   D_DstPayWndProc := Return;
end;


{-----------------------------------------------------------------------}
{ Function : AboutInit                                                  }
{-----------------------------------------------------------------------}
{ Purpose :                                                             }
{    Initialisation for the D_Account Box                                   }
{-----------------------------------------------------------------------}
{  Parameters : Standart window  parameters                             }
{-----------------------------------------------------------------------}

function D_DstPayInit(Window : hWnd; Message,wParam : Word;
                   lParam : LongInt):Integer;
var
   D_DstPayProc     : TFarProc;
begin
   D_DstPayProc := MakeProcInstance(@D_DstPayWndProc, hInstance);
   DialogBox(hInstance, 'DSTPAIMENT', Window, D_DstPayProc);  { Modal Dialog !}
   FreeProcInstance(D_DstPayProc);
end;



begin
end.