/*  Project Main

	 Copyright  1994. ITD.

	 SUBSYSTEM	:	MAIN.EXE
	 FILE			:	mnaffdlg.cpp
	 AUTHOR		:	TK
	 CREATION	:	07 december 1994


	 OVERVIEW
	 ========
	 Source file for implementation of MainAffairsDlg (TDialog).
*/

#include <owl\owlpch.h>
#pragma hdrstop
extern WORD hInst ;

#include "mnaffdlg.h"
#include "TUADS.H"



DEFINE_RESPONSE_TABLE1(MainAffairsDlg, TDialog)
	EV_CBN_SELCHANGE(IDC_TRADER,UpdateAmount) ,
	EV_CBN_SELCHANGE(IDC_CUSTOMER,UpdateAmount) ,
END_RESPONSE_TABLE;




MainAffairsDlg::MainAffairsDlg (TWindow* parent, TResId resId):
	 TDialog(parent, resId, 0)
{
	CBTRADERS		= new TComboBox(this,IDC_TRADER,10) ;
	CBCUSTOMERS		= new TComboBox(this,IDC_CUSTOMER,10) ;
	EDAMOUNT			= new TEdit(this,IDC_AMOUNT) ;
}


MainAffairsDlg::~MainAffairsDlg ()
{
	delete CBTRADERS   ;
	delete CBCUSTOMERS ;
	delete EDAMOUNT  ;
	Destroy();
}

void MainAffairsDlg::SetupWindow ()
{
  PTable	CustomTable ;
  PTable	TraderTable ;
  char  lpstrName[31] ;
  UINT i ;
  
  TDialog::SetupWindow() ;

  CustomTable  = GetTableInfo(hInst,"CUSTOME");
  TraderTable  = GetTableInfo(hInst,"TRADERS");

  CBCUSTOMERS->AddString("All");
  for(i=1;i<= CustomTable->NbRecs;i++)
  {
		Status = TbGetField(CustomTable,i,1,lpstrName,30);
		CBCUSTOMERS->AddString(lpstrName);
  }
  CBTRADERS->AddString("All");
  for( i=1;i<= TraderTable->NbRecs;i++)
  {
		Status = TbGetField(TraderTable,i,1,lpstrName,30);
		CBTRADERS->AddString(lpstrName);
  }
  UpdateAmount() ;
}

void MainAffairsDlg::UpdateAmount()
{
	char      lpstrCust[31];
	char      lpstrTrad[31];
	BOOL      bComputeCust;
	BOOL      bComputeTrad;
	long      m_Amount ;
	char		 txt[20] ;
	PTable	AffairsTable ;

	struct Affairs
	{
		char cTrader[30];
		char cCustomer[30];
		long lDate;
		char cProduct[20];
		long lAmount;
	} far* sAffairsRecord;

	m_Amount = 0 ;
	AffairsTable = GetTableInfo(hInst,"AFFAIRS");

	lstrcpy(lpstrCust,"") ;
	lstrcpy(lpstrTrad,"") ;
	if (CBCUSTOMERS->GetSelIndex() != CB_ERR)
		CBCUSTOMERS->GetString(lpstrCust,CBCUSTOMERS->GetSelIndex());
	if (CBTRADERS->GetSelIndex() != CB_ERR)
		CBTRADERS->GetString(lpstrTrad,CBTRADERS->GetSelIndex());


	if (_fstrnicmp(lpstrCust,"All",3)==0)
		bComputeCust = TRUE ;
	else
		bComputeCust = FALSE;

	if (_fstrnicmp(lpstrTrad,"All",3)==0)
		bComputeTrad = TRUE;
	else
		bComputeTrad = FALSE;

	if (AffairsTable!=NULL)
	{
		for (UINT i=1;i<=AffairsTable->NbRecs;i++)
		{
			sAffairsRecord = (Affairs far*)TbGetRecordAddress(AffairsTable,i);
			if (_fstrcmp(lpstrCust,sAffairsRecord->cCustomer)==0 || bComputeCust == TRUE )
			{
				if (_fstrcmp(lpstrTrad,sAffairsRecord->cTrader)==0 || bComputeTrad == TRUE)
				{
					m_Amount += sAffairsRecord->lAmount;
				}
			}
		}
	}
	ltoa(m_Amount,txt,10) ;
	EDAMOUNT->SetText(txt) ;
	return;
}



