Option Explicit

Sub DrawFrame (Frm As Form, FirstCtrl As Control, SecondCtrl As Control, OffSet As Integer)
Dim iLeft  As Integer, iTop As Integer, iRight As Integer, iBottom As Integer
Dim DrkGray As Long, FullWhite As Long, Black As Long
' Set the forms properties
Frm.DrawStyle = 6
Frm.FillStyle = 0
Frm.FillColor = QBColor(7)

' Set the three colors
Black = RGB(0, 0, 0)
DrkGray = RGB(128, 128, 128)
FullWhite = RGB(255, 255, 255)

' Left side of frame
iLeft = FirstCtrl.Left - OffSet
' Top of frame
iTop = FirstCtrl.Top - OffSet
' Right side of frame
iRight = SecondCtrl.Left + SecondCtrl.Width + OffSet
' Bottom of frame
iBottom = SecondCtrl.Top + SecondCtrl.Height + OffSet

' Draw the 4 outer lines of the frame to give the raised 3D effect
Frm.Line (iLeft, iTop)-(iRight, iTop), DrkGray
Frm.Line (iLeft, iTop)-(iLeft, iBottom), DrkGray
Frm.Line (iLeft, iBottom)-(iRight, iBottom), FullWhite
Frm.Line (iRight, iTop + 10)-(iRight, iBottom + 10), FullWhite

' Draw the 4 inner lines of the frame to give the inset 3D effect
Frm.Line (iLeft + 20, iTop + 20)-(iRight, iTop + 20), FullWhite
Frm.Line (iLeft + 20, iTop + 20)-(iLeft + 20, iBottom), FullWhite
Frm.Line (iLeft + 20, iBottom - 20)-(iRight, iBottom - 20), DrkGray
Frm.Line (iRight - 20, iTop + 20)-(iRight - 20, iBottom), DrkGray

End Sub

Sub DrawPanel (Frm As Form, FirstCtrl As Control, SecondCtrl As Control, OffSet As Integer, Bevel As Integer)
Dim iLeft  As Integer, iTop As Integer, iRight As Integer, iBottom As Integer
Dim DrkGray As Long, FullWhite As Long, Black As Long
' Set the forms properties
Frm.DrawStyle = 6
Frm.FillStyle = 0
Frm.FillColor = QBColor(7)

' Set the three colors
Black = RGB(0, 0, 0)
DrkGray = RGB(128, 128, 128)
FullWhite = RGB(255, 255, 255)

' Left side of panel
iLeft = FirstCtrl.Left - OffSet
' Top of panel
iTop = FirstCtrl.Top - OffSet
' Right side of panel
iRight = SecondCtrl.Left + SecondCtrl.Width + OffSet
' Bottom of panel
iBottom = SecondCtrl.Top + SecondCtrl.Height + OffSet

' Draw a black outlined box to be filled by the FillColor (Gray)
Frm.Line (iLeft - 15, iTop - 15)-(iRight + 15, iBottom + 15), Black, B

' Draw the 4 outer lines of the panel to give the raised 3D effect
Frm.Line (iLeft, iTop)-(iRight, iTop), FullWhite
Frm.Line (iLeft, iTop)-(iLeft, iBottom), FullWhite
Frm.Line (iLeft, iBottom)-(iRight, iBottom), DrkGray
Frm.Line (iRight, iTop)-(iRight, iBottom), DrkGray

' Draw the 4 inner lines of the panel to give the inset 3D effect
Frm.Line (iLeft + Bevel, iTop + Bevel)-(iRight - Bevel, iTop + Bevel), DrkGray
Frm.Line (iLeft + Bevel, iTop + Bevel)-(iLeft + Bevel, iBottom - Bevel), DrkGray
Frm.Line (iLeft + Bevel, iBottom - Bevel)-(iRight - Bevel, iBottom - Bevel), FullWhite
Frm.Line (iRight - Bevel, iTop + Bevel)-(iRight - Bevel, iBottom - Bevel), FullWhite

End Sub

Sub OutLines (FormName As Form)
    Dim DrkGray As Long, FullWhite As Long
    Dim I As Integer
    Dim ctop As Integer, cleft As Integer, cright As Integer, cbottom As Integer

    ' Outline a form's controls for 3D look unless control's TAG
    ' property is set to "skip".

    Dim cname As Control
    DrkGray = RGB(128, 128, 128)
    FullWhite = RGB(255, 255, 255)

    For I = 0 To (FormName.Controls.Count - 1)
        Set cname = FormName.Controls(I)
        If TypeOf cname Is Menu Then
            'Debug.Print "menu item"
        ElseIf (UCase(cname.Tag) = "OLD") Then
            ctop = cname.Top - screen.TwipsPerPixelY
            cleft = cname.Left - screen.TwipsPerPixelX
            cright = cname.Left + cname.Width
            cbottom = cname.Top + cname.Height
            FormName.Line (cleft, ctop)-(cright, ctop), DrkGray
            FormName.Line (cleft, ctop)-(cleft, cbottom), DrkGray
            FormName.Line (cleft, cbottom)-(cright, cbottom), FullWhite
            FormName.Line (cright, ctop)-(cright, cbottom), FullWhite
        ElseIf (UCase(cname.Tag) = "OLU") Then
            ctop = cname.Top - screen.TwipsPerPixelY
            cleft = cname.Left - screen.TwipsPerPixelX
            cright = cname.Left + cname.Width
            cbottom = cname.Top + cname.Height
            FormName.Line (cleft, ctop)-(cright, ctop), FullWhite
            FormName.Line (cleft, ctop)-(cleft, cbottom), FullWhite
            FormName.Line (cleft, cbottom)-(cright, cbottom), DrkGray
            FormName.Line (cright, ctop)-(cright, cbottom), DrkGray
        End If
    Next I
End Sub

