//
//  Sample code for creating a Window from within QPW
//
//  This is a QPW 5.0 macro token.  To utilize, compile and copy
//  the DLL to the QPW directory and load QPW.  Load the dll into
//  memory with {DLL.LOAD WINTEST}.  Once the DLL is present, you
//  can enter {WindowDisplay} into a cell and execute it via
//  Tools | Macro | Execute
//
//  Sample created 1994 by R. Wilkman
//

#include <windows.h>
#include "qprowin.h"

//
//  Message Loop for WindowDisplay function
//
LRESULT CALLBACK MainWndProc(HWND hWnd, UINT message,
                             WPARAM wParam, LPARAM lParam)
{
switch(message)
   {
   case WM_PAINT:
   HDC PaintDC;
   PAINTSTRUCT ps;
   PaintDC = BeginPaint(hWnd, &ps);
   TextOut(PaintDC, 5, 5, "Hello QPW!", 10);
   EndPaint(hWnd, &ps);
   return 0;

   case WM_DESTROY:
   PostQuitMessage(0);
   return 0;

   default:
   return DefWindowProc(hWnd, message, wParam, lParam);
   }
}
      
//
// macro function WindowDisplay
//
int WindowDisplay() // quickie function
{
WNDCLASS wndclass;
char ProgName[] = "Test";
char QPW_MINIMIZE[] = "{Alt+Space}n~";
HWND hWnd;
MSG msg;

wndclass.style		= CS_VREDRAW | CS_HREDRAW;
wndclass.lpfnWndProc	= (WNDPROC) MainWndProc;
wndclass.hInstance	= QProGetProgramInstance();
wndclass.hIcon		= LoadIcon(NULL, IDI_APPLICATION);
wndclass.hCursor	= LoadCursor(NULL, IDC_ARROW);
wndclass.hbrBackground	= (HBRUSH) (COLOR_WINDOW +1);
wndclass.lpszMenuName	= NULL;
wndclass.cbClsExtra	= 0;
wndclass.cbWndExtra	= 0;
wndclass.lpszClassName  = ProgName;

RegisterClass(&wndclass);

hWnd = CreateWindow(ProgName,"TestWindow in QPW",WS_OVERLAPPEDWINDOW,
                    CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
                    CW_USEDEFAULT, NULL, NULL, QProGetProgramInstance(),
                    NULL);
ShowWindow(hWnd,SW_SHOWNORMAL);
UpdateWindow(hWnd);
QProExecuteMacro(QPW_MINIMIZE,EXECMACRO_SYNC); // handles some screen weirdies

while (GetMessage(&msg, NULL, 0, 0))
   {
   TranslateMessage(&msg);
   DispatchMessage(&msg);
   }

return msg.wParam;
}


//=========================================================================
//  Quattro Pro for Windows prescribed header (and other overhead)
//=========================================================================
SelfDefStructure MyFuncs[] = {
  {
   "macro int WindowDisplay()", // Function Prototype
   (FarProc)&WindowDisplay,     // Pointer to _exported function
   "WindowDisplay", // Help Line  (optional/samples use default of Help)
   "WindowDisplay"  // English form of name (match the function name above)
  },
  NULL              // Always null terminate the list!
};


//=========================================================================
//  QPWMessage = (version 1.0 of toolkit used DLLFunctionDirectory)
//  This function serves as the main initialization and registration
//  entrypoint for QPW add-ins.  The return value of this function is a
//  pointer to a table which holds all of the function prototyping info
//=========================================================================
//  #pragma argsused is a command to disable var checking in this function
#pragma argsused

BOOL Exported QPWMessage(QPWMsg msg, WORD wParam, DWORD lParam)
{
  LPDLLInfo pDLL = (LPDLLInfo)lParam;

  switch (msg) {
    case QPWMSG_Init:
    case QPWMSG_Term:
      break;
    case QPWMSG_Info:
      pDLL->wVersion = QProInterfaceVersion;
      pDLL->wSDSSize = sizeof(SelfDefStructure);
      pDLL->pSDS = &MyFuncs[0];
      return TRUE;
    }
  return FALSE;
}


//=========================================================================
//      WINDOWS REQUIRED STUFF (LibMain and WEP)
//=========================================================================

//=========================================================================
//  LibMain   ( Windows prescribed DLL entrypoint )
//=========================================================================
//  #pragma argsused is a command to disable var checking in this function
#pragma argsused
int FAR PASCAL LibMain( HANDLE hInstance, WORD wDataSeg,
			WORD cbHeapSize, LPSTR lpszCmdLine)
{
//  perform DLL initialization
  if (cbHeapSize != 0) {
    UnlockData(0);;
  }
  return 1;
}


//=========================================================================
//  WEP  ( Windows specified de-initialization entrypoint for this DLL )
//=========================================================================
//  #pragma argsused is a command to disable var checking in this function
#pragma argsused
int FAR _export PASCAL WEP(int nParameter)
{
  return 1;
}
