#include  <windows.h>
#include  <bivbx.h>
#include  "vbx.rh"
// ======================================================== //
BOOL CALLBACK _export DialogProc( HWND, UINT, WPARAM, LPARAM );
long FAR PASCAL WndProc(HWND, UINT, WPARAM, LPARAM);
// ======================================================== //
HINSTANCE hInst;
int result;
// ======================================================== //
#pragma argsused
int PASCAL WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,
			LPSTR lpCmdLine,  int nCmdShow )
{
  static char szAppName[]  = "DialogVBX";
  HWND     hwnd;
  MSG      msg;
  WNDCLASS wndclass;

  hInst = hInstance;

  if( !hPrevInstance )
  {
    wndclass.style = CS_HREDRAW | CS_VREDRAW;
    wndclass.lpfnWndProc   = WndProc;
    wndclass.cbClsExtra    = 0;
    wndclass.cbWndExtra    = 0;
    wndclass.hInstance     = hInstance;
    wndclass.hIcon         = LoadIcon(NULL,IDI_APPLICATION);
    wndclass.hCursor       = LoadCursor( NULL, IDC_ARROW );
    wndclass.hbrBackground =(HBRUSH)GetStockObject(WHITE_BRUSH);
    wndclass.lpszMenuName  = MAKEINTRESOURCE(MENU_1);
    wndclass.lpszClassName = szAppName;

    RegisterClass( &wndclass );
  }
  //  (1)  Initialize VB emulator DLL
  result = VBXInit( hInst, "Thunder" );

  hwnd = CreateWindow( szAppName, "VBX Dialog Program",
				   WS_OVERLAPPEDWINDOW,
				   CW_USEDEFAULT, CW_USEDEFAULT,
				   CW_USEDEFAULT, CW_USEDEFAULT,
				   NULL, NULL, hInst, NULL );
  ShowWindow( hwnd, nCmdShow );
  UpdateWindow( hwnd );

  while( GetMessage( &msg, NULL, 0, 0 ) )
  {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }

  //  7) clean up and unload the DLL
  VBXTerm();
  return msg.wParam;
}

// ===================================================== //
BOOL CALLBACK _export DialogProc( HWND hwnd, UINT msg,
					  WPARAM wParam, LPARAM lParam)
{
  BOOL result = TRUE;
  switch ( msg )
  {
    case WM_INITDIALOG:
    {
	 //  (2) Initialize control with DLGINIT data
	 VBXInitDialog( hwnd, hInst, "DIALOG_1" );
	 return TRUE;
    }
    case WM_COMMAND:
    {
	 switch( wParam )
	   case IDOK:
	   case IDCANCEL:
		EndDialog( hwnd, wParam );
		result = 0;
		break;
    }
    //  (3) Respond to VBX Event
    case WM_VBXFIREEVENT:
    {
	 VBXEVENT far *pVBXEvent;
	 long ActiveRow;
	 pVBXEvent=(VBXEVENT far *)lParam;
	 // (4) determine which VBX Event occurred
	 switch( pVBXEvent->EventIndex )
	 {
	   case Event_SpreadSheet_RightClick:
	   {
		char temp[30];
		long Col,Row;
		HWND hwndCtl;
		HCTL hCtl;
		// (5) Decode the event arguments
		Col=VBX_EVENTARGNUM( pVBXEvent, long, 1 );
		Row=VBX_EVENTARGNUM( pVBXEvent, long, 2 );
		wsprintf( temp,"Right click in row: %ld col: %ld",
				Row, Col );
		MessageBox( hwnd, temp, "VBX Event", MB_OK );
		// (6)  Read a property of the control
		// (6a) Get the window handle of the control
		hwndCtl = GetDlgItem( hwnd, IDC_SPREAD1 );
		// (6b) Get the HCTL of the control
		hCtl = VBXGetHctl( hwndCtl );
		// (6c) Get the data from the property of the control
		VBXGetPropByName( hCtl, "ActiveRow",
					   (LPVOID)&ActiveRow );
		wsprintf( temp, "ActiveRow Property = %ld",
				ActiveRow );
		MessageBox( hwnd, temp, "ActiveRow Property",
				  MB_OK );
		break;
	   }
	 }
    }
    default:
	 result = FALSE;
  }
  return result;
}

long FAR PASCAL WndProc( HWND hwnd, UINT msg,
					WPARAM wParam, LPARAM lParam )
{
  int result;
  switch( msg )
  {
    case WM_COMMAND:
    {
	 switch( wParam )
	 {
	   case CM_FILETEST:
	   {
		FARPROC fproc;
		fproc=(FARPROC)MakeProcInstance( FARPROC(DialogProc),
								   hInst );
		DialogBox(hInst,"DIALOG_1",NULL,(DLGPROC)fproc);
		FreeProcInstance( fproc );
		break;
	   }
	   case CM_FILEEXIT:
		PostMessage( hwnd, WM_CLOSE, 0, 0L );
		break;
	 }
	 break;
    }
    case WM_DESTROY:
	 PostQuitMessage(0);
	 return 0;
    default: break;
  }
  return DefWindowProc( hwnd, msg, wParam, lParam );
}

//======================================================
// vbx.rh
//
#define Event_SpreadSheet_RightClick 18

#define IDC_SPREAD1	   101
#define MENU_1          100

// #define DIALOG_1	1

#define CM_FILEEXIT     102
#define CM_FILETEST	   103
