{ include file for WLLTEST and EXETEST }

(****************************************************************************
                            sample functions
 ****************************************************************************)
FUNCTION WInsert(txt : PChar) : Boolean;
{ example of a non-dialog command }
VAR
  wcmd : TWordCommand;
BEGIN
  wcmd.Init(wdInsert, T_NONE, NIL, 0);
  wcmd.AddStringParam(txt);
  WInsert := wcmd.ExecuteCommand;
  wcmd.Done;
END;


FUNCTION WEditGoTo(dest : PChar) : Boolean;
{ example of a dialog command }
VAR
  wcmd : TWordDlgCommand;
BEGIN
  wcmd.Init(wdEditGoTo, T_NONE, NIL, 0, CMD_ACTION, [DLG_SET_DATA]);

  { be sure to use Add***DlgField() for dialog commands! }
  wcmd.AddStringDlgField(fidDestination, dest, StrLen(dest)+1);
  WEditGoTo := wcmd.ExecuteCommand;
  wcmd.Done;
END;


FUNCTION WGetAuthor(dest : PChar; maxSize : Word) : Boolean;
{ example of a dialog query }
VAR
  wcmd : TWordDlgCommand;
BEGIN
  wcmd.Init(wdFileSummaryInfo, T_NONE, NIL, 0, CMD_DEFAULTS, [DLG_GET_DATA]);
  { it's NOT a function! result is returned in fidAuthor.dest }
  wcmd.AddStringDlgField(fidAuthor, dest, maxSize);
  WGetAuthor := wcmd.ExecuteCommand;
  wcmd.Done;
END;


FUNCTION WSelection(st : PChar; maxSize : Word) : Boolean;
{ example of a function returning a string }
VAR
  wcmd : TWordCommand;
BEGIN
  wcmd.Init(wdSelectionStr, T_STRING, st, maxSize);
  WSelection := wcmd.ExecuteCommand;
  wcmd.Done;
END;


FUNCTION WInt(n : Double; VAR rslt : Integer) : Boolean;
{ example of a function returning an Integer }
VAR
  wcmd : TWordCommand;
  p : PChar;
BEGIN
  wcmd.Init(wdInt, T_SHORT, @rslt, SizeOf(rslt));
  wcmd.AddDoubleParam(n);
  WInt := wcmd.ExecuteCommand;
  wcmd.Done;
END;


PROCEDURE Test1;
VAR
  strBuf : Array[0..100] OF Char;
  int : Integer;
BEGIN
  { get Selection$() }
  IF NOT WSelection(strBuf, SizeOf(strBuf)) THEN
    Exit;
  MessageBox(0, strBuf, 'Selection', MB_OK);

  IF NOT WGetAuthor(strBuf, SizeOf(strBuf)) THEN
    Exit;
  MessageBox(0, strBuf, 'Author', MB_OK);

  { Insert "Test" }
  IF NOT WInsert(strBuf) THEN
    Exit;

  { EditGoto .dest="\StartOfDoc" }
  IF NOT WEditGoTo('\StartOfDoc') THEN
    Exit;

  IF (WInt(123.4567, int)) THEN BEGIN
    Str(int, strBuf);
    MessageBox(0, strBuf, 'Int() result', MB_OK);
  END ELSE
    Exit;
END;

{EOF}

