unit Fmvrmeta;

interface

uses
	SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
	Forms, Dialogs, Menus, ExtCtrls,VRMeta;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Draw1: TMenuItem;
    Image1: TImage;
    File1: TMenuItem;
    Load1: TMenuItem;
    Circle1: TMenuItem;
    Rectangle1: TMenuItem;
    Create1: TMenuItem;
    Save1: TMenuItem;
    Show1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Create1Click(Sender: TObject);
    procedure Load1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
		procedure Circle1Click(Sender: TObject);
    procedure Rectangle1Click(Sender: TObject);
    procedure Show1Click(Sender: TObject);
  private
    { Private declarations }
    VrMetafile: TVRMetafile;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin { TForm1.FormCreate }
	 VrMetafile := TVrMetafile.Create;
end;  { TForm1.FormCreate }

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin { TForm1.FormClose }
	 VrMetafile.Free;
end;  { TForm1.FormClose }

procedure TForm1.Create1Click(Sender: TObject);
begin { TForm1.Create1Click }
	 VrMetafile.Free;
	 VrMetafile := TVRMetafile.Create;
	 with VRMetafile do
	 begin
			Height:=96;
			Width:=96;
			with Canvas	do
			begin
				Font := Form1.Font;
				TextOut( 10, 10, 'Hello World');
				Ellipse( 0, 0, 1000, 1000);
			end;
			{No need to close as we are going to save which will close for us}
			SaveToFile( 'MyWMF.WMF');

	 end;
end;  { TForm1.Create1Click }

procedure TForm1.Load1Click(Sender: TObject);
begin { TForm1.Load1Click }
	 VrMetafile.LoadFromFile('MyWmf.wmf');
end;  { TForm1.Load1Click }

procedure TForm1.Save1Click(Sender: TObject);
begin { TForm1.Save1Click }
	 VrMetafile.SaveToFile( 'MyWMF.WMF');
end;  { TForm1.Save1Click }

procedure TForm1.Show1Click(Sender: TObject);
begin { TForm1.Show1Click }
	 Image1.Picture.Metafile := VrMetafile;
end;  { TForm1.Show1Click }

procedure TForm1.Circle1Click(Sender: TObject);
begin { TForm1.Circle1Click }
	 VrMetafile.Canvas.Ellipse(10,10,800,800);
	 {no need to close as savetofile will do it for us}
	 VrMetafile.SaveToFile( 'MyWMF.WMF');
end;  { TForm1.Circle1Click }

procedure TForm1.Rectangle1Click(Sender: TObject);
begin { TForm1.Rectangle1Click }
	 VrMetafile.Canvas.Rectangle(50,50,500,500);
	 {since were only going to assign we must close first
	 ie this doesnt actually acces a VRMeta method first!!!}
	 VrMetafile.close;
	 Image1.Picture.Metafile := VrMetafile;
end;  { TForm1.Rectangle1Click }

end. { Unit FmVrMeta }
