unit Genmain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, Mask, ValMisc;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    UserNameEdit: TEdit;
    RegNoEdit: TEdit;
    CopyButton: TBitBtn;
    CloseButton: TBitBtn;
    RandSeedEdit: TMaskEdit;
    procedure RandSeedEditExit(Sender: TObject);
    procedure CopyButtonClick(Sender: TObject);
    procedure UserNameEditExit(Sender: TObject);
  private
    { Private declarations }
    procedure Calculate;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Calculate;
var
  Seed : LongInt;
  UserName,RegNo : string;
begin
  UserName:=Trim(UserNameEdit.Text);
  if UserName='' then
  begin
    ErrorMessage('User name field must be completed');
    exit;
  end;
  try
    Seed:=StrToInt(Trim(RandSeedEdit.Text));
  except
    on EConvertError do
    begin
      raise;
      RandSeedEdit.Text:='0';
      exit;
    end;
  end;
  RegNo:=RegCode(Seed,UserName);
  RegNoEdit.Text:=RegNo;
end;

procedure TForm1.RandSeedEditExit(Sender: TObject);
var
  s : string;
  i : LongInt;
begin
  s:=RandSeedEdit.Text;
  while (Length(s)>1) and (s[1] in ['0',' ']) do
    Delete(s,1,1);
  s:=Trim(s);
  try
    i:=StrToInt(s);
  except
    i:=0;
  end;
  RandSeedEdit.Text:=IntToStr(i);
  if Trim(UserNameEdit.Text)<>'' then Calculate;
end;

procedure TForm1.CopyButtonClick(Sender: TObject);
begin
  with RegNoEdit do
  begin
    SelectAll;
    CopyToClipboard;
    ClearSelection;
  end;
end;

procedure TForm1.UserNameEditExit(Sender: TObject);
var
  TempName : string;
  TempNameLen : byte absolute TempName;
  ValidChars,i : byte;
begin
  TempName:=UpperCase(UserNameEdit.Text);
  ValidChars:=0;
  i:=1;
  while i<=TempNameLen do
  begin
    if UpCase(TempName[i]) in ['A'..'Z','0'..'9'] then
       Inc(ValidChars);
    Inc(i);
  end;
  if ValidChars<3 then
  begin
    ErrorMessage('User Name must contain more than 2 alphanumeric characters');
    UserNameEdit.Text:='';
    Exit;
  end;
  if Trim(UserNameEdit.Text)<>'' then Calculate;
end;

end.
