{------------------------------------------------------------------------------}
{UNREGISTERED VERSION (6/1/95) PLEASE REDISTRIBUTE IN tPACK.ZIP!
 This revision does not contain everything, nor are the exciting
 DataSetReporter and ExtendedMenu[Item] components included.
 Use SWREG#5906 to receive these, icons and a help file for $130.
 You must register when using this code in a business application!
 You'll receive a license to use this code in up to 50 copies of
 any app you write. In turn you will get responsive e-mail
 tech support and enhancements till I run out of registrations
 or suggestions. Meanwhile.. enjoy the code. Bye! I'll make more.
 {(C)'1995 Michael/Ax-Systems, 71560,1754@Compuserve.com}
{------------------------------------------------------------------------------}

unit UserNetW;

{REQUIRES 'NOVELL' TO BE DEFINED FOR NOVEL FEATURES TO WORK. WILL BE FIXED.}

{-----------------------------------------------------------------------------------------}
{ USERNOV                                                                                 }
{-----------------------------------------------------------------------------------------}

interface

uses
  Classes,
  PasUtils
  ,UserInfo;

Const
  NetWorkPasswordOk = 0;
  NetWorkPasswordLockOut = 197;

Type
  TNetWareUserInfo = class(TUserInfo)
  {wraps some netware calls for easy access (gets the servername!) and can validate a
  password against the users password}
  private
    fConnectID,
    fConnectNumber : LongInt;                                { Default connection id }
    pServerName  :PString;
    pLoginName   :PString;
    pFullName    :PString;
    pLoginTime   :PString;
  protected
    function GetServerName:String;
    function GetLoginName:String;
    function GetFullName:String;
    function GetLoginTime:String;
    procedure SetNoString(const Value:String);
  public
    Constructor Create(aOwner:TComponent); Override;
    Destructor Destroy; Override;
    function UpdateOK:boolean; Override;
    Function HasPassWord:Boolean;
    Function CheckPassWord(const Value:String):Integer;
  published
    property ConnectID:Longint read fConnectID;
    property ConnectNumber:Longint read fConnectNumber;

    property ServerName:String read GetServerName write SetNoString;
    property LoginName:String read GetLoginName write SetNoString;
    property FullName:String read GetFullName write SetNoString;
    property LoginTime: String read GetLoginTime write SetNoString;
    end;

{$IFDEF NOVELL}
Function GetConnectionNumber : Integer;                    { Get novell connection number }
Function GetConnectionInformation(ConId : LongInt;         { Get Novell connection info }
           UserName : PChar; Var ObjType : Integer; Var ObjID : LongInt; LoginTime : PChar) : Integer;
Function GetDefaultConnectionID : Integer;                 { Get Novell Default Connection ID }
Function GetFileServerName(DefConID : LongInt;             { Get Novell File server Name }
           FsName : PChar) : Integer;
Function ReadPropertyValue(szUserName : PChar;             { Read a Novell property Value }
           ObjType : Integer;szPropName : PChar;SegNum :  Integer;szLongName : PChar;
           Var iMoreSegs : Char;Var iMoreFlags : Char) : Integer;
Function VerifyBinderyObjectPassword(UserName : PChar;     { Verify a password against a bindery object }
           BinType  : Integer; PassWord : PChar) : Integer;
{$ENDIF}


implementation

uses
  Controls
  ,SysUtils
  ,Forms;

{-----------------------------------------------------------------------------------------}
{ NETWARE USER INFO                                                                       }
{-----------------------------------------------------------------------------------------}

{$IFDEF NOVELL}
Function GetConnectionNumber;         external 'NWNETAPI';
Function GetConnectionInformation;    external 'NWNETAPI';
Function GetDefaultConnectionID;      external 'NWNETAPI';
Function GetFileServerName;           external 'NWNETAPI';
Function ReadPropertyValue;           external 'NWNETAPI';    { Declare novell calls }
Function VerifyBinderyObjectPassword; external 'NWNETAPI';
{$ENDIF}

{-----------------------------------------------------------------------------------------}
{ OBJECT CREATION                                                                         }
{-----------------------------------------------------------------------------------------}

Constructor TNetWareUserInfo.Create(aOwner:TComponent);
begin
  inherited Create(aOwner);
{  Options:=[uifUpdateOnLoad,uifUpdateOnGet];}
  pServerName:=NullStr;
  pLoginName:=NullStr;
  pFullName:=NullStr;
  pLoginTime:=NullStr;
end;

Destructor TNetWareUserInfo.Destroy;
begin
  DisposeStr(pLoginTime);
  DisposeStr(pFullName);
  DisposeStr(pLoginName);
  DisposeStr(pServerName);
  inherited Destroy;
end;


function TNetWareUserInfo.UpdateOK:boolean;
var
  fzServerName  : array [0..50] of Char;                   { File server Name }
  fzLoginName   : array [0..50] of Char;                   { User Name }
  fzFullName    : array [0..127] of Char;                  { Fill Name }
  fzLoginTime   : array [0..9] of Char;                    { Login Time }
  iRc : Integer;                                           { Return Type }
  iOtype   : Integer;                                      { Object Type }
  iOID : LongInt;                                          { Object Id }
  iMoreSegs, iMoreFlags : Char;                            { Local Flags }
begin
  Result:=inherited UpdateOK;
  if not Result then
    Exit;
{$IFDEF NOVELL}
  fzServerName[0] := #0;                                   { Null FS name }
  fzLoginName[0] := #0;                                    { Null User Name }
  fzFullName[0] := #0;                                     { Fill Name }
  fzLoginTime[0] := #0;                                    { Login Time }
  fConnectID := GetDefaultConnectionID;                    { Get default connection ID }
  fConnectNumber:= GetConnectionNumber;                    { Get connection Number }
  iRc := GetConnectionInformation(                         { Get connection info }
           fConnectNumber,@fzLoginName[0],iOtype,iOID,fzLoginTime);
  if fzLoginName[0] = #0 then Exit;                        { If No User Name, No Net thus exit }
  iRc := GetFileServerName(fConnectID,fzServerName);       { Get FS name }
  iRc := ReadPropertyValue(                                { Get the user's full Name }
           fzLoginName,iOtype,'IDENTIFICATION',1,fzFullName,iMoreSegs,iMoreFlags);
  MovePChar2PString(pServerName,fzServerName,false);
  MovePChar2PString(pLoginName,fzLoginName,false);
  MovePChar2PString(pFullName,fzFullName,false);
  MovePChar2PString(pLoginTime,fzLoginTime,false);
{$ENDIF}
end;

{-----------------------------------------------------------------------------------------}
{ OBJECT FUNCTIONS                                                                        }
{-----------------------------------------------------------------------------------------}

Function TNetWareUserInfo.HasPassWord:Boolean;
{since calling the VerifyBinderyObjectPassword function multiple times with the wrong pw
can trigger the network's intruder alert and leave the user locked out when the log back in
we're using two constants to get the value only once. Perhaps there is a system message that
kicks in when a user changes names while logged in, but this will kick in just once per run.}
const
  init:Boolean=True; {could make a property}
  HasPW:Boolean=False;
begin
  if Init then begin
    Init:=False;
    HasPW:=CheckPassWord('')<>NetWorkPasswordOk;
    end;
  Result:=HasPW; {true if the user has a network password}
end;

Function TNetWareUserInfo.CheckPassWord(const Value:String):Integer;
var
  Cursor:TCursor;
  zPWD: PChar;
  zLoginName: PChar;
begin
{$IFDEF NOVELL}
  Cursor:= Screen.Cursor;
  Screen.Cursor := crHourGlass;                            { Start waiting }
  zPWD:=MakePChar(Value);
  zLoginName:=MakePChar(pLoginName^);
  Result := VerifyBinderyObjectPassword(zLoginName,1,zPWD); { Verify against USER login name }
  FreePChar(zLoginName);
  FreePChar(zPWD);
  Screen.Cursor := Cursor;
{$ELSE}
  Result:= NetWorkPasswordOk;
{$ENDIF}
end;

{-----------------------------------------------------------------------------------------}
{ PROPERTY PLUMBING                                                                       }
{-----------------------------------------------------------------------------------------}

procedure TNetWareUserInfo.SetNoString(const Value:String);
begin
end;

function TNetWareUserInfo.GetServerName:String;
begin
  Result:=pServerName^;
end;

function TNetWareUserInfo.GetLoginName:String;
begin
  Result:=pLoginName^;
end;

function TNetWareUserInfo.GetFullName:String;
begin
  Result:=pFullName^;
end;

function TNetWareUserInfo.GetLoginTime:String;
begin
  Result:=pLoginTime^;
end;

{-----------------------------------------------------------------------------------------}
{                                                                                         }
{-----------------------------------------------------------------------------------------}

end.
