{------------------------------------------------------------------------------}
{UNREGISTERED VERSION (6/1/95) PLEASE REDISTRIBUTE IN tPACK.ZIP!
 This revision does not contain everything, nor are the exciting
 DataSetReporter and ExtendedMenu[Item] components included.
 Use SWREG#5906 to receive these, icons and a help file for $130.
 You must register when using this code in a business application!
 You'll receive a license to use this code in up to 50 copies of
 any app you write. In turn you will get responsive e-mail
 tech support and enhancements till I run out of registrations
 or suggestions. Meanwhile.. enjoy the code. Bye! I'll make more.
 {(C)'1995 Michael/Ax-Systems, 71560,1754@Compuserve.com}
{------------------------------------------------------------------------------}

unit Toolbar;
{defines a bunch of customized panels.}

interface

uses Forms, SysUtils, WinProcs, WinTypes,
  Classes, Controls, Buttons, StdCtrls, ExtCtrls;

type
  TExtendedPanel = class(TPanel)
  private
    procedure SetUniqueName(const Value:String);
  public
    constructor Create(aOwner:TComponent); Override;
    property UniqueName:String write SetUniqueName stored false;
  published
    end;

  TToolBar = class(TExtendedPanel)
  public
    constructor Create(aOwner:TComponent); Override;
    end;

  TStatusBar = class(TExtendedPanel)
  public
    constructor Create(aOwner:TComponent); Override;
    end;

  TStatusPanel = class(TExtendedPanel)
  private
    procedure ShowHint(Sender: TObject);
  public
    constructor Create(aOwner:TComponent); Override;
    procedure Loaded; Override;
    end;

  TMpModes=(mpIdle,mpTime,mdDate,mpResources);
  TMessagePanel = class(TExtendedPanel)
  protected
    fmpMode: TmpModes;
    fTimer: TTimer;
    fPriorIdle: TIdleEvent;
  private
    procedure IdleEvent(Sender: TObject; var Done: Boolean);
    procedure UpdatePanel(Sender: TObject);
    procedure SetMpMode(Value:TmpModes);
  public
    constructor Create(aOwner:TComponent); Override;
    destructor Destroy; Override;
    procedure Click; Override;
  published
    property mpMode: TmpModes read fmpMode write SetMpMode;
    end;

{------------------------------------------------------------------------------}

implementation

{------------------------------------------------------------------------------}

constructor TExtendedPanel.Create(aOwner:TComponent);
begin
  inherited Create(aOwner);
end;

procedure TExtendedPanel.SetUniqueName(const Value:String);
var
  i:integer;
  a:string[4];
begin
  a:='1';
  i:=1;
  while true do
    if owner.findcomponent(Value+a)=nil then begin
      name:= Value+a;
      break;
      end
    else begin
      inc(i);
      a:=inttostr(i);
      end;
end;

{------------------------------------------------------------------------------}

constructor TToolBar.Create(aOwner:TComponent);
begin
  inherited Create(aOwner);
  if aOwner.Name<>'' then begin
    Align:=alTop;
    Height:=23;
    UniqueName:='ToolBar';
    Caption:='';
    end;
end;

{------------------------------------------------------------------------------}

constructor TStatusBar.Create(aOwner:TComponent);
begin
  inherited Create(aOwner);
  if aOwner.Name<>'' then begin
    Top:=TForm(aOwner).Height-1;
    Align:=alBottom;
    Height:=18;
    UniqueName:='StatusBar';
    Caption:='';
    with TMessagePanel.Create(aOwner) do
      Parent:=Self;
    with TStatusPanel.Create(aOwner) do
      Parent:=Self;
    end;
end;

{------------------------------------------------------------------------------}

constructor TStatusPanel.Create(aOwner:TComponent);
begin
  inherited Create(aOwner);
  if aOwner.Name<>'' then begin
    Align:=alClient;
    UniqueName:='StatusPanel';
    Caption:='';
    Alignment := taLeftJustify;
    BevelOuter := bvLowered;
    end;
  Loaded;
end;

procedure TStatusPanel.Loaded;
begin
  inherited Loaded;
  Application.OnHint:=ShowHint;      {WATCH IT!!! THIS is a pretty big assumption}
  Application.ShowHint:=True;
  Application.HintPause:=300;
end;

procedure TStatusPanel.ShowHint(Sender: TObject);
begin
  Caption := Application.Hint;
end;

{------------------------------------------------------------------------------}

constructor TMessagePanel.Create(aOwner:TComponent);
begin
  inherited Create(aOwner);

  if aOwner.Name<>'' then begin
    Align:=alRight;
    Width:=85;
    UniqueName:='MessagePanel';
    Caption:='';
    {}
    BevelOuter := bvLowered;
    Alignment := taCenter{LeftJustify};
    {}
    fPriorIdle:= Application.OnIdle;
    Application.OnIdle:=IdleEvent;
    end;

  fmpMode:=mpTime;
  fTimer:=TTimer.Create(self);
  fTimer.Interval:=1000;
  fTimer.Enabled:=True;
  fTimer.OnTimer:=UpdatePanel;
end;


destructor TMessagePanel.Destroy;
begin
  fTimer.enabled:=false;
  fTimer.free;
  Application.OnIdle:=fPriorIdle;
  inherited Destroy;
end;

procedure TMessagePanel.SetMpMode(Value:TMpModes);
begin
  if Value<>fmpMode then begin
    fmpMode:=Value;
    fTimer.Enabled:=Value<>mpIdle;
    end;
end;

procedure TMessagePanel.Click;
begin
  if fmpmode<high(tmpmodes) then
    mpMode:=succ(fMpMode)
  else
    mpmode:=low(tmpmodes);
  inherited Click;
end;

procedure TMessagePanel.IdleEvent(Sender: TObject; var Done: Boolean);
begin
  if assigned(fPriorIdle) then
    fPriorIdle(Sender,Done);
  UpdatePanel(Sender);
end;

procedure TMessagePanel.UpdatePanel(Sender: TObject);
begin
  case fmpMode of
    mpIdle,
    mpTime: Caption := TimeToStr(Time);
    mdDate: Caption := DateToStr(Now);
  else
    Caption:= format('%d MB, %d%%',
     [GetFreeSpace(0) shr 20, GetFreeSystemResources(0)]);
    end;
end;

{------------------------------------------------------------------------------}

end.

