{------------------------------------------------------------------------------}
{UNREGISTERED VERSION (6/1/95) PLEASE REDISTRIBUTE IN tPACK.ZIP!
 This revision does not contain everything, nor are the exciting
 DataSetReporter and ExtendedMenu[Item] components included.
 Use SWREG#5906 to receive these, icons and a help file for $130.
 You must register when using this code in a business application!
 You'll receive a license to use this code in up to 50 copies of
 any app you write. In turn you will get responsive e-mail
 tech support and enhancements till I run out of registrations
 or suggestions. Meanwhile.. enjoy the code. Bye! I'll make more.
 {(C)'1995 Michael/Ax-Systems, 71560,1754@Compuserve.com}
{------------------------------------------------------------------------------}

unit ErrorMsg;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, SysUtils, db, Dialogs
, PasUtils
, UserInfo;

type
  TErrorDialogForm = class(TForm)
    Memo1: TMemo;
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    HelpBtn: TBitBtn;
  private
    { Private declarations }
    procedure DecodeError(Error:Exception);
  public
    { Public declarations }
  end;

{------------------------------------------------------------------------------}
{                                                                              }
{------------------------------------------------------------------------------}

  TErrorDialog = class(TDialogShell)
    Error:Exception;
    eSender: TObject;
  private
    fResult: TExceptionReAction;
    fCanRetry: Boolean; {can an exception be retried?}
    fCanIgnore: Boolean; {can an exception be ignored?}
  protected
    function GetTest:Boolean; override;
    procedure SetTest(Value:Boolean); override;
  public
    constructor Create(aOwner:Tcomponent); override;
    procedure ExceptionProc(Sender: TObject;E:Exception);
    procedure RetryException(Sender:TObject;E:Exception;var Action:TExceptionReAction);
    procedure Execute; Override;
  published
    property CanRetry: Boolean read fCanRetry write fCanRetry;
    property CanIgnore: Boolean read fCanIgnore write fCanIgnore;
    property Result: TExceptionReAction read fResult write fResult;
    end;

{------------------------------------------------------------------------------}
{                                                                              }
{------------------------------------------------------------------------------}

implementation

{$R *.DFM}

{------------------------------------------------------------------------------}
{                                                                              }
{------------------------------------------------------------------------------}

constructor TErrorDialog.Create(aOwner:TComponent);
begin
  inherited Create(aOwner);
  Error:=nil;
  eSender:=nil;

{  Application.OnException:=ExceptionProc; } {ok but can be tricky!}

end;


procedure TErrorDialog.ExceptionProc(Sender: TObject;E:Exception);
begin
  messagebeep($FFFF);
  Error:=E;
  eSender:=Self;
  Screen.Cursor:=crDefault;
  Execute;
{  Application.ShowException(E); }
end;


procedure TErrorDialog.SetTest(Value:Boolean);
begin
  Error:=Exception.Create('Test of '+Classname);
  eSender:=Self;
  Execute;
  Error.Free;
  Error:=nil;
end;

function TErrorDialog.GetTest:Boolean;
begin
  Result:=(fResult=reRetry);
end;


{------------------------------------------------------------------------------}

procedure TErrorDialog.RetryException(Sender:TObject;E:Exception;var Action:TExceptionReAction);
begin
  eSender:=Sender;
  Error:=E;
  fResult:=Action;
  Execute;
  Action:=fResult;
end;


procedure TErrorDialog.Execute;
var
  a:string;
  b:TMsgDlgButtons;
  Cursor:TCursor;
begin
  Cursor:=Screen.Cursor;
  Screen.Cursor:=crDefault;

  if fCanIgnore and fCanRetry then
    b:=mbAbortRetryIgnore
  else
    if fCanIgnore then
      b:=[mbIgnore,mbCancel]
    else
      if fCanRetry then
        b:=[mbRetry,mbCancel]
      else
        b:=[mbCancel];
  case MessageDlg(Error.ClassName+'! in '+eSender.ClassName+#13+Error.Message, mtError,b,0) of
    mrOk,
    mrRetry: fResult:=reRetry;
    mrIgnore: fResult:=reIgnore;
    else
      fResult:=reRaise;
    end;

{  With TErrorDialogForm.Create(Application) do begin
    if eSender<>nil then
      Caption:=eSender.ClassName+' Dialog';
    DecodeError(Error);
    if ShowModal = IdOk then
      fResult:= reRetry
    else
      fResult:= reRaise;
    Free;
    end;  }

  Screen.Cursor:=Cursor;
end;

{------------------------------------------------------------------------------}
{                                                                              }
{------------------------------------------------------------------------------}

procedure TErrorDialogForm.DecodeError(Error:Exception);
var
  i,n:integer;
  plural:boolean;
  a:string[3];
begin
  if Error = nil then begin
    Memo1.Text:='';
    exit;
    end;
  plural:=false;
  if Error is EdbEngineError then
    with Error as EdbEngineError do begin
      n:=ErrorCount;
      plural:= n>1;
      Memo1.Text:='Received '+inttostr(n)+' Error';
      if plural then
        Memo1.Text:=Memo1.Text+'s';
      Memo1.Text:=Memo1.Text+' from the Database Engine that';
      end
  else
    if Error is EdbEngineError then
      Memo1.Text:='The Database Access layer reports an error that'
    else
      Memo1.Text:='An Error';

  if plural then
    a:='are'
  else
    a:='is';
  Memo1.Text:=Memo1.Text+' '+a+' detailed below. Please decide how to proceed.';
  Memo1.Lines.Add(' ');

  if Error is EdbEngineError then
    with Error as EdbEngineError do begin
      for i:=0 to n-1 do
        Memo1.Lines.Add(
          inttostr(i+1)+'/'+inttostr(n)+': '
          +'#'+inttostr(Errors[i].ErrorCode)+': '
          +Errors[i].Message);
      end
  else
    Memo1.Text:=Memo1.Text+' '+Error.ClassName+': '+Error.Message+'.';
end;

{------------------------------------------------------------------------------}

end.
