{------------------------------------------------------------------------------}
{UNREGISTERED VERSION (6/1/95) PLEASE REDISTRIBUTE IN tPACK.ZIP!
 This revision does not contain everything, nor are the exciting
 DataSetReporter and ExtendedMenu[Item] components included.
 Use SWREG#5906 to receive these, icons and a help file for $130.
 You must register when using this code in a business application!
 You'll receive a license to use this code in up to 50 copies of
 any app you write. In turn you will get responsive e-mail
 tech support and enhancements till I run out of registrations
 or suggestions. Meanwhile.. enjoy the code. Bye! I'll make more.
 {(C)'1995 Michael/Ax-Systems, 71560,1754@Compuserve.com}
{------------------------------------------------------------------------------}

unit Debugctl;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, Toolbar, ExtCtrls
, Debug
, UserInfo;

type
  TDebugControl= class(TDialogShell)
  private
    {uses vars global to this unit}
  protected
    function GetState:TDebugExtendedComponentState;
    procedure SetState(Value:TDebugExtendedComponentState);
    function GetFlags:TDebugExtendedComponentFlags;
    procedure SetFlags(Value:TDebugExtendedComponentFlags);
    function GetTest:Boolean; override;
    procedure SetTest(Value:Boolean); override;
    function GetEnabled:Boolean;
    procedure SetEnabled(Value:Boolean);
  public
    constructor Create(aOwner:TComponent); Override;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    destructor Destroy; Override;
    procedure Loaded; Override;
  published
    property Options: TDebugExtendedComponentFlags read GetFlags write SetFlags;
    property Enabled: Boolean read GetEnabled write SetEnabled stored false;
    property State: TDebugExtendedComponentState read GetState write SetState stored false;
    end;

implementation

{-----------------------------------------------------------------------------------------}
{ TDebugControl                                                                            }
{-----------------------------------------------------------------------------------------}

constructor TDebugControl.Create(aOwner:TComponent);
begin
  inherited Create(aOwner);
  DebugState:=DebugState-[decDestroying];
  Options:= DebugFlags;
  if (decCreate in DebugFlags) then
    DebugLog(nil,'Create '+ClassName);
end;

destructor TDebugControl.Destroy;
begin
  if (decDestroy in DebugFlags) then
    DebugLog(nil,'Destroy '+ClassName);
  DebugState:=DebugState+[decDestroying]-[decActive];
  Options:=[];
  {DebugDlg.Free;
  DebugDlg:=nil;}
  inherited Destroy;
end;

procedure TDebugControl.Loaded;
begin
  if (decLoaded in DebugFlags) then
    DebugLog(nil,'Loaded '+ClassName);
  inherited Loaded;
  ComponentIndex:=0;        {makes itself first component.}
end;

procedure TDebugControl.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if aComponent<>nil then begin
    if (aComponent is TDebugControl) and (Operation = opRemove) then
      DebugState:=DebugState-[decDestroying]+[decActive];
    if (([decInsert, decRemove]*DebugFlags)<>[]) then
      if (Operation = opRemove) and (decRemove in DebugFlags) then
        DebugLog(nil,'Remove '+AComponent.Name+'('+AComponent.ClassName+')')
      else
        if (Operation = opInsert) and (decInsert in DebugFlags) then
          DebugLog(nil,'Insert '+AComponent.Name+'('+AComponent.ClassName+')');
    end;
end;

{}

function TDebugControl.GetState:TDebugExtendedComponentState;
begin
  Result:=DebugState;
end;

procedure TDebugControl.SetState(Value:TDebugExtendedComponentState);
begin {DebugState:=Value;} {read only}
end;

{}

function TDebugControl.GetEnabled:Boolean;
begin
  Result:=decEnabled in DebugFlags;
end;

procedure TDebugControl.SetEnabled(Value:Boolean);
begin
  if Value and (not GetEnabled) then
    AdjustDebugFlags(DebugFlags+[decEnabled])
  else
    if (not Value) and GetEnabled then
      AdjustDebugFlags(DebugFlags-[decEnabled]);
end;

{}

function TDebugControl.GetFlags:TDebugExtendedComponentFlags;
begin
  Result:=DebugFlags;
end;

procedure TDebugControl.SetFlags(Value:TDebugExtendedComponentFlags);
begin
  if (csLoading in ComponentState) then
    DebugFlags:=Value
  else
    Debug.AdjustDebugFlags(Value); {adjusts state and changes flags}
end;

{}

{-----------------------------------------------------------------------------------------}
{ DESIGN TIME TEST PROCS                                                                  }
{-----------------------------------------------------------------------------------------}

procedure TDebugControl.SetTest(Value:Boolean);
begin
  DebugLog(nil,'Test '+ClassName);
end;

function TDebugControl.GetTest:Boolean;
begin
  Result:= decActive in DebugState;
end;

end.


