unit Ufromto; { DAVID BERNEDA 100115.1155@compuserve.com }

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs,StdCtrls,ExtCtrls,Buttons,Menus;

{ LOCALIZATION CONSTANTS, CHANGE FREELY }
Const IdiomFrom        ='From:';
      IdiomTo          ='To:';
      IdiomButtonChange='&Change';
      IdiomHintFromTo  ='Right-Click to change data range.';
      IdiomHintButton  ='Click to change data range.';
      IdiomThisMonth   ='This &Month';

type
  TFromTo= class(TPanel)
  private
    { Private declarations }
    FOnChange:TNotifyEvent;
    FFrom,
    FTo:TDateTime;
    Function GetFromSt:String;
    Function GetToSt:String;
    Procedure SetFromSt(s:String);
    Procedure SetToSt(s:String);
    Procedure SetFrom(s:TDateTime);
    Procedure SetTo(s:TDateTime);
  protected
    { Protected declarations }
    Procedure ThisYear(Sender: TObject);  { from 1/1/95 to TODAY/95 }
    Procedure WholeYear(Sender: TObject); { from 1/1/95 to 12/31/95 }
    Procedure ThisMonth(Sender: TObject);
    Procedure AMonth(Sender: TObject);
    Procedure Notify;
  public
    { Public declarations }
    LabelFromTx,
    LabelToTx,
    LabelFrom,
    LabelTo:TLabel;
    FChange:TBitBtn;
    Constructor Create(AOwner:TComponent); override;
    Procedure ChangeClick(Sender:TObject);
    Procedure SetAMonth(Mes,a:Word);
    Procedure SetThisMonth;
    Procedure SetLastMonth;
    Procedure SetThisYear;
    Procedure SetWholeYear;
    Procedure Loaded; override;
  published
    { Published declarations }
    property OnChange:TNotifyEvent read FOnChange write FOnChange;
    property FromDate:TDateTime read FFrom write SetFrom;
    property ToDate:TDateTime read FTo write SetTo;
    property FromDateSt:String read GetFromSt write SetFromSt;
    property ToDateSt:String read GetToSt write SetToSt;
  end;

procedure Register;

implementation

Uses UFromToD;

Function YearSt:String; { returns the current year in string }
Var Y,M,D:Word;
Begin
  DecodeDate(Date,Y,M,D);
  result:=IntToStr(Y);
End;

Constructor TFromTo.Create(AOwner:TComponent);
Begin
  inherited Create(AOwner);
  FFrom:=Date;
  FTo:=Date;
  Caption:='';
  Width:=300;
  Font.Name:='Arial';
  Font.Size:=9;
  ShowHint:=True;
  Hint:=IdiomHintFromTo;
  LabelFromTx:=TLabel.Create(Self);
  With LabelFromTx do
  Begin
    Caption:=IdiomFrom;
    Top:=12;
    Left:=6;
  End;
  insertControl(LabelFromTx);
  LabelToTx:=TLabel.Create(Self);
  With LabelToTx do
  Begin
    Caption:=IdiomTo;
    Top:=12;
    Left:=120;
  End;
  insertControl(LabelToTx);
  LabelFrom:=TLabel.Create(Self);
  With LabelFrom do
  Begin
    Caption:=GetFromSt;
    Top:=12;
    Left:=42;
    Font.Size:=9;
    Font.Style:=[fsBold];
  End;
  insertControl(LabelFrom);
  LabelTo:=TLabel.Create(Self);
  With LabelTo do
  Begin
    Caption:=GetToSt;
    Top:=12;
    Left:=146;
    Font.Size:=9;
    Font.Style:=[fsBold];
  End;
  insertControl(LabelTo);
  FChange:=TBitBtn.Create(Self);
  With FChange do
  Begin
    Caption:=IdiomButtonChange;
    Font.Color:=clBlue;
    Font.Style:=[fsBold];
    Default:=False;
    Hint:=IdiomHintButton;
    Top:=4;
    Left:=222;
    Width:=68;
    OnClick:=ChangeClick;
  end;
  insertControl(FChange);
End;

Procedure TFromTo.Loaded;
var t:Word;
    tmpItem:TMenuItem;
Begin
  inherited Loaded;
  Caption:='';
  PopupMenu:=TPopupMenu.Create(Self);
  With PopupMenu.Items do
  Begin
    Add(NewItem(IdiomButtonChange+'...',0,False,True,ChangeClick,0,'MenuTitol'));
    Add(NewLine);
    Add(NewItem(IdiomWholeYear+' '+YearSt,0,False,True,WholeYear,0,'MenuTotAny'));
    Add(NewItem(IdiomThisYear+' '+YearSt,0,
                               False,True,ThisYear,0,'MenuAquestAny'));
    Add(NewItem(IdiomThisMonth,0,False,True,ThisMonth,0,'MenuAquestMes'));

    Add(NewLine);
    for t:=1 to 12 do
    Begin
      tmpItem:=NewItem(LongMonthNames[t],0,False,True,AMonth,0,
                          'MenuMes'+IntToStr(t));
      tmpItem.Tag:=t;
      Add(tmpItem);
    end;
  end;
end;

Procedure TFromTo.ChangeClick(Sender:TObject);
Begin
  With TFromToDlg.Create(Self) do  { CREATES THE FROMTO DIALOG }
  try
    FromEdit.Text:=FromDateSt;
    ToEdit.Text  :=ToDateSt;
    if ShowModal=mrOk then
    Begin
      FromDateSt:=FromEdit.Text;
      ToDateSt  :=ToEdit.Text;
      Notify;
    End;
  finally
    Free;
  end;
End;

Procedure TFromTo.Notify;
Begin
  if Assigned(FOnChange) then FOnChange(Self);
end;

Function TFromTo.GetFromSt:String;
Begin
  result:=DateToStr(FFrom);
End;

Function TFromTo.GetToSt:String;
Begin
  result:=DateToStr(FTo);
End;

Procedure TFromTo.SetFromSt(s:String);
Begin
  try
    FFrom:=StrToDate(s);
    LabelFrom.Caption:=s;
  finally
  end;
End;

Procedure TFromTo.SetToSt(s:String);
Begin
  try
    FTo:=StrToDate(s);
    LabelTo.Caption:=s;
  finally
  end;
End;

Procedure TFromTo.SetFrom(s:TDateTime);
Begin
  FFrom:=s;
  LabelFrom.Caption:=GetFromSt;
End;

Procedure TFromTo.SetTo(s:TDateTime);
Begin
  FTo:=s;
  LabelTo.Caption:=GetToSt;
End;

Procedure TFromTo.SetThisMonth;
Var a,m,d:Word;
Begin
  DecodeDate(Date,a,m,d);
  SetAMonth(m,a);
End;

Procedure TFromTo.SetAMonth(Mes,a:Word);
Begin
  SetFrom(EncodeDate(a,Mes,1));
  SetTo(EncodeDate(a,Mes,DaysInMonth(Mes,a)));
End;

Procedure TFromTo.SetLastMonth;
Var a,m,d:Word;
Begin
  DecodeDate(Date,a,m,d);
  Dec(m);
  if m=0 then
  Begin
    m:=12;
    Dec(a);
  end;
  SetAMonth(m,a);
End;

{ from 1/1/95 to TODAY }
Procedure TFromTo.SetThisYear;
Var a,m,d:Word;
Begin
  DecodeDate(Date,a,m,d);
  SetFrom(EncodeDate(a,1,1));
  SetTo(EncodeDate(a,m,d));
End;

Procedure TFromTo.SetWholeYear;
Var a,m,d:Word;
Begin
  DecodeDate(Date,a,m,d);
  SetFrom(EncodeDate(a,1,1));
  SetTo(EncodeDate(a,12,31));
End;

Procedure TFromTo.ThisYear(Sender: TObject);
Begin
  SetThisYear;
  Notify;
End;

Procedure TFromTo.WholeYear(Sender: TObject);
Begin
  SetWholeYear;
  Notify;
End;

{ set this month }
Procedure TFromTo.ThisMonth(Sender: TObject);
Begin
  SetThisMonth;
  Notify;
End;

{ popup menu month items come here }
Procedure TFromTo.AMonth(Sender: TObject);
var a,m,d:Word;
Begin
  DecodeDate(Date,a,m,d);
  SetAMonth((Sender as TComponent).Tag,a);
  Notify;
End;

procedure Register;
begin
  RegisterComponents('DAVID B.', [TFromTo]);
end;

end.
