unit UCalenda;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Grids,Calendar;

type
  TCalendari = class(TCalendar)
  private
    { Private declarations }
  protected
    { Protected declarations }
    procedure DrawCell(ACol, ARow: Longint; ARect: TRect; AState: TGridDrawState); override;
  public
    { Public declarations }
    Function DateSt:String;
  published
    { Published declarations }
  end;

procedure Register;

implementation

procedure TCalendari.DrawCell(ACol, ARow: Longint; ARect: TRect; AState: TGridDrawState);
var c:Integer;
Begin
  if not (gdSelected in AState) then
  Begin
    c:=(ACol+StartOfWeek) mod 7;
    if c=0 then Canvas.Font.Color:=clRed else
    if c=6 then Canvas.Font.Color:=clNavy;
  end;
  inherited DrawCell(ACol,ARow,ARect,AState);
End;

Function TCalendari.DateSt:String;
Begin
  result:=DateToStr(CalendarDate);
End;

procedure Register;
begin
  RegisterComponents('DAVID B.', [TCalendari]);
end;

end.
