(****************************************************************
 This is a run-time sizeable child window control. 
 If you like this control you can feel free to use it.

 Atanas Stoyanov
 CIS : 100551,1072

*****************************************************************)

unit Sizeable;
Interface

uses WinTypes, Messages, Classes, Graphics, Forms, Controls;

procedure Register;
type
  TPaintEvent = procedure(Sender  : TObject;PaintDC : HDC) of object;
  TSizeEvent  = procedure(Sender  : TObject;{$IFDEF WIN32}
                         SizeType : Longint;{ SIZE_MAXIMIZED, SIZE_MINIMIZED, SIZE_RESTORED,
                                            SIZE_MAXHIDE, SIZE_MAXSHOW }
                                            {$ELSE}
                         SizeType : Word;   { SIZE_MAXIMIZED, SIZE_MINIMIZED, SIZE_RESTORED,
                                            SIZE_MAXHIDE, SIZE_MAXSHOW }
                                            {$ENDIF}
                         Width, Height : Word) of object;

  TSizeableWnd = class(TCustomControl)
  private
    FOnChange: TNotifyEvent;
    FOnPaint : TPaintEvent;
    FOnSizeChange : TSizeEvent;
    FCanvas  : TControlCanvas;
    procedure WMNCCalcSize(var Message : TWMNCCalcSize); message WM_NCCALCSIZE;
    procedure WMNCPaint(var Message : TWMNCPaint);message WM_NCPAINT;
    procedure WMNCHittest(var Message : TWMNCHittest);message WM_NCHITTEST;
    procedure WMSize(var Message: TWMSize); message WM_SIZE;
    function GetCanvas: TCanvas;
  protected
    procedure CreateParams(var Params: TCreateParams); override;
    procedure Change; dynamic;
    procedure PaintWindow(DC: HDC); override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    property Canvas: TCanvas read GetCanvas;
  published
    property OnChange: TNotifyEvent read FOnChange write FOnChange;
    property OnKeyDown;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnDblClick;
    property OnSizeChange: TSizeEvent read FOnSizeChange write FOnSizeChange;
    property OnPaint: TPaintEvent read FOnPaint write FOnPaint;
  end;

implementation

uses SysUtils, WinProcs, Consts, StdCtrls;

constructor TSizeableWnd.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ControlStyle := ControlStyle + [csOpaque];
  Color := clWindow;
  SetBounds(0, 0, 100, 100);
  FCanvas := TControlCanvas.Create;
  FCanvas.Control := Self;

end;

destructor TSizeableWnd.Destroy;
begin
  FCanvas.Free;
  inherited Destroy;
end;

procedure TSizeableWnd.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  with Params do
  begin
    Style := Style or WS_CLIPSIBLINGS;
    WindowClass.Style := WindowClass.Style or CS_HREDRAW or CS_VREDRAW or CS_DBLCLKS;
  end;
end;

function TSizeableWnd.GetCanvas: TCanvas;
begin
  Result := FCanvas;
end;

procedure TSizeableWnd.WMNCCalcSize(var Message : TWMNCCalcSize);
begin
  inherited;
  with Message do
  begin
    Dec(CalcSize_Params^.rgrc[0].right,GetSystemMetrics(SM_CXFRAME));
    Dec(CalcSize_Params^.rgrc[0].bottom,GetSystemMetrics(SM_CYFRAME));
    Inc(CalcSize_Params^.rgrc[0].left,GetSystemMetrics(SM_CXBORDER));
    Dec(CalcSize_Params^.rgrc[0].right,GetSystemMetrics(SM_CXBORDER));
    Inc(CalcSize_Params^.rgrc[0].top,GetSystemMetrics(SM_CYBORDER));
    Dec(CalcSize_Params^.rgrc[0].bottom,GetSystemMetrics(SM_CYBORDER));
  end;
end;

procedure TSizeableWnd.WMNCPaint(var Message : TWMNCPaint);
var
  DC : HDC;
  rcWindow,
  rcScreen : TRect;
  hbrShadow : hBrush;
  rgbBorder : TColorRef;
  hPenBorder : hPen;
begin
  inherited ;
  GetWindowRect(Handle,rcScreen);
  SetRect(rcWindow,0,0,rcScreen.right-rcScreen.left,
                       rcScreen.bottom-rcScreen.top);
  DC := GetWindowDC(Handle);
  rgbBorder := GetSysColor(COLOR_WINDOWFRAME);
  hbrShadow := GetStockObject(DKGRAY_BRUSH);
  SelectObject(DC,hbrShadow);
  PatBlt(DC,rcWindow.right-GetSystemMetrics(SM_CXFRAME),
            GetSystemMetrics(SM_CYFRAME),GetSystemMetrics(SM_CXFRAME),rcWindow.Bottom,PATCOPY);
  PatBlt(DC,GetSystemMetrics(SM_CXFRAME),rcWindow.bottom-GetSystemMetrics(SM_CYFRAME)
          ,rcWindow.right,GetSystemMetrics(SM_CYFRAME),PATCOPY);
  hPenBorder := CreatePen(PS_INSIDEFRAME,
                GetSystemMetrics(SM_CXBORDER),
                rgbBorder);
  SelectObject(DC,hPenBorder);
  SelectObject(DC,GetStockObject(HOLLOW_BRUSH));
  Rectangle(DC,0,0,rcWindow.right-GetSystemMetrics(SM_CXFRAME),
                   rcWindow.Bottom-GetSystemMetrics(SM_CYFRAME));
  ReleaseDC(Handle,DC);
  deleteObject(hPenBorder);
end;

procedure TSizeableWnd.WMNCHittest(var Message : TWMNCHittest);
var
  ptClient1,ptClient2,
  ptMouse : TPoint;
  rc : TRect;
begin
  inherited ;
  if Message.Result <> HTCLIENT then
  begin
    ptMouse := Message.Pos;
    rc := GetClientRect;
    ptClient1.x := 0;ptClient1.y := 0;
    ptClient1 := ClientToScreen(ptClient1);
    ptClient2.x := rc.right;ptClient2.y := rc.bottom;
    ptClient2 := ClientToScreen(ptClient2);
    if (ptMouse.x < ptClient1.x) or
       (ptMouse.y < ptClient1.y) then
      Message.result := HTBorder else
    if (ptMouse.x > ptClient2.x) and
       (ptMouse.y > ptClient2.y) then
      Message.result :=  HTBOTTOMRIGHT else
    if (ptMouse.x > ptClient2.x) then
      Message.Result := HTRIGHT else
    if (ptMouse.y > ptClient2.y) then
      Message.Result := HTBOTTOM;
  end;
end;

procedure TSizeableWnd.WMSize(var Message: TWMSize);
begin
  inherited;
  if Assigned(FOnSizeChange) then
  with Message do OnSizeChange(Self,SizeType,Width, Height);
end;


procedure TSizeableWnd.Change;
begin
  if Assigned(FOnChange) then FOnChange(Self);
end;

procedure TSizeableWnd.PaintWindow(DC: HDC);
begin
  FCanvas.Handle := DC;
  if Assigned(FOnPaint) then FOnPaint(Self,DC);
  FCanvas.Handle := 0;
end;


procedure Register;
begin
  RegisterComponents('Additional', [TSizeableWnd]);
end;

end.


