unit TEST_A1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, SimpleThread, AnotherGauge, ExtCtrls;

type
  TMainForm = class(TForm)
    Thread: TSimpleThread;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    cbActive: TCheckBox;
    Button4: TButton;
    Button5: TButton;
    cbSuspended: TCheckBox;
    Panel1: TPanel;
    G1: TAnotherGauge;
    G2: TAnotherGauge;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure ThreadActivate(Sender: TObject);
    procedure ThreadResume(Sender: TObject);
    procedure ThreadSuspend(Sender: TObject);
    procedure ThreadTerminate(Sender: TObject);
    procedure ThreadExecute(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    procedure UpdateLights;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.Button1Click(Sender: TObject);
begin
 Thread.Active := true;
 UpdateLights;
end;

procedure TMainForm.Button2Click(Sender: TObject);
begin
 Thread.Active := false;
 UpdateLights;
end;

procedure TMainForm.Button3Click(Sender: TObject);
begin
 Thread.Kill;
 UpdateLights;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
 UpdateLights;
end;

procedure TMainForm.Button4Click(Sender: TObject);
begin
 Thread.Suspended := true;
 UpdateLights;
end;

procedure TMainForm.Button5Click(Sender: TObject);
begin
 Thread.Suspended := false;
 UpdateLights;
end;

procedure TMainForm.ThreadActivate(Sender: TObject);
begin
 UpdateLights;
end;

procedure TMainForm.ThreadResume(Sender: TObject);
begin
 UpdateLights;
end;

procedure TMainForm.ThreadSuspend(Sender: TObject);
begin
 UpdateLights;
end;

procedure TMainForm.ThreadTerminate(Sender: TObject);
begin
 UpdateLights;
end;

procedure TMainForm.UpdateLights;
begin
  cbSuspended.Checked := Thread.Suspended;
  cbActive.Checked := Thread.Active;
end;



procedure TMainForm.ThreadExecute(Sender: TObject);
begin
  while not ( Sender as TSimpleThread ).Terminated do
   begin
     with G1 do Value := Min + Random( Max - Min );
     with G2 do Value := Min + Random( Max - Min );
     Sleep( 100 );
   end;
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Thread.Active := false;
end;

end.
