unit Bmpview1;

interface

uses 
  WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons, 
  dialogs, ExtCtrls, 
  StdCtrls, sysutils, FileCtrl, Grids, Outline, DirOutln, Simage;

type
  TViewer = class(TForm)
    ImageLabel: TLabel;
    FileList: TFileListBox;
    DriveBox: TDriveComboBox;
    TreeLabel: TLabel;
    DriveLabel: TLabel;
    tree: TDirectoryOutline;
    RadioGroup1: TRadioGroup;
    GroupBox1: TGroupBox;
    CropBtn: TButton;
    CancelCropBtn: TButton;
    ShowCropped: TRadioButton;
    ShowFull: TRadioButton;
    ShowFitted: TRadioButton;
    ShowActual: TRadioButton;
    BitBtn1: TBitBtn;
    ScrollBox1: TScrollBox;
    Panel1: TPanel;
    image: TSimage;
    procedure FileListClick(Sender: TObject);
    procedure DriveBoxChange(Sender: TObject);
    procedure treeChange(Sender: TObject);
    procedure ImageClick(Sender: TObject);
    procedure OptionsClick(Sender: TObject);
    procedure CancelCropBtnClick(Sender: TObject);
    procedure CropBtnClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
  { Private declarations }
    procedure loadimage(
                     fname : string);
    procedure SetOptions(
                     OnOff : boolean);
  private
    CropTool : boolean;
    cur_rect : Trect;
    orgheight,
    orgwidth,
    oldheight,
    oldwidth : integer;
  end;

var
  Viewer: TViewer;

implementation
uses
  fullscr;

{$R *.DFM}

{-------------------------------------------------------------------------}
procedure TViewer.FileListClick(Sender: TObject);
begin
  if croptool then
    CancelCropBtnClick(Sender);
  with filelist do   
    if filename <> '' then LoadImage(filename);
end;

{-------------------------------------------------------------------------}
procedure TViewer.DriveBoxChange(Sender: TObject);
var
  SaveCursor : HCursor;
begin
  SaveCursor := screen.cursor;
  screen.cursor := crHourGlass;
  tree.drive := drivebox.drive;
  screen.cursor := SaveCursor;
end;

{-------------------------------------------------------------------------}
procedure TViewer.treeChange(Sender: TObject);
var
  SaveCursor : HCursor;
begin
  SaveCursor := screen.cursor;
  screen.cursor := crHourGlass;
  LoadImage('');
  with FileList do
  begin
    directory := tree.directory;
    if items.count > 0 then
    begin
      itemindex := 0;
      FileListClick(Sender);
    end;
  end;
  screen.cursor := SaveCursor;
end;

{-------------------------------------------------------------------------}
procedure TViewer.loadimage(
                        fname : string);
begin
  with image do
    if get_filename <> fname then
    begin
      CropBtn.enabled := yes;
      cur_rect := rect(0,0,0,0);
      changefromfile(fname,cur_rect,no,ShowActual.checked);
    end;
end;

{-------------------------------------------------------------------------}
procedure TViewer.ImageClick(Sender: TObject);
begin
  FullSlide.Image.ReplaceWith(TSimage(Sender),rect(0,0,0,0),no,no);
  FullSlide.showmodal;
end;

{-------------------------------------------------------------------------}
procedure TViewer.SetOptions(
                     OnOff : boolean);
begin
  ShowCropped.enabled := OnOff;
  ShowActual.enabled  := OnOff;
  ShowFull.enabled    := OnOff;
  ShowFitted.enabled  := OnOff;
end;

{-------------------------------------------------------------------------}
procedure TViewer.OptionsClick(Sender: TObject);
begin
  Image.Redraw(cur_rect,ShowCropped.Checked,ShowActual.checked);
  Filelist.SetFocus;
end;

{-------------------------------------------------------------------------}
procedure TViewer.CropBtnClick(Sender: TObject);
var
  changed : boolean;
begin
  with image do
    if croptool then
    begin
      croptool_off(changed,cur_rect);
      CropBtn.caption := 'Activate Crop &Tool';
      CancelCropBtn.enabled := no;
      SetOptions(yes);
      if ShowCropped.Checked then
        Redraw(cur_rect,yes,ShowActual.checked);
    end
    else
    begin
      if ShowCropped.Checked then
        Redraw(cur_rect,no,ShowActual.checked);
      croptool_on;
      CropBtn.caption := 'Save Crop Settings';
      CancelCropBtn.enabled := yes;
      SetOptions(no);
    end;                           
  croptool := not croptool;
end;

{-------------------------------------------------------------------------}
procedure TViewer.CancelCropBtnClick(Sender: TObject);
var
  changed : boolean;
  rect : Trect;
begin
  with image do
    if croptool then
    begin
      croptool_off(changed,rect);
      CropBtn.caption := 'Activate Crop &Tool';
      CancelCropBtn.enabled := no;
      SetOptions(Yes);
      if ShowCropped.Checked then
        Redraw(cur_rect,yes,ShowActual.checked);
    end;
  croptool := no;
end;

{-------------------------------------------------------------------------}
procedure TViewer.FormResize(Sender: TObject);
var
  resizeimage : boolean;
  t,l,w,h,
  h_delta,
  w_delta : integer;
begin
  if oldheight = 0 then                                     {original call}
  begin
    orgheight := height;
    oldheight := height;
    orgwidth  := width;
    oldwidth  := width;
  end
  else
  begin
    resizeimage := no;
    if height >= orgheight then
      h_delta := (height - oldheight)
    else
      h_delta := (orgheight - oldheight);
    if h_delta <> 0 then
    begin
      ScrollBox1.height := ScrollBox1.height + h_delta;
      inc(oldheight,h_delta);
      resizeimage := yes;
    end;
    if width >= orgwidth then
      w_delta := (width - oldwidth)
    else
      w_delta := (orgwidth - oldwidth);
    if w_delta <> 0 then
    begin                    
      ScrollBox1.width := ScrollBox1.width + w_delta;
      inc(oldwidth,w_delta);
      resizeimage := yes;
    end;
    if resizeimage then
      with image do
      begin
        GetDesignedSize(t,l,w,h);
        SetDesignedSize(t,l,w + w_delta,h + h_delta);
        Redraw(cur_rect,ShowCropped.Checked,ShowActual.checked);
      end;
  end;
end;

end.
