unit Mainform;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, About, Grids, Menus, ExtCtrls;

type
  TForm1 = class(TForm)
    ShuffleGrid: TDrawGrid;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Help1: TMenuItem;
    New: TMenuItem;
    Quit: TMenuItem;
    About: TMenuItem;
    Preview: TImage;
    NumMovesLabel: TLabel;
    N1: TMenuItem;
    procedure ShuffleGridDrawCell(Sender: TObject; Col, Row: Longint;
      RectArg: TRect; State: TGridDrawState);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ShuffleGridSelectCell(Sender: TObject; Col, Row: Longint;
      var CanSelect: Boolean);
    procedure NewClick(Sender: TObject);
    procedure AboutClick(Sender: TObject);
    procedure QuitClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

const
  Bitmapname = 'SHUFFLE.BMP';

var
  Form1: TForm1;
  Bitmap: TBitmap;
  Layout: array[0..15] of Integer;
  EmptyCell: Integer;
  NumMoves: Integer;
  IsStarted: Boolean;


implementation

{$R *.DFM}


procedure TForm1.ShuffleGridDrawCell(Sender: TObject; Col, Row: Longint;
  RectArg: TRect; State: TGridDrawState);
var
   Index: Integer;
   FromCol, FromRow: Integer;
   FromRect: TRect;
   EmptyCellCol, EmptyCellRow: Integer;
begin
     { Calculate which rect to paint in the cell}
     Index := Row * ShuffleGrid.RowCount + Col;
     FromCol := Layout[Index] mod ShuffleGrid.ColCount;
     FromRow := Layout[Index] div ShuffleGrid.ColCount;

     FromRect := ShuffleGrid.CellRect(FromCol, FromRow);

     { Fill the cell with the correct portion of the bitmap }
     { or if it is the empty cell, just fill the rect with nothing }
     if Index <> EmptyCell then
        ShuffleGrid.Canvas.CopyRect(RectArg, Bitmap.Canvas, FromRect)
     else
        ShuffleGrid.Canvas.FillRect(RectArg);

end;

procedure TForm1.FormCreate(Sender: TObject);
var
   i: Integer;
begin
    { Size the Grid }
    with ShuffleGrid do
    begin
        DefaultColWidth := Width div ColCount - 1;
        DefaultRowHeight := Height div RowCount - 1;
    end;

    { Load the bitmap }
    Bitmap := TBitmap.Create;
    Bitmap.LoadFromFile(Bitmapname);
    Bitmap.Canvas.StretchDraw(
      Rect(0, 0, ShuffleGrid.Width, ShuffleGrid.Height), Bitmap);

    { Set the preview bitmap }
    Preview.Picture.Bitmap.LoadFromFile(Bitmapname);

    { Initialize the Layout array }
    for i:=0 to 15 do
        Layout[i] := i;
    EmptyCell := 3;
    NumMoves := 0;
    IsStarted := FALSE;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
     Bitmap.Free;
end;

procedure TForm1.ShuffleGridSelectCell(Sender: TObject; Col, Row: Longint;
  var CanSelect: Boolean);
var
   CurSelected, Temp: Integer;
   EmptyCol, EmptyRow: Integer;
   I: Integer;
   NotFinished: Boolean;
begin
     EmptyCol := EmptyCell mod ShuffleGrid.ColCount;
     EmptyRow := EmptyCell div ShuffleGrid.ColCount;
     CurSelected := Row * ShuffleGrid.RowCount + Col;
     if ((IsStarted = TRUE) and
         ((EmptyCol = Col) and ((EmptyRow = Row - 1) or (EmptyRow = Row + 1)) or
         (EmptyRow = Row) and ((EmptyCol = Col - 1) or (EmptyCol = Col + 1)))) then
     begin
          {Do the moves in the Layout array }
          Temp := Layout[CurSelected];
          Layout[CurSelected] := Layout[EmptyCell];
          Layout[EmptyCell] := Temp;
          EmptyCell := CurSelected;

          { If first time after restart, repaint all }
          if NumMoves = 0 then
              ShuffleGrid.Invalidate;

          { Update the nuber of moves label }
          NumMoves := NumMoves + 1;
          NumMovesLabel.Caption := IntToStr(NumMoves) + ' moves';
          CanSelect := TRUE;

          { Test if all bricks are in the right place }
          NotFinished := FALSE;
          for I := 0 to 15 do
              if Layout[I] <> I then
                 NotFinished := TRUE;
          if NotFinished = FALSE then
          begin
              IsStarted := FALSE;
              ShuffleGrid.Invalidate;
          end
     end
     else
     begin
          { Not a movable cell selected }
          CanSelect := FALSE;
     end
end;

procedure TForm1.NewClick(Sender: TObject);
var
   I, Col, Row: Integer;
   CanSelect: Boolean;
begin
     { Do the shuffle (500 random moves) }
     Randomize;
     for I := 0 to 500 do
     begin
          CanSelect := FALSE;
          IsStarted := TRUE;
          while CanSelect = FALSE do
              ShuffleGridSelectCell(Form1, Random(4), Random(4), CanSelect);
     end;
     ShuffleGrid.Invalidate;
     NumMoves := 0;
end;

procedure TForm1.AboutClick(Sender: TObject);
begin
     AboutBox.ProgramIcon.Picture.LoadFromFile(Bitmapname);
    AboutBox.Caption := 'About ' + Application.Title;
    AboutBox.ShowModal;
end;

procedure TForm1.QuitClick(Sender: TObject);
begin
     Close;
end;

end.
