{ Second attempt at a Delphi Visual component for R&R runtime }
{ You are free to distribute and use this file as you wish with this header }
{ Please email any comments/enhancements to cbrooksbank@msn.com }

{ Needs R&R Report Writer - SQL Edition V6.0 - Concentric Data Systems, Inc.}
{ Author Chris Brooksbank (cbrooksbank@msn.com) }
{ Written : June 1995 }
{ Needs rrsqlint }

{ October 1995 changes :
Changed class name from TReportRR to TRRSQL60
  ( needed because some propertys changed String to enumarated lists )

GPF bug on editing any stringlist property (e.g. sortfields) fixed

function prototypes in interface unit defined as far

resource protection on execute method improved

execute method now returns TRUE/FALSE for success/failure

join information for reports now loaded ( JoinTablenames and JoinAliasNames )

drop down lists for several propertys e.g. report destination

askprinter property for interactive printer selection by user

askreport property for interactive report selection by user

askdatasource property for interactive datasource selection by user

asktable property for interactive table selection by user

edited changes to sort/group/joins is now passed to report in execute

run method added ( does same as execute )

user paramaters added and passed to report on execute

lasterrorcode and lasterrormessage property added

active property added to allow report running at design time

added Database property

execute method now uses anything setup in replaces property

added where property for Auto-SQL reports
}

unit RR_SQL60;

interface

uses
  SysUtils,WinTypes,WinProcs,Messages,Classes,Graphics,Controls,Forms,
  Dialogs,rrsqlint,DsgnIntf;

type
  TrrFilterUsage = (rrfuSaved,rrfuNone,rrfuComponent,rrfuInteractive);
  TrrDest = (rrdDisplay,rrdTextFile,rrdPrinter,rrdWorksheet,rrdXBase,
             rrdInteractive);
  TrrExportDest = (rredDisplay,rredFile,rredPrinter);
  TrrwsBorderStyle = (rrwsNone,rrwsFixedSingle,rrwsSizable,rrwsFixedDouble);

  TRRSQL60 = class(TComponent)
  private
    { Private declarations }
     fActive:Boolean;
     fAskPrinter:Boolean;
     fAskReport:Boolean;
     fAskDataSource:Boolean;
     fAskTable:Boolean;
     fAuthor:String;
     fAppName:String;
     fBeginPage: Longint;
     fCopies: Longint;
     fDatabasename: String;
     fDataDir    : String;
     fDataSource: String;
     fDisplayErrors: Boolean;
     fDisplayStatus: Boolean;
     fEndPage: LongInt;
     fErrorCode: String;
     fErrorMessage: String;
     fExportDest: TrrExportDest;
     fFields: TStrings;
     fFilter: String;
     fFilterUsage: TrrFilterUsage;
     fGroupFields: TStrings;
     fImageDir   : String;
     fJoinTablenames: TStrings;
     fJoinAliasNames: TStrings;
     fLibName: String;
     fMasterTableName: String;
     fMemoName: String;
     fOutputDest: TRRDest;
     fOutputFile: String;
     fPassword: String;
     fPreventEscape: Boolean;
     fPrinterName: String;
     fPrinterPort: String;
     fReplaces: TStrings;
     fRepName:String;
     fReportPick: Boolean;
     fSortFields: TStrings;
     fStatusEveryPage: Boolean;
     fSuppressTitle: Boolean;
     fTestPattern: Boolean;
     fUserName: String;
     fUserParamsNames: TStrings;
     fUserParamsValues: TStrings;
     fVersion: String;
     fWait: Boolean;
     fWhere:String;
     fWinBorderStyle: TrrwsBorderStyle;
     fWinControlBox: Boolean;
     fWinHeight: Integer;
     fWinLeft:Integer;
     fWinMaxButton: Boolean;
     fWinMinButton: Boolean;
     fWinParentHandle: Integer;
     fWinTitle: String;
     fWinTop: Integer;
     fWinWidth:Integer;
     procedure SetRepName(NewRepName: String);
     procedure SetLibName(NewLibName:String);
     procedure LoadReportInfo;
     procedure LoadFields(hReport:Integer);
     procedure LoadGroupFields(hReport:Integer);
     procedure LoadSortFields(hReport:Integer);
     procedure LoadJoins(hReport:Integer);
     procedure LoadUserParams(hReport:Integer);
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(Aowner:TComponent); override;
    destructor Free;
    function execute:Boolean;
    function run:Boolean;
    procedure setfFields(Value:Tstrings);
    procedure setfGroupFields(Value:Tstrings);
    procedure setfJoinTableNames(Value:Tstrings);
    procedure setfJoinAliasNames(Value:Tstrings);
    procedure setfReplaces(Value:Tstrings);
    procedure setfSortFields(Value:Tstrings);
    procedure setfUserParamsNames(Value:Tstrings);
    procedure setfUserParamsValues(Value:Tstrings);
    procedure setfActive(Value:Boolean);
    procedure setfAuthor(Value:String);
    procedure savereplaces(hReport:Integer);
    procedure loadreplaces(hReport:Integer);
  published
    { Published declarations }
    property Active: Boolean read fActive write SetfActive;
    property AppName: String read fAppName write fAppName;
    property AskPrinter:Boolean read fAskPrinter write fAskPrinter;
    property AskReport:Boolean read fAskReport write fAskReport;
    property AskDataSource:Boolean read fAskDataSource write fAskDataSource;
    property AskTable:Boolean read fAskTable write fAskTable;
    property Author: String read fAuthor write setfAuthor;
    property BeginPage: Longint read fBeginPage write fBeginPage default 1;
    property Copies: Longint read fCopies write fCopies default 1;
    property Databasename:String read fDatabasename write fDatabasename;
    property DataSource: String read fDataSource write fDataSource;
    property DisplayErrors: Boolean read fDisplayErrors write fDisplayErrors;
    property DisplayStatus: Boolean read fDisplayStatus write fDisplayStatus;
    property EndPage: Longint read fEndPage write fEndPage default 999999;
    property ErrorCode: String read fErrorcode write fErrorcode;
    property ErrorMessage: String read fErrorMessage write fErrorMessage;
    property ExportDest: TrrExportDest read fExportDest write fExportDest;
    property Fields: TStrings read fFields write setfFields;
    property Filter: String read fFilter write fFilter;
    property FilterUsage: TrrFilterUsage read fFilterUsage write fFilterUsage;
    property GroupFields: TStrings read fGroupFields write setfGroupFields;
    property JoinTableNames: TStrings read fJoinTableNames
                                      write setfJoinTableNames;
    property JoinAliasNames: TStrings read fJoinAliasNames
                                      write setfJoinAliasNames;
    property MasterTableName: String read fMasterTableName write fMasterTableName;
    property MemoName: String read fMemoName write fMemoName;
    property OutputDest: TrrDest read fOutputDest write fOutputDest
                                 default rrdDisplay;
    property OutputFile: String read fOutputFile write fOutputFile;
    property Password: String read fPassword write fPassword;
    property PreventEscape: Boolean read fPreventEscape write fPreventEscape;
    property PrinterName: String read fPrinterName write fPrinterName;
    property PrinterPort: String read fPrinterPort write fPrinterPort;
    property Replaces:Tstrings read fReplaces write SetfReplaces;
    property ReportLibrary:String read fLibName write setLibName;
    property ReportName: String read fRepName write setRepName;
    property SortFields: TStrings read fSortFields write setfSortFields;
    property StatusEveryPage: Boolean read fStatusEveryPage
                                      write fStatusEveryPage;
    property SuppressTitle: Boolean read fSuppressTitle write fSuppressTitle;
    property TestPattern: Boolean read fTestPattern write fTestPattern;
    property UserName: String read fUserName write fUserName;
    property UserParamsNames: TStrings read fUserParamsNames
                                       write setfUserParamsNames;
    property UserParamsValues: TStrings read fUserParamsValues
                                       write setfUserParamsValues;
    property Version:String read fVersion write fversion;
    property Wait: Boolean read fWait write fWait;
    property Where: String read fWhere write fWhere;
    property WinBorderStyle:TrrwsBorderStyle read fWinBorderStyle
             write fWinBorderStyle default rrwsSizable;
    property WinControlBox: Boolean read fWinControlBox write fWinControlBox;
    property WinHeight: Integer read fWinHeight write fWinHeight;
    property WinLeft: Integer read fWinLeft write fWinLeft;
    property WinMaxButton: Boolean read fWinMaxButton write fWinMaxButton default true;
    property WinMinButton: Boolean read fWinMinButton write fWinMinButton default true;
    property WinParentHandle: Integer read fWinParentHandle write fWinParentHandle;
    property WinTitle: String read fWinTitle write fWinTitle;
    property WinTop:Integer read fWinTop write fWinTop;
    property WinWidth:Integer read fWinWidth write fWinWidth;
end;

procedure Register;

implementation

{ ************************************************************************** }
constructor TRRSQL60.create(AOwner:Tcomponent);
{ ************************************************************************** }
begin
  inherited create(AOwner);

  fAppName:=application.EXEname;

  fFields:=TStringList.Create;
  fJoinTableNames:=TStringList.Create;
  fJoinAliasNames:=TStringList.Create;
  fGroupFields:=TStringList.Create;
  fSortFields:=TStringList.Create;
  fUserParamsNames:=TStringList.Create;
  fUserParamsValues:=TStringList.Create;
  fReplaces:=TStringList.Create;

  fAuthor:='cbrooksbank@msn.com';
  fVersion:='1.00';
  fBeginPage:=1;
  fEndPage:=999999;
  fOutputDest:=rrdDisplay;
  fCopies:=1;
  fWinBorderStyle:=rrwsSizable;
  fWinMaxButton:=true;
  fWinMinButton:=true;
  fWait:=true;
end;

{ ************************************************************************** }
destructor TRRSQL60.Free;
{ ************************************************************************** }
begin
  fFields.Free;
  fJoinTableNames.Free;
  fJoinAliasNames.Free;
  fGroupFields.Free;
  fSortFields.Free;
  fUserParamsNames.Free;
  fUserParamsValues.Free;
  fReplaces.free;
  inherited Free;
end;


{ ************************************************************************** }
procedure Register;
{ ************************************************************************** }
begin
  RegisterComponents('SI', [TRRSQL60]);
end;


{ ************************************************************************** }
procedure TRRSQL60.setlibname(NewLibName:String);
{ ************************************************************************** }
begin
  flibname:=NewLibName;
  loadreportinfo;
end;

{ ************************************************************************** }
procedure TRRSQL60.LoadReportInfo;
{ ************************************************************************** }
{ When reportname or libname change load various information }
{ from the report. E.G. fields,sort-fields,group-fields,joins e.t.c.}
var
  hMyReport:Integer;
  MyApp_,MyLib_,MyRep_: array[0..255] of char;
begin

  if ((fRepName<>'') and (fLibName<>'')) then begin

    fFields.Clear;
    fSortFields.Clear;
    fJoinTableNames.Clear;
    fJoinAliasNames.Clear;
    fGroupFields.Clear;

    StrPCopy(MyApp_,application.EXEname);
    StrPCopy(MyLib_,fLibName);
    StrPCopy(MyRep_,fRepName);

    InitRunTimeInstance;
    try
      hMyReport:=ChooseReport(MyApp_,MyLib_,MyRep_,sizeof(MyRep_));
      try
        if hMyReport>0 then begin
          LoadFields(hMyReport);
          LoadGroupFields(hMyReport);
          LoadSortFields(hMyReport);
          LoadJoins(hMyReport);
          LoadUserParams(hMyReport);
          LoadReplaces(hMyReport);
          if fRepName='' then fRepName:=StrPas(MyRep_);
        end;
      finally
        EndReport(hMyReport);
      end;
    finally
      EndRunTimeInstance;
    end;
  end;

end;


{ ************************************************************************** }
procedure TRRSQL60.LoadUserParams(hReport:Integer);
{ ************************************************************************** }
var
  ParamName,ParamValue:Array[0..30] of char;
begin
  GetFirstUserParam(hReport,ParamName,Sizeof(ParamName),
                    paramValue,sizeof(ParamValue));
  fUserParamsNames.Add(StrPas(ParamName));
  fUSerParamsValues.Add(StrPas(ParamValue));
  while GetNextUserParam(hReport,ParamName,Sizeof(ParamName),
                         ParamValue,sizeof(ParamValue)) do begin
    fUserParamsNames.Add(StrPas(ParamName));
    fUSerParamsValues.Add(StrPas(ParamValue));
  end;
end;

{ ************************************************************************** }
procedure TRRSQL60.LoadFields(hReport:Integer);
{ ************************************************************************** }
var
  FieldName:Array[0..30] of char;
begin
  GetFirstFieldName(hReport,FieldName,Sizeof(FieldName));
  fFields.Add(StrPas(FieldName));
  while GetNextFieldName(hReport,FieldName,Sizeof(FieldName)) do
    fFields.Add(StrPas(FieldName));
end;

{ ************************************************************************** }
procedure TRRSQL60.LoadGroupFields(hReport:Integer);
{ ************************************************************************** }
var
  GroupField:Array[0..30] of char;
begin
  GetFirstGroupField(hReport,GroupField,Sizeof(GroupField));
  fGroupFields.Add(StrPas(GroupField));
  while GetNextGroupField(hReport,GroupField,Sizeof(GroupField)) do
    fGroupFields.Add(StrPas(GroupField));
end;

{ ************************************************************************** }
procedure TRRSQL60.LoadSortFields(hReport:Integer);
{ ************************************************************************** }
var
  SortField:Array[0..30] of char;
begin
  GetFirstSortField(hReport,SortField,Sizeof(SortField));
  fSortFields.Add(StrPas(SortField));
  while GetNextSortField(hReport,SortField,Sizeof(SortField)) do
    fSortFields.Add(StrPas(SortField));
end;

{ ************************************************************************** }
procedure TRRSQL60.LoadJoins(hReport:Integer);
{ ************************************************************************** }
var
  JoinTableName,JoinAliasName:Array[0..50] of char;
begin
  GetFirstJoinInfo(hReport,JoinTableName,Sizeof(JoinTableName),
                   JoinAliasName,sizeof(JoinAliasName));

  fJoinTableNames.Add(StrPas(JoinTableName));
  fJoinAliasNames.Add(StrPas(JoinAliasName));

  while GetNextJoinInfo(hReport,JoinTableName,Sizeof(JoinTableName),
                        JoinAliasName,sizeof(JoinAliasName)) do begin
    fJoinTableNames.Add(StrPas(JoinTableName));
    fJoinAliasNames.Add(StrPas(JoinAliasName));
  end
end;


{ ************************************************************************** }
procedure TRRSQL60.SetRepName(NewRepName: String);
{ ************************************************************************** }
begin
  fRepName:=NewRepName;
  LoadReportInfo;
end;


{ ************************************************************************** }
function TRRSQL60.Run:Boolean;
{ ************************************************************************** }
begin
  Result:=Execute;
end;


{ ************************************************************************** }
function TRRSQL60.Execute:Boolean;
{ ************************************************************************** }
var
  { Handle of report }
  hReport: Integer;

  { Temp vars to hold Pchar versions of String properties }
  Appname_,LibName_,RepName_,DataSource_,PrinterName_: array[0..255] of char;
  PrinterPort_,PassWord_,UserName_: array[0..30] of char;
  filter_: array[0..255] of char;
  MasterTableName_,MemoName_,OutputFile_,WinTitle_: array[0..255] of char;
  Tablename_,Databasename_,Where_:array[0..255] of char;

  { Flags returned after report was run }
  ECode:Integer;
  cmdshow: Integer;
  PageCount:LongInt;
  EMsg:array[0..255] of char;

  ErrorMess: String;
  CharString:String;
  SiField,SiField2:array[0..255] of char;

  i:Integer;

begin
  {Run the report }
  Result:=false;

  { Convert Pascal type strings to C++ strings as expected by DLL }
  StrPCopy(Appname_,fAppname);
  StrPCopy(DataSource_,fDataSource);
  StrPCopy(Filter_,fFilter);
  StrPCopy(Libname_,fLibName);
  StrPCopy(MasterTableName_,fMasterTableName);
  StrPCopy(MemoName_,fMemoName);
  StrPCopy(OutputFile_,fOutputFile);
  StrPCopy(Password_,fPassword);
  StrPCopy(Printername_,fPrinterName);
  StrPCopy(PrinterPort_,fPrinterPort);
  StrPCopy(RepName_,fRepName);
  StrPCopy(UserName_,fUserName);
  StrPCopy(WinTitle_,fWinTitle);
  StrPCopy(Databasename_,fDatabasename);
  StrPCopy(Where_,fwhere);

  { Initialise RSREPORT.DLL and get a handle for the report }
  InitRuntimeInstance;
  try
    if AskReport then
      hReport:=ChooseReport(Appname_,LibName_,RepName_,sizeof(RepName_))
    else
      hReport:=chooseReport(AppName_,LibName_,RepName_,Sizeof(RepName_));

    try
      { Pass all the propertys to RSREPORT.DLL }
      SetBeginPage(hReport,fBeginPage);
      SetCopies(hReport,fCopies);
      SetDisplayErrors(hReport,fDisplayErrors);
      SetDisplayStatus(hReport,FDisplayStatus);
      SetEndPage(hReport,fEndPage);

      CharString:=Copy('DFP',Ord(fExportDest)+1,1);
      SetExportDest(hReport,CharString[1]);

      SetFilter(hReport,Filter_);

      CharString:=Copy('SEO?',Ord(fFilterUsage)+1,1);
      SetFilterUsage(hReport,CharString[1]);

      SetMasterTableName(hReport,MasterTableName_);
      SetMemoName(hReport,MemoName_);

      CharString:=Copy('DAPWX?',Ord(fOutputDest)+1,1);
      SetOutputDest(hReport,CharString[1]);

      SetOutPutFile(hReport,OutputFile_);
      SetPassword(hReport,Password_);
      SetPreventEscape(hReport,fPreventEscape);
      SetStatusEveryPage(hReport,fStatusEveryPage);
      SetTestPattern(hReport,fTestPattern);
      SetUserName(hReport,Username_);

      CharString:=Copy('0123',Ord(fWinBorderStyle)+1,1);
      SetWinBorderStyle(hReport,Ord(CharString[1])-Ord('0'));

      SetWinControlBox(hReport,fWinControlBox);
      SetWinHeight(hReport,fWinHeight);
      SetWinLeft(hReport,fWinLeft);
      SetWinMaxButton(hReport,fWinMaxButton);
      SetWinMinButton(hReport,fWinMinButton);
      SetWinParentHandle(hReport,fWinParentHandle);
      SetWinTitle(hReport,WinTitle_);
      SetWinTop(hReport,fWinTop);
      SetWinWidth(hReport,fWinWidth);

      { Set sort fields }
      for i:=0 to (fSortFields.Count-1) do begin
        if ((fSortFields[i]<>'') and
           (Pos('RECNO',UpperCase(fSortFields[i]))=0)) then begin
          StrPCopy(SiField,fSortFields[i]);
          SetSortField(hReport,SiField,i+1);
        end;
      end;

      { Set Group Fields }
      for i:=0 to (fGroupFields.Count-1) do begin
        if fGroupFields[i]<>'' then begin
          StrPCopy(SiField,fGroupFields[i]);
          SetGroupField(hReport,SiField,i+1);
        end;
      end;

      { Set join information }
      for i:=0 to (fJoinTableNames.Count-1) do begin
        if fJoinTableNames[i]<>'' then begin
          StrPCopy(SiField,fJoinTableNames[i]);
          StrPCopy(SiField2,fJoinAliasNames[i]);
          SetJoinInfo(hReport,SiField,Sifield2,i+1);
        end;
      end;

      { Set user paramaters }
      for i:=0 to (fUserParamsNames.Count-1) do begin
        if fUserParamsNames[i]<>'' then begin
          StrPCopy(SiField,fUserParamsNames[i]);
          StrPCopy(SiField2,fUserParamsValues[i]);
          SetUserParam(hreport,SiField,SiField2);
        end;
      end;


      if AskPrinter then
        choosePrinter(hReport,PrinterName_,sizeof(PrinterName_),
                      PrinterPort_,sizeof(PrinterPort_));
      SetPrinter(hReport,PrinterName_);
      SetPrinterPort(hReport,PrinterPort_);

      if AskDataSource then
        ChooseDataSource(hReport,Datasource_,sizeof(Datasource_));


      if AskTable then ChooseTable(hReport,Tablename_,sizeof(TableName_),
                                   DataSource_,sizeof(DataSource_),
                                   Databasename_,sizeof(Databasename_));

      SetDataSource(hReport,DataSource_);

      if fwhere<>'' then SetWhere(hReport,where_);

      SaveReplaces(hReport);

      { Run the report and then clean up }
      cmdshow:=SW_SHOWNORMAL;
      fErrorCode:='';
      fErrorMessage:='';
      ResetErrorInfo;
      if ExecRunTime(hReport,fWait,cmdshow,@ECode,@PageCount,EMsg,sizeof(EMsg))
      then Result:=True else begin
        geterrorinfo(Emsg,sizeof(EMsg),@Ecode);
        fErrorMessage:=StrPas(EMsg);

        case Ecode of
          Ord('C'):fErrorCode:='Cancelled';
          Ord('D'):fErrorCode:='Diagnostic';
          Ord('I'):fErrorCode:='Iteration';
          Ord('J'):fErrorCode:='Job Control';
          Ord('L'):fErrorCode:='Library';
          Ord('S'):fErrorCode:='Syntax';
          Ord('V'):fErrorCode:='Value';
          else
            fErrorCode:=Chr(Ecode);
        end;

        MessageDlg('R&&R Error : '+StrPas(EMsg),mtError,[mbAbort],0);
      end;
    finally
      EndReport(hReport);
    end;
  finally
    endRunTimeInstance;
  end;
end;

{ ************************************************************************** }
procedure TRRSQL60.SetfFields(Value:Tstrings);
{ ************************************************************************** }
begin
  fFields.Assign(Value);
end;

{ ************************************************************************** }
procedure TRRSQL60.SetfGroupFields(Value:Tstrings);
{ ************************************************************************** }
begin
  fGroupFields.Assign(Value);
end;

{ ************************************************************************** }
procedure TRRSQL60.SetfJoinTableNames(Value:Tstrings);
{ ************************************************************************** }
begin
  fJoinTableNames.Assign(Value);
end;

{ ************************************************************************** }
procedure TRRSQL60.SetfJoinAliasNames(Value:Tstrings);
{ ************************************************************************** }
begin
  fJoinAliasNames.Assign(Value);
end;

{ ************************************************************************** }
procedure TRRSQL60.SetfReplaces(Value:Tstrings);
{ ************************************************************************** }
begin
  fReplaces.Assign(Value);
end;

{ ************************************************************************** }
procedure TRRSQL60.SetfSortFields(Value:Tstrings);
{ ************************************************************************** }
begin
  fSortFields.Assign(Value);
end;

{ ************************************************************************** }
procedure TRRSQL60.SetfUserParamsNames(Value:Tstrings);
{ ************************************************************************** }
begin
  fUserParamsNames.Assign(Value);
end;

{ ************************************************************************** }
procedure TRRSQL60.SetfUserParamsValues(Value:Tstrings);
{ ************************************************************************** }
begin
  fUserParamsValues.Assign(Value);
end;


{ ************************************************************************** }
procedure TRRSQL60.SetfActive(Value:Boolean);
{ ************************************************************************** }
begin
  fActive:=Value;
  if (not value) then
    fActive:=Value else fActive:=execute;
end;

{ ************************************************************************** }
procedure TRRSQL60.SetfAuthor(Value:String);
{ ************************************************************************** }
begin
  if Value<>'cbrooksbank@msn.com' then
  messagedlg('Please send bugs/comments/enhancements to cbrooksbank@msn.com',mtInformation,
              [mbOk],0);
  fAuthor:='cbrooksbank@msn.com';
end;

{ ************************************************************************** }
procedure TRRSQL60.SaveReplaces(hReport:Integer);
{ ************************************************************************** }
var
  i:Integer;
  ThisReplace,ReplaceList:String;
  Replaces_:array[0..255] of char;
begin
  ReplaceList:='';
  for i:=0 to (fReplaces.count-1) do begin
    ThisReplace:=fReplaces[i];
    if ThisReplace<>'' then begin
      ReplaceList:=ReplaceList+','+ThisReplace;
    end;
  end;

  if ReplaceList<>'' then begin
    ReplaceList:=Copy(ReplaceList,1,length(replacelist)-1);
    StrPCopy(Replaces_,ReplaceList);
    SetReplace(hReport,Replaces_);
  end;
end;

{ ************************************************************************** }
procedure TRRSQL60.LoadReplaces(hReport:Integer);
{ ************************************************************************** }
var
  Replace:Array[0..30] of char;
begin
  GetFirstReplace(hReport,Replace,Sizeof(Replace));
  fReplaces.Add(StrPas(Replace));
  while GetNextReplace(hReport,Replace,Sizeof(Replace)) do
    fReplaces.Add(StrPas(Replace));
end;
end.
