{ Demo of interfacing Delphi to a DLL }
{ Needs R&R Report Writer - SQL Edition V6.0 - Concentric Data Systems, Inc.}

{ Borland Delphi Interface Unit To R&R Runtime DLL }
{ Author : Chris Brooksbank (cbrooksbank@cix.compulink.co.uk) }
{ June 13th 1995 }
{ Version 1.1 }

{ You are free to distribute and use this file as you wish with this header }
{ Please email any comments/enhancements to cbrooksbank@msn.com }

{ October 1995 function prototypes marked as far }

unit RRSQLInt;

interface

uses WinTypes;

{ ************* Sample code to run a report ************************ }
{ ****************************************************************** }

{ ************* Initialisation and cleanup functions/ run report ******* }
function InitRunTimeInstance: Boolean;far;
  { You must call this function first. It initialises an instance of the
    R&R runtime DLL }
function EndRunTimeInstance: Boolean;far;
  { Call this function to cleanup after you have finished using the R&R
    runtime DLL }
function EndReport(hReport: Integer): Boolean;far;
  { Free resources allocated to a report. Always call after using a report. }
function  ChooseReport(MyApp,LibName,RepName:PChar;Size: Integer): Integer;far;
  { Given a report library and report name return a handle to this report.
    Most functions need a hReport param. That is what this function returns.
    If RepName is NIL interactively asks for report from menu }
function  GetNewReportHandle(MyApp: PChar): Integer;far;
  { Another way of getting a report handle. This is a handle to a empty
    report information structure. Use ChooseReport in preference to this }
function  execRuntime(hReport:Integer;Wait:Boolean;cmdShow: Integer;
                      ECode: PInteger;PageCount: PLongInt;
                      EMsg:Pchar;Emsgsizeof: Integer): Boolean;far;
   { After getting a report handle and amending any settings call this
     function to actually run the report
     cmdShow can be sw_hide,sw_minimize,sw_restore,sw_show,sw_showmaximized,
                    sw_showminimized,sw_showminnoactive,sw_showna,
		    sw_shownoactive,sw_shownormal
		    ie any Windows API ShowWindow
     on Return Ecode value indicates (Error message in EMsg) :
     Ecode=N Successful execution of report
     Ecode=C User cancelled the report Emsg="Report canceled"
     Ecode=J Report structure pointed to by hReport is incorrect/corrupt
     Ecode=R Report began to execute but failed to complete. }
{ ********************************************************************** }


{ ********************************************************************** }
{ Getting information about R&R errors }
function GetErrorInfo(Msg:PChar;MsgSize:Integer;ErrCode:PInteger): Boolean;far;
  { Get error message and code returned by last DLL call }
  { ErrCode can be :
    C=Cancel. User cancelled a dialog box presented by the R&R DLL
    D=Diagnostic. Misc. error such as out of memory
    I=Iteration. No more values for requested getfirst or getnext function
    J=Job Control. Problem with specified runtime control file
    L=Library.Problem with report library being accessed
    S=Syntax error.
    V=Value. No value available for specified paramater.}
function resetErrorInfo: Boolean;far;
  { Clear out the last error message }
{ ********************************************************************** }


{ Which page to start printing at }
function  GetBeginPage(hReport: Integer;BeginPage: Plongint): Boolean;far;
function  SetBeginPage(hReport: Integer;lBeginPage: longint): Boolean;far;

{ Which page to end printing at }
function  GetEndPage(hReport:Integer;EndPage: Plongint): Boolean;far;
function  SetEndPage(hReport: Integer;EndPage: LongInt): Boolean;far;

{ How many copies of report to print }
function  GetCopies(hReport: Integer;Copies: PInteger): Boolean;far;
function  SetCopies(hReport: Integer;Copies: Integer): Boolean;far;

{ Data source for report }
function  ChooseDataSource(hReport:Integer;DataSource:PChar;Size:Integer): Boolean;far;
  { Interactive choosing by user }
function  SetDataSource(hReport: Integer;DataSource: PChar): Boolean;far;
function  GetDataSource(hReport: Integer;DataSource: PChar): Boolean;far;

{ Should R&R display errors on the screen ? }
function SetDisplayErrors(hReport:Integer;DispErr: Boolean): Boolean;far;
function GetDisplayErrors(hReport:Integer;DispErr: Pbool): Boolean;far;

{ Should R&R display a status window as the report is being generated ? }
function SetDisplayStatus(hReport:Integer;DispStatus: Boolean): Boolean;far;
function GetDisplayStatus(hReport:Integer;DispStatus:PBool): Boolean;far;

{ Export destination }
{ D=Display
  F=File
  P=Printer }
function SetExportDest(hReport:Integer;Val: char ): Boolean;far;
function GetExportDest(hReport:Integer;Val: PChar): Boolean;far;

{ View/alter the filter the report will use }
function setFilter(hReport:Integer;Filter: PChar): Boolean;far;
function getFilter(hReport:Integer;Filter:Pchar;Size:Integer): Boolean;far;

{ Which filter to use }
{ S=use filter saved with report
  E=dont use any filter. Use entire recordset
  O=Use filter specified with setfilter()
  ?=Allow user to interactively design filter at runtime }
function setFilterUsage(hReport:Integer;Val:Char): Boolean;far;
function getFilterUsage(hReport:Integer;Val: PChar): Boolean;far;

{ get/set the main table to be used in the report }
function setMasterTableName(hReport:Integer;FileName:PChar): Boolean;far;
function getMasterTableName(hReport:Integer;Filename: PChar;Size: Integer): Boolean;far;

{ get/set the ASCII memo file to use in the report }
function setMemoName(hReport:Integer;Path:Pchar): Boolean;far;
function getMemoName(hReport:Integer;Path:PChar;Size:Integer): Boolean;far;

{ get/set the Report output destination }
{ D=Display
  A/T=Text File - set by setOutputFile
  P=Printer
  W=Worksheet File
  X=XBASE file
  ?=Interactive at runtime }
function setOutputDest(hReport:Integer;Dest:Char): Boolean;far;
function getOutputDest(hReport:Integer;Dest:Pchar): Boolean;far;

{ Filename to output report to }
function setOutputFile(hReport:Integer;Name:Pchar): Boolean;far;
function getOutputFile(hReport:Integer;Name:PChar;Size: Integer): Boolean;far;

{ Allow user to interactively select the printer to use }
{ can later pass selected name to setPrinter }
function ChoosePrinter(hReport:Integer;Printer:PChar;SizePrinter:Integer;
	               PortName:PChar;SizePort:Integer): Boolean;far;

{ Get/set printer name associated with the report }
function getPrinter(hReport:Integer;PrinterName: PChar;Size: Integer): Boolean;far;
function setPrinter(hReport:Integer;PrinterName: PChar): Boolean;far;

{ Set the parent window of the preview window by passing the window handle }
function SetWinParentHandle(hReport:Integer;hParent:Integer): Boolean;far;

{ Replace the default data directory specified in RSW.INI }
function SetDataDir(hReport:Integer;Dir:PChar): Boolean;far;

{ Get/set functions for group fields }
function GetFirstGroupField(hReport:Integer;Name:PChar;Size:Integer): Boolean;far;
function GetNextGroupField(hReport:Integer;Name:PChar;Size:Integer):  Boolean;far;
{ GetErrorInfo() returns 'I' in 3rd param when no more in list }
function SetGroupField(hReport:Integer;Name:Pchar;GroupNum:Integer): Boolean;far;
{ Need to setgroupfields 1..last one to modify }

{ Replace the default image directory as stored in RSW.INI }
function SetImageDir(hReport:Integer;Dir:PChar): Boolean;far;

{ Get/Set printer port }
function GetPrinterPort(hReport:Integer;PortName:PChar;Size:Integer): Boolean;far;
function SetPrinterPort(hReport:Integer;Port:PChar): Boolean;far;

{ R=User prompted to select a report from current report library
  ?=User prompted to pick a succession of reports }
function GetReportPick(hReport:Integer;Pickflag:PChar): Boolean;far;
function SetReportPick(hReport:Integer;Pickflag:Char): Boolean;far;

{ Functions to get/set sort fields }
function GetFirstSortField(hReport:Integer;Name:PChar;Size:Integer): Boolean;far;
function GetNextSortField(hReport:Integer;Name:PChar;Size:Integer): Boolean;far;
{ GetErrorInfo() returns 'I' in 3rd param when no more in list }
function SetSortField(hReport:Integer;Name:PChar;SortNum:Integer): Boolean;far;

{ Get field names available to report }
function GetFirstFieldName(hReport:Integer;FieldName:PChar;FnSize:Integer): Boolean;far;
function GetNextFieldName(hReport:Integer;FieldName:PChar;Fnsize:Integer): Boolean;far;
{ GetErrorInfo() returns 'I' in 3rd param when no more in list }

{ Allow user to interactively select a table,database and datasource }
function ChooseTable(hReport:Integer;Table:PChar;SizeofTable:Integer;
	              DataSource:PChar;SizeOfDataSource:Integer;
		      DataBase:PChar;SizeOfDataBase:Integer): Boolean;far;


{ Get/set functions for join informations. Main table & related alias name.}
function GetFirstJoinInfo(hReport:Integer;TableName:PChar;
	                  TableSize:Integer;Alias:PChar;
			  AliasSize:Integer): Boolean;far;
function GetNextJoinInfo(hReport:Integer;TableName:PChar;
      	                 TableSize:Integer;Alias:PChar;
			 AliasSize:Integer): Boolean;far;
{ GetErrorInfo() returns 'I' in 3rd param when no more in list }
function setJoinInfo(hreport:Integer;TableName:PChar;
	             AliasName:PChar;AliasNum:Integer): Boolean;far;



{ Get/set user paramaters }
function GetFirstUserParam(hReport:Integer;PName:PChar;PNameSize:Integer;
	                   PValue:PChar;PValueSize:Integer): Boolean;far;
function GetNextUserParam(hReport:Integer;PName:PChar;PNameSize:Integer;
	                   PValue:PChar;PValueSize:Integer): Boolean;far;
{ GetErrorInfo() returns 'I' in 3rd param when no more in list }
function SetUserParam(hReport:Integer;Name:PChar;Value:PChar): Boolean;far;
{ To get R&R to ask in a dialog 'Enter Your Name :' then pass a value of
  "?Enter your name:"}

{ Get/set functions for replaceable parts of SELECT,EXEC or DEFINE REPORTVIEW
  statements. ( Those parts enclosed in <<>> e.g. :
  Select <<'firstname','lastname'>> from students
  where <<'firstname'<'lastname'>>}
function GetFirstReplace(hReport:Integer;Replace:PChar;Size:Integer): Boolean;far;
function GetNextReplace (hReport:Integer;Replace:PChar;Size:Integer): Boolean;far;
{ GetErrorInfo() returns 'I' in 3rd param when no more in list }
function SetReplace(hReport:Integer;Replacement:PChar): Boolean;far;
  { Replacement should be comma-separated list of parameters
    enclosed in double angle brackets :
    <<param1>>,<<param2>>,<<param3>>...<<paramn>>}


{ Should user be allowed to abort report when R&R is generating it by
  clicking on a cancel button ? }
function GetPreventEscape(hReport:Integer;Value:PBool): Boolean;far;
function SetPreventEscape(hReport:Integer;Value:Boolean): Boolean;far;

{ Get/set report library name and directory }
function GetLibrary(hReport:Integer;LibName:PChar;LibNameSize:Integer): Boolean;far;
function setLibrary(hreport:Integer;LibName:PChar): Boolean;far;
function setLibraryDir(hReport:Integer;DirName:PChar): Boolean;far;

{ Set username and password needed to connect to reports datasource }
function setPassword(hReport:Integer;Password:PChar): Boolean;far;
function setUserName(hReport:Integer;UserName:PChar): Boolean;far;

{ Should user be offered a test pattern before real report is printed ? }
function getTestPattern(hReport:Integer;Value:PBool): Boolean;far;
function setTestPattern(hReport:Integer;Value:Boolean): Boolean;far;

{ Read/write all configurations for current report to a ASCII file }
function getRunTimeRecord(AppName:PChar;Filename:PChar): Integer;far;
function writeRunTimeRecord(hReport:Integer;FileName:PChar): Boolean;far;

{ Should status file be updated after every page or just at report end ? }
{ status file only applicable when execRuntime is passed Wait of nonzero}
function getStatusEveryPage(hReport:Integer;Value:PBool):Boolean;far;
function setStatusEveryPage(hReport:Integer;Value:Boolean):Boolean;far;
function setStatusFileName(hReport:Integer;FileName:PChar): Boolean;far;

{ Specify a where clause for insertion in the SQL statement of#
  the Auto-SQL report specified by hReport . No effect on a user-SQL report }
function SetWhere(hReport:Integer;Where:PChar): Boolean;far;

{ Suppress title and summary areas for empty reports ? }
function setSuppressTitle(hReport:Integer;Value:Boolean): Boolean;far;

{ Get/set caption for runtime windows displayed by R&R runtime }
function setWinTitle(hReport:Integer;Title:PChar): Boolean;far;
function getWinTitle(hReport:Integer;Title:Pchar;Size:Integer): Boolean;far;

{ Style of print-preview window
  0=No Border
  1=Fixed size & single line border
  2=User can change size of preview window
  3=Fixed size and double line border }
function setWinBorderStyle(hReport:Integer;Style:Integer): Boolean;far;

{ Should preview window have a control menu ? }
function setWinControlBox(hReport:Integer;ControlBox:Boolean): Boolean;far;

{ Get/set dimensions of report preview window }
function setWinTop(hReport,WinTop:Integer): Boolean;far;
function setWinLeft(hReport,Left:Integer): Boolean;far;
function setWinWidth(hReport,WinWidth:Integer): Boolean;far;
function setWinHeight(hReport,Height:Integer): Boolean;far;

{ Allow minimize and maximise of preview window ? }
function setWinMaxButton(hReport:Integer;AllowButton:Boolean): Boolean;far;
function setWinMinButton(hReport:Integer;AllowButton:Boolean): Boolean;far;

implementation

{ Tell Delphi that all the functions are stored in RSREPORT.DLL }

function initRunTimeInstance;
  external 'RSREPORT';
function endRunTimeInstance;
  external 'RSREPORT';
function endReport;
  external 'RSREPORT';
function chooseReport;
  external 'RSREPORT';
function GetNewReportHandle;
  external 'RSREPORT';
function execRunTime;
  external 'RSREPORT';
function GetErrorInfo;
  external 'RSREPORT';
function ResetErrorInfo;
  external 'RSREPORT';
function GetBeginPage;
  external 'RSREPORT';
function SetBeginPage;
  external 'RSREPORT';
function GetEndPage;
  external 'RSREPORT';
function SetEndPage;
  external 'RSREPORT';
function GetCopies;
  external 'RSREPORT';
function SetCopies;
  external 'RSREPORT';
function ChooseDataSource;
  external 'RSREPORT';
function SetDataSource;
  external 'RSREPORT';
function GetDataSource;
  external 'RSREPORT';
function SetDisplayErrors;
  external 'RSREPORT';
function GetDisplayErrors;
  external 'RSREPORT';
function SetDisplayStatus;
  external 'RSREPORT';
function GetDisplayStatus;
  external 'RSREPORT';
function SetExportDest;
  external 'RSREPORT';
function GetExportDest;
  external 'RSREPORT';
function setFilter;
  external 'RSREPORT';
function getFilter;
  external 'RSREPORT';
function setFilterUsage;
  external 'RSREPORT';
function getFilterUsage;
  external 'RSREPORT';
function setMasterTableName;
  external 'RSREPORT';
function getMasterTableName;
  external 'RSREPORT';
function setMemoName;
  external 'RSREPORT';
function getMemoName;
  external 'RSREPORT';
function setOutputDest;
  external 'RSREPORT';
function getOutputDest;
  external 'RSREPORT';
function setOutputFile;
  external 'RSREPORT';
function getOutputFile;
  external 'RSREPORT';
function ChoosePrinter;
  external 'RSREPORT';
function getPrinter;
  external 'RSREPORT';
function setPrinter;
  external 'RSREPORT';
function SetWinParentHandle;
  external 'RSREPORT';
function SetDataDir;
  external 'RSREPORT';
function getFirstGroupField;
  external 'RSREPORT';
function getNextGroupField;
  external 'RSREPORT';
function SetGroupField;
  external 'RSREPORT';
function SetImageDir;
  external 'RSREPORT';
function GetPrinterPort;
  external 'RSREPORT';
function SetPrinterPort;
  external 'RSREPORT';
function GetReportPick;
  external 'RSREPORT';
function SetReportPick;
  external 'RSREPORT';
function GetFirstSortField;
  external 'RSREPORT';
function GetNextSortField;
  external 'RSREPORT';
function SetSortField;
  external 'RSREPORT';
function GetFirstFieldName;
  external 'RSREPORT';
function GetNextFieldName;
  external 'RSREPORT';	 
function ChooseTable;
  external 'RSREPORT';
function GetFirstJoinInfo;
  external 'RSREPORT';
function GetNextJoinInfo;
  external 'RSREPORT';
function setJoinInfo;
  external 'RSREPORT';
function GetFirstUserParam;
  external 'RSREPORT';
function GetNextUserParam;
  external 'RSREPORT';
function SetUserParam;
  external 'RSREPORT';
function GetFirstReplace;
  external 'RSREPORT';
function GetNextReplace;
  external 'RSREPORT';
function SetReplace;
  external 'RSREPORT';
function GetPreventEscape;
  external 'RSREPORT';
function SetPreventEscape;
  external 'RSREPORT';
function GetLibrary;
  external 'RSREPORT';
function setLibrary;
  external 'RSREPORT';
function setLibraryDir;
  external 'RSREPORT';
function setPassword;
  external 'RSREPORT';
function setUserName;
  external 'RSREPORT';
function getTestPattern;
  external 'RSREPORT';
function setTestPattern;
  external 'RSREPORT';
function getRunTimeRecord;
  external 'RSREPORT';
function writeRunTimeRecord;
  external 'RSREPORT';
function getStatusEveryPage;
  external 'RSREPORT';
function setStatusEveryPage;
  external 'RSREPORT';
function setStatusFileName;
  external 'RSREPORT';
function SetWhere;
  external 'RSREPORT';
function setSuppressTitle;
  external 'RSREPORT';
function setWinTitle;
  external 'RSREPORT';
function getWinTitle;
  external 'RSREPORT';
function setWinBorderStyle;
  external 'RSREPORT';
function setWinControlBox;
  external 'RSREPORT';
function setWinTop;
  external 'RSREPORT';
function setWinLeft;
  external 'RSREPORT';
function setWinWidth;
  external 'RSREPORT';
function setWinHeight;
  external 'RSREPORT';
function setWinMaxButton;
  external 'RSREPORT';
function setWinMinButton;
  external 'RSREPORT';

end.
