unit Rpform;

interface

uses
  Printers,
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, RPBase, RPCanvas, RPrinter,
  RPFiler, RPMemo, RPDBUtil, DBTables, DB;

type
  TReportForm = class(TForm)
    Label1: TLabel;
    BitBtn1: TBitBtn;
    TestReportPrinter: TReportPrinter;
    TestReportFiler: TReportFiler;
    BioLifeDataSource: TDataSource;
    BioLifeTable: TTable;
    BioLifeTableSpeciesNo: TFloatField;
    BioLifeTableCategory: TStringField;
    BioLifeTableCommon_Name: TStringField;
    BioLifeTableSpeciesName: TStringField;
    BioLifeTableLengthcm: TFloatField;
    BioLifeTableLength_In: TFloatField;
    BioLifeTableNotes: TMemoField;
    BioLifeTableGraphic: TGraphicField;
    CustomerDataSource: TDataSource;
    CustomerTable: TTable;
    OrdersDataSource: TDataSource;
    OrdersTable: TTable;
    CustomerTableCustNo: TFloatField;
    CustomerTableCompany: TStringField;
    CustomerTableAddr1: TStringField;
    CustomerTableAddr2: TStringField;
    CustomerTableCity: TStringField;
    CustomerTableState: TStringField;
    CustomerTableZip: TStringField;
    CustomerTableCountry: TStringField;
    CustomerTablePhone: TStringField;
    CustomerTableFAX: TStringField;
    CustomerTableTaxRate: TFloatField;
    CustomerTableContact: TStringField;
    CustomerTableLastInvoiceDate: TDateTimeField;

    procedure BitBtn1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);

  { Report1 functions }
    procedure PrintReport1(Sender: TObject);
    procedure BeforePrintReport1(Sender: TObject);

  { Report2 functions }
    procedure BeforePrintReport2(Sender: TObject);
    procedure PrintHeaderReport2(Sender: TObject);
    procedure PrintFooterReport2(Sender: TObject);
    function PrintPageReport2(    Sender: TObject;
                              var PageNum: integer): boolean;

  { Report3 functions }
    procedure BeforePrintReport3(Sender: TObject);
    procedure AfterPrintReport3(Sender: TObject);
    procedure PrintHeaderReport3(Sender: TObject);
    procedure PrintFooterReport3(Sender: TObject);
    function PrintPageReport3(    Sender: TObject;
                              var PageNum: integer): boolean;

  { Report4 functions }
    procedure BeforePrintReport4(Sender: TObject);
    function PrintPageReport4(    Sender: TObject;
                              var PageNum: integer): boolean;

  { Report5 functions }
    procedure BeforePrintReport5(Sender: TObject);
    procedure PrintHeaderReport5(Sender: TObject);
    function PrintPageReport5(    Sender: TObject;
                              var PageNum: integer): Boolean;
    procedure PrintFooterReport5(Sender: TObject);
  public
    GotoPrinter: boolean;
    TestBaseReport: TBaseReport;
    MemoBuf: TMemoBuf;
    FileStream: TFileStream;
  end;

var
  ReportForm: TReportForm;

implementation

{$R *.DFM}

procedure TReportForm.BitBtn1Click(Sender: TObject);

begin
  If (BitBtn1.Kind = bkCancel) then begin
    TestBaseReport.Abort;
  end else begin
    Close;
  end; { else }
end;


procedure TReportForm.FormActivate(Sender: TObject);

begin
  If GotoPrinter then begin
    TestBaseReport := TestReportPrinter;
  end else begin
    TestBaseReport := TestReportFiler;
  end; { else }

  With TestBaseReport do begin
    try
      Execute;
    finally
      BitBtn1.Kind := bkOK;
      If Aborted then begin
        StatusFormat := #13'Report Canceled!';
        UpdateStatus;
      end else begin
        StatusFormat := #13'Report Completed!';
        UpdateStatus;
      end; { else }
    end; { try }
  end; { with }
end;


{***************** Report 1 *******************}

procedure TReportForm.BeforePrintReport1(Sender: TObject);

begin { BeforePrintReport1 }
  With Sender as TBaseReport do begin
    StatusFormat := 'Printing Page %p'#13'%0'#13'%1';
    StatusText.Add('');
    StatusText.Add('');
  end; { with }
end;  { BeforePrintReport1 }


procedure TReportForm.PrintReport1(Sender: TObject);

var
  I1: integer;
  L1: longint;
  S1: string[20];
  S2: string[20];
  Bitmap: TBitmap;
  PolyLineArr: array[1..6] of TPoint;

begin { PrintReport1 }
  With Sender as TBaseReport do begin
  {*** Report Page Demo ***}
    StatusText[0] := 'Printing Report Page';
    StatusText[1] := 'Boxed columns';
    UpdateStatus;
    SectionTop := 0.75;
    SetFont('Arial',24);
    SetFont('Arial',24);
    Underline := true;
    Home;
    PrintCenter('Report Page Demo',PageWidth / 2);

    SetFont('Times New Roman',8);
    SectionBottom := 10.75;
    PrintFooter('Page ' + IntToStr(CurrentPage),pjLeft);
    PrintFooter('Date 01/20/95',pjRight);
    SectionBottom := 10.5;

    YPos := 1.5;
    SetFont('Times New Roman',12);
    SetTopOfPage;
    Home;

  { Print column headers }
    ClearTabs;
    SetPen(clBlack,psSolid,1,pmCopy); { Set pen to 1 dot width }
    SetTab(0.5,pjCenter,3.5,0,BOXLINEALL,0);
    SetTab(NA,pjCenter,1.0,0,BOXLINEALL,0);
    SetTab(NA,pjCenter,1.5,0,BOXLINEALL,0);
    SetTab(NA,pjCenter,1.5,0,BOXLINEALL,0);
    Bold := true;
    Tab(-2,NA,-2,-2,NA); { Draw tab box with heavy outer borders }
    Print('Name');
    Tab(NA,NA,-2,-2,NA); { Draw tab box with heavy outer borders }
    Print('Number');
    Tab(NA,NA,-2,-2,NA); { Draw tab box with heavy outer borders }
    Print('Amount 1');
    Tab(NA,-2,-2,-2,NA); { Draw tab box with heavy outer borders }
    Println('Amount 2');
    Bold := false;

  { Print data lines in boxes }
    ClearTabs;
    SetTab(0.5,pjLeft,3.5,2,BOXLINEALL,0);
    SetTab(NA,pjCenter,1.0,2,BOXLINEALL,0);
    SetTab(NA,pjRight,1.5,2,BOXLINEALL,10);
    SetTab(NA,pjRight,1.5,2,BOXLINEALL,0);
    For I1 := 1 to 10 do begin
      Str(I1 * 1.23:2:2,S1);
      Str(I1 * 98.76:2:2,S2);
      Print(#9'LastName' + IntToStr(I1) + ', ');
      SetFont('Times New Roman',8);
      Print('FirstName M.');
      SetFont('Times New Roman',12);
      Println(#9 + IntToStr(I1) + #9'$' + S1 + #9'$' + S2);
    end; { for }

  { Print data lines with shading }
    StatusText[1] := 'Graybar columns';
    UpdateStatus;
    ClearTabs;
    SetTab(0.5,pjLeft,3.5,2,BOXLINENONE,0);
    SetTab(NA,pjCenter,1.0,2,BOXLINENONE,0);
    SetTab(NA,pjRight,1.5,2,BOXLINENONE,0);
    SetTab(NA,pjRight,1.5,2,BOXLINENONE,0);
    For I1 := 11 to 20 do begin
      If Odd(I1) then begin
        TabShade := 0;
      end else begin
        TabShade := 15;
      end; { else }
      Str(I1 * 1.23:2:2,S1);
      Str(I1 * 98.76:2:2,S2);
      Print(#9'LastName' + IntToStr(I1) + ', ');
      SetFont('Times New Roman',8);
      Print('FirstName M.');
      SetFont('Times New Roman',12);
      Println(#9 + IntToStr(I1) + #9'$' + S1 + #9'$' + S2);
    end; { for }
    ClearTabs;

  { Columns demo }
    StatusText[1] := 'Columns of information';
    UpdateStatus;
    ClearTabs;
    SetTopOfPage;
    SectionBottom := 8.0;
    Home;
    SetFont('Times New Roman',12);
    Bold := true;
    Underline := true;
    Italic := true;
    Print('Columns (LinesLeft/ColumnLinesLeft/LineNum/ColumnNum)');
    SetTopOfPage; { Set top of page to current YPos }
    Bold := false;
    Underline := false;
    Italic := false;
    Home; { Goto home position }

    SetColumns(4,0.5); { Create 4 columns with 0.5" between each }
    While ColumnLinesLeft > 0 do begin
      Println(IntToStr(LinesLeft) + '/' + IntToStr(ColumnLinesLeft) + '/' +
       IntToStr(LineNum) + '/' + IntToStr(ColumnNum));
    end; { while }

  { Columns demo }
    StatusText[1] := 'Boxed Columns of information';
    UpdateStatus;
    ClearTabs;
    SetTopOfPage;
    SectionBottom := 10.5;
    Home;
    SetFont('Times New Roman',12);
    Bold := true;
    Italic := true;
    Print('Boxed Columns');
    SetTopOfPage; { Set top of page to current YPos }
    Bold := false;
    Italic := false;
    Home; { Goto home position }

    ClearTabs;
    SetPen(clBlack,psSolid,1,pmCopy); { Set pen to 1 dot width }
    SetTab(0.5,pjCenter,0.375,0,BOXLINEALL,0);
    SetTab(NA,pjCenter,0.375,0,BOXLINEALL,0);
    SetTab(NA,pjCenter,0.375,0,BOXLINEALL,0);
    SetTab(NA,pjCenter,0.375,0,BOXLINEALL,0);
    SetColumns(4,0.5); { Create 4 columns with 0.5" between each }
    While ColumnLinesLeft > 0 do begin
      If LineNum = 1 then begin
        TabShade := 15;
        Println(#9'LL'#9'CLL'#9'L#'#9'C#'); { Print title bar }
      end else begin
        TabShade := 0;
        Println(#9 + IntToStr(LinesLeft) + #9 + IntToStr(ColumnLinesLeft) +
         #9 + IntToStr(LineNum) + #9 + IntToStr(ColumnNum));
      end; { else }
    end; { while }
    SetColumns(1,0);

  {*** Graphics page demonstration ***}
    NewPage;
    ResetSection;
    StatusText[0] := 'Printing Graphics Page';
    UpdateStatus;
    SetFont('Arial',24);
    Underline := true;
    Home;
    PrintCenter('Graphics Page Demo',PageWidth / 2);
    SetFont('Times New Roman',8);

    SectionBottom := 10.75; { Temporarily move the section bottom down }
    PrintFooter('Page ' + IntToStr(CurrentPage),pjLeft);
    PrintFooter('Date 01/20/95',pjRight);
    SectionBottom := 10.5; { Reset section bottom }

    OriginX := 0.0;
    OriginY := 0.5;
    SetFont('Arial',10);

  { Arc/Chord demo }
    StatusText[1] := 'GDI functions';
    UpdateStatus;
    SetPen(clBlack,psSolid,-2,pmCopy); { Set pen to black 2/100ths" wide }
    YPos := 0.95;
    PrintCenter('Arc() and Chord()',2.125);
    Arc(1.125,1.0,3.125,3.0,3.125,2.0,0.0,0.0);
    SetBrush(clBlack,bsClear,nil);
    Chord(1.125,1.0,3.125,3.0,0.0,0.8,3.125,2.25);

  { Pie demo }
    YPos := 0.95;
    PrintCenter('Pie()',4.25);
    SetPen(clBlack,psSolid,-2,pmCopy); { Set pen to black 2/100ths" wide }
    SetBrush(clBlack,bsHorizontal,nil);
    Pie(3.25,1.0,5.25,3.0,5.25,2.0,0.0,0.0);
    SetBrush(clBlack,bsVertical,nil);
    Pie(3.25,1.0,5.25,3.0,0.0,0.0,3.25,7.0);
    SetBrush(clBlack,bsBDiagonal,nil);
    Pie(3.25,1.0,5.25,3.0,3.25,7.0,5.25,2.0);

  { Ellipse demo }
    YPos := 1.2;
    PrintCenter('Ellipse()',6.375);
    SetBrush(clBlack,bsCross,nil);
    Ellipse(5.375,1.25,7.375,2.75);

  { RoundRect Demo }
    YPos := 3.4;
    PrintCenter('RoundRect()',2.125);
    SetBrush(clBlack,bsDiagCross,nil);
    RoundRect(1.125,3.5,3.125,5.0,0.25,0.25);
    YPos := 4.0;
    SetBrush(clBlack,bsSolid,nil);
    TextBKMode := bkOpaque;
    BKColor := clWhite;
    PrintCenter('Opaque Text',2.125);
    YPos := 4.5;
    TextBKMode := bkTransparent;
    PrintCenter('Transparent Text',2.125);

  { Polyline demo }
    YPos := 3.4;
    PrintCenter('psDash w/ PolyLine()',4.25);
    OriginX := 4.25; { Set origin for simpler calc }
    OriginY := 5.0;
    SetPen(clBlack,psDash,-2,pmCopy); { Set pen to black 2/100ths" wide }
    PolyLineArr[1] := CreatePoint(0,-1);
    PolyLineArr[2] := CreatePoint(-0.59,0.81);
    PolyLineArr[3] := CreatePoint(0.95,-0.31);
    PolyLineArr[4] := CreatePoint(-0.95,-0.31);
    PolyLineArr[5] := CreatePoint(0.59,0.81);
    PolyLineArr[6] := CreatePoint(0,-1);
    PolyLine(PolyLineArr);
    OriginX := 0.0; { Reset origin }
    OriginY := 0.5;

  { PaintBitmap demo }
    YPos := 3.4;
    PrintCenter('PaintBitmapRect()',6.375);
    Bitmap := TBitmap.Create;
    Bitmap.LoadFromFile('RPDEMO.BMP');
    PrintBitmapRect(5.375,3.5,7.375,5.5,Bitmap);
    Bitmap.Free;

  { Units demo }
    StatusText[1] := 'Units demo';
    UpdateStatus;
    SetPen(clBlack,psSolid,-1,pmCopy); { Set pen to black 1/100ths" wide }
    GotoXY(1.0,5.5);
    Bold := true;
    Underline := true;
    Italic := true;
    Print('Units Demonstration');
    Bold := false;
    Underline := false;
    Italic := false;

  { Draw inches ruler }
    Units := unInch;
    GotoXY(1.0,5.75);
    Bold := true;
    Print('Inches');
    Bold := false;
    YPos := 6.0;
    MoveTo(1.0,6.25);
    LineTo(7.0,6.25);
    For I1 := 0 to 6 do begin
      PrintCenter(IntToStr(I1),I1 + 1);
      MoveTo(I1 + 1,6.05);
      LineTo(I1 + 1,6.25);
    end; { for }

  { Draw millimeters ruler }
    Units := unMM;
    OriginY := 12.7; { Set to 1/2 inch down }
    GotoXY(25.4,170);
    Bold := true;
    Print('Millimeters');
    Bold := false;
    YPos := 175;
    MoveTo(25.4,180);
    LineTo(175.4,180);
    For I1 := 0 to 15 do begin
      PrintCenter(IntToStr(I1 * 10),I1 * 10 + 25.4);
      MoveTo(I1 * 10 + 25.4,176);
      LineTo(I1 * 10 + 25.4,180);
    end; { for }
    Units := unInch; { Set units back to inches }

  { Text at specific locations }
    StatusText[1] := 'Text at specific locations';
    UpdateStatus;
    OriginX := 0.0; { Set origin to normal }
    OriginY := 0.0;
    GotoXY(1.0,8.5);
    Print('Text @ 1.0,8.5');
    GotoXY(6.0,8.5);
    Println('Text @ 6.0,8.5');
    GotoXY(2.0,9.0);
    Println('Text @ 2.0,9.0');
    GotoXY(3.0,9.5);
    Println('Text @ 3.0,9.5');
  end; { with }
end;  { PrintReport1 }


{***************** Report 2 *******************}

procedure TReportForm.BeforePrintReport2(Sender: TObject);

begin { BeforePrintReport2 }
  With Sender as TBaseReport do begin
    StatusFormat := 'Printing Page %p'#13'%0'#13'%1';
    StatusText.Add('');
    StatusText.Add('');
  end; { with }
  BioLifeTable.First; { Position on the first record }
end;  { BeforePrintReport2 }


procedure TReportForm.PrintHeaderReport2(Sender: TObject);

begin { PrintHeaderReport2 }
  With Sender as TBaseReport do begin
    SectionTop := 0.5;
    SetFont('Arial',24);
    Underline := true;
    Home;
    PrintCenter('Biolife Database Report Demo',PageWidth / 2);
  end; { with }
end;  { PrintHeaderReport2 }


function TReportForm.PrintPageReport2(    Sender: TObject;
                                      var PageNum: integer): Boolean;

var
  I1: integer;
  S1: string[20];
  DBMemoBuf: TDBMemoBuf;
  Stream: TMemoryStream;
  Bitmap: TBitmap;
  Lines: integer;

begin { PrintPageReport2 }
  With Sender as TBaseReport do begin
    SectionTop := 1.25;
    SectionBottom := 10.0;
    SetFont('Times New Roman',10);
    Home;

  { Print column headers }
    SetPen(clBlack,psSolid,1,pmCopy); { Set pen to 1 dot width }
    ClearTabs;
    SetTab(0.5,pjCenter,1.25,0,BOXLINEALL,0);
    SetTab(NA,pjCenter,1.0,0,BOXLINEALL,0);
    SetTab(NA,pjCenter,5.25,0,BOXLINEALL,0);
    Bold := true;
    Tab(-2,NA,-2,-2,NA); { Draw tab box with heavy outer borders }
    Print('Common Name');
    Tab(NA,NA,-2,-2,NA); { Draw tab box with heavy outer borders }
    Print('Image');
    Tab(NA,-2,-2,-2,NA); { Draw tab box with heavy outer borders }
    Println('Notes');
    Bold := false;

  { Print data lines in boxes }
    ClearTabs;
    SetTab(0.5,pjLeft,1.25,2,BOXLINEVERT,0);
    SetTab(NA,pjLeft,1.0,2,BOXLINEVERT,0);
    SetTab(NA,pjLeft,5.25,2,BOXLINEVERT,0);
    DBMemoBuf := TDBMemoBuf.Create;
    try
      DBMemoBuf.PrintStart := TabStart(3);
      DBMemoBuf.PrintEnd := TabEnd(3);
      Repeat
        DBMemoBuf.Field := BioLifeTableNotes;
        Lines := MemoLines(DBMemoBuf);
        If Lines < 7 then begin { Check to see if memo is too short }
          Lines := 7;
        end; { if }
        If Lines > LinesLeft then begin { See if we have enough space left }
          Break; { Go to the next page }
        end; { if }

      { Print Name }
        Print(#9 + BioLifeTableCommon_Name.AsString);

      { Print Bitmap }
        Print(#9);
        Bitmap := TBitmap.Create;
        try
          GraphicFieldToBitmap(BioLifeTableGraphic,Bitmap);
          PrintBitmapRect(XPos,YPos,XPos + TabWidth(0),YPos + TabWidth(0),Bitmap);
        finally
          Bitmap.Free;
        end; { try }

      { Draw memo field }
        PrintMemo(DBMemoBuf,Lines,true);

      { Draw line on bottom of memo field }
        Tab(0,0,1,0,NA);
        Tab(0,0,1,0,NA);
        Tab(0,0,1,0,NA);
        ResetTabs; { Reset tabs back }

        BioLifeTable.Next;
      until BioLifeTable.EOF;
    finally
      DBMemoBuf.Free;
    end; { try }
  end; { with }

  Result := (not BioLifeTable.EOF) and (PageNum < 3);
end;  { PrintPageReport2 }


procedure TReportForm.PrintFooterReport2(Sender: TObject);

begin { PrintFooterReport2 }
  With Sender as TBaseReport do begin
    SetFont('Times New Roman',8);
    SectionBottom := 10.5;
    PrintFooter('Page ' + IntToStr(CurrentPage),pjLeft);
    PrintFooter('Date 01/20/95',pjRight);
    SectionBottom := 10.0;
  end; { with }
end;  { PrintFooterReport2 }


{***************** Report 3 *******************}

procedure TReportForm.BeforePrintReport3(Sender: TObject);

begin { BeforePrintReport3 }
  With Sender as TBaseReport do begin
    StatusFormat := 'Printing Page %p'#13'%0'#13'%1';
    StatusText.Add('');
    StatusText.Add('');

    MarginTop := 1.0;
    MarginBottom := 1.0;

  { Create memo buffer }
    MemoBuf := TDBMemoBuf.Create;
  { Load up MemoBuf from file }
    FileStream := TFileStream.Create('RPDEMO.TXT',fmOpenRead);
    try
      MemoBuf.LoadFromStream(FileStream,0);
    finally
      FileStream.Free;
    end; { try }
  end; { with }
end;  { BeforePrintReport3 }


procedure TReportForm.AfterPrintReport3(Sender: TObject);

begin { AfterPrintReport3 }
  MemoBuf.Free;
end;  { AfterPrintReport3 }


procedure TReportForm.PrintHeaderReport3(Sender: TObject);

begin { PrintHeaderReport3 }
  With Sender as TBaseReport do begin
    MarginTop := 0.5;
    SetFont('Arial',24);
    Underline := true;
    Home;
    PrintCenter('Document Demo',PageWidth / 2);
    MarginTop := 1.0;
    SetColumns(3,0.25);
  end; { with }
end;  { PrintHeaderReport3 }


function TReportForm.PrintPageReport3(    Sender: TObject;
                                      var PageNum: integer): Boolean;

var
  I1: integer;
  S1: string[20];
  Lines: integer;

begin { PrintPageReport3 }
  With Sender as TBaseReport do begin
    SetFont('Times New Roman',10);
    Home;

  { Print memo buffer }
    SetColumns(3,0.25);
    MemoBuf.PrintStart := ColumnStart;
    MemoBuf.PrintEnd := ColumnEnd;
    PrintMemo(MemoBuf,ColumnLinesLeft,false);
    ClearColumns;

    Result := not MemoBuf.Empty;
  end; { with }
end;  { PrintPageReport3 }


procedure TReportForm.PrintFooterReport3(Sender: TObject);

begin { PrintFooterReport3 }
  With Sender as TBaseReport do begin
    SetFont('Times New Roman',8);
    MarginBottom := 0.5;
    PrintFooter('Page ' + IntToStr(CurrentPage),pjLeft);
    PrintFooter('Date 01/20/95',pjRight);
    MarginBottom := 1.0;
  end; { with }
end;  { PrintFooterReport3 }


{***************** Report 4 - Labels Report *******************}

procedure TReportForm.BeforePrintReport4(Sender: TObject);

begin { BeforePrintReport4 }
  With Sender as TBaseReport do begin
    StatusFormat := 'Printing Page %p'#13'%0'#13'%1';
    StatusText.Add('');
    StatusText.Add('');

    MarginLeft := 0.15; { Margins on each label }
    MarginRight := 0.0;
    MarginTop := 0.0;
    MarginBottom := 0.0;
  end; { with }
  CustomerTable.First;
end;  { BeforePrintReport4 }


function TReportForm.PrintPageReport4(    Sender: TObject;
                                      var PageNum: integer): Boolean;

var
  Row: integer;
  Col: integer;
  Lines: integer;
  LabelWidth: double;
  LabelHeight: double;
  LabelLeftMargin: double;
  LabelTopMargin: double;

begin { PrintPageReport4 }
  With Sender as TBaseReport do begin
    SetFont('Arial',12);

  { Set up for Avery 5260 labels (1" x 2-5/8") }
    LabelWidth := 2.8; { Width from one label to the same edge on the next label }
    LabelHeight := 1.0; { Height from one label to the same edge on the next label }
    LabelLeftMargin := 0.15; { Left margin of first label }
    LabelTopMargin := 0.5; { Top margin of first label }

  { Process through each label on the page }
    For Row := 0 to 9 do begin
      If CustomerTable.EOF then Break;
      For Col := 0 to 2 do begin
        If CustomerTable.EOF then Break;
        OriginX := Col * LabelWidth + LabelLeftMargin;
        OriginY := Row * LabelHeight + LabelTopMargin;
        Home;

      { Print a label from current record }
        Println(CustomerTableCompany.AsString);
        Println(CustomerTableAddr1.AsString);
        If CustomerTableAddr2.AsString <> '' then begin
          Println(CustomerTableAddr2.AsString);
        end; { if }
        Print(CustomerTableCity.AsString);
        If CustomerTableState.AsString = '' then begin
          Println(', ' + CustomerTableCountry.AsString);
        end else begin
          Println('  ' + CustomerTableState.AsString + ', ' +
           CustomerTableZip.AsString);
        end; { else }

      { Get next record }
        CustomerTable.Next;
      end; { for }
    end; { for }

    Result := not CustomerTable.EOF;
  end; { with }
end;  { PrintPageReport4 }


{***************** Report 5 *******************}

procedure TReportForm.BeforePrintReport5(Sender: TObject);

begin { BeforePrintReport5 }
  With Sender as TBaseReport do begin
    StatusFormat := 'Printing Page %p'#13'%0'#13'%1';
    StatusText.Add('');
    StatusText.Add('');

    MarginLeft := 0.5;
    MarginRight := 0.5;
    MarginTop := 0.5;
    MarginBottom := 1.0;
  end; { with }
  CustomerTable.First;
end;  { BeforePrintReport5 }


procedure TReportForm.PrintHeaderReport5(Sender: TObject);

begin { PrintHeaderReport5 }
  With Sender as TBaseReport do begin
    MarginTop := 0.5;
    SetFont('Arial',24);
    Underline := true;
    Home;
    PrintCenter('Customer List',PageWidth / 2);
    MarginTop := 1.0;
  end; { with }
end;  { PrintHeaderReport5 }


function TReportForm.PrintPageReport5(    Sender: TObject;
                                      var PageNum: integer): Boolean;

var
  I1: integer;
  S1: string[20];
  Lines: integer;

begin { PrintPageReport5 }
  With Sender as TBaseReport do begin
    SetFont('Times New Roman',10);
    Home;

    ClearTabs;
    SetTab(0.5,pjCenter,2.5,2,BOXLINEALL,0);
    SetTab(NA,pjCenter,1.25,2,BOXLINEALL,0);
    SetTab(NA,pjCenter,1.25,2,BOXLINEALL,0);
    SetTab(NA,pjCenter,0.5,2,BOXLINEALL,0);
    SetTab(NA,pjCenter,2.0,2,BOXLINEALL,0);
    Println(#9'Company'#9'Phone'#9'Fax'#9'Tax'#9'Contact');

    ClearTabs;
    SetTab(0.5,pjLeft,2.5,2,BOXLINEALL,0);
    SetTab(NA,pjCenter,1.25,2,BOXLINEALL,0);
    SetTab(NA,pjCenter,1.25,2,BOXLINEALL,0);
    SetTab(NA,pjRight,0.5,2,BOXLINEALL,0);
    SetTab(NA,pjLeft,2.0,2,BOXLINEALL,0);
    While (LinesLeft > 0) and not CustomerTable.EOF do begin
      Print(#9 + CustomerTableCompany.AsString);
      Print(#9 + CustomerTablePhone.AsString);
      Print(#9 + CustomerTableFax.AsString);
      Print(#9 + CustomerTableTaxRate.AsString);
      Println(#9 + CustomerTableContact.AsString);
      CustomerTable.Next;
    end; { while }

    Result := not CustomerTable.EOF;
  end; { with }
end;  { PrintPageReport5 }


procedure TReportForm.PrintFooterReport5(Sender: TObject);

begin { PrintFooterReport5 }
  With Sender as TBaseReport do begin
    SetFont('Times New Roman',8);
    MarginBottom := 0.5;
    PrintFooter('Page ' + IntToStr(CurrentPage),pjLeft);
    PrintFooter('Date 01/20/95',pjRight);
    MarginBottom := 1.0;
  end; { with }
end;  { PrintFooterReport5 }


end. { RPForm }

