unit Rptest;

interface

uses
  RPForm, Preview, Printers,
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls;

type
  TMainForm = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    GroupBox1: TGroupBox;
    RBReport1: TRadioButton;
    RBReport2: TRadioButton;
    GroupBox2: TGroupBox;
    RBPrinter: TRadioButton;
    RBPreview: TRadioButton;
    Label4: TLabel;
    RBReport3: TRadioButton;
    RBReport4: TRadioButton;
    RBReport5: TRadioButton;
    Label5: TLabel;
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.BitBtn1Click(Sender: TObject);

begin
  Close;
end;


procedure TMainForm.BitBtn2Click(Sender: TObject);

var
  ReportStream: TMemoryStream;
  Aborted: boolean;

begin
{ Generate report file }
  ReportForm := TReportForm.Create(self);
  With ReportForm do begin
    GotoPrinter := RBPrinter.Checked;
    If GotoPrinter then begin
      TestBaseReport := TestReportPrinter;
    end else begin
      TestBaseReport := TestReportFiler;
      ReportStream := TMemoryStream.Create;
      TestReportFiler.Stream := ReportStream;
    end; { else }

    try
      With TestBaseReport do begin
        If RBReport1.Checked then begin
          OnPrintPage := nil;
          OnPrint := PrintReport1;
          OnBeforePrint := BeforePrintReport1;
          OnAfterPrint := nil;
          OnPrintHeader := nil;
          OnPrintFooter := nil;
          OnNewPage := nil;
          OnNewColumn := nil;
        end else if RBReport2.Checked then begin
          OnPrintPage := PrintPageReport2;
          OnPrint := nil;
          OnBeforePrint := BeforePrintReport2;
          OnAfterPrint := nil;
          OnPrintHeader := PrintHeaderReport2;
          OnPrintFooter := PrintFooterReport2;
          OnNewPage := nil;
          OnNewColumn := nil;
        end else if RBReport3.Checked then begin
          OnPrintPage := PrintPageReport3;
          OnPrint := nil;
          OnBeforePrint := BeforePrintReport3;
          OnAfterPrint := AfterPrintReport3;
          OnPrintHeader := PrintHeaderReport3;
          OnPrintFooter := PrintFooterReport3;
          OnNewPage := nil;
          OnNewColumn := nil;
        end else if RBReport4.Checked then begin
          OnPrintPage := PrintPageReport4;
          OnPrint := nil;
          OnBeforePrint := BeforePrintReport4;
          OnAfterPrint := nil;
          OnPrintHeader := nil;
          OnPrintFooter := nil;
          OnNewPage := nil;
          OnNewColumn := nil;
        end else if RBReport5.Checked then begin
          OnPrintPage := PrintPageReport5;
          OnPrint := nil;
          OnBeforePrint := BeforePrintReport5;
          OnAfterPrint := nil;
          OnPrintHeader := PrintHeaderReport5;
          OnPrintFooter := PrintFooterReport5;
          OnNewPage := nil;
          OnNewColumn := nil;
        end; { else }
      end; { with }

    { Print report }
      Aborted := true;
      try
        ReportForm.ShowModal;
        Aborted := ReportForm.TestBaseReport.Aborted;
      finally
        ReportForm.Free;
      end; { try }

    { Goto preview form }
      If not GotoPrinter and not Aborted then begin
        PreviewForm := TPreviewForm.Create(self);
        PreviewForm.FilePrinter1.Stream := ReportStream;
        PreviewForm.FilePreview1.Stream := ReportStream;
        try
          PreviewForm.ShowModal;
        finally
          PreviewForm.Free;
        end; { try }
      end; { if }
    finally
      If not GotoPrinter then begin
        ReportStream.Free;
      end; { if }
    end; { try }
  end; { with }
end;


end.
