{Form to use as 'Roll Up', similar to Corel, Photoshop, etc.

by Casey Charlton - 29/6/95  (casey@larouss.demon.co.uk)

based on code by Anders Ohlsson (ao@it.kth.se)

This form is Freeware, please use it as you want. If you find
it useful, send me an message - casey@larouss.demon.co.uk

To use it - Enlarge the 'FormArea' panel to the size that you want
the roll up to cover, and place your controls within it. Edit the
FormCreate code to change colors, caption, etc.   }

unit Rollform;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, Buttons;

type
  TRollUp = class(TForm)
    Panel1: TPanel;
    FormArea: TPanel;
    CaptionLabel: TLabel;
    CloseButton: TSpeedButton;
    UpButton: TSpeedButton;
    DownButton: TSpeedButton;
    RollButton: TSpeedButton;
    procedure Panel1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Panel1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Panel1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure RollButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CloseButtonClick(Sender: TObject);
  private
    { Private declarations }
    OldX,
    OldY,
    OldLeft,
    OldTop,
    RolledDownHeight   : Integer;
    ScreenDC           : HDC;
    MoveRect           : TRect;
    Moving             : Boolean;
  public
    { Public declarations }
  end;

var
  RollUp: TRollUp;

implementation

{$R *.DFM}

{Anders Ohlsson's code starts here}
procedure TRollUp.Panel1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if Button = mbLeft then begin
    SetCapture(Panel1.Handle);
    ScreenDC := GetDC(0);
    OldX := X;
    OldY := Y;
    OldLeft := X;
    OldTop := Y;
    MoveRect := BoundsRect;
    DrawFocusRect(ScreenDC,MoveRect);
    Moving := True;
  end;
end;

procedure TRollUp.Panel1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if Moving then begin
    DrawFocusRect(ScreenDC,MoveRect);
    OldX := X;
    OldY := Y;
    MoveRect := Rect(Left+OldX-OldLeft,Top+OldY-OldTop,
                     Left+Width+OldX-OldLeft,Top+Height+OldY-OldTop);
    DrawFocusRect(ScreenDC,MoveRect);
  end;
end;

procedure TRollUp.Panel1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if Button = mbLeft then begin
    ReleaseCapture;
    DrawFocusRect(ScreenDC,MoveRect);
    Left := Left+X-OldLeft;
    Top := Top+Y-OldTop;
    ReleaseDC(0,ScreenDC);
    Moving := False;
  end;
end;
{Anders Ohlsson's code ends here}

procedure TRollUp.RollButtonClick(Sender: TObject);
begin
     if ClientHeight = RolledDownHeight then        {it's currently down}
        begin
             ClientHeight := Panel1.Height;         {set it to the caption bar's height}
             RollButton.Glyph := DownButton.Glyph;  {change arrow}
        end
        else
        begin                                       {it's rolled up}
             ClientHeight := RolledDownHeight;      {set it to full size}
             RollButton.Glyph := UpButton.Glyph;    {change arrow}
        end;
end;

procedure TRollUp.FormCreate(Sender: TObject);
begin
{Position buttons - correct for panel as default,
 adjust if necessary}
     CloseButton.Left := 1;
     CloseButton.Top := 0;
     RollButton.Left := Panel1.ClientWidth - RollButton.Width - 1;
     RollButton.Top :=0;
{Preserve height of form}
     RolledDownHeight := ClientHeight;
{Position form on screen}
     Top := 300;
     Left := 200;
{Set colour of title bar (Panel1) and caption}
     Panel1.Color := clNavy;
     CaptionLabel.Font.Color := clWhite;
{Set the caption}
     CaptionLabel.Caption := 'Caption';
end;

procedure TRollUp.CloseButtonClick(Sender: TObject);
begin
{Close clicked - close down form. Use .Show to bring
 it back again}
     Close;
end;

end.
