unit Mastrpt1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Reports, StdCtrls, DB, DBTables;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Query1: TQuery;
    Query1CustNo: TFloatField;
    Query1Company: TStringField;
    Query1Addr1: TStringField;
    Query1Addr2: TStringField;
    Query1City: TStringField;
    Query1State: TStringField;
    Query1Zip: TStringField;
    Query1Country: TStringField;
    Query1Phone: TStringField;
    Query1FAX: TStringField;
    Query1TaxRate: TFloatField;
    Query1Contact: TStringField;
    Query1LastInvoiceDate: TDateTimeField;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Procedure ReportInit;
    Procedure ReportDone;

    Procedure PrintHeader     ( HeaderBand  : tFixedReportBand;
                                var Status  : tBandStatus );

    Procedure InitItem        ( DetailBand  : tRecurringReportBand );
    Procedure PrintItem       ( DetailBand  : tFixedReportBand;
                                var Status  : tBandStatus );

  end;

var
  Form1: TForm1;

implementation
Uses pStatus;

{$R *.DFM}

procedure tForm1.ReportInit;
Begin
     { prevent the user from hitting another key while printing }
     Enabled := False;

     With PrintStatusForm Do
     Begin
          ProgressGauge.MaxValue := 100;
          ProgressGauge.Progress := 0;
          CurrentPage := 1;
          PrintStatus := 'Loading Data...';
          PrinterName := Reporter.Printers[Reporter.PrinterIndex];
          Show;
          UpdateStatus;
     End;

     { Open needed table(s) }
     Query1.Open;

     With PrintStatusForm Do
     Begin
          ProgressGauge.MaxValue := Query1.RecordCount;
          PrintStatus := 'Printing...';
          UpdateStatus;
     End;

     { set the margins and define the font styles }
     With Reporter Do
     Begin
          TopMargin.AsInches := 2.0;
          LeftMargin.AsInches := 0.25;
          RightMargin.AsInches := 0.25;
          BottomMargin.AsInches := 1.0;

          { Set the Report's default unit to inches }
          PreferredUnit := puInches;

          Canvas.Font.Size := 9;
          Canvas.Font.Style := [];
          Canvas.Font.Name  := 'Arial';
          CreateFontStyle ( 'Detail1' );

          Canvas.Font.Size := 10;

          Canvas.Font.Style := [fsBold];
          CreateFontStyle ( 'Detail2' );
          CreateFontStyle ( 'Heading1' );
          Canvas.Font.Color := clWhite;
          CreateFontStyle ( 'Heading2' );
          Canvas.Font.Color := clBlack;

          Canvas.Font.Size := 14;
          CreateFontStyle ( 'Detail3' );

          Canvas.Font.Size := 18;
          CreateFontStyle ( 'Heading3' );

          Canvas.Font.Size := 42;
          Canvas.Font.Style := [fsBold,fsItalic];
          Canvas.Font.Name  := 'Times New Roman';
          CreateFontStyle ( 'Heading4' );
     End;
End;

procedure tForm1.ReportDone;
Begin
     { Close opened table(s) }
     Query1.Close;

     { enable the main form and close the print status dialog }
     Enabled := True;

     PrintStatusForm.Close;
End;

procedure tForm1.PrintHeader (     HeaderBand : tFixedReportBand;
                               var Status     : tBandStatus );
Begin
     With HeaderBand, Reporter Do
     Begin
          { plop a 1/2 inch box onto the bottom of the header.  note that
            I use ConvertWidth to convert inches to dots, even though I've
            set inches as the Reporter's default unit.  This is because
            this output call is made directly to the canvas, not through
            the Reporter's output functions.  The canvas only uses dots/
            pixels, so I need to convert inches to dots }

          Canvas.Brush.Color := clDkGray;
          Canvas.Brush.Style := bsSolid;
          Canvas.Rectangle ( Left,  Bottom - ConvertHeight.Inches(0.5).AsDots,
                             Right, Bottom );
          Canvas.Brush.Color := clWhite;


          { do all the text output now }

          { save the current font }
          SaveFont;

          { output page number }
          SetFontStyle ( 'Heading1' );
          TopOfBand;
          TextOut ( 'Page ' + IntToStr ( PageNumber ), ttaRightMargin );


          { output report heading }
          SetFontStyle ( 'Heading3' );
          MoveY ( 0.25 ); { move down 1/4 inch from top of header }
          TextOut ( 'Customer List', ttaBandHCenter );
          NextLine;

          SetFontStyle ( 'Heading1' );
          TextOut ( 'By Last Invoice', ttaBandHCenter );

          { output company name }
          SetFontStyle ( 'Heading4' );
          Canvas.Brush.Style := bsClear;
          BottomOfBand;
          AdjustY ( -0.5 );
          TextOut ( 'M.A.S.T.', ttaLeftMargin );


          { output column headings }
          SetFontStyle ( 'Heading2' );
          Canvas.Brush.Style := bsClear;

          { position the text just above the bottom of the band }
          BottomOfBand;
          AdjustY ( -0.1 );

          TabTo ( 0.655 );
          TextOut ( 'Last Invoice', ttaCenter );

          TabTo ( 1.25 );
          TextOut ( 'Address', ttaLeft );

          TabTo ( 5.75 );
          TextOut ( 'Fax', ttaLeft );

          { move just a little right of the right margin }
          RightOfBand;
          RelativeTabTo ( -0.1 );
          TextOut ( 'Customer No.', ttaRight );

          PreviousLine;
          TabTo ( 1.25 );
          TextOut ( 'Customer', ttaLeft );

          TabTo ( 5.75 );
          TextOut ( 'Phone', ttaLeft );

          { restore previous font }
          Reporter.RestoreFont;

     End;
End;

procedure tForm1.InitItem ( DetailBand : tRecurringReportBand );
Begin
     { Here we inform the Reporter of the height of the Detail band.
       This allows it to avoid breaking a record across pages.  I'm
       giving each band the height of two 14 point lines }

     With DetailBand, Reporter Do
     Begin
          { every output call between SetBandBegin and SetBandEnd is
            used to set the height of the band.  Once this is done, the
            Reporter will not allow a band to be split across pages }
          SetBandBegin;

          SaveFont;

          SetFontStyle ( 'Detail3' );
          NextLine;
          NextLine;

          RestoreFont;

          SetBandEnd;
     End;

     (DetailBand as tRecurringReportBand).SetBandEnd;
End;

procedure tForm1.PrintItem   (     DetailBand : tFixedReportBand;
                               var Status     : tBandStatus );
Begin
     With DetailBand, Reporter Do
     Begin
          SetFontStyle ( 'Detail3' );
          TabTo ( 1.25 );
          TextOut ( Query1Company.AsString, ttaLeft );
          NextLine;

          { These two curious statements position us (vertically) to
            where we need to be to print out the phone number.  This
            kind of move is necessary, because the Reporter prints the
            upper left corner of the text at the current X, Y. }
          SetFontStyle ( 'Detail2' );
          PreviousLine;

          { position ourselves and output the phone number }
          TabTo ( 5.75 );
          TextOut ( Query1Phone.AsString, ttaLeft );
          NextLine;

          { position ourselves and output the last invoice date }
          TabTo ( 0.655 );
          TextOut ( DateToStr(Query1LastInvoiceDate.Value), ttaCenter );

          { position ourselves and output the address }
          SetFontStyle ( 'Detail1' );
          TabTo ( 1.25 );
          TextOut ( Query1Addr1.AsString + '  ' +
                    Query1Addr2.AsString + '  ' +
                    Query1City.AsString  + ', ' +
                    Query1State.AsString + ' ' +
                    Query1Zip.AsString + ' ' +
                    Query1Country.AsString,
                    ttaLeft );

          { position ourselves and output the fax number }
          SetFontStyle ( 'Detail2' );
          TabTo ( 5.75 );
          TextOut ( Query1Fax.AsString, ttaLeft );

          { position ourselves and output the customer number }
          RightOfBand;
          RelativeTabTo ( -0.1 );
          TextOut ( Query1CustNo.AsString, ttaRight );
     End;


     With PrintStatusForm Do
     Begin
          ProgressGauge.Progress := ProgressGauge.Progress + 1;
          CurrentPage := Reporter.PageNumber;
          UpdateStatus;
     End;

     Query1.Next;
     If PrintStatusForm.Canceled Then
        Status := bsAbort
     Else If Query1.EOF Then
        Status := bsDone;
End;


procedure TForm1.Button1Click(Sender: TObject);
begin
     Reporter.OnReportInit := ReportInit;
     Reporter.OnReportDone := ReportDone;

     Reporter.AddHeader ( PrintHeader );
     Reporter.AddDetail ( InitItem, PrintItem );

     Reporter.Run;
end;

end.
