 unit Boxrpt1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Reports, StdCtrls, DB, DBTables;

type
  TForm1 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }

    Procedure ReportInit;
    Procedure ReportDone;

    Procedure BetweenPages;

    Procedure PrintHeader (     HeaderBand : tFixedReportBand;
                            var Status     : tBandStatus );

    Procedure PrintHeader2 (     HeaderBand : tFixedReportBand;
                             var Status     : tBandStatus );

    Procedure PrintItem       ( DetailBand  : tFixedReportBand;
                                var Status  : tBandStatus );

  end;

var
  Form1: TForm1;

implementation
Uses PStatus, Printers;

{$R *.DFM}

procedure tForm1.ReportInit;
Begin
     { prevent user from pressing key while printing }
     Enabled := False;

     With PrintStatusForm Do
     Begin
          ProgressGauge.MaxValue := 2;
          ProgressGauge.Progress := 0;
          CurrentPage := 1;
          PrintStatus := 'Printing...';
          PrinterName := Reporter.Printers[Reporter.PrinterIndex];
          Show;
          UpdateStatus;
     End;
End;

procedure tForm1.ReportDone;
Begin
     { get rid of the print status dialog and enable the form again }
     Enabled := True;

     PrintStatusForm.Close;
End;

procedure tForm1.BetweenPages;
Begin
     { replace current header with new header }
     If Reporter.PageNumber = 1 Then
     Begin
          Reporter.AddHeader ( PrintHeader2 );
          Reporter.Orientation := poLandscape;
     End;
End;

procedure tForm1.PrintHeader (     HeaderBand : tFixedReportBand;
                               var Status     : tBandStatus );
Begin
     With HeaderBand, Reporter Do
     Begin
          Canvas.Font.Size := 18;
          Canvas.Font.Style := [fsBold];
          BoxTextOut ( 'Header Change Example', ttaBandHCenter + ttaBandVCenter,
                       btBox, 20, 10,
                       stBottomRight, 20 );
     End;
End;

procedure tForm1.PrintHeader2 (     HeaderBand : tFixedReportBand;
                                var Status     : tBandStatus );
Begin
     With HeaderBand, Reporter Do
     Begin
          Canvas.Font.Size := 10;
          Canvas.Font.Style := [fsBold];
          TextOut ( 'Page ' + IntToStr ( Reporter.PageNumber ),
                    ttaTopOfBand + ttaRightMargin );

          Canvas.Font.Size := 18;
          BoxTextOut ( 'Orientation Change Example', ttaBandHCenter + ttaBandVCenter,
                       btBox, 20, 2,
                       stBottomRight, 10 );
     End;
End;

procedure tForm1.PrintItem   (     DetailBand : tFixedReportBand;
                               var Status     : tBandStatus );
Var
   Offset, Gap : Word;
Begin
     With DetailBand, Reporter Do
     Begin
          Canvas.Brush.Style := bsClear;
          Gap := (Bottom-Top) Div 10;
          For Offset := 0 to 3 Do
              Canvas.Rectangle ( Left   + Offset * Gap,
                                 Top    + Offset * Gap,
                                 Right  - Offset * Gap,
                                 Bottom - Offset * Gap );


          With PrintStatusForm Do
          Begin
               ProgressGauge.Progress := ProgressGauge.Progress + 1;
               CurrentPage := Reporter.PageNumber;
               UpdateStatus;
          End;


          { note:  the manual advancement of the page is necessary because
                   I'm not attempting to print below the margin of the
                   detail band (which is normally used to force the
                   report to a new page) }
          If ( PrintStatusForm.Canceled ) Then
             Status := bsAbort
          Else If ( PageNumber = 2 ) Then
             Status := bsDone
          Else
              NewPage;
     End;
End;


procedure TForm1.Button1Click(Sender: TObject);
begin
     Reporter.OnReportInit   := ReportInit;
     Reporter.OnReportDone   := ReportDone;
     Reporter.OnBetweenPages := BetweenPages;

     Reporter.AddHeader ( PrintHeader );
     Reporter.AddDetail ( Nil, PrintItem );

     Reporter.Run;
end;

end.
