unit Summrpt1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, DB, DBTables, Reports;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Table1: TTable;
    Table2: TTable;
    DataSource1: TDataSource;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }

    { declare report variables }
    NumCustomers, NumOrders : Word;
  public
    { Public declarations }
    Procedure ReportInit;
    Procedure ReportDone;

    Procedure PrintHeader     ( HeaderBand  : tFixedReportBand;
                                var Status  : tBandStatus );
    Procedure PrintFooter     ( FooterBand  : tFixedReportBand;
                                var Status  : tBandStatus );

    Procedure ReportSummarySetup ( MasterBand : tFixedReportBand;
                                   var Status : tBandStatus );
    Procedure ReportSummary      ( MasterBand : tFixedReportBand;
                                   var Status : tBandStatus );

    Procedure PrintCustomer   ( MasterBand  : tFixedReportBand;
                                var Status  : tBandStatus );
    Procedure CustomerSummary ( SummaryBand : tFixedReportBand;
                                var Status  : tBandStatus );

    Procedure PrintOrder      ( MasterBand  : tFixedReportBand;
                                var Status  : tBandStatus );

  end;

var
  Form1: TForm1;

implementation
Uses pStatus;

{$R *.DFM}

procedure tForm1.ReportInit;
Begin
     { Don't allow the user to use the main form while the report
       is printing }
     Enabled := False;

     { Set up the Print Status Dialog }
     With PrintStatusForm Do
     Begin
          ProgressGauge.MaxValue := 100;
          ProgressGauge.Progress := 0;
          CurrentPage := 1;
          PrintStatus := 'Loading data...';
          PrinterName := Reporter.Printers[Reporter.PrinterIndex];
          Show;
          UpdateStatus;
     End;

     Table2.Open;
     PrintStatusForm.ProgressGauge.MaxValue := Table2.RecordCount;
     Table1.Open;

     { Set the Report margins }
     Reporter.TopMargin.AsInches := 2.0;
     Reporter.LeftMargin.AsInches := 1.0;
     Reporter.RightMargin.AsInches := 1.0;
     Reporter.BottomMargin.AsInches := 1.0;


     { set the Report's default units }
     Reporter.PreferredUnit := puInches;

     { set the Report's initial font }
     Reporter.Canvas.Font.Size := 14;

     PrintStatusForm.PrintStatus := 'Printing...';
     PrintStatusForm.UpdateStatus;
End;

procedure tForm1.ReportDone;
Begin
     { Close Tables and Print status dialog }
     Table1.Close;
     Table2.Close;

     { Re-Enable main form before closing status dialog }
     Enabled := True;

     PrintStatusForm.Close;
End;

procedure tForm1.PrintHeader (     HeaderBand : tFixedReportBand;
                               var Status     : tBandStatus );
Begin
     With Reporter, HeaderBand Do
     Begin
          { save old font and set new font }
          SaveFont;
          Canvas.Font.Size := 24;
          Canvas.Font.Name := 'Times New Roman';


          BoxTextOut ( 'Customer Order Detail',
                       ttaBandHCenter + ttaBandVCenter,
                       btBox,
                       20,
                       3,
                       stBottomLeft,
                       20 );

          { restore previous font }
          RestoreFont;

     End;
End;

procedure tForm1.PrintFooter (     FooterBand : tFixedReportBand;
                               var Status     : tBandStatus );
Begin
     With FooterBand, Reporter Do
     Begin
          Canvas.MoveTo ( Left, Top );
          Canvas.LineTo ( Right, Top );
          TopOfBand;
          AdjustY ( 0.1 );

          Reporter.SaveFont;
          Reporter.Canvas.Font.Size := 8;
          Reporter.Canvas.Font.Name := 'Times New Roman';

          TextOut ( 'Customer Order Detail', ttaLeftMargin );
          TextOut ( 'Page ' + IntToStr(PageNumber), ttaRightMargin );

          Reporter.RestoreFont;
     End;
End;


procedure tForm1.ReportSummarySetup (     MasterBand : tFixedReportBand;
                                      var Status     : tBandStatus );
Begin
     { initialize report variables for this group }
     NumCustomers := 0;
End;

procedure tForm1.ReportSummary (     MasterBand : tFixedReportBand;
                                 var Status     : tBandStatus );
Begin
     With MasterBand Do
     Begin
          { Give the summary a little extra space before printing }
          NextLine;

          BoxTextOut ( 'Number of customers with more than three orders: ' +
                       IntToStr ( NumCustomers ),
                       ttaLeft,
                       btTop, 10, 3,
                       stNone, 0);
     End;

     { Tell the reporter the report is done }
     Status := bsDone;
End;

procedure tForm1.PrintCustomer (     MasterBand : tFixedReportBand;
                                 var Status     : tBandStatus );
Begin
     { Print out the group's name and initialize this group's report variables }
     MasterBand.TextOut ( Table1.FieldByName ( 'Company' ).AsString, ttaLeft );
     NumOrders := 0;
End;

procedure tForm1.CustomerSummary (     SummaryBand : tFixedReportBand;
                                   var Status      : tBandStatus );
Begin
     { Output the group's report variables }
     SummaryBand.BoxTextOut ( '# Orders for ' +
                           Table1.FieldByName ( 'Company' ).AsString +
                           ': ' +
                           IntToStr(NumOrders),
                           ttaLeft,
                           btTop, 10, 3,
                           stNone, 0);
     { Put an extra line at the bottom of the summary band }
     SummaryBand.NextLine;

     { Increment a report variable }
     If NumOrders > 3 Then
        Inc ( NumCustomers );

     { advanec the table and set the report status }
     Table1.Next;
     If PrintStatusForm.Canceled Then
        Status := bsAbort
     Else If Table1.EOF Then
          Status := bsDone;
End;

procedure tForm1.PrintOrder (     MasterBand : tFixedReportBand;
                              var Status     : tBandStatus );
Begin
     { Output the Order No }
     MasterBand.TabTo ( 0.5 );
     MasterBand.TextOut ( 'Order No. ' + Table2.FieldByName ( 'OrderNo' ).AsString, ttaLeft );

     { Increment a report variable }
     Inc ( NumOrders );

     { update the Print Status dialog }
     PrintStatusForm.ProgressGauge.Progress := PrintStatusForm.ProgressGauge.Progress + 1;
     PrintStatusForm.CurrentPage := Reporter.PageNumber;
     PrintStatusForm.UpdateStatus;

     { advance the orders table and set the report status }
     Table2.Next;
     If PrintStatusForm.Canceled Then
        Status := bsAbort
     Else If Table2.EOF Then
          Status := bsDone;
End;

procedure TForm1.Button1Click(Sender: TObject);
begin
     { Set the bands the Reporter will be printing }
     Reporter.OnReportInit := ReportInit;
     Reporter.OnReportDone := ReportDone;

     Reporter.AddHeader ( PrintHeader );
     Reporter.AddFooter ( PrintFooter );

     Reporter.AddDetail ( Nil, PrintOrder );
     Reporter.AddGroup  ( Nil, PrintCustomer, CustomerSummary );
     Reporter.AddGroup  ( Nil, ReportSummarySetup, ReportSummary );

     Reporter.Run;
end;

end.
