unit Pstatus;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Gauges;

type
  TPrintStatusForm = class(TForm)
    Label2: TLabel;
    Label3: TLabel;
    ProgressGauge: TGauge;
    CancelButton: TButton;
    procedure FormShow(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Canceled : Boolean;

    CurrentPage : Word;
    PrintStatus : String;
    PrinterName : String;

    Procedure UpdateStatus;
  end;

var
  PrintStatusForm: TPrintStatusForm;

implementation

{$R *.DFM}

Procedure tPrintStatusForm.UpdateStatus;
Var
   StatusWidth : Word;
Begin
     If Canceled Then
     Begin
          Application.ProcessMessages;
          Exit;
     End;

     Caption := PrintStatus;
     Label2.Caption := 'To ' + PrinterName;
     Label3.Caption := 'Page ' + IntToStr ( CurrentPage );

     StatusWidth := Label2.Width;
     If Label3.Width > StatusWidth Then StatusWidth := Label3.Width;
     If ProgressGauge.Width > StatusWidth Then StatusWidth := ProgressGauge.Width;
     If CancelButton.Width > StatusWidth Then StatusWidth := CancelButton.Width;

     ClientWidth := 32 + StatusWidth;
     Label2.Width := StatusWidth;
     Label3.Width := StatusWidth;

     ProgressGauge.Left := ( ClientWidth - ProgressGauge.Width ) Div 2;
     CancelButton.Left  := ( ClientWidth - CancelButton.Width ) Div 2;

     Left := ( Screen.Width - ClientWidth ) Div 2;
     Top  := ( Screen.Height - ClientHeight ) Div 2; 

     Application.ProcessMessages;
End;

procedure TPrintStatusForm.FormShow(Sender: TObject);
begin
     Canceled := False;
end;

procedure TPrintStatusForm.CancelButtonClick(Sender: TObject);
begin
     Canceled := True;
     Caption := 'Aborting...';
end;

end.
