 unit Chrtrpt1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Reports, StdCtrls, DB, DBTables, VBXCtrl, Chart2fx;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    ChartFX1: TChartFX;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }

    Procedure PrintHeader     ( HeaderBand  : tFixedReportBand;
                                var Status  : tBandStatus );

    Procedure PrintItem       ( DetailBand  : tFixedReportBand;
                                var Status  : tBandStatus );

  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure tForm1.PrintHeader (     HeaderBand : tFixedReportBand;
                               var Status     : tBandStatus );
Begin
     With HeaderBand, Reporter Do
     Begin
          Canvas.Font.Size := 18;
          Canvas.Font.Style := [fsBold];
          BoxTextOut ( 'Chart FX Sample Report', ttaBandHCenter + ttaBandVCenter,
                       btBox, 20, 10,
                       stBottomRight, 20 );
     End;
End;

procedure tForm1.PrintItem   (     DetailBand : tFixedReportBand;
                               var Status     : tBandStatus );
Var
   SaveX : Word;
Begin
     With DetailBand, Reporter Do
     Begin
          { Print out the chart, centered on the page.  Use the text in
            Edit1 and Edit2 to set the width and height of the Chart on
            the page.  This defaults to black/white printing.  If you
            want to try color, change the last parameter to True }
          PlaceChartFX ( ChartFX1, ttaBandHCenter + ttaBandVCenter,
                         StrToFloat ( Edit1.Text ),
                         StrToFloat ( Edit2.Text ),
                         0, 0,
                         False );
     End;

     Status := bsDone;
End;


procedure TForm1.Button1Click(Sender: TObject);
begin
     { Set the Report's default unit to inches }
     Reporter.PreferredUnit := puInches;

     Reporter.AddHeader ( PrintHeader );
     Reporter.AddDetail ( Nil, PrintItem );

     Reporter.Run;
end;

end.
