{
 Designer:  Craig Ward
 Date:      18/1/96

 Version:   1.0

 Function:  Filter box (allows user to set filter on records to be printed).
********************************************************************************}
unit Query;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, DB, DBTables, Print;

type
  TQueryDlg = class(TForm)
    Bevel1: TBevel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    lstFields: TListBox;
    Label4: TLabel;
    Bevel3: TBevel;
    SpeedButton2: TSpeedButton;
    SpeedButton1: TSpeedButton;
    queryPrint: TQuery;
    Label1: TLabel;
    GroupBox1: TGroupBox;
    radAll: TRadioButton;
    radWhere: TRadioButton;
    comboField: TComboBox;
    comboOperator: TComboBox;
    editFilter: TEdit;
    Bevel2: TBevel;
    lblfield: TLabel;
    lblFilter: TLabel;
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure radWhereClick(Sender: TObject);
    procedure radAllClick(Sender: TObject);
  private
    { Private declarations }
    FTable: string;                                               {stores table name}
    procedure SetList;
    procedure SetQuery;
    procedure SetCombos;
  public
    { Public declarations }
    FSQL: string;
  end;

var
  QueryDlg: TQueryDlg;

implementation

{$R *.DFM}


{***custom routines*************************************************************}

{set list}
procedure TQueryDlg.SetList;
var
 iInc: integer;
begin

 lstFields.clear;
 queryPrint.first;

 {read field names into list}
  begin
   for iInc := 1 to (queryPrint.FieldCount) do
    begin
     lstFields.Items.add(queryPrint.Fields[iInc -1].FieldName);
    end;
  end;
end;

{set query}
procedure TQueryDlg.SetQuery;
var
 i: integer;
 sFilter: ^string;
begin

 try
  New(sFilter);

  {initial statement}
  FSQL := 'select ';

  {add field names to sql statement}
  for i := 0 to (lstFields.Items.Count -1) do
   begin
    {if last field name, don't add a comma}
    if i <> (lstFields.Items.Count -1) then
     FSQL := FSQL + FTable +'."'+ lstFields.Items[i] +'",'
    else
     FSQL := FSQL + FTable +'."'+ lstFields.Items[i] +'" '
   end;

  {if filtering on a string field add quotes}
  if queryPrint.FieldByName(comboField.text).dataType = ftString then
   sFilter^ := '"'+ editFilter.text +'"'
  else
   sFilter^ := editFilter.text;

  {if using a filter, then append expression to SQL statement}
  if radAll.checked = true then
   FSQL := FSQL +'from '+ FTable
  else
   FSQL := FSQL +'from '+ FTable +' where '+ FTable +'."'+ comboField.Text +'" '+ comboOperator.text +' '+ sFilter^;

 finally
  Dispose(sFilter);
 end;

end;


{set combos}
procedure TQueryDlg.SetCombos;
var
 i: integer;
begin

 {initialise}
 comboField.clear;

 {read field names into combo box}
 for i := 0 to (queryPrint.FieldCount -1) do
  begin
   comboField.Items.Add(queryPrint.Fields[i].FieldName);
  end;

 {set indices}
 comboField.itemIndex := 0;
 comboOperator.itemIndex := 0;

end;


{***buttons*********************************************************************}

{restore list}
procedure TQueryDlg.SpeedButton2Click(Sender: TObject);
begin
 SetList;
end;

{delete item from list}
procedure TQueryDlg.SpeedButton1Click(Sender: TObject);
begin
 lstFields.Items.Delete(lstFields.ItemIndex);
end;

{cancel}
procedure TQueryDlg.BitBtn2Click(Sender: TObject);
begin
 modalResult := mrCancel;
end;

{ok}
procedure TQueryDlg.BitBtn1Click(Sender: TObject);
begin
 if lstFields.Items.Count > 0 then
  begin
   setQuery;
   modalResult := mrOK;
  end
 else
  modalResult := mrCancel;
end;

{select where}
procedure TQueryDlg.radWhereClick(Sender: TObject);
begin
 {enable}
 comboField.enabled := true;
 comboOperator.enabled := true;
 editFilter.enabled := true;
 lblField.enabled := true;
 lblFilter.enabled := true;

end;

{select all}
procedure TQueryDlg.radAllClick(Sender: TObject);
begin
 {disable}
 comboField.enabled := false;
 comboOperator.enabled := false;
 editFilter.enabled := false;
 lblField.enabled := false;
 lblFilter.enabled := false;
end;


{***form's preferences**********************************************************}

{on create}
procedure TQueryDlg.FormCreate(Sender: TObject);
begin
 {read data from TQuery in main form}
 queryPrint.databaseName := PrintDlg.QueryPrint.DatabaseName;
 queryPrint.SQL.clear;
 queryPrint.SQL.Add(PrintDlg.FSQL);
 queryPrint.active := true;
 FTable := PrintDlg.FTable;

 {initiate this form}
 setList;
 setCombos;

 {default to radAll radio-group}
 radAllClick(self);
end;

{}
end.
