{-------------------------------------------------}
{                                                 }
{    The ODLED component is Copyright  1995      }
{         by Olivier Dahan CIS 100632,32          }
{  Use of ODLED is FREE ONLY IF you register by   }
{  sending me a message to ask it !               }
{  If you use it without register, poltergeists   }
{  will come at night and will sing "Stranger in  }
{  the night" just in the middle of your best     }
{  dreams, and this, till you register !          }
{-------------------------------------------------}

{ Creation date:  July - 9 - 95 }
{ History: }
{ JUL-10-95: Adding blink ability }


unit ODLED;

{$R OdLedlit.res}

interface

uses  WinProcs,
  Classes,
  Graphics,
  Controls,
  StdCtrls,
  Messages,
  ExtCtrls,
  Choose;

procedure Register;

type
    TLedLittleColor = (lcBlack,lcDarkGray,lcRed,lcDarkRed,lcGreen,lcDarkGreen,
                 lcYellow,lcDarkYellow,lcBlue,lcDarkBlue,lcPurple,lcDarkPurple,
                 lcCyan,lcDarkCyan);


type
  TODLedLittle = class(TImage)
  private
	{ Private declarations }
	Face         : TBitmap;
	FLed,
        OldLed,
        FClicLed      : TLedLittleColor;
        Ftimer        : TTimer;
        FBlink        : Boolean;
        FInterval     : Integer;
        FBkState      : boolean;
        FbkSave       : TLedLittleColor;
        FOnBlink      : TNotifyEvent;
	procedure SetBitmap;
	procedure SetLed(NewLed: TLedLittleColor);
        procedure SetClicLed(NewLed: TLedLittleColor);
        procedure SetBlink(Onn:Boolean);
        procedure SetInterval(value:integer);
        procedure WMSize (var Message: TWMSize); message wm_paint;
  protected
        procedure TimeHit(Sender : TObject);
  public
	{ Public declarations }
        constructor Create(AOwner: TComponent); override;
        destructor Free;
        procedure Toggle;
        procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
        procedure MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
  published
        property LedColor: TLedLittleColor read FLed write SetLed;
        property ClicLedColor: TLedLittleColor read FClicLed write SetClicLed;
        property Interval: Integer read Finterval write SetInterval;
        property Blink : Boolean read FBlink write SetBlink;
        property OnBlink: TNotifyEvent read FOnBlink write FOnBlink;
  end;


implementation

Uses DsgnIntf;


const
     LEDString : array[TLedLittleColor] of PChar =
      ('BLACKLED','DARKGRAYLED','REDLED','DARKREDLED','GREENLED','DARKGREENLED',
       'YELLOWLED','DARKYELLOWLED','BLUELED','DARKBLUELED','PURPLELED',
       'DARKPURPLELED','CYANLED','DARKCYANLED');
     MaxHeight = 16;
     MaxWidth = 16;


{-------------------------------------------------
                        TODLedLittle
--------------------------------------------------}

constructor TODLedLittle.Create(AOwner: TComponent);
begin
     inherited Create(AOwner);
     FLed := lcblack;
     Face := TBitmap.Create;  {Note dynamic allocation of the pointer}
     Face.Handle := LoadBitmap(hInstance, 'BLACKLED'); {Old-fashioned API call}
     Self.Height := MaxHeight;
     Self.Width := MaxWidth;
     SetBitmap;
     OldLed := lcBlack;
     FclicLed:=lcDarkgray;
     Fblink:=false;
     Finterval:=250;
     Ftimer:=Nil;
     FbkState:=True;
end; {Create}

destructor TODLedLittle.Free;
begin
     Face.Free; {Use Free rather than Destroy, as Free checks for a nil pointer first}
     if assigned(Ftimer) then Ftimer.Free; { deallocate timer if assigned }
     inherited Free;
end; {Free}

procedure TODLedLittle.Toggle;
begin
     if fLed = lcdarkcyan then fled := lcblack else Inc(fled);  {Don't allow fLed to overflow}
     SetBitmap;
end; {Toggle}

procedure TODLedLittle.SetBitmap;
begin
     Face.Handle := LoadBitmap(hInstance, LedString[fled]);
     Self.Picture.Graphic := Face as TGraphic;  {Use RTTI to cast face as TGraphic, needed by TImage}
end; {SetBitmap}

procedure TODLedLittle.SetInterval(Value : Integer);
begin
if Value <> FInterval then
  begin
  if Assigned(Ftimer) then begin FTimer.Free;
                                 if not fbkstate then begin
                                                      fled:=fbksave;
                                                      setbitmap;
                                                      fbkstate:=true;
                                                      end;
                                 end;
  FTimer := Nil;
  if FBlink and (Value > 0) then
    begin
    FTimer := TTimer.Create(Self);
    FTimer.Interval := Value;
    FTimer.OnTimer := TimeHit;
    end;
  FInterval := Value;
  end;
end;

procedure TODLedLittle.SetBlink(Onn : boolean);
begin
if Onn <> FBlink then
  begin
  FBlink := Onn;
  if not Onn then
    begin
    if Assigned(Ftimer) then begin FTimer.Free;
                                 if not fbkstate then begin
                                                      fled:=fbksave;
                                                      setbitmap;
                                                      fbkstate:=true;
                                                      end;
                                 end;
    FTimer := Nil;
    end
  else if FInterval > 0 then
    begin
    FTimer := TTimer.Create(Self);
    FTimer.Interval := FInterval;
    FTimer.OnTimer := TimeHit;
    end;
  end;
end;


procedure TODLEdLittle.TimeHit(Sender : TObject);
begin
Fbkstate:=not fbkstate;
If FbkState then Fled:=fbksave else
   begin fbksave:=fled; fled:=FclicLed; end;
SetBitMap;
if Assigned(FOnBlink) then FOnBlink(Self);
end;


procedure TODLedLittle.SetLed(NewLed: TLedLittleColor);
begin
     FLed := NewLed;
     SetBitmap;
end; {SetMood}

procedure TODLedLittle.SetClicLed(NewLed: TLedLittleColor);
begin
     FClicLed := NewLed;
end; {SetMood}


{This method will respond to a mouse push on the Led by storing the
old face for later use and giving the "ClicLed" face.  }
procedure TODLedLittle.MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
if not Fblink then
   begin
     OldLed := LedColor;
     SetLed(FclicLed);
   end;
     inherited MouseDown(Button, Shift, X, Y);
end; {MouseDown}

{This method restores the old face when the mouse comes back up}
procedure TODLedLittle.MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     inherited MouseUp(Button, Shift, X, Y);
     If not Fblink then SetLed(OldLed);
end; {MouseUp}

{This method keeps the user from sizing the Led at design time.
You can use the 'csDesigning in ComponentState' to control what the
user can do at design time}
procedure TODLedLittle.WMSize(var Message: TWMSize);
begin
     inherited;
     if (csDesigning in ComponentState) then
     begin
          Width := MaxWidth;
          Height := MaxHeight;
     end;
end; {WMSize}

{------------------------------------}

procedure Register;
begin
  RegisterComponents('Divers4', [TODLedLittle]);
  RegisterPropertyEditor( TypeInfo( TLedLittleColor ), TODLedLittle, 'LED',
   TLedLittleProperty );
end; {Register}

end.

