unit Choose;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, ExtCtrls, StdCtrls, DsgnIntF, TypInfo;


type
    TLedLittleColor = (lcBlack,lcDarkGray,lcRed,lcDarkRed,lcGreen,lcDarkGreen,
                 lcYellow,lcDarkYellow,lcBlue,lcDarkBlue,lcPurple,lcDarkPurple,
                 lcCyan,lcDarkCyan);


  TChooseDlg = class(TForm)
    BitBtn1: TBitBtn;
    Panel1: TPanel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    SpeedButton7: TSpeedButton;
    SpeedButton8: TSpeedButton;
    SpeedButton9: TSpeedButton;
    SpeedButton10: TSpeedButton;
    SpeedButton11: TSpeedButton;
    SpeedButton12: TSpeedButton;
    SpeedButton13: TSpeedButton;
    SpeedButton14: TSpeedButton;
    procedure SpeedButton1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    FLed      : TLedLittleColor;
    procedure SetLed(NewLed: TLedLittleColor);
  public
    { Public declarations }
    property LedColor: TLedLittleColor read FLed write SetLed;
  end;

  TLedLittleProperty = class( TEnumProperty )
       function GetAttributes: TPropertyAttributes; override;
       procedure Edit; override;
  end;

var
  ChooseDlg: TChooseDlg;

implementation

{$R *.DFM}

procedure TChooseDlg.SpeedButton1Click(Sender: TObject);
begin
     FLed := TLedLittleColor((Sender as TSpeedButton).Tag);
end; {SpeedButton1Click}

procedure TChooseDlg.FormCreate(Sender: TObject);
begin
     SpeedButton1.Down := True;
end; {FormCreate}

procedure TChooseDlg.SetLed(NewLed: TLedLittleColor);
var
   Counter: Integer;
begin
     FLed := NewLed;
     for Counter := 0 to ComponentCount - 1 do
     begin
          if (Components[Counter] is TSpeedButton) then
          begin
               if TSpeedButton(Components[Counter]).Tag = Ord(Newled) then
                  TSpeedButton(Components[Counter]).Down := True;
          end;
     end;
end;  {SetLed}

{---------Property Editor Stuff--------------}

function TLedLittleProperty.GetAttributes: TPropertyAttributes;
begin
	Result := [paDialog];
end;  {GetAttributes}

procedure TLedLittleProperty.Edit;
var
   ChooseDlg: TChooseDlg;
begin
     ChooseDlg := TChooseDlg.Create(Application);
     try
        ChooseDlg.LedColor := TLedLittleColor(GetOrdValue);
        ChooseDlg.ShowModal;
        SetOrdValue(Ord(ChooseDlg.LedColor))
     finally
        ChooseDlg.Free
     end;
end; {Edit}

end.
